<?php 
class Settings extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->personal_information();
	}

	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List personal_information for a particular
	 * 			 Advertiser
	 */	

	public function personal_information()
	{
		$data['page_title'] = $this->lang->line('personal_information');
		$data['breadcrumb'] = '';		
		$personal_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');		
		$data['personal_info']=$personal_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');					
		$data['content'] = $this->load->view('settings/personal_information',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:company_information
	 * @param   :Null
	 * @return  :List company_information for a particular
	 * 			 Advertiser
	 */	
	public function company_information()
	{
		$data['page_title'] = $this->lang->line('company_info');
		$data['breadcrumb'] = '';
		$company_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');		
		$data['content'] = $this->load->view('settings/company_information',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:billing_information
	 * @param   :Null
	 * @return  :Loads the form to get user billing information
	 */	

	public function billing_information()
	{
		$data['page_title'] = $this->lang->line('billing_information');
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/billing_information',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:payment_settings
	 * @param   :Null
	 * @return  :Loads the form to get user payment information
	 */	

	public function payment_settings()
	{
		$data['page_title'] = $this->lang->line('payment_settings');
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/payment_settings',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:email_preferences
	 * @param   :Null
	 * @return  :Loads the form to get user email preferences
	 */	

	public function email_preferences()
	{
		$data['page_title'] = $this->lang->line('email_preferences');
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/email_preferences',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:referral_programs
	 * @param   :Null
	 * @return  :Loads the form to get user Referal programs
	 */	

	public function referral_program()
	{
		$data['page_title'] = $this->lang->line('referral_program');
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/referral_program',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
		
	/*
	 * 
	 * name		: account_settings
	 * @param   : Null
	 * @return  : account_settings for a particular
	 * 			 Advertiser
	 */	

	public function account_settings()
	{
		$data['page_title'] = $this->lang->line('account_settings');
		$data['breadcrumb'] = '';
		$account_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['account_info']=$account_info[0];	
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');			
		$data['content'] = $this->load->view('settings/account_settings',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
}
