<?php 
class Reports extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
	}

	function index()
	{
		//$this->reports();
	}

	/*
	 * 
	 * name		:overview
	 * @param   :Null
	 * @return  :Generate advertser reports by the datewise.
	 */	

	public function overview()
	{
		$data['page_title'] = $this->lang->line('overview_report');
		$data['breadcrumb'] = '';
		// GET DEFAULT PERIOD FROM CONFIG FILE
     	$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
  
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/overview',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_OVERVIEW';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';
		
	    $input['language'] = $this->config->item('language');
	    $input['exchangeval'] = $this->config->item('exchangeRate');		

		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		
		
		
		echo $data;
	}
	
	
	/*
	 * 
	 * name		:geographic
	 * @param   :Null
	 * @return  :Generate advertser reports by the countrywise.
	 */	

	public function geographic()
	{
		$data['page_title'] =  $this->lang->line('geographic_report');

		$data['breadcrumb'] = '';
		
		// GET DEFAULT PERIOD FROM CONFIG FILE

		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		//dateformat
		$data['date_format'] =	$this->rest->get('api/v1/report/fetch_app_config_date_format',array('api_key'=>get_session('api_key')),'php');
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('reports/geographic',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_country_stat($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = get_session('api_key');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY',
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';			  
	    $input['language'] = $this->config->item('language');
	    $input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	
	
	/*
	 * 
	 * name		:campaign
	 * @param   :Null
	 * @return  :Generate advertser reports by campaign.
	 */	

	public function campaign()
	{
		$data['page_title'] = $this->lang->line('campaign_report');

		$data['breadcrumb'] = '';

		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		//dateformat
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CAMPAIGN']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/campaigns',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_campaign_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CAMPAIGN';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
				
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');			  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		echo $data;
	}
	
	/*
	 * 
	 * name		:creatives
	 * @param   :Null
	 * @return  :Generate advertser reports by creatives.
	 */	

	public function creatives($camp=FALSE)
	{
		$data['page_title'] = $this->lang->line('creative_report');

		$data['breadcrumb'] = '';

		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns/'.$camp,array("api_key"=>get_session('api_key')),'php');
		//dateformat
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$data['campaigns_id']=$camp;
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CREATIVE']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('reports/creatives',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_creative_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CREATIVE';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');		
		  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		echo $data;
	}
	/*
	 * 
	 * name		:spend
	 * @param   :Null
	 * @return  :Generate advertser reports by their spend.
	 */	

	public function spend()
	{
		$data['page_title'] = $this->lang->line('spend_report');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('reports/spend',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:video
	 * @param   :Null
	 * @return  :Generate advertser reports for video.
	 */	

	public function video()
	{
		$data['page_title'] = $this->lang->line('video_report');

		$data['breadcrumb'] = '';
		
		$data['creative_data']				= 	$this->rest->get('api/v1/report/fetch_video_creative',array("api_key"=>get_session('api_key')),'php');
	
		//print_r($data['creative_data']);exit;		
				
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_VIDEO']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/video',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_video_stats($env='all',$ban_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_VIDEO';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'VIDEO',
						'creative_id'=>$ban_id
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($ban_id != 'all'){
			$input['creative_id'] = $ban_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  

    	if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
					  			  
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	
	public function dsp()
	{	
		$data['page_title'] = $this->lang->line('dsp_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
	
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('reports/dsp_report',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function fetch_dsp_stats($from_date=FALSE,$to_date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$adv_account_id = 	get_session('account_id');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADVERTISER']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
						'adv_account_id' =>	$adv_account_id							
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data	= 	$this->rest->post('api/v1/report/fetch_advertiser_dsp',$input,'json');
		//$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');

		

		echo $data;
	}
	
	
	/*
	 * 
	 * name: dsp
	 * @param : null
	 * @return : list all dsp statistics .
	 */	

	public function dsp_date($exchange_id=false,$from_date=false,$to_date=false)
	{	
		//$data['page_title'] = $this->lang->line('dsp_date_report'); 
		 $data['page_title'] =  $this->lang->line('dsp_datewise_performance');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		$data['exchange_id']	=	$exchange_id;
		$data['search_date']		= array(
	
										$data['from_date']		=	$from_date,
										$data['to_date']		=	$to_date

								);
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		//$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('reports/dsp_date_report',$data,TRUE);
		
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	
	
	public function fetch_dsp_date_stats($exchange_id=false,$from_date=FALSE,$to_date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$adv_account_id = 	get_session('account_id');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADVERTISER']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id,
						'adv_account_id' =>	$adv_account_id							
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data	= 	$this->rest->post('api/v1/report/fetch_advertiser_dsp_date',$input,'json');
		//$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	/*
	 * 
	 * name: dsp_details
	 * @param : null
	 * @return : list all dsp under date statistics .
	 */	

	public function dsp_details($exchange_id=false,$date=false)
	{	
		// $data['page_title'] = $this->lang->line('dsp_detail_report'); //  
		
		$data['page_title'] = $this->lang->line('dsp_detail_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['exchange_id']	=	$exchange_id;
		$data['date']			=	$date;
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('reports/dsp_detail_report',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_dsp_detail_stats($exchange_id=false,$date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$adv_account_id = 	get_session('account_id');
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id,
						'date'			=>	$date,
						'adv_account_id' =>	$adv_account_id					
					  );		
	
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}		  
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
							
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		
		//$data	=	$this->rest->get('api/v1/report/fetch_dsp_detail',$input,'json');				  
		$data	= 	$this->rest->post('api/v1/report/fetch_advertiser_dsp_detail',$input,'json');

		
		echo $data;
	}
	
public function city_report()
	{
		$data['page_title'] = $this->lang->line('city_report');

		$data['breadcrumb'] = '';
		
		// GET DEFAULT PERIOD FROM CONFIG FILE

		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		//dateformat
		$data['date_format'] =	$this->rest->get('api/v1/report/fetch_app_config_date_format',array('api_key'=>get_session('api_key')),'php');
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CITY_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('reports/city_report',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_city_stat($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = get_session('api_key');
		$page			= 'REPORT_CITY_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CITY',
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';			  
	    $input['language'] = $this->config->item('language');
	    $input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	
	/*
	 * 
	 * name		:Age Report
	 * @param   :Null
	 * @return  :Generate advertser reports by age.
	 */	

	public function age()
	{
		$data['page_title'] = "Age Report";//$this->lang->line('creative_report');

		$data['breadcrumb'] = '';

		$api_key=get_session('api_key');
		//$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');
		$data['age']=$this->rest->get('api/v1/report/fetch_targeting_age',array("api_key"=>$api_key),'php');  			
		//echo $this->rest->debug();  die("123");
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_AGE']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('reports/age',$data,TRUE);
		$this->template->set_layout('advertiser_layout');  
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by age
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_age_stats($env='all',$age='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_AGE';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'AGE'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($age != 'all'){
			$input['site']  = $age;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
//~ print_r($data); exit;
		echo $data;
	}
	
	/*
	 * 
	 * name		:GENDER Report
	 * @param   :Null
	 * @return  :Generate advertser reports by gender.
	 */	

	public function gender()
	{
		$data['page_title'] = "Gender Report";

		$data['breadcrumb'] = '';
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_GENDER']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		/*DAC020 on Feb 15,2020*/
		//$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');		
		$data['gender']=$this->rest->get('api/v1/report/fetch_targeting_gender',array("api_key"=>$api_key),'php');		
		$data['content'] = $this->load->view('reports/gender',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by gender
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_gender_stats($env='all',$gender='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_GENDER';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'GENDER'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($gender != 'all'){
			$input['site'] = $gender;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
//~ print_r($data); exit;
		echo $data;
	}
	
	
	

	/*
	 * 
	 * name		:Site Report
	 * @param   :Null
	 * @return  :Generate advertser reports by site.
	 */	

	public function site()
	{
		$data['page_title'] = "Site Report";
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_SITES']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/report/fetch_targeting_sites',array("api_key"=>$api_key),'php');
		//echo $this->rest->debug();  die("123456");  
		
		//$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');	
		$data['content'] = $this->load->view('reports/site',$data,TRUE);   
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by site
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_site_stats($env='all',$site='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_SITES';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'SITES'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}

		/*DAC020 ON FEB15,2020*/
		
		if($site != 'all'){
			$input['site'] = $site;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
				
		//~ print_r($data); exit;
		echo $data;
	}
	
	
	
	/*
	 * 
	 * name		:Sentiment Report
	 * @param   :Null
	 * @return  :Generate advertser reports by sentiment.
	 */	

	public function sentiment()
	{
		$data['page_title'] = "Sentiment Report";
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_SENTIMENT']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		//$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');
		$data['sentiment']=$this->rest->get('api/v1/report/fetch_targeting_sentiment',array("api_key"=>$api_key),'php');
		//~ print_r($data);exit;
		$data['content'] = $this->load->view('reports/sentiment',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * Lists the Statistics by sentiment
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_sentiment_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_SENTIMENT';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'SENTIMENT'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		//~ print_r($data); exit;
		echo $data;
	}
	
	public function fetch_city_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		
		$api_key 	= get_session('api_key');
		$account_type 	= get_session('account_type');
		$page			= 'REPORT_CITY_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CITY',
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
	    $input['language'] = $this->config->item('language');
	    $input['exchangeval'] = $this->config->item('exchangeRate');
	//~ print_r($input);exit;
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
	
		//~ 
  //~ $this->rest->debug();
		echo $data;
	}
	
	
	public function custom_targeting1()
	{
		$data['page_title'] = $this->lang->line('custom_targeting1');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CUSTOMTARG1']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg1']=$this->rest->get('api/v1/report/fetch_custom_targeting1',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('reports/customtarg1',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg1_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG1';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG1'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		//~ print_r($data); exit;
		echo $data;
	}
	
	public function custom_targeting2()
	{
		$data['page_title'] = $this->lang->line('custom_targeting2');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CUSTOMTARG2']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg2']=$this->rest->get('api/v1/report/fetch_custom_targeting2',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('reports/customtarg2',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg2_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG2';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG2'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		echo $data;
	}
	
	public function custom_targeting3()
	{
		$data['page_title'] = $this->lang->line('custom_targeting3');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CUSTOMTARG3']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg3']=$this->rest->get('api/v1/report/fetch_custom_targeting3',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('reports/customtarg3',$data,TRUE);
		//~ print_r($data);exit;
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg3_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG3';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG3'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		echo $data;
	}
	
	public function custom_targeting4()
	{
		$data['page_title'] = $this->lang->line('custom_targeting4');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CUSTOMTARG4']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg4']=$this->rest->get('api/v1/report/fetch_custom_targeting4',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('reports/customtarg4',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg4_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG4';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG4'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		echo $data;
	}
	
}
