<?php 
class Payments extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->payments();
	}

	/*
	 * 
	 * name		:payments
	 * @param   :Null
	 * @return  :Generate advertser payments/Invoice
	 */	

	public function payments()
	{
		$data['page_title'] = $this->lang->line('payments');
		$data['breadcrumb'] = '';
		$admin_details=$this->rest->get('api/v1/network/get_network_account_details',array('api_key'=>get_session('api_key')),'php');
		$paypal_details= $this->rest->get('api/v1/payments/fetch_paypal_admin', array('api_key' => get_session('api_key')), 'php');
	    $data['paypal_id']=$paypal_details;
		$data['account_details']=$admin_details[0];
		$data['content'] = $this->load->view('payments/payments',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:add_fund
	 * @param   :Null
	 * @return  :Loads the add fund module for the payment
	 */	

	public function add_fund()
	{
		$data['page_title'] = $this->lang->line('add_fund');
		$data['breadcrumb'] = '';
		$data['account_id'] = get_session('account_id');
		if(!empty($data['account_id']))
		{  $this->load->view('payments/modal_payments/content/add_fund',$data);
		}else{
			echo 'Login to continue';	
		}
	}
	
	/*
	 * 
	 * name		:add_fund
	 * @param   :Null
     * @return  :Loads the add fund module for the payment
	*/	
	public function fetch_advertiser_payment_list()
	{  
	   $exchangeval = $this->config->item('exchangeRate');
	   $pay_list=$this->rest->get('api/v1/payments/fetch_advertiser_payment',array('api_key'=>get_session('api_key'),'exchangeval'=>$exchangeval),'json');
//~ $this->rest->debug();
	   echo convert_to_datatable_format($pay_list);
	}
	
	/*
	 * 
	 * name		:get_payment_details
	 * @param   :Null
     * @return  :Loads the add fund module for the payment
	*/
	
	public function get_payment_details()
	{
	   $month=$this->input->post('month');
	   $year=$this->input->post('year');
	   $account_id=$this->input->post('accountid');
	   $exchangeval = $this->config->item('exchangeRate');

	   $pay_list=$this->rest->post('api/v1/payments/fetch_advertiser_date_wise_payment',array('api_key'=>get_session('api_key'),'month'=>$month,'year'=>$year,'exchangeval'=>$exchangeval),'json');
	   echo convert_to_datatable_format($pay_list);
	}
	
	/*
	 * 
	 * name		:deposits
	 * @param   :Null
     * @return  :Loads the add fund module for the payment
	*/
	public function deposits()
	{
		$data['page_title'] = $this->lang->line('deposit_amount_details');
		$data['breadcrumb'] = '';
		$admin_details=$this->rest->get('api/v1/network/get_network_account_details',array('api_key'=>get_session('api_key')),'php');
		$paypal_details= $this->rest->get('api/v1/payments/fetch_paypal_admin', array('api_key' => get_session('api_key')), 'php');
	    $data['paypal_id']=$paypal_details;
		$data['account_details']=$admin_details[0];
		$data['content'] = $this->load->view('payments/deposits/deposit_details',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_payment_deposit_list
	 * @param : null
	 * @return : list of payments need to be approve.
	 */	
	public function fetch_payment_deposit_list()
	{
		$exchangeval = $this->config->item('exchangeRate');
		$deposit_list	  = $this->rest->get('api/v1/payments/fetch_deposit_amount_list',array('api_key'=>get_session('api_key'),'exchangeval'=>$exchangeval),'json');
		
		echo convert_to_datatable_format($deposit_list);
	}
	
	public function advertiser_billing_information()
	{
		$b_id=$this->input->post("b_id");
		$data['billing_details']=$this->rest->get('api/v1/payments/advertiser_billing_details',array('billing_id'=>$b_id,'api_key'=>get_session('api_key')),'php');
		$content = $this->load->view('payments/deposits/billing_preview',$data,TRUE);
		 
	}

}
