<?php 

class Creatives extends CI_Controller

{
	

    function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

		

	}

    
    

	function index($idS=FALSE)

	{

		$this->creatives($idS);

	}



	/*

	 * 

	 * name		:creatives

	 * @param   :Null

	 * @return  :List all the creatives for a particular

	 * 			 advertiser

	 */	



	public function creatives($ids=FALSE)

	{

		$data['page_title'] = $this->lang->line('manage_creatives');



		$data['breadcrumb'] = '';



		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns/',array("api_key"=>get_session('api_key')),'php');

		// GET DEFAULT PERIOD FROM CONFIG FILE

		

		$set = $this->config->item('report_config');

		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CREATIVE']['CHART']['DEFAULT_INTERVAL']);

		if($ids)
		{
		
		//to pass campaign id
		$data['campaigns_id']=$ids;
		}
		$data['content'] = $this->load->view('creatives/manage_creatives',$data,TRUE);

		$this->template->set_layout('advertiser_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:fetch_creative

	 * @param   :Null

	 * @return  :List all the creatives for a particular

	 * 			 advertiser

	 */	



   	public function fetch_creative($campaign=FALSE)

	{

		$creatives		= $this->rest->get('api/v1/creative/fetch/'.$campaign,array("api_key"=>get_session('api_key'),"subacc"=>get_session('subacc'),"campaignid"=>get_session('campaignid')),'json');
         
		echo convert_to_datatable_format($creatives);

	}



/*

	 * 

	 * name   : add_web_creatives

	 * @param : Null

	 * @return: Loads a page to create a new web creative

	 */	



	public function add_web_creatives()

	{

		$data['page_title'] = $this->lang->line('add_web_creatives');



		$data['breadcrumb'] = '';

		

		$data['content'] = $this->load->view('creatives/add_web_creative',$data,TRUE);

		

		$this->template->set_layout('advertiser_layout');

		$this->template->build('view', $data);

	}



	/*

	 * 

	 * name   : web_creative

	 * @param : Null

	 * @return: Loads web creative modal box

	 */	

	public function web_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_web_creative',$data);	

	}

	

	/*

	 * 

	 * name   : html_creative

	 * @param : Null

	 * @return: Loads html creative modal box

	 */	

	public function html_creative()
	{
		
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');
		

		//~ $data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_html_creative',$data);	

	}



	/* html mobile creative */
	public function html_mobile_creative()
	{
		
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');
		

		echo $this->load->view('creatives/modal_creatives/content/add_html_mobile_creative',$data);	

	}

	/* edit_html_mobile_creative */
	function edit_html_mobile_creative($creative_id=false)

	{

		if($creative_id)

		{
		
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */											
//~ 
				//~ $data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"WEB"),'php');
				$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

				$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				$data['creative_details']=$creative_data[0];

				echo $this->load->view('creatives/modal_creatives/content/edit_html_mobile_creative',$data);
			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */					
				

		}
	}

	

	/*

	 * 

	 * name   : flash_creative

	 * @param : Null

	 * @return: Loads html creative modal box

	 */	

	public function flash_creative()

	{
//~ 
		//~ $data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_flash_creative',$data);	

	}

	

	/*

	 * 

	 * name   : text_creative

	 * @param : Null

	 * @return: Loads TEXT creative modal box

	 */	

	public function text_creative()
	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_text_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_web_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_web_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */											

			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"WEB"),'php');

			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_web_creative',$data);

				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					

		}

	}

	/*

	 * 

	 * name   : edit_flash_creative

	 * @param : Null

	 * @return: Loads flash creative details in a modal box

	 */	

	public function edit_flash_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								
					//~ $data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"WEB"),'php');	
					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session('api_key'),"campaign_type"=>"WEB"),'php');

					$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$data['creative_details']=$creative_data[0];



					$creative_dependiency_data= $this->rest->get('api/v1/creative/fetch_creative_dependiences',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					

					$data['creative_dependiency_data']=$creative_dependiency_data[0];



					echo $this->load->view('creatives/modal_creatives/content/edit_flash_creative',$data);

				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					

		}

	}

	

	/*

	 * 

	 * name   : edit_text_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_text_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */				

				$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"WEB"),'php');

				$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				$data['creative_details']=$creative_data[0];

				echo $this->load->view('creatives/modal_creatives/content/edit_text_creative',$data);
			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */
		}

	}

	/*

	 * 

	 * name   : edit_text_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_html_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */											
//~ 
				//~ $data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"WEB"),'php');
				$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session('api_key'),"campaign_type"=>"WEB"),'php');

				$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				$data['creative_details']=$creative_data[0];

				echo $this->load->view('creatives/modal_creatives/content/edit_html_creative',$data);
			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */					
				

		}

	}

	

	/****************************************************************************************

	

								VIDEO CREATIVES ADD AND EDIT



	*****************************************************************************************/



	/*

	 * 

	 * name   : video_inline_creative



	 * @param : Null

	 * @return: Loads video inline creative modal box

	 */	

	public function video_inline_creative($type=false)
	{
		if($type == "web")
		{
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');
		}
		else
		{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');
		}
		$data['type'] = $type;
		echo $this->load->view('creatives/modal_creatives/content/add_video_inline_creative',$data);	

	}
	/*
	 * 
	 * name   : video_overlay_creative
	 * @param : Null
	 * @return: Loads video overlay creative modal box
	 */	
	public function video_overlay_creative($type=false)
	{
		if($type == "web")
		{
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"WEB"),'php');
		}
		else
		{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');
		}

		$data['type'] = $type;
		echo $this->load->view('creatives/modal_creatives/content/add_video_overlay_creative',$data);	

	}


	/* pause_video_creative */
	public function pause_video_creative($type=false)
	{
		
		if($type == 'mobile')
		{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');
		}

		$data['type'] = $type;
		echo $this->load->view('creatives/modal_creatives/content/add_pause_video_creative',$data);	

	}

	/*rewarded_video_creative*/
	public function rewarded_video_creative($type=false)
	{
		
		if($type == 'mobile')
		{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');
		}

		$data['type'] = $type;
		echo $this->load->view('creatives/modal_creatives/content/add_rewarded_video_creative',$data);	

	}

	/*

	 * 

	 * name   : edit_video_inline_creative



	 * @param : Null

	 * @return: Loads video inline creative modal box

	 */	

	public function edit_video_inline_creative($creative_id=false)
	{
		if($creative_id)
		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */											
					$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');
					
					$banner_type = ($creative_data[0]['dj_banner_type'] == 'MV_IN') ? 'MOBILE' : 'WEB';
					
					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session('api_key'),"campaign_type"=>$banner_type),'php');
					//~ print_r($data['campaign_data']);die("==");
					$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$companion_id				=	$vast_data[0]['vast_companion_banner_id'];

					if($companion_id!=0)

					{

						$companion_data			= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$companion_id),'php');

						if($companion_data)

						{

							$data['comp_size']	=	$companion_data[0]['width'].'x'.$companion_data[0]['height'];						

						}

						else

						{

							$data['comp_size']	=	'';

						}

					}

					else

					{

						$data['comp_size']		=	'';

					}

					

					$data['creative_data']		=	$creative_data[0];

					$data['vast_data']			=	$vast_data[0];

					

					echo $this->load->view('creatives/modal_creatives/content/edit_video_inline_creative',$data);	
				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					
			

		}

	}

	

	

	/*

	 * 

	 * name   : edit_video_overlay_creative

	 * @param : Null

	 * @return: Loads video overlay creative modal box

	 */	

	public function edit_video_overlay_creative($creative_id=false)
	{

		if($creative_id)
		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */											
					$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$banner_type = ($creative_data[0]['dj_banner_type'] == 'MV_OL') ? 'MOBILE' : 'WEB';
					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session('api_key'),"campaign_type"=>$banner_type),'php');
					

					$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$companion_id				=	$vast_data[0]['vast_companion_banner_id'];

					if($companion_id!=0)

					{

						$companion_data			= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$companion_id),'php');

						if($companion_data)

						{

							$data['comp_size']	=	$companion_data[0]['width'].'x'.$companion_data[0]['height'];						

						}

						else

						{

							$data['comp_size']	=	'';

						}

					}

					else

					{

						$data['comp_size']		=	'';

					}

					

					$data['creative_data']		=	$creative_data[0];

					$data['vast_data']			=	$vast_data[0];

					echo $this->load->view('creatives/modal_creatives/content/edit_video_overlay_creative',$data);	
				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					

		}

	}



	public function edit_pause_video_creative($creative_id=false)
	{

		if($creative_id)
		{
		
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
															
					$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$banner_type = ($creative_data[0]['dj_banner_type'] == 'MV_CP') ? 'MOBILE' : 'WEB';
					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session('api_key'),"campaign_type"=>$banner_type),'php');
					

					$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$companion_id				=	$vast_data[0]['vast_companion_banner_id'];

					if($companion_id!=0)

					{

						$companion_data			= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$companion_id),'php');

						if($companion_data)

						{

							$data['comp_size']	=	$companion_data[0]['width'].'x'.$companion_data[0]['height'];						

						}

						else

						{

							$data['comp_size']	=	'';

						}

					}

					else

					{

						$data['comp_size']		=	'';

					}

					

					$data['creative_data']		=	$creative_data[0];

					$data['vast_data']			=	$vast_data[0];

					echo $this->load->view('creatives/modal_creatives/content/edit_pause_video_creative',$data);	
				
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
									

		}

	}

	

	/*

	 * 

	 * name   : filter_companions

	 * @param : Null

	 * @return: Loads a page to existing  web creatives

	 */	

	

	public function filter_companions($campaign_id=false,$width=false,$height=false,$companion_id=false)
	{	

		if($width && $height)
		{

			$data['companion']		= 	$this->rest->get('api/v1/video_creative/filter_companions',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id,"width"=>$width,"height"=>$height),'php');

			if($companion_id!=false)
			{

				$data['companion_id']	=	$companion_id;

			}
			else
			{

				$data['companion_id']	=	0;

			}


			$this->load->view('creatives/modal_creatives/content/filter_companions',$data,TRUE);

		}

	}	



	/****************************************************************************************

	

								MOBILE CREATIVES ADD AND EDIT



	*****************************************************************************************/

	

	/*

	 * 

	 * name   : add_mobile_creatives

	 * @param : Null

	 * @return: Loads a page to create a new mobile creative

	 */	



	public function add_mobile_creatives()
	{

		$data['page_title'] = $this->lang->line('add_mobile_creatives');


		$data['breadcrumb'] = '';


		$data['content'] = $this->load->view('creatives/add_mobile_creative',$data,TRUE);
		

		$this->template->set_layout('advertiser_layout');

		$this->template->build('view', $data);

	}

	

	/* 

	 * name   : image_creative

	 * @param : Null

	 * @return: Loads mobile image creative modal box

	 */	

	public function image_creative()

	{

		$mobile_screens_size	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');



		$data['wide'] = $mobile_screens_size[0];

		$data['static'] = $mobile_screens_size[1];

		$data['interstitial'] = $mobile_screens_size[2];



		$data['small'] = $mobile_screens_size[5];

		$data['medium'] = $mobile_screens_size[4];

		$data['large'] = $mobile_screens_size[3];

		

		

		$data['tab_small'] = $mobile_screens_size[6];

		$data['tab_medium'] = $mobile_screens_size[7];

		$data['tab_large'] = $mobile_screens_size[8];

		

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_image_creative',$data,TRUE);

		//echo $this->load->view('creatives/modal_creatives/content/add_image_creative');	

	}

	

	/*

	 * 

	 * name   : edit_image_creative

	 * @param : creative id

	 * @return: Loads image creative details in a modal box

	 */	

	public function edit_image_creative($creative_id=false)

	{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								

				$mobile_screens_size	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');

				$data['wide'] = $mobile_screens_size[0];

				$data['static'] = $mobile_screens_size[1];

				$data['interstitial'] = $mobile_screens_size[2];

				

				$data['large'] = $mobile_screens_size[3];

				$data['medium'] = $mobile_screens_size[4];

				$data['small'] = $mobile_screens_size[5];



				$data['tab_small'] = $mobile_screens_size[6];

				$data['tab_medium'] = $mobile_screens_size[7];

				$data['tab_large'] = $mobile_screens_size[8];

				

				if($creative_id)

				{

					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

					$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$data['creative_details']=$creative_data[0];



					$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					

					$data['creative_dependiency_data']=$creative_dependiency_data;



					echo $this->load->view('creatives/modal_creatives/content/edit_image_creative',$data);
				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					

		}

	}

	

	/*

	 * 

	 * name   : mobile_text_creative

	 * @param : Null

	 * @return: Loads TEXT creative modal box

	 */	

	public function mobile_text_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_mob_text_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_mob_text_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_mob_text_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								

					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

					$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$data['creative_details']=$creative_data[0];

					echo $this->load->view('creatives/modal_creatives/content/edit_mob_text_creative',$data);
				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					
			

		}

	}

	

	

	/* 

	 * name   : interstitial_creative

	 * @param : Null

	 * @return: Loads mobile interstitial creative modal box

	 */	

	public function interstitial_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_interstitial_creative',$data);	

	}



	/*

	 * 

	 * name   : edit_interstitial_creative

	 * @param : creative id

	 * @return: Loads interstitial creative details in a modal box

	 */	

	public function edit_interstitial_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								

					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

					$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$data['creative_details']=$creative_data[0];
					
					$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');
					
					$data['creative_dependiency_data']=$creative_dependiency_data;
					
					echo $this->load->view('creatives/modal_creatives/content/edit_interstitial_creative',$data);
				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					

		}

	}

	

	/* 

	 * name   : expand_creative

	 * @param : Null

	 * @return: Loads mobile expand creative modal box

	 */	

	public function expand_creative()
	{

	/*	$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_cpe_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php'); */
	
	$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');
		 

		echo $this->load->view('creatives/modal_creatives/content/add_expand_creative',$data);	

	}



	/*

	 * 

	 * name   : edit_adhesion_creative

	 * @param : creative id

	 * @return: Loads ADHESION creative details in a modal box

	 */	

	public function edit_adhesion_creative($creative_id=false)

	{

		if($creative_id)
		{

		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */				

					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

					/*$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_creative',array("creative_id"=>$creative_id),'php');

					

					$data['creative_details_parent']=$creative_data[0];

					$data['creative_details_child']=$creative_data[1];*/

					$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$data['creative_details']=$creative_data[0];



					$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					

					$data['creative_dependiency_data']=$creative_dependiency_data;

					

					echo $this->load->view('creatives/modal_creatives/content/edit_adhesion_creative',$data);
				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					

		}

	}

	

	/*

	 * 

	 * name   : edit_flex_creative

	 * @param : creative id

	 * @return: Loads flex creative details in a modal box

	 */	

	public function edit_flex_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								
					$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

					

					

					$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					$data['creative_details']=$creative_data[0];



					$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

					

					$data['creative_dependiency_data']=$creative_dependiency_data;

					

					echo $this->load->view('creatives/modal_creatives/content/edit_flex_creative',$data);
				/* added by karthika on dec-12*/
				}else
				{
				redirect( site_url('advertiser/creatives'), "refresh");	
				}
				/* end */					
					

		}

	}

	

	/*

	 * 

	 * name   : edit_expand_creative

	 * @param : creative id

	 * @return: Loads expand creative details in a modal box

	 */	

	public function edit_expand_creative($creative_id=false)

	{

		if($creative_id)

		{
			
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								

				$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

				

				$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				$data['creative_details']=$creative_data[0];



				$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				

				$data['creative_dependiency_data']=$creative_dependiency_data;



				echo $this->load->view('creatives/modal_creatives/content/edit_expand_creative',$data);
			
			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */
		}

	}

	

	/* 

	 * name   : reveal_creative

	 * @param : Null

	 * @return: Loads mobile reveal creative modal box

	 */	

	public function reveal_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_reveal_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_reveal_creative

	 * @param : creative id

	 * @return: Loads reveal creative details in a modal box

	 */	

	public function edit_reveal_creative($creative_id=false)

	{

		if($creative_id)

		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

				$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				$data['creative_details']=$creative_data[0];



				$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				

				$data['creative_dependiency_data']=$creative_dependiency_data;



				echo $this->load->view('creatives/modal_creatives/content/edit_reveal_creative',$data);
			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */				

		}

	}

	

	/* 

	 * name   : filmstrip_creative

	 * @param : Null

	 * @return: Loads mobile filmstrip creative modal box

	 */	

	public function filmstrip_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_filmstrip_creative',$data);	

	}



	/* 

	 * name   : adhesion_creative

	 * @param : Null

	 * @return: Loads mobile adhesion creative modal box

	 */	

	public function adhesion_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_adhesion_creative',$data);	

	}

	/* 

	 * name   : flex_creative

	 * @param : Null

	 * @return: Loads mobile adhesion creative modal box

	 */	

	public function flex_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_flex_creative',$data);	

	}



	

	/*

	 * 

	 * name   : edit_filmstrip_creative

	 * @param : creative id

	 * @return: Loads filmstrip creative details in a modal box

	 */	

	public function edit_filmstrip_creative($creative_id=false)

	{

		if($creative_id)

		{

		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								
				$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

				$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				$data['creative_details']=$creative_data[0];



				$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

				

				$data['creative_dependiency_data']=$creative_dependiency_data;



				echo $this->load->view('creatives/modal_creatives/content/edit_filmstrip_creative',$data);
			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */				

		}

	}



	/* 

	 * name   : pull_creative

	 * @param : Null

	 * @return: Loads mobile pull creative modal box

	 */	

	public function pull_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_pull_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_pull_creative

	 * @param : creative id

	 * @return: Loads pull creative details in a modal box

	 */	

	public function edit_pull_creative($creative_id=false)

	{

		if($creative_id)

		{

		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

			

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;

			echo $this->load->view('creatives/modal_creatives/content/edit_pull_creative',$data);

			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */			

		}

	}

	

	/* 

	 * name   : slider_creative

	 * @param : Null

	 * @return: Loads mobile slider creative modal box

	 */	

	public function slider_creative()

	{

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_slider_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_slider_creative

	 * @param : creative id

	 * @return: Loads slider creative details in a modal box

	 */	

	

	public function edit_slider_creative($creative_id=false)

	{

		if($creative_id)

		{

		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');
			
			$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_id),'php'); 	
			
			 if($acc_id == $adv_id)
			 {
				/*end */								
				$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

				$parent_data			= 	$this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"account_id"=>get_session('account_id'),"creative_id"=>$creative_id),'php');

				$child_data				= 	$this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>get_session('api_key'),"account_id"=>get_session('account_id'),"creative_id"=>$creative_id),'php');

				$data['parent_data']	=	$parent_data[0];

				$data['child_data']		=	$child_data;

				echo $this->load->view('creatives/modal_creatives/content/edit_slider_creative',$data);
			/* added by karthika on dec-12*/
			}else
			{
			redirect( site_url('advertiser/creatives'), "refresh");	
			}
			/* end */				

		}

	}

	

	/*

	 * 

	 * name: preview_creative

	 * @param : null

	 * @return : list of creatives to preview.

	 */	



	public function preview_creative($banner_id=FALSE)
	{  
		/* added by karthika on dec -12*/
		$acc_id = get_session('account_id');
		
		$adv_id = $this->rest->get('api/v1/creative/fetch_adv',array("api_key"=>get_session('api_key'),'banner_id'=>$banner_id),'php'); 	
		
		 if($acc_id == $adv_id)
		 {
			/*end */		
			
			
		$data['creative_list']	=	$this->rest->get('api/v1/approval/preview_creative',array("api_key"=>get_session('api_key'),'banner_id'=>$banner_id),'php'); 

		echo $this->load->view('creatives/modal_creatives/content/preview_creative',$data);
		
		/* added by karthika on dec-12*/
		}else
		{
		redirect( site_url('advertiser/creatives'), "refresh");	
		}
		/* end */
	}
	public function mobile_html_creative()

	{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_mob_html_creative',$data);	

	}
	
	// Link Zones Details
	public function link_zones($creative_id = FALSE)
	{
		
		if(!$creative_id || !is_numeric($creative_id))
		{
			$this->creatives();
		}
		else
		{
			$data['page_title'] 	= 	$this->lang->line('banners_zones');
			$data['breadcrumb']		= 	'';
			$data['creative_id']	=	$creative_id;
			/*$zone_data				= 	$this->rest->get('api/v1/creative/fetch_adblocks', array("api_key"=>get_session('api_key'), "creative_id" => $creative_id),'json');
			$data['zone_data']		=	json_decode($zone_data, true);*/
			
			$data['banner_data'] 	= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'), "creative_id" => $creative_id),'php');
			
			if($data['banner_data'][0]['dj_admin_approve'] == 0)
			{
				redirect('advertiser/creatives');
			}
			
			// GET DEFAULT PERIOD FROM CONFIG FILE
			$data['content'] 		=	$this->load->view('creatives/link_zones',$data,TRUE);
			$this->template->set_layout('advertiser_layout');
			$this->template->build('view', $data);
		}
	}

		/*
	 * 
	 * name   : video_interstital_creative
	 * @param : Null
	 * @return: Loads video overlay creative modal box
	 */	
	public function video_interstital_creative($type = 'web')
	{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>strtoupper($type)),'php');

		$data['type'] = $type;
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_interstital_creative',$data);	

	}
	/*

	 * 

	 * name   : edit_video_interstital_creative



	 * @param : Null

	 * @return: Loads video inline creative modal box

	 */	
	
		public function edit_video_interstital_creative($creative_id=false)
	{
		
		
		if($creative_id)
		{
			$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');
			
			$banner_type = ($creative_data[0]['dj_banner_type'] == 'MV_IR') ? 'MOBILE' : 'WEB';
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>$banner_type),'php');
		    
		    
			$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');
         
			$companion_id				=	$vast_data[0]['vast_companion_banner_id'];
			  

			if($companion_id!=0)

			{

				$companion_data			= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$companion_id),'php');

				if($companion_data)

				{

					$data['comp_size']	=	$companion_data[0]['width'].'x'.$companion_data[0]['height'];						

				}

				else

				{

					$data['comp_size']	=	'';

				}

			}

			else

			{

				$data['comp_size']		=	'';

			}

			

			$data['creative_data']		=	$creative_data[0];

			$data['vast_data']			=	$vast_data[0];

			

			echo $this->load->view('creatives/modal_creatives/content/edit_video_interstital_creative',$data);	

		}

	}
	
	
	/*
	 * 
	 * name   : video_native_creative
	 * @param : Null
	 * @return: Loads video overlay creative modal box
	 */	
	public function video_native_creative($type = 'mobile')
	{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns_bidding',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>strtoupper($type)),'php');

		$data['type'] = $type;
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_native_creative',$data);	

	}
	
	public function edit_video_native_creative($creative_id=false)
	{
		
		
		if($creative_id)
		{
			$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');
			
			$banner_type = 'MOBILE';
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>$banner_type),'php');
		    
		    
			$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');
         
			$companion_id				=	$vast_data[0]['vast_companion_banner_id'];
			  

			if($companion_id!=0)

			{

				$companion_data			= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>get_session('api_key'),"creative_id"=>$companion_id),'php');

				if($companion_data)

				{

					$data['comp_size']	=	$companion_data[0]['width'].'x'.$companion_data[0]['height'];						

				}

				else

				{

					$data['comp_size']	=	'';

				}

			}

			else

			{

				$data['comp_size']		=	'';

			}

			
			$data['creative_data']		=	$creative_data[0];

			$data['vast_data']			=	$vast_data[0];

			

			echo $this->load->view('creatives/modal_creatives/content/edit_video_native_creative',$data);	

		}

	}

	/* 
	 * name   : native image creative
	 * @param : Null
	 * @return: Loads mobile native image creative creative modal box
	 */	
	public function native_image_creative()
	{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');
		echo $this->load->view('creatives/modal_creatives/content/add_native_image_creative',$data);	
	}

	public function edit_native_image_creative($creative_id=false)
	{
		if($creative_id)
		{
			$creative_data				= 	$this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');
			
			$banner_type = 'MOBILE';
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>$banner_type),'php');
		    
			$data['comp_size']		=	'';
			
			$data['creative_data']		=	$creative_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_native_image_creative',$data);	

		}
	}

	//mobile_html5_creative
	public function mobile_html5_creative()
	{
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session("api_key"),"subacc"=>get_session("subacc"),"site_id"=>get_session("site_id"),"campaignid"=>get_session("campaignid"),"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_mob_html5_creative',$data);	

	}

	//edit_html5_mobile_creative
	function edit_html5_mobile_creative($creative_id=false){

//print_r($creative_id);
		if($creative_id){

			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>get_session('api_key'),"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			echo $this->load->view('creatives/modal_creatives/content/edit_mob_html5_creative',$data);

		}

	}

	public function geofencing_terget($campaignid=false)

	{  	
		if($campaignid){
		 $data['geofencing']	=	$this->rest->get('api/v1/creative/geofencing_fetch',array("api_key"=>get_session('api_key'),'campaignid'=>$campaignid),'json');
		 $data['count'] = count(json_decode($data['geofencing'],true));
		 echo $this->load->view('creatives/modal_creatives/content/geofencing',$data); 
		}else
		{
			echo $this->load->view('creatives/modal_creatives/content/geofencing');
		}
	}

	public function geofencing_add()
	{
		 $data = $this->input->post();
		 $circles=$data['circles'];
		 // $circles='welcome';
		 $campaignid=$data['campaign_id'];

		 $geofencing=$this->rest->post('api/v1/creative/geofencing_add',array("api_key"=>get_session('api_key'),'campaignid'=>$campaignid,'circles'=>$circles),'php'); 

	}
	
	

	
	
				
}

