<?php 

class Campaigns extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->campaigns();
	}
	
	/*
	 * 
	 * name		:campaigns
	 * @param   :Null
	 * @return  :List all the campaigns for a particular
	 *
	 */	

	public function campaigns()
	{

		$data['page_title'] = $this->lang->line('manage_your_campaigns');
		$data['link'] =$this->default_configurations->get('linking_type');

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['MANAGE_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('campaigns/manage_campaigns',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:fetch_campaign
	 * @param   :Null
	 * @return  :List all the creatives for a particular
	 * 			 advertiser
	 */	

	public function fetch_campaign()
	{
		
		
		$campaigns		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'json');
		
		echo convert_to_datatable_format($campaigns);
	}
	
	/*
	 * 
	 * name   : add_campaigns
	 * @param : Null
	 * @return: Loads a page to create a new campaign
	 * 
	 */	

	public function add_campaigns()
	{
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		//Fetch available site categories
		$data['campaign_category']=$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');
		
	
		// INtegration by jayashree 
			//Fetch available publishers
		$data['sel_publishers']=$this->rest->get('api/v1/utilities/fetch_publisherslist/',array("api_key"=>get_session('api_key'),'agency_id'=>$agency_id),'php');
		
		if($data['sel_publishers']!='')
		{
			
			
		array_push($data['sel_publishers'],array('publisher_name' => 'All','pub_id'=>'all','publisher_site'=>'Publishers'));
		}
		//Fetch available dsp
		$data['dsplist'] = $this->rest->get('api/v1/utilities/dsplist', array("api_key" => get_session('api_key'),'agency_id'=>1) , 'php');
		//~ print_r(json_decode($data['dsplist']));exit;
		if($data['dsplist']!='')
		{
			
			array_push($data['dsplist'],array("dsp_type_name" => "All SSP's","exchangeid"=>"all"));
		}
	
	
		//Fetch available campaign type
		$data['campaign_type']		= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
       //For available ssp categories
        $data['ssp_category'] = $this->rest->get('api/v1/utilities/ssplist', array(
            "api_key" => get_session('api_key')
        ) , 'php');
        //Fetch day and time
        
        $data['target']				=	$this->targeting_list();
        
        $data['dsp_category'] =$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');
	
		$data['content'] = $this->load->view('campaigns/add_campaigns',$data,TRUE);

		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name   : edit_campaign
	 * @param : Null
	 * @return: Loads a page to edit a new campaign
	 * 
	 */	

	public function edit_campaign($campaign_id=false)
	{
		/* added by karthika on dec -10*/
		$acc_id = get_session('account_id');
		
		$camp_adv_id = $this->rest->get('api/v1/campaign/get_advertiser_account',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');		
		
		if($acc_id == $camp_adv_id)
		{
			/*end */
			$campaign_check = $this->rest->get('api/v1/campaign/check_houseads_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$campaign_ck = $campaign_check[0];
			
			$admin_campaign = $campaign_ck['campaignid'];
			
				
			
			if($campaign_id == $admin_campaign)
			{
				redirect( site_url('advertiser/campaigns'), "refresh");
			} 
			
			
			if($campaign_id)
			{
				
				
				$data['page_title'] = "Optimize campaign";

				$data['breadcrumb'] = '';
				//Fetch available site categories
				$data['campaign_category']=$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');
				
				//Fetch available publishers integrated by jayashree
			$data['sel_publishers']=$this->rest->get('api/v1/utilities/fetch_publisherslist/',array("api_key"=>get_session('api_key'),'agency_id'=>$agency_id),'php');
			if($data['sel_publishers']!='')
			{
				array_push($data['sel_publishers'],array('company_name' => 'All','pub_id'=>'all','publisher_site'=>'Publishers'));
			}
			$data['publisherids']=$this->rest->get('api/v1/utilities/fetch_publishersid/',array("api_key"=>get_session('api_key'),'agency_id'=>$agency_id),'php');
	
			//Fetch available dsp
			$data['dsplist'] = $this->rest->get('api/v1/utilities/dsplist', array("api_key" => get_session('api_key'),'agency_id'=>1) , 'php');
			
			if($data['dsplist']!='')
			{
				array_push($data['dsplist'],array("dsp_type_name" => "All SSP's","exchangeid"=>"all"));
			}
				
			$data['dspids'] = $this->rest->get('api/v1/utilities/dspids', array("api_key" => get_session('api_key'),'agency_id'=>1) , 'php');
			
				
					//For available ssp categories
				$data['ssp_category'] = $this->rest->get('api/v1/utilities/ssplist', array(
					"api_key" => get_session('api_key')
				) , 'php');
				
				$data['dsp_category'] =$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');
				//Fetch day and time
				$data['target']				=	$this->targeting_list();
				//Fetch available campaign type
				$data['campaign_type']		= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
				//Fetch Campaign details
				$camapaign_details= $this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				
			$data['aff_ids']=$camapaign_details[0]['affiliate_id'];
			$data['pub_list']=explode(',',$camapaign_details[0]['affiliate_id']);
			$data['dsp_list']=explode(',',$camapaign_details[0]['dsplist']);

				//Fetch browser targeting details
				$browser_details= $this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch os targeting details
				$os_details= $this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch time targeting details
				$time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch geo targeting details
				$geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch city targeting
				 $city_details= $this->rest->get('api/v1/campaign/fetch_city_targeting',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id,"type"=>'city'),'php');
               
				//Fetch profile targeting details
				$profile_age= $this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				$profile_gender= $this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				$profile_color= $this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				$profile_height= $this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				$profile_weight= $this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');

				//Fetch mobile os targeting details
				$mobile_os_details= $this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch mobile manufactures targeting details
				$mobile_manu_details= $this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch mobile capability details
				$mobile_capa_details= $this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch mobile telecom details
				$mobile_telecom_details= $this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				//Fetch moblie geo targetting details
				$mobile_geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				
				

				
				$data['camapaign_details']=$camapaign_details[0];
				
				
				$data['targ_browser']=$browser_details[0];
				$data['targ_os']=$os_details[0];
				$data['targ_time']=$time_details[0];
				$data['targ_geo']=$geo_details[0];
				$data['targ_city']=$city_details[0];
				$data['profile_age']=$profile_age[0];
				$data['profile_gender']=$profile_gender[0];
				$data['profile_color']=$profile_color[0];
				$data['profile_height']=$profile_height[0];
				$data['profile_weight']=$profile_weight[0];
				
				$data['targ_mob_os']=$mobile_os_details[0];
				$data['targ_mob_manu']=$mobile_manu_details[0];
				$data['targ_mob_capa']=$mobile_capa_details[0];
				$data['targ_mob_tele']=$mobile_telecom_details[0];
				$data['targ_mob_geo']=$mobile_geo_details[0];
				//print_r($data);exit;
				$data['content'] = $this->load->view('campaigns/edit_campaigns',$data,TRUE);

				$this->template->set_layout('advertiser_layout');
				$this->template->build('view', $data);
			}
			
		}else
		{
			redirect( site_url('advertiser/campaigns'), "refresh");
		}

	}

	/*
	 * 
	 * name   : fetch_campaign_crative
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function fetch_campaign_creative($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');
		
		
		$daypart_time=$this->input->post('daypart_time');
		
		$a=$this->input->post('targ_time');
	
		
		if(($daypart_time != NULL || $daypart_time != '') ){
			$day_targ = 'Y';
			
		}
		else{
			$day_targ = 'N';
			
		}
		if(($this->input->post('targ_time'))){
			$targ_times = $this->input->post('targ_time');
			
		}
		else{
			
		}
		if(($this->input->post('targ_daypart'))){
			$targ_daypart = $this->input->post('targ_daypart');
			
			
		}
		else{
			
		}
		if(($daypart_time != NULL || $daypart_time != '') ){
			
		$input = array(
						'api_key'=>get_session('api_key'),
						'campaign_id'=>$campaign_id,
						'day_targ' => $day_targ,
						'daypart_time'=>$this->input->post('daypart_time'),
					  );
			
		$data['campaign_day_success']	= $this->rest->post('api/v1/campaign/add_campaign_favourite',$input,'json');
		
	}
		
		//Fetch available linked creatives
		
		$data['existing_creative']	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		//print_r($data['existing_creative']);exit;
		#echo $this->rest->debug();exit;

		echo $this->load->view('campaigns/existing_creative',$data);

	}
	/*
	 * 
	 * name   : overview
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function overview($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');
		
		//echo $campaign_id;
		//exit;

		//Fetch Campaign details
		$camapaign_details['campaign_details']= $this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key'),"view_type"=>'formated'),'json');
		$camp_details_to_php_array=json_decode($camapaign_details['campaign_details']);//For verification
		if($camp_details_to_php_array[0]->dj_targetting_type=='WEB')
		{
			//Fetch browser targeting details
			$browser_details= $this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_browsers_display_name='';
			if(isset($browser_details[0]['data']) AND !empty($browser_details[0]['data']))
			{
				$browser_details_array=explode(',',$browser_details[0]['data']);
				foreach($browser_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_BROWSERS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_browsers_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch os targeting details
			$os_details= $this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_os_display_name='';
			if(isset($os_details[0]['data']) AND !empty($os_details[0]['data']))
			{
				$os_details_array=explode(',',$os_details[0]['data']);
				foreach($os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch time targeting details
			//~ $time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php'); 
			//~ $targetted_time_display_name='';
						//~ 
			//~ if(isset($time_details[0]['data']))// AND !empty($time_details[0]['data']))
			//~ {
				//~ $targ_time_array=array('1'=>'0:00-0:59','2'=>'1:00-1:59' ,'3'=>'2:00-2:59' ,'4'=>'3:00-3:59','5'=>'4:00-4:59','6'=>'5:00-5:59' ,'7'=> '6:00-6:59','8'=> '7:00-7:59','9'=>'8:00-8:59' ,'10'=> '9:00-9:59','11'=>'10:00-10:59' ,'12'=>'11:00-11:59','13'=>'12:00-12:59','14'=>'13:00-13:59','15'=>'14:00-14:59' ,'16'=>'15:00-15:59' ,'17'=>'16:00-16:59','18'=> '17:00-17:59','19'=> '18:00-18:59','20'=>'19:00-19:59' ,'21'=>'20:00-20:59','22'=> '21:00-21:59','23'=> '22:00-22:59','24'=>'23:00-23:59');
				//~ $time_details_array=explode(',',$time_details[0]['data']);
				//~ foreach($time_details_array as $value)
				//~ {
					//~ if(isset($targ_time_array[$value]) AND !empty($targ_time_array[$value]))
						//~ $targetted_time_display_name.=ucfirst($targ_time_array[$value]).',';
				//~ }
			//~ }
			//Fetch time and day targeting details
			$time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php'); 
			$targetted_time_display_name='';
			$day_array=array();$time_array=array();$time_series='';			
			if(isset($time_details[0]['data']))// AND !empty($time_details[0]['data']))
			{
				$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
				$targ_day_array			=	array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
				$time_details_array=explode(',',$time_details[0]['data']);
				foreach($time_details_array as $value)
				{
					$day_time_array=explode('_',$value);
					$day = $day_time_array[0];
					$time = $day_time_array[1];//print_r($time);
					if(isset($targ_time_array[$time]) AND !empty($targ_time_array[$time]) AND isset($targ_day_array[$day]) AND !empty($targ_day_array[$day])){
						 if(!in_array($day, $day_array, true)){
							array_push($day_array, $day);
						}
						 if(in_array($day, $day_array, true)){
							//array_push($time_array, $time);
							$time_array[$day][]=$time;
							
						}
				
					}
				}
			}
			$countht=0;
			$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
			$targ_day_array			=	array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
			foreach($time_array as $key=>$vals){
				
				
				foreach($vals as $keys=>$timess){
					
					$time_first=explode('-',$targ_time_array[$timess]);
					$time_series .= ucfirst($time_first[0]).',';
					$countht++;
				}
				
				$targetted_time_display_name .= ucfirst($targ_day_array[$key]).'-'.rtrim($time_series,",").'</br>';
				$time_series = '';
				
			}
			if($countht == '168' || $countht == 0){
					$targetted_time_display_name = "All";
				}
				else{
					$targetted_time_display_name = $targetted_time_display_name;
				}
			//Fetch geo targeting details
			$geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_geo_display_name='';
			if(isset($geo_details[0]['data']) AND !empty($geo_details[0]['data']))
			{
				$geo_details_array=explode(',',$geo_details[0]['data']);
				foreach($geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			
			$capping=$camp_details_to_php_array[0]->capping;
			$block=$camp_details_to_php_array[0]->block/3600;
			$frequency_capping=$capping.'&nbsp;impression in '.$block.'&nbsp;Hours';
			  //Fetch City details
			$city_details= $this->rest->get('api/v1/campaign/fetch_city_targeting',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id,"type"=>'city'),'php');
			$targetted_city_display_name='';
		
			if(isset($city_details[0]['data']) AND !empty($city_details[0]['data']))
			{			
				$city_details_array=explode(',',$city_details[0]['data']);
				$country_array = array();
				$city_array = array();
				foreach($city_details_array as $value)
				{
				$text=explode('|',$value);
				$country_code=$text[0];
				$city_name=$text[1];
				    $this->db->select("name");
					$this->db->where('value',$country_code);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					$country_name=$result[0]['name'];
					$test=$country_name .'-'.$city_name;
					 if(!in_array($country_name, $country_array, true)){
							array_push($country_array, $country_name);
						}
						 if(in_array($country_name, $country_array, true)){
							//array_push($time_array, $time);
							$city_array[$country_name][]=$city_name;
							
							
						}
					}
			    foreach($city_array as $key=>$vals){
			
				
				foreach($vals as $keys=>$times){
						
					$time_first=$times;
					$time_series .= ucfirst($time_first).',';
					
				}
				
				$targetted_city_display_name .= ucfirst($key).'-'.rtrim($time_series,",").'</br>';
				
				$time_series = '';
			
				}				
		
				//~ $targetted_city_display_name=rtrim($targetted_city_display_name,",");
			
			}

			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_browsers_display_name,'targ_2'=>$targetted_os_display_name,'targ_7'=>$targetted_time_display_name,'targ_4'=>$targetted_geo_display_name,'targ_5'=>$frequency_capping,'targ_11'=>$targetted_city_display_name)
			);
		}
		elseif($camp_details_to_php_array[0]->dj_targetting_type=='MOBILE')
		{
			//echo $campaign_id;
			//echo "MOBILE";
		
			
			//Fetch mobile os targeting details
			$mobile_os_details= $this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_os_display_name='';
			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_details_array=explode(',',$mobile_os_details[0]['data']);
				foreach($mobile_os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details
			$mobile_manu_details= $this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_manu_display_name='';
			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_details_array=explode(',',$mobile_manu_details[0]['data']);
				foreach($mobile_manu_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_MANU);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_manu_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			
			//print_r($mobile_manu_details);
			//exit;
			//Fetch mobile capability details
			$mobile_capa_details= $this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			//~ print_r($mobile_capa_details);exit;
			$targetted_mob_capa_display_name='';
			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_details_array=explode(',',$mobile_capa_details[0]['data']);
				$param_array = array();
				$param_value_array = array();
				foreach($mobile_capa_details_array as $value)
				{
				$text=explode('|',$value);
				$param_name=$text[0];
				$param_value=$text[1];
				    $this->db->select("name");
					$this->db->where('name',$param_name);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					$device_name=$result[0]['name'];
					$test=$device_name .'-'.$param_value;
					 if(!in_array($device_name, $param_array, true)){
							array_push($param_array, $device_name);
						}
						 if(in_array($device_name, $param_array, true)){
							//array_push($time_array, $time);
							$param_value_array[$device_name][]=$param_value;
						
						}
					}
			    foreach($param_value_array as $key=>$vals){
			
				
				foreach($vals as $keys=>$capability_value){
						
					$capability_first=$capability_value;
					$capability_series .= ucfirst($capability_first).',';
					
				}
				
				
				$targetted_mob_capa_display_name .= ucfirst($key).'-'.rtrim($capability_series,",").'</br>';
				
				$capability_series = '';
			
				}				
		
			}
			//Fetch mobile telecom details
			$mobile_telecom_details= $this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("campaign_id"=>$campaign_id,"type"=>'teleco',"api_key"=>get_session('api_key')),'php');
			
			$targetted_mob_telecom_display_name='';
			
			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{			
				$mobile_telecom_details_array=explode(',',$mobile_telecom_details[0]['data']);
				
				$carrier_array = array();
				$ip_array = array();
				foreach($mobile_telecom_details_array as $value)
				{
				$text=explode('|',$value);
				$carrier=$text[1];
				
				$ip=$text[2];
			
				    $this->db->select("carriername");
					$this->db->where('carriername',$carrier);
					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		
					$result = $query->result_array();
					$carrier_name=$result[0]['carriername'];
					 if(!in_array($carrier_name, $carrier_array, true)){
							array_push($carrier_array, $carrier_name);
						}
						 if(in_array($carrier_name, $carrier_array, true)){
							//array_push($time_array, $time);
							$telecom_array[$carrier_name][]=$ip;
						
							
						}
					}
			    foreach($telecom_array as $key=>$vals){
			
				
				foreach($vals as $keys=>$teleco){
						
					$telecom_first=$teleco;
					$telecom_series .= ucfirst($telecom_first).';';
					
				}
				
				$targetted_mob_telecom_display_name .= ucfirst($key).'-'.rtrim($telecom_series,",").'</br>';
				
				$telecom_series = '';
			
				}				
		
				
			
			}

			//Fetch moblie geo targetting details
			$mobile_geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_geo_display_name='';
			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_details_array=explode(',',$mobile_geo_details[0]['data']);
				foreach($mobile_geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}

				//Fetch time and day targeting details
			$time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php'); 
			$targetted_time_display_name='';
			$day_array=array();$time_array=array();$time_series='';			
			if(isset($time_details[0]['data']))// AND !empty($time_details[0]['data']))
			{
				$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
				$targ_day_array			=	array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
				$time_details_array=explode(',',$time_details[0]['data']);
				foreach($time_details_array as $value)
				{
					$day_time_array=explode('_',$value);
					$day = $day_time_array[0];
					$time = $day_time_array[1];//print_r($time);
					if(isset($targ_time_array[$time]) AND !empty($targ_time_array[$time]) AND isset($targ_day_array[$day]) AND !empty($targ_day_array[$day])){
						 if(!in_array($day, $day_array, true)){
							array_push($day_array, $day);
						}
						 if(in_array($day, $day_array, true)){
							//array_push($time_array, $time);
							$time_array[$day][]=$time;
							
						}
				
					}
				}
			}
			$countmht=0;
			$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
			$targ_day_array			=	array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
			foreach($time_array as $key=>$vals){
				
				
				foreach($vals as $keys=>$timess){
					
					$time_first=explode('-',$targ_time_array[$timess]);
					$time_series .= ucfirst($time_first[0]).',';
					$countmht++;
				}
				
				$targetted_time_display_name .= ucfirst($targ_day_array[$key]).'-'.rtrim($time_series,",").'</br>';
				$time_series = '';
				
			}
			if($countmht == '168' || $countmht == 0){
					$targetted_time_display_name = "All";
				}
				else{
					$targetted_time_display_name = $targetted_time_display_name;
				}
            //Fetch City details
			$city_details= $this->rest->get('api/v1/campaign/fetch_city_targeting',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id,"type"=>'city'),'php');
			$targetted_city_display_name='';
		
			if(isset($city_details[0]['data']) AND !empty($city_details[0]['data']))
			{			
				$city_details_array=explode(',',$city_details[0]['data']);
				$country_array = array();
				$city_array = array();
				foreach($city_details_array as $value)
				{
				$text=explode('|',$value);
				$country_code=$text[0];
				$city_name=$text[1];
				    $this->db->select("name");
					$this->db->where('value',$country_code);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					$country_name=$result[0]['name'];
					$test=$country_name .'-'.$city_name;
					 if(!in_array($country_name, $country_array, true)){
							array_push($country_array, $country_name);
						}
						 if(in_array($country_name, $country_array, true)){
							//array_push($time_array, $time);
							$city_array[$country_name][]=$city_name;
							
							
						}
					}
			    foreach($city_array as $key=>$vals){
			
				
				foreach($vals as $keys=>$times){
						
					$time_first=$times;
					$time_series .= ucfirst($time_first).',';
					
				}
				
				$targetted_city_display_name .= ucfirst($key).'-'.rtrim($time_series,",").'</br>';
				
				$time_series = '';
			
				}				
		
				//~ $targetted_city_display_name=rtrim($targetted_city_display_name,",");
			
			}



			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_mob_os_display_name,'targ_2'=>$targetted_mob_manu_display_name,'targ_8'=>$targetted_mob_capa_display_name,'targ_4'=>$targetted_mob_telecom_display_name,'targ_5'=>$targetted_mob_geo_display_name,'targ_7'=>$targetted_time_display_name,'targ_11'=>$targetted_city_display_name)
			);
			
			//echo $campaign_id;
			//echo "<pre>";
			//print_r($final_targeting);
			//echo "</pre>";
		//exit;
		}
		elseif($camp_details_to_php_array[0]->dj_targetting_type=='CROSS')
		{
			$browser_details= $this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_browsers_display_name='';
			if(isset($browser_details[0]['data']) AND !empty($browser_details[0]['data']))
			{
				$browser_details_array=explode(',',$browser_details[0]['data']);
				foreach($browser_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_BROWSERS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_browsers_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch os targeting details
			$os_details= $this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_os_display_name='';
			if(isset($os_details[0]['data']) AND !empty($os_details[0]['data']))
			{
				$os_details_array=explode(',',$os_details[0]['data']);
				foreach($os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//~ //Fetch time targeting details
			//~ $time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php'); 
			//~ $targetted_time_display_name='';
						//~ 
			//~ if(isset($time_details[0]['data']))// AND !empty($time_details[0]['data']))
			//~ {
				//~ $targ_time_array=array('1'=>'0:00-0:59','2'=>'1:00-1:59' ,'3'=>'2:00-2:59' ,'4'=>'3:00-3:59','5'=>'4:00-4:59','6'=>'5:00-5:59' ,'7'=> '6:00-6:59','8'=> '7:00-7:59','9'=>'8:00-8:59' ,'10'=> '9:00-9:59','11'=>'10:00-10:59' ,'12'=>'11:00-11:59','13'=>'12:00-12:59','14'=>'13:00-13:59','15'=>'14:00-14:59' ,'16'=>'15:00-15:59' ,'17'=>'16:00-16:59','18'=> '17:00-17:59','19'=> '18:00-18:59','20'=>'19:00-19:59' ,'21'=>'20:00-20:59','22'=> '21:00-21:59','23'=> '22:00-22:59','24'=>'23:00-23:59');
				//~ $time_details_array=explode(',',$time_details[0]['data']);
				//~ foreach($time_details_array as $value)
				//~ {
					//~ if(isset($targ_time_array[$value]) AND !empty($targ_time_array[$value]))
						//~ $targetted_time_display_name.=ucfirst($targ_time_array[$value]).',';
				//~ }
			//~ }
			
			//Fetch time and day targeting details
			$time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php'); 
			$targetted_time_display_name='';
			$day_array=array();$time_array=array();$time_series='';			
			if(isset($time_details[0]['data']))// AND !empty($time_details[0]['data']))
			{
				$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
				$targ_day_array			=	array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
				$time_details_array=explode(',',$time_details[0]['data']);
				foreach($time_details_array as $value)
				{
					$day_time_array=explode('_',$value);
					$day = $day_time_array[0];
					$time = $day_time_array[1];//print_r($time);
					if(isset($targ_time_array[$time]) AND !empty($targ_time_array[$time]) AND isset($targ_day_array[$day]) AND !empty($targ_day_array[$day])){
						 if(!in_array($day, $day_array, true)){
							array_push($day_array, $day);
						}
						 if(in_array($day, $day_array, true)){
							//array_push($time_array, $time);
							$time_array[$day][]=$time;
							
						}
				
					}
				}
			}
			$countmht=0;
			$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
			$targ_day_array			=	array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
			foreach($time_array as $key=>$vals){
				
				
				foreach($vals as $keys=>$timess){
					
					$time_first=explode('-',$targ_time_array[$timess]);
					$time_series .= ucfirst($time_first[0]).',';
					$countmht++;
				}
				
				$targetted_time_display_name .= ucfirst($targ_day_array[$key]).'-'.rtrim($time_series,",").'</br>';
				$time_series = '';
				
			}
				if($countmht == '168' || $countmht == 0){
					$targetted_time_display_name = "All";
				}
				else{
					$targetted_time_display_name = $targetted_time_display_name;
				}
			//Fetch geo targeting details
			$geo_details= $this->rest->get('api/v1/campaign/fetch_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_geo_display_name='';
			if(isset($geo_details[0]['data']) AND !empty($geo_details[0]['data']))
			{
				$geo_details_array=explode(',',$geo_details[0]['data']);
				foreach($geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			
			$capping=$camp_details_to_php_array[0]->capping;
			$block=$camp_details_to_php_array[0]->block/3600;
			$frequency_capping=$capping.'&nbsp;impression in '.$block.'&nbsp;Hours';
			
			$mobile_os_details= $this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_os_display_name='';
			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_details_array=explode(',',$mobile_os_details[0]['data']);
				foreach($mobile_os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details
			$mobile_manu_details= $this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_manu_display_name='';
			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_details_array=explode(',',$mobile_manu_details[0]['data']);
				foreach($mobile_manu_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_MANU);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_manu_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			
			//print_r($mobile_manu_details);
			//exit;
			//Fetch mobile capability details
			$mobile_capa_details= $this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			//~ print_r($mobile_capa_details);exit;
			$targetted_mob_capa_display_name='';
			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_details_array=explode(',',$mobile_capa_details[0]['data']);
				$param_array = array();
				$param_value_array = array();
				foreach($mobile_capa_details_array as $value)
				{
				$text=explode('|',$value);
				$param_name=$text[0];
				$param_value=$text[1];
				    $this->db->select("name");
					$this->db->where('name',$param_name);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					$device_name=$result[0]['name'];
					$test=$device_name .'-'.$param_value;
					 if(!in_array($device_name, $param_array, true)){
							array_push($param_array, $device_name);
						}
						 if(in_array($device_name, $param_array, true)){
							//array_push($time_array, $time);
							$param_value_array[$device_name][]=$param_value;
						
						}
					}
			    foreach($param_value_array as $key=>$vals){
			
				
				foreach($vals as $keys=>$capability_value){
						
					$capability_first=$capability_value;
					$capability_series .= ucfirst($capability_first).',';
					
				}
				
				
				$targetted_mob_capa_display_name .= ucfirst($key).'-'.rtrim($capability_series,",").'</br>';
				
				$capability_series = '';
			
				}				
		
			}
			//Fetch mobile telecom details
			$mobile_telecom_details= $this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("campaign_id"=>$campaign_id,"type"=>'teleco',"api_key"=>get_session('api_key')),'php');
			
			$targetted_mob_telecom_display_name='';
			
			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{			
				$mobile_telecom_details_array=explode(',',$mobile_telecom_details[0]['data']);
				
				$carrier_array = array();
				$ip_array = array();
				foreach($mobile_telecom_details_array as $value)
				{
				$text=explode('|',$value);
				$carrier=$text[1];
				
				$ip=$text[2];
			
				    $this->db->select("carriername");
					$this->db->where('carriername',$carrier);
					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		
					$result = $query->result_array();
					$carrier_name=$result[0]['carriername'];
					 if(!in_array($carrier_name, $carrier_array, true)){
							array_push($carrier_array, $carrier_name);
						}
						 if(in_array($carrier_name, $carrier_array, true)){
							//array_push($time_array, $time);
							$telecom_array[$carrier_name][]=$ip;
						
							
						}
					}
			    foreach($telecom_array as $key=>$vals){
			
				
				foreach($vals as $keys=>$teleco){
						
					$telecom_first=$teleco;
					$telecom_series .= ucfirst($telecom_first).';';
					
				}
				
				$targetted_mob_telecom_display_name .= ucfirst($key).'-'.rtrim($telecom_series,",").'</br>';
				
				$telecom_series = '';
			
				}				
		
				
			
			}

			//Fetch moblie geo targetting details
			$mobile_geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_geo_display_name='';
			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_details_array=explode(',',$mobile_geo_details[0]['data']);
				foreach($mobile_geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch City details
				$city_details= $this->rest->get('api/v1/campaign/fetch_city_targeting',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id,"type"=>'city'),'php');
			$targetted_city_display_name='';
		
			if(isset($city_details[0]['data']) AND !empty($city_details[0]['data']))
			{			
				$city_details_array=explode(',',$city_details[0]['data']);
				$country_array = array();
				$city_array = array();
				foreach($city_details_array as $value)
				{
				$text=explode('|',$value);
				$country_code=$text[0];
				$city_name=$text[1];
				    $this->db->select("name");
					$this->db->where('value',$country_code);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					$country_name=$result[0]['name'];
					$test=$country_name .'-'.$city_name;
					 if(!in_array($country_name, $country_array, true)){
							array_push($country_array, $country_name);
						}
						 if(in_array($country_name, $country_array, true)){
							//array_push($time_array, $time);
							$city_array[$country_name][]=$city_name;
							
							
						}
					}
			    foreach($city_array as $key=>$vals){
			
				
				foreach($vals as $keys=>$times){
						
					$time_first=$times;
					$time_series .= ucfirst($time_first).',';
					
				}
				
				$targetted_city_display_name .= ucfirst($key).'-'.rtrim($time_series,",").'</br>';
				
				$time_series = '';
			
				}				
		
				//~ $targetted_city_display_name=rtrim($targetted_city_display_name,",");
			
			}



			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_browsers_display_name,'targ_2'=>$targetted_os_display_name,'targ_3'=>$targetted_time_display_name,'targ_4'=>$targetted_geo_display_name,'targ_5'=>$frequency_capping,'targ_6'=>$targetted_mob_os_display_name,'targ_7'=>$targetted_mob_manu_display_name,'targ_8'=>$targetted_mob_capa_display_name,'targ_9'=>$targetted_mob_telecom_display_name,'targ_10'=>$targetted_mob_geo_display_name,'targ_11'=>$targetted_city_display_name)
			);
			
			//echo $campaign_id;
			 //~ echo "<pre>";
			 //~ print_r($final_targeting);
			 //~ echo "</pre>";
		//~ exit;
			
		}

		$existing_creative	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		if(!empty($existing_creative))
			$no_of_creative['no_of_linked_creative']=sizeof($existing_creative);
		else
			$no_of_creative['no_of_linked_creative']='0';
		
		$result_tmp=array_merge($camapaign_details,$no_of_creative);
		
		if(isset($final_targeting))
		{
			$result=json_encode(array_merge($result_tmp,$final_targeting));
			print_r($result);
		}
		else
		{
			$result=json_encode($result_tmp);
			print_r($result);
		}
		
		
	}

	
	/*
	 * 
	 * name   : view_tracker
	 * @param : campaign_id
	 * @return: Fetch campaign tracker code for particular campaign
	 */	
	public function view_tracker($campaign_id)
	{
		/* added by karthika on dec -10*/
		$acc_id = get_session('account_id');
		
		$camp_adv_id = $this->rest->get('api/v1/campaign/get_advertiser_account',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');		

		if($acc_id == $camp_adv_id)
		{
			/*end */		
		
			$data['tracker_data'] = $this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'json');
			if($data['tracker_data']!=='')
			{
				echo $this->load->view('campaigns/view_trackers_content',$data);
			}
		/* added by karthika on dec-10*/	
		}else
		{
			redirect( site_url('advertiser/campaigns'), "refresh");
		}		
		/* end */
	}
	//manual linking aprl 18
	public function linked_zones($campaign_id = FALSE)
	{
		/* added by karthika on dec -10*/
		$acc_id = get_session('account_id');
		
		$camp_adv_id = $this->rest->get('api/v1/campaign/get_advertiser_account',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');		
		
		if($acc_id == $camp_adv_id)
		{
			/*end */				
			if(!$campaign_id || !is_numeric($campaign_id))
			{
				$this->campaigns();
			}
			else
			{
				$data['page_title'] 	= 	"Campaigns to Zone linking";
				$data['breadcrumb']		= 	'';
				$data['campaign_id']	=	$campaign_id;
				$data['campaign_data'] 	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("api_key"=>get_session('api_key'), "campaign_id" => $campaign_id),'php');
				$data['content'] 		=	$this->load->view('campaigns/linked_zones',$data,TRUE);
				$this->template->set_layout('advertiser_layout');
				$this->template->build('view', $data);
			}
		/* added by karthika on dec-10*/	
		}else
		{
			redirect( site_url('advertiser/campaigns'), "refresh");
		}		
		/* end */			
	
	}
	/*
	 * 
	 * name		:targeting
	 * @param   :Null
	 * @return  :List Day time targeting
	 *
	 */	

	public function targeting_list()
	{
		$api_key		=	get_session('api_key');
		$data['time']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		$data['days']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'days'),'php');
		//print_r($data['time']);exit;
		return $data;
	}
	
}
