<!--scripts-->
<script src="<?php echo base_url();?>support/highcharts/js/highcharts.js"></script>
<script src="<?php echo base_url();?>support/highcharts/js/modules/exporting.js"></script>
<!--scripts-->
<div class="page-header">
   <div class="pull-left">
      <h1><?php echo $this->lang->line('environment_report');?></h1>
      <div class="help-block">
         <?php echo $this->lang->line('environment_helpblock');?>
      </div>
   </div>
   <?php  echo $this->template_widget->widget('admin_earnings');?>
</div>
<div class="breadcrumbs">
   <?php echo $breadcrumb;?>
</div>
<div class="row-fluid">
   <div class="span12">
      <div class="box ">
         <div class="box-title">
            <h3><i class="icon-bar-chart"></i><?php echo $this->lang->line('perform_environment');?></h3>
            <div class="actions"><a href="#" class="btn btn-mini content-slideUp"><i class="icon-angle-down"></i></a> </div>
         </div>
         <div class="box-content">
            <div class="statistic-big">
               <div class="top">
                  <div class="highlight-toolbar">
                     <div class="pull-left">
                        <form id='frm_search' name="frm_search">
                           <div class="btn-toolbar">
                              <div class="btn-group">
                                 <?php if($this->config->item('prod_code')=='MOB'){?>
                                 <select id='environment' name="environment" class='chosen-select' data-nosearch="true" data-placeholder="<?php echo $this->lang->line('sort_by'); ?>" onchange="update_filter()">
                                    <option value="Mobile"><?php echo $this->lang->line('mobile'); ?></option>
                                 </select>
                                 <?php }else if($this->config->item('prod_code')=='VID'){?>
                                 <select id='environment' name="environment" class='chosen-select' data-nosearch="true" data-placeholder="<?php echo $this->lang->line('sort_by'); ?>" onchange="update_filter()">
                                    <option value="Display"><?php echo $this->lang->line('website'); ?></option>
                                 </select>
                                 <?php }else{?>
                                 <select id='environment' name="environment" class='chosen-select' data-nosearch="true" data-placeholder="<?php echo $this->lang->line('sort_by'); ?>" onchange="update_filter()">
                                    <option value="all"><?php echo $this->lang->line('all_environment'); ?></option>
                                    <option value="Display"><?php echo $this->lang->line('website'); ?></option>
                                    <option value="Mobile"><?php echo $this->lang->line('mobile'); ?></option>
                                 </select>
                                 <?php }?>
                              </div>
                              <div class="btn-group">
                                 <a href="#" name="reservation" id="reservation" class="btn margin_correction"><span>
                                 <span id="default_start_date"><?php echo ($search_date != FALSE)?date($this->default_configurations->date_format,strtotime($search_date['from_date'])):''; ?></span> - 
                                 <span id="default_end_date"><?php echo ($search_date != FALSE)?date($this->default_configurations->date_format,strtotime($search_date['to_date'])):''; ?></span></span>&nbsp;&nbsp;<i class="icon-caret-down"></i></a>				
                              </div>
                              <div class="btn-group">
                                 <a id='refresh_search'  class="btn margin_correction" rel="tooltip" title="<>"><i class="icon-refresh"></i></a>
                              </div>
                           </div>
                           <input type='hidden' value="<?php echo ($search_date != FALSE)?date('Y-m-d',strtotime($search_date['from_date'])):''; ?>"  id='date_from' name='date_from'/>
                           <input type='hidden' value="<?php echo ($search_date != FALSE)?date('Y-m-d',strtotime($search_date['to_date'])):''; ?>" id='date_to' name="date_to" />
                        </form>
                     </div>
                  </div>
               </div>
               <div class="bottom">
                  <div id="environment_performance_chart" style="min-width: 310px; margin: 0 auto">
				  <center><img id='loading' src='<?php echo base_url($this->config->item('theme_file_path')); ?>/img/loading.gif'></center>				  
				  </div>
               </div>
               <div class="bottom">
                  <ul class="stats-overview">
                     <li >
                        <span class="name" ><?php echo $this->lang->line('impression');?></span>
                        <span id='total_imp' class="value"> 0 </span>
                     </li>
                     <li>
                        <span class="name"><?php echo $this->lang->line('clicks');?></span>
                        <span id='total_clk' class="value"> 0 </span>
                     </li>
                     <li >
                        <span class="name"><?php echo $this->lang->line('unique_impression');?></span>
                        <span id='total_uimp' class="value">0 </span>
                     </li>
                     <li >
                        <span class="name" ><?php echo $this->lang->line('unique_clicks');?></span>
                        <span id='total_uclk' class="value"> 0 </span>
                     </li>
                     <li>
                        <span class="name"><?php echo $this->lang->line('converstion');?></span>
                        <span id="total_con" class="value"> 0 </span>
                     </li>
                  </ul>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<div class="pull-right">
   <small><span style="color:red">*</span><?php echo $this->config->item('notify_spend_details');?></small>
</div>
<script src="<?php echo base_url();?>support/highcharts/js/modules/no-data-to-display.src.js"></script>
<script>
   function update_filter()
   {
	$('#environment_performance_chart').html("");
	$("#environment_performance_chart").append("<center><img id='loading' src='<?php echo base_url($this->config->item('theme_file_path')); ?>/img/loading.gif'></center>");
		
   	load_chart();	
   }
   /*
   $('#refresh_search').click(function (){
   	$('#environment').val('all').trigger('liszt:updated');
   	$('#date_from').val(start_default_date);
   	$('#date_to').val(end_default_date);
   	$('#reservation span').text(default_start_date_txt+' - '+default_end_date_txt);
   	//site_url+"/admin/reports/fetch_environment_stats";
   	//dataTableRedraw();
   	// Load Chart
   	load_chart();
   });
   */
</script>
<script>
   $(document).ready(function() {
   	start_default_date = jQuery('#date_from').val();
   	end_default_date =  jQuery('#date_to').val();
   	default_start_date_txt = jQuery('#default_start_date').text();
   	default_end_date_txt = jQuery('#default_end_date').text();
     });
     
</script>
<script>
   $('.stats-overview').hide();
   
   // REFRESH EVENT	
   
   $( ".content-refresh" ).bind('click',function(evt) {
   	var is_refresh='1';
   	load_chart(is_refresh);	
   });
  
   
   load_chart();	
   
   // INITIAL CHART LAOD
   
   var chart;	
   
   function load_chart(){
   
   		$(function(){
   		
   		var options = {
   		chart: {
   				renderTo: 'environment_performance_chart',
   				type: 'column'
   			},
              title: {
                  text: lbl_report.env_rep,
                  align : 'left'
              },
              xAxis: {
                  categories: [],
                  title: {
					  text: lbl_report.env_values
				  },
   
              },
              yAxis: {
                  min: 0,
                  title: {
                      text: lbl_report.values
                  },
                  stackLabels: {
                      enabled: false,
                      style: {
                          fontWeight: 'bold',
                          color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                      }
                  }
              },
              legend: {
                  align: 'right',
                  x: -70,
                  verticalAlign: 'top',
                  y: -10,
                  floating: true,
                  backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColorSolid) || 'white',
                  borderColor: '#CCC',
                  borderWidth: 1,
                  shadow: true
              },
              exporting: {
				enabled: true,
				chartOptions: {
				 
				  title: {
					text: lbl_report.env_rep,
					align: 'left'
				  },
				  legend: {
						align: 'right',
						x: -15,
						verticalAlign: 'top',
						y: 28,
						
					},
				},
				filename : lbl_report.env_rep + '_' + Math.floor(Date.now() / 1000),
			  },
              tooltip: {
                  formatter: function() {
				var test = parseFloat(this.y).toFixed(2);

   				if(this.series.name=='SPEND')
   				{
   					return '<b>'+ this.x +'</b><br/>'+
   						this.series.name +': $'+ test;
   				} else if(this.series.name=='CTR') {
   					return '<b>'+ this.x +'</b><br/>'+
   						this.series.name +':'+ test+'%';
   				}
   				else if(this.series.name=='ECPM') 
					{
						return '<b>'+ this.x +'</b><br/>'+
							this.series.name +': '+decodeHtml(currency)+' '+ test; 
					}
   				else {
   					return '<b>'+ this.x +'</b><br/>'+
   						this.series.name +':'+ this.y;
   				}
                  }
              },
              plotOptions: {
                  column: {
                      stacking: 'normal',
                      dataLabels: {
                          enabled: true,
                          color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'
                      }
                  }
              },
   			series: []
   		};
   		
   		chart = new Highcharts.Chart(options);
   		chart.showLoading();
   		
   		// AJAX request to get the data
   		$.ajax({
   		// URL from the link that was clicked on
   		type:'POST',
   		url: site_url+'/api/v1/report/fetch/format/json?api_key='+api_key,
   		data:{
   					'page':'REPORT_ENVIRONMENT',
   					'display_type':'CHART',
   					'date_from':$('#date_from').val(),
   					'date_to':$('#date_to').val(),
   					'account_id':'<?php echo get_session('account_id'); ?>',
   					//~ 'account_type':'<?php echo get_session('account_type'); ?>',
   					'account_type':'<?php echo get_session('account_type'); ?>','language':'<?php echo $this->config->item('language'); ?>',

   					'environment':$('#environment').val()
   				},
   		// Success function. the 'data' parameter is an array of objects that can be looped over
   		success: function(data, textStatus, jqXHR){
   		if(data.response == 'ok'){
   			if (data.data!=false)
   			{
   				options.series = data.chart_data;
   				options.xAxis.categories = data.chart_x_axis;
   				chart = new Highcharts.Chart(options);
   				chart.hideLoading();
   			}
   			else
   			{
   				chart.hideNoData();
   				chart.showNoData(lbl_charts.no_data_found_refine_ur_filters);
   				chart.hideLoading();
   			}
   			var total = data.total;
   			for (key in total) {
   				var rec = total[key];
   				var test = parseFloat(rec.value).toFixed(2);
   						if(rec.key == 'ECPM'){
   							$('#total_'+rec.key.toString().toLowerCase()).html('$'+test)
   						}
   						else if(rec.key == 'SPEND'){
   							$('#total_'+rec.key.toString().toLowerCase()).html('$'+test)
   						}
   						else if(rec.key == 'CTR'){
   							$('#total_'+rec.key.toString().toLowerCase()).html(test+'%')
   						}
   						else
   						{
   							$('#total_'+rec.key.toString().toLowerCase()).html(''+rec.value)
   						}
   			}
   			if(!data.chart_data)
   			{
   				$('#total_imp').html('0');
   				$('#total_clk').html('0');
   				$('#total_uimp').html('0');
   				$('#total_uclk').html('0');
   				$('#total_con').html('0');
   			}
   		}
   		}, 
   		// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
   		error: function(jqXHR, textStatus, errorThrown){
   		
   		}
   		}); 
   			$(".toggle-nav").click(function(e) {
   				$('#environment_performance_chart').highcharts(options);
   			});
   		});	
   	}
   	 function decodeHtml(html) 
   {
    var txt = document.createElement("textarea");
    txt.innerHTML = html;
    //~ var xxx = formatNumber(txt.value);
    //~ alert(xxx);
    return txt.value;
    }
    
    function formatNumber(num) {
  return num.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, 'R$1,')
}
</script>

