<?php

class Do_payments extends CI_Model

{

	/*  djax_payment_transaction

	 * ---------------------

	 *  id

		account_id

		name

		email

		payment_type

		date

		amount

		currency

		account_no

		payment_no

		clearing_date

		status

		id_no

		transaction

		payment_response_id

		admin_approval_status

		approved_date

	 * */

	 

	  /*

	   * Adds the Advertiser fund and waiting for admin approval

	   * 

	   * name: add_fund

	   * @param : $fund_details

	   * @return :Insert id OR FALSE

	   * 

	   */

	 function get_user_information($account_id=FALSE)
	 {
		 if($account_id != FALSE){
			$this->db->where('account_id',$account_id);
		}
		
		$query = $this->db->get(TAB_CLIENTS);		
		
		$result = $query->result_array();
		
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		} 
		 
	 }

	 function add_fund($fund_details,$account_id){

		

		//$this->db->trans_begin();

		

		//Fetch the advertiser information

		$adv_details = $this->get_user_information($account_id);
		$adv_final_details = $adv_details[0];
		if($fund_details['payment_type']=='wire')

		{

			$pay_type = 1;
			
			$billing_detail = array(

									'name' 				=> $adv_final_details['clientname'],

									'email'				=> $adv_final_details['email'],

									'payment_type'		=> $pay_type,

									'bank_name' 		=> $fund_details['bank_name'],

									'bank_address'		=> $fund_details['bank_address'],

									'bank_account_no'	=> $fund_details['bank_acc_no'],

									//'paypal_id'			=> $fund_details['paypal_id'],

									'created_date'		=> date('Y-m-d H:i:s')

									);

	    

			$this->db->insert(TAB_BILL_INFO,$billing_detail);						

			$billing_ins_id = $this->db->insert_id();

		}

		else

		{

			$pay_type = 2;	
			
			$admin_paypal = $this->get_admin_payment_info();			
			
			$billing_detail = array(

									'name' 				=> $adv_final_details['clientname'],

									'email'				=> $adv_final_details['email'],

									'payment_type'		=> $pay_type,

									'paypal_id'			=> $fund_details['paypal_id'],

									'created_date'		=> date('Y-m-d H:i:s')

									);

			
			$query = $this->db->query("insert into djax_billing_information(name,email,payment_type,paypal_id,created_date) 
				values('".$adv_final_details['clientname']."','".$adv_final_details['email']."','".$pay_type."','".$fund_details['paypal_id']."','".date('Y-m-d H:i:s')."');");
			//$this->db->insert(TAB_BILL_INFO,$billing_detail);						

			$billing_ins_id = $this->db->insert_id();

		}

	

		//Adds the advertiser fund into db

		$addfundObj = array("account_id" 		=> $account_id,

						 "name" 				=> $adv_final_details['clientname'],

						 "email" 				=> $adv_final_details['email'],

						 "payment_type" 		=> $fund_details['payment_type'],

						 "amount" 				=> $fund_details['amount'],

						 "currency" 			=> $this->config->item('currency'),

						 "transaction" 			=> 'credit',

						 "admin_approval_status"=> 0,

						 "date"=>date('Y-m-d H:i:s'),

						 "ref_billing_id"		=> $billing_ins_id 	

						);

		$this->db->insert(TAB_PAY_TRANS,$addfundObj);			

			$last_insert_id = $this->db->insert_id();

		if($last_insert_id){

			if ($this->db->trans_status() === FALSE)

			{

				$this->db->trans_rollback();

				return FALSE;

			}

			else

			{

				$this->db->trans_commit();

				return $last_insert_id;

			}

		}

		else

		{

			return FALSE;

		}

	 }

	public function get_admin_payment_info()
	{    
	   
		$this->db->select('paypal_id');
		$this->db->where('payment_type',2);
		$query = $this->db->get(TAB_ADMIN_PAYD);
		$result = $query->result_array();
	    if($result)
		{			
			return $result[0]['paypal_id'];
		}
		else
		{
			return FALSE;
		}
	} 

	 /*

	   * Make Payment for publisher based on invoices

	   * 

	   * name: make_payment

	   * @param : $fund_details

	   * @return :Insert id OR FALSE

	   * 

	   */

	 

	 function make_payment($details){

		

		$invoice_id = $details['invoice_id'];

		

		//Get the Invoice Details based on invoice_id

		$invoice_details = $this->fetch_invoice_account_details($invoice_id);

		

		$invoice_details = $invoice_details[0];

		

		//Get the Account details 

		$account_details = $this->fetch_publisher_account_details($invoice_details['account_id']);

		

		//Transaction Begin

		$this->db->trans_begin();

		

		//Inserts array for payment response

		$ins_pay_response = array('account_id'=>$invoice_details['account_id'],

							   'payment_type'=>$account_details['payment_type'],

							   'payment_request_id'=>$invoice_details['id'],

							   'payer_email'=>get_session('email'),

							   'receiver_email'=>$invoice_details['email'],

							   'payment_gross'=>$invoice_details['amount'],

							   'payment_status'=>1,

							   'payment_date'=>$invoice_details['in_date'],

							   'payment_paid_date'=>date('Y-m-d H:i:s'),

							);

		

		$this->db->insert(TAB_PAY_RES,$ins_pay_response);

		

		$payment_response_id = $this->db->insert_id();

		

		if($payment_response_id)

		{

			// Billing information name to be considered

			$ins_pay_trans = array('account_id'=>$account_details['account_id'],

							   'name'=>$invoice_details['name'],

							   'email'=>$invoice_details['email'],

							   'payment_type'=>$account_details['payment_type'],

							   'date'=>date('Y-m-d H:i:s'),

							   'amount'=>$invoice_details['amount'],

							   'currency'=>$account_details['currency_code'],

							   'account_no'=>$account_details['bank_account_no'],

							   'clearing_date'=>date('Y-m-d H:i:s'),

							   'status'=>1,

							   'transaction'=>'debit',

							   'payment_response_id'=>$payment_response_id,

							   'admin_approval_status'=>1

							);

		

			$this->db->insert(TAB_PAY_TRANS,$ins_pay_trans);					

			

			$payment_transaction_id = $this->db->insert_id();

		}else{

			$payment_transaction_id = '';

		}

		

		if($payment_transaction_id)

		{						

			//Insert one mapping table for further reference

			$ins_pay_invoice_payment = array('payment_id'=>$payment_transaction_id,

											'invoice_id'=>$invoice_details['id']

										);

										

			$this->db->insert(TAB_INVOICE_PAY,$ins_pay_invoice_payment);

		}

		

		//Update the Billing Information

		

		$billing_address = $invoice_details['address'].','.$invoice_details['city'].','.$invoice_details['state'].','.$invoice_details['country'];

		

		$ins_bill_info = array('name'=>$invoice_details['name'],

							   'email'=>$invoice_details['email'],

							   'company_name'=>$invoice_details['company_name'],

							   'billing_address'=>$billing_address,

							   'payment_type'=>$account_details['payment_type'],

							   'bank_name'=>$account_details['bank_name'],		

							   'bank_address'=>$account_details['bank_address'],		

							   'swift_bic'=>$account_details['swift_bic'],		

							   'iban'=>$account_details['iban'],	

							   'routing_number'=>$account_details['routing_number'],		

							   'bank_account_no'=>$account_details['bank_account_no'],		

							   'account_holder_name'=>$account_details['account_holder_name'],		

							   'paypal_id'=>$account_details['paypal_id'],

							   'created_Date'=>date('Y-m-d H:i:s')		

						);

						

			$this->db->insert(TAB_BILL_INFO,$ins_bill_info);

			

			$billing_id = $this->db->insert_id();			

		

		//Updates the Invoice is paid

		$this->db->update(TAB_INVOICE,array('invoice_status'=>1,'billing_id'=>$billing_id),array('invoice_id'=>$invoice_details['id']));	

	

		

		if ($this->db->trans_status() === FALSE)

		{

			$this->db->trans_rollback();

			return FALSE;

		}

		else

		{

			$this->db->trans_commit();

			$invoice_details = array('invoice'=>$invoice_details);

			$account_details = array('account'=>$account_details);

			

			$final_details = array_merge($invoice_details,$account_details);

			

			return $final_details;

		}

	}

	 

	 function fetch($where=FALSE){

		

		if($where != FALSE){

			$this->db->where($where);

		}

		

		$this->db->select('site_id,account_id,site_name,site_url');		

		$this->db->where('is_deleted','0');

		

		$this->db->order_by('added_date');

		

		

		$query = $this->db->get(TAB_PUB_SITES);		

		

		$result = $query->result_array();

			

		if($result)

		{			

			return $result;

		}

		else

		{

			return FALSE;

		}



		

	 }

	 

  /*

   * 

   * name: fetch_payment_list

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

   public function fetch_payment_list($agencyid)

    {

	   $this->db->select('*');

	   $this->db->where('tpt.transaction',"credit");

	   $this->db->where_not_in('tpt.account_id',0);

	   $this->db->where('tpt.admin_approval_status',0);

	   $this->db->where('tc.agencyid',$agencyid);

	   $this->db->join(TAB_CLIENTS.' as tc','tpt.account_id=tc.account_id');

	   $this->db->order_by('tpt.date');

	   $query = $this->db->get(TAB_PAY_TRANS.' as tpt');

	   $result=$query->result_array();

	   #echo $this->db->last_query();exit;

	   if($result)

	    {

		  return $result;

		}

	   else

	    {

		   return FALSE;

		}

   }

   

   

   /*

   * 

   * name: fetch_unapproved_advertiser_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

   public function fetch_unapproved_advertiser_payment($agency_id,$adv_account_id=FALSE)

    {

	   

	   $SQL = "

				SELECT oxp.`date` as last_create_date, (

						SELECT count(*) FROM 

							".TAB_PAY_TRANS." as oxp

							JOIN ".TAB_CLIENTS." as oxcl  ON oxcl.account_id=oxp.account_id

						WHERE

						oxcl.agencyid={$agency_id} ";

						

		if($adv_account_id != FALSE){

			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

		}		

				

								

		$SQL .= "  AND oxp.`admin_approval_status`=0 AND 

					   oxp.`transaction` = 'credit'

					) as deposit_count 

				FROM 

					".TAB_PAY_TRANS." as oxp

					JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxp.account_id

				WHERE

					oxcl.agencyid={$agency_id}	";

		

		if($adv_account_id != FALSE){

			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

		}			

		

		$SQL  .= "	AND oxp.`admin_approval_status`=0 AND 

					   oxp.`transaction` = 'credit'";

					

		$SQL .= " ORDER BY 

					oxp.`date` DESC LIMIT 0,1";

	

	  $query = $this->db->query($SQL);



	  $result=$query->result_array(); 



		 if($result)



		{			



			return $result[0];



		}



		else



		{



			return FALSE;



		}	

   }

   

   

   /*

   * 

   * name: fetch_approved_advertiser_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

   public function fetch_approved_advertiser_payment($agency_id,$adv_account_id=FALSE)

    {

	   

	   $SQL = "

				SELECT oxp.`date` as last_create_date, (

						SELECT count(*) FROM 

							".TAB_PAY_TRANS." as oxp

							JOIN ".TAB_CLIENTS." as oxcl  ON oxcl.account_id=oxp.account_id

						WHERE

						oxcl.agencyid={$agency_id} ";

						

		if($adv_account_id != FALSE){

			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

		}		

				

								

		$SQL .= "  AND oxp.`admin_approval_status`=1 AND 

					   oxp.`transaction` = 'credit'

					) as deposit_count 

				FROM 

					".TAB_PAY_TRANS." as oxp

					JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxp.account_id

				WHERE

					oxcl.agencyid={$agency_id}	";

		

		if($adv_account_id != FALSE){

			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

		}			

		

		$SQL  .= "	AND oxp.`admin_approval_status`=1 AND 

					   oxp.`transaction` = 'credit'";

					

		$SQL .= " ORDER BY 

					oxp.`date` DESC LIMIT 0,1";

	

	  $query = $this->db->query($SQL);



	  $result=$query->result_array(); 



		 if($result)



		{			



			return $result[0];



		}



		else



		{



			return FALSE;



		}	

   }

   

   /*

   * 

   * name: fetch_unapproved_advertiser_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

   public function fetch_unapproved_publisher_payment($agency_id,$pub_account_id=FALSE)

    {

	   

	   $SQL = "

				SELECT oxi.`invoice_date` as last_create_date, (

						SELECT count(*) FROM 

							".TAB_INVOICE." as oxi

							JOIN ".TAB_AFFILIATE." as oxaff  ON oxaff.account_id=oxi.account_id

							JOIN ".TAB_PUB_PAYD." as pp  ON oxaff.account_id=pp.account_id

						WHERE

						oxaff.agencyid={$agency_id} AND pp.is_default=1 ";

						

		if($pub_account_id != FALSE){

			$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

		}		

				

								

		$SQL .= "  AND oxi.`invoice_status`=0 

					) as invoice_count 

				FROM 

					".TAB_INVOICE." as oxi

					JOIN ".TAB_AFFILIATE." as oxaff ON oxaff.account_id=oxi.account_id

					JOIN ".TAB_PUB_PAYD." as pp  ON oxaff.account_id=pp.account_id

				WHERE

					oxaff.agencyid={$agency_id}	AND pp.is_default=1 ";

		

		if($pub_account_id != FALSE){

			$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

		}			

		

		$SQL  .= "	AND oxi.`invoice_status`=0 ";

					

		$SQL .= " ORDER BY 

					oxi.`invoice_date` DESC LIMIT 0,1";

	

	  $query = $this->db->query($SQL);



	  $result=$query->result_array(); 



		 if($result)



		{			



			return $result[0];



		}



		else



		{



			return FALSE;



		}	

   }

   

   

   /*

   * 

   * name: fetch_approved_publisher_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

   public function fetch_approved_publisher_payment($agency_id,$pub_account_id=FALSE,$date=FALSE)

    {

	   

	   

	   $SQL = "

				SELECT oxi.`invoice_date` as last_create_date, (

						SELECT count(*) FROM 

							".TAB_INVOICE." as oxi

							JOIN ".TAB_AFFILIATE." as oxaff  ON oxaff.account_id=oxi.account_id

						WHERE

						oxaff.agencyid={$agency_id}  ";

						

		if($pub_account_id != FALSE){

			$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

		}	

		

		if($date != FALSE){

			$SQL .= "  AND DATE(oxi.invoice_paid_date) = '".$date."'"; 

		}		

				

								

		$SQL .= "  AND oxi.`invoice_status`=1 

					) as invoice_count 

				FROM 

					".TAB_INVOICE." as oxi

					JOIN ".TAB_AFFILIATE." as oxaff ON oxaff.account_id=oxi.account_id

				WHERE

					oxaff.agencyid={$agency_id}	";

		

		if($pub_account_id != FALSE){

			$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

		}			

		

		if($date != FALSE){

			$SQL .= "  AND DATE(oxi.invoice_paid_date) = '".$date."'"; 

		}		

			

		

		$SQL  .= "	AND oxi.`invoice_status`=1 ";

					

		$SQL .= " ORDER BY 

					oxi.`invoice_date` DESC LIMIT 0,1";

	

	  $query = $this->db->query($SQL);



	  $result=$query->result_array(); 



		 if($result)



		{			



			return $result[0];



		}



		else



		{



			return FALSE;



		}	

   }

   

   /*

   * 

   * name: payment_approve

   * @param : payment id,amount,account_id

   * @return :Payment id OR FLASE

   * 

   */

   public function payment_approve($id=FALSE,$amount=FALSE,$account_id=FALSE)

   {

	 $data=array(

	              'admin_approval_status'=>1,

				  'approved_date'=>date('Y-m-d H:m:s'),

				  'clearing_date'=>date('Y-m-d H:m:s')

	          );

	 if(!empty($data))

	 {

		$this->db->where('id',$id);

		$this->db->update(TAB_PAY_TRANS,$data);
		
		
		/*$query = $this->db->query("update  ox_clients set (name,email,payment_type,paypal_id,created_date) 
				values('".$adv_final_details['clientname']."','".$adv_final_details['email']."','".$pay_type."','".$fund_details['paypal_id']."','".date('Y-m-d H:i:s')."');");*/
				
				
		//add approve amount into ox_clients
		//return 
		$this->db->select('dj_cur_balance');

		$this->db->where('account_id',$account_id);

		$query = $this->db->get(TAB_CLIENTS);

		$result=$query->result_array();

		$tot_amount=$result[0]['dj_cur_balance']+$amount;

		$add=array('dj_cur_balance'=>$tot_amount);

		$this->db->where('account_id',$account_id);

		$this->db->update(TAB_CLIENTS,$add);

		return $id;

	 }

	 else

	 {

		 return FALSE;

	 }

   }

  

   /*

   * 

   * name: payment_reject

   * @param : payment id

   * @return :Payment id OR FLASE

   * 

   */

   public function payment_reject($id=FALSE)

   {

          $data=array(

	              'admin_approval_status'=>-1,

				  'approved_date'=>date('Y-m-d H:m:s'),

				  'clearing_date'=>date('Y-m-d H:m:s')

	          );

	 if(!empty($data))

	 {

	    //update reject status and return account_id

		$this->db->select('account_id');

		$this->db->where('id',$id);

		$this->db->update(TAB_PAY_TRANS,$data);

		$this->db->where('id',$id);

		$query=$this->db->get(TAB_PAY_TRANS);

		$result=$query->result_array();

		if($result){

		$acc_id=$result[0]['account_id'];

		return $acc_id;

		}

	 }

	 else

	 {

		 return FALSE;

	 }

   }

   

   /*

   * 

   * name: payment_viewmore

   * @param : payment id

   * @return :Payment detailed list of payment

   * 

   */

   public function payment_viewmore($id=FALSE)

   {

     $this->db->select('*');

	 $this->db->where('id',$id);

	 $query=$this->db->get(TAB_PAY_TRANS);

	 $result=$query->result_array();

	 if($result)

	 {

	    return $result;

	 }

	 else

	 {

	    return FALSE;

	 }

   }

   

   /*

   * 

   * name: fetch_pub_payment_list

   * @param : none

   * @return :detailed list of publisher payment

   * 

   */

   public function fetch_pub_payment_list($invoice_id =FALSE,$agencyid=FALSE)

   {

       $this->db->select('ti.invoice_id,ti.account_id as account_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,ti.invoice_net_amount as amount,tu.contact_name as name,tu.email_address as email,tpp.*');

	   $this->db->where('ti.invoice_status',0);

	   $this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id');

       $this->db->join(TAB_PUB_PAYD.' as tpp ','tpp.account_id=ti.account_id');

	   $this->db->where('tpp.is_default',1);

       if($agencyid!=FALSE)

	   {

	     $this->db->where('tf.agencyid',$agencyid);

		 $this->db->join(TAB_AFFILIATE.' as tf','tpp.account_id=tf.account_id');

	   }

	   if($invoice_id)

       {

		   $query=$this->db->get_where(TAB_INVOICE.' as ti ',array('invoice_id'=>$invoice_id));

	   }else{

			$query=$this->db->get(TAB_INVOICE.' as ti ');

	   }

	   $result=$query->result_array();

	   #echo $this->db->last_query();exit;

	   if($result)

	    {

		  return $result;

		}

	   else

	    {

		   return FALSE;

		}

   }

   

  /*

  * name: publisher_invoice_viewmore

  * @param : $invoice_id

  * @return :detailed list of publisher payment 

  */

   public function fetch_individual_invoice($invoice_id=FALSE)

   {  

     $this->db->select('ti.invoice_id as id,ti.invoice_net_amount as total_earn,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,tu.contact_name as name,tu.email_address as email,tii.item_code,tii.item_desc,tii.amount,tii.currency');

	   $this->db->where('ti.invoice_id',$invoice_id);

       $this->db->from(TAB_INVOICE.' as ti ');

	   $this->db->join(TAB_INVOICE_ITEM.' as tii ','tii.invoice_id=ti.invoice_id');

	   $this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id');

	   $query=$this->db->get();

	   $result=$query->result_array();

	   if($result)

	    {

		  return $result;

		}

	   else

	    {

		   return FALSE;

		}

    }

    

    /*

	 * name: publisher_invoice_viewmore

	 * @param : $invoice_id

     * @return :detailed list of publisher payment 

    */

    public function fetch_publisher_account_details($account_id=FALSE)

    {

		if($account_id)

		{

			$this->db->where('is_default',1);

			$query = $this->db->get_where(TAB_PUB_PAYD,array('account_id'=>$account_id));

			

			if($query->num_rows>0)

			{

				$result = $query->result_array();

				return $result[0];

			}else{

				return FALSE;	

			}

		

		}else{

			return FALSE;	

		}	

	}

	

	   /*

   * name: fetch_publisher_invoice_list

   * @param : none

   * @return :detailed list of publisher payment 

   */

	public function fetch_publisher_invoice_list($account_id=FALSE)

	{

	   $this->db->select('tu.contact_name as name,MONTHNAME(ti.invoice_date)as month,YEAR(ti.invoice_date)as year,ti.invoice_status,ti.invoice_id,ti.invoice_code,ti.invoice_net_amount as netamount');

	   if($account_id)

	   {

	     $this->db->where('ti.account_id',$account_id);

	   }

	   $this->db->from(TAB_INVOICE.' as ti ');

	   $this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id');

	   $query=$this->db->get();

	   $result=$query->result_array();

	   if($result)

	    {

		  return $result;

		}

	   else

	    {

		   return FALSE;

		}

	}

	

		 /**

       * Retreives the categories associated with this site

       * 

       * @param numeric $site_id Site id

       * 

	   * @return boolean Returns TRUE (or) FALSE

    */

	 

	 public function fetch_publisher_invoice_item($invoice_id =FALSE)

	 {

		 if($invoice_id)

		 {

			 $this->db->select('item_desc,amount,currency');

			 $query = $this->db->get_where(TAB_INVOICE_ITEM,array('invoice_id'=>$invoice_id));

			 $result = $query->result_array();

			 return $result;

		  }else{

				return FALSE;	

			 }

		  

	 }

	 

	    /*

   * 

   * name: fetch_invoice_account_details

   * @param : none

   * @return :detailed list of publisher payment

   * 

   */

   public function fetch_invoice_account_details($invoice_id =FALSE)

   {

       $this->db->select('ti.invoice_id as id,ti.account_id as account_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,ti.invoice_net_amount as amount,tu.contact_name as name,tu.email_address as email,ta.dj_company_name as company_name,ta.dj_address as address,ta.dj_state as state,ta.dj_city as city,ta.dj_country as country');

	   $this->db->where('ti.invoice_status',0);

       $this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id');

       $this->db->join(TAB_AFFILIATE.' as ta','ta.account_id=ti.account_id');

       if($invoice_id)

       {

		   $query=$this->db->get_where(TAB_INVOICE.' as ti ',array('invoice_id'=>$invoice_id));

	   }else{

			$query=$this->db->get(TAB_INVOICE.' as ti ');

	   }

	   $result=$query->result_array();

	   if($result)

	    {

		  return $result;

		}

	   else

	    {

		   return FALSE;

		}

   }

   

   /*

   * 

   * name: insert_paypal_response

   * @param : $paypal_order

   * @return :TRUE or FALSE

   * 

   */

    function insert_paypal_order($paypal_order)
    {
		
		$check_exist_txn_id	=	$this->db->query('select count(*) as duplicate from djax_payment_response where txn_id="'.$paypal_order['txn_id'].'"');
		$check=$check_exist_txn_id->result_array();
		if($check[0]['duplicate']==0)
		{
			
		
			//$this->db->insert('djax_payment_response',$paypal_order);
			$query = $this->db->query("insert into djax_payment_response(account_id,payment_type,payment_request_id,payer_email,receiver_email,txn_id,ipn_track_id,payment_gross,mc_currency,item_name,item_number,quantity,payment_status,payment_date,address_country_code,payment_paid_date) 
					values('".$paypal_order['account_id']."',2,'".$paypal_order['payment_request_id']."','".$paypal_order['payer_email']."','".$paypal_order['receiver_email']."','".$paypal_order['txn_id']."','".$paypal_order['ipn_track_id']."','".$paypal_order['payment_gross']."','".$paypal_order['mc_currency']."','".$paypal_order['item_name']."','".$paypal_order['item_number']."','".$paypal_order['quantity']."','".$paypal_order['payment_status']."','".$paypal_order['payment_date']."','".$paypal_order['address_country_code']."','".$paypal_order['payment_paid_date']."')");
					
			if($query){
				$payment_response_id = $this->db->insert_id();
				return 	$payment_response_id;
				
	
			}
			
		}
		

        

    }

	function insert_paypal_transaction($transaction)
    {
	   	$query = $this->db->query("insert into djax_payment_transaction( account_id, name, email, payment_type, date, amount, currency, account_no,  clearing_date, status,  transaction, payment_response_id, admin_approval_status)
					values('".$transaction['account_id']."','".$transaction['name']."','".$transaction['email']."','".$transaction['payment_type']."','".$transaction['date']."','".$transaction['amount']."','".$transaction['currency']."','".$transaction['account_no']."','".$transaction['clearing_date']."','".$transaction['status']."','".$transaction['transaction']."','".$transaction['payment_response_id']."','".$transaction['admin_approval_status']."')");
					
			if($query){
				$payment_trans_id = $this->db->insert_id();
				return 	$payment_trans_id;
				
	
			}
	}
   
	function insert_paypal_invoice_payment($invoice_pay)
    {
	   	$query = $this->db->query("insert into djax_invoice_payment( payment_id, invoice_id)
					values('".$invoice_pay['payment_id']."','".$invoice_pay['invoice_id']."')");
					
			if($query){
				$payment_invoice_id = $this->db->insert_id();
				return 	$payment_invoice_id;
				
	
			}
	}
	
	function update_billing_info($billing)
    {
	   	$query = $this->db->query("insert into djax_billing_information( name, email, company_name, billing_address, payment_type, bank_name, bank_address, swift_bic, iban, routing_number, bank_account_no, account_holder_name, paypal_id, created_date)
					values('".$billing['name']."','".$billing['email']."','".$billing['company_name']."','".$billing['billing_address']."','".$billing['payment_type']."','".$billing['bank_name']."','".$billing['bank_address']."','".$billing['swift_bic']."','".$billing['iban']."','".$billing['routing_number']."','".$billing['bank_account_no']."','".$billing['account_holder_name']."','".$billing['paypal_id']."','".$billing['created_Date']."')");
					
			if($query){
				$billings_id = $this->db->insert_id();
				return 	$billings_id;
				
	
			}
	}
	
	function update_invoice_info($invoice_info)
    {
	   	$query = $this->db->query("update djax_invoice set invoice_status='".$invoice_info['invoice_status']."',billing_id='".$invoice_info['billing_id']."' where invoice_id='".$invoice_info['invoice_id']."' ");
					
			if($query){
				//$payment_invoice_id = $this->db->insert_id();
				return $query;
				
	
			}
	}
   /*

   * 

   * name: fetch_advertiser_payment

   * @param : $account_id

   * @return : Sumary details of advertiser payments

   * 

   */

	public function fetch_advertiser_payment($account_id=FALSE)

	{

	   $sql="SELECT ROUND(SUM(spend),4) as tot_spend,ROUND(SUM(paid),4) as tot_paid,ROUND((SUM(paid) - SUM(spend)),4) as balance, month,year,month_number,account_id

	    FROM 

	   (SELECT sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id as account_id FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(tds.date_time) 

UNION

SELECT 0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year, MONTH(approved_date) as month_number, account_id FROM `djax_payment_transaction` WHERE  `account_id` = $account_id  AND  `transaction` = 'credit'  AND `admin_approval_status` = 1 GROUP BY MONTH(approved_date)

UNION

SELECT sum(oba.dj_win_bid) as spend ,0 as paid,MONTHNAME(oba.date_time) as month,0 as year, 0 as month_number,tcl.account_id as account_id FROM `ox_data_bkt_a` as oba JOIN `ox_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(oba.date_time)

UNION

SELECT sum(obc.dj_win_bid * obc.count) as spend ,0 as paid,MONTHNAME(obc.interval_start) as month,0 as year, 0 as month_number,tcl.account_id as account_id FROM `ox_data_bkt_c` as obc JOIN `ox_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obc.interval_start)

UNION

SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,MONTHNAME(obm.interval_start) as month,0 as year, 0 as month_number,tcl.account_id as account_id FROM `ox_data_bkt_m` as obm JOIN `ox_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obm.interval_start)

) as final GROUP BY month";

      $result=$this->db->query($sql);
      
	  $data=$result->result_array();

	  if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		} 

	}

   

   /*

   * 

   * name: fetch_advertiser_date_wise_payment

   * @param : $account_id

   * @return : detailed info of advertiser payments date wise

   * 

   */

	public function fetch_advertiser_date_wise_payment($month=FALSE,$year=FALSE,$account_id=FALSE)

	{

	   $sql= "SELECT ROUND(sum(spend),4) as tot_spend,ROUND(sum(paid),4) as tot_paid,date FROM

	   (

			SELECT (sum(tds.dj_total_revenue)) as spend,0 as paid, DATE(tds.date_time) as date FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id  GROUP BY DATE(tds.date_time)UNION

			SELECT 0 as spend,sum(amount) as paid, DATE(approved_date) as date FROM `djax_payment_transaction` WHERE `account_id` = $account_id AND `transaction` = 'credit' AND `admin_approval_status` = 1 GROUP BY DATE(approved_date)

			UNION

SELECT sum(oba.dj_win_bid) as spend ,0 as paid,DATE(oba.date_time) as date FROM `ox_data_bkt_a` as oba JOIN `ox_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(oba.date_time)

UNION

SELECT sum(obc.dj_win_bid * obc.count) as spend ,0 as paid,DATE(obc.interval_start) as date FROM `ox_data_bkt_c` as obc JOIN `ox_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(obc.interval_start)

UNION

SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,DATE(obm.interval_start) as date FROM `ox_data_bkt_m` as obm JOIN `ox_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(obm.interval_start)

			)as final WHERE MONTH(date)=$month AND YEAR(date)=$year GROUP BY date";

      $result=$this->db->query($sql);

	  $data=$result->result_array();

	  if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		} 

	}

	

	

  /*

   * 

   * name: fetch_publisher_invoice_payment_list

   * @param : $account_id

   * @return : detailed info of publisher payments invoice 

   * 

   */

 	public function fetch_publisher_invoice_payment_list($account_id=FALSE) 

	{ 

	  $sql= "SELECT month_name,year,month,pub_earn,cumm_earn,cumm_paid,(@final_paid:= @final_paid + cumm_paid) as final_paid, (ROUND(SUM(cumm_earn),4)-ROUND(@final_paid + cumm_paid,4)) as balance,accountid FROM (

SELECT MONTHNAME(date)as month_name,YEAR(date) as year,MONTH(date) as month,ROUND(SUM(pub_earn),4) as pub_earn,ROUND(SUM(cumm_earn),4) as cumm_earn,

		   ROUND(SUM(cumm_paid),4) as cumm_paid,accountid FROM 

		   (

			SELECT date_time as date,account_id as accountid,pub_earn,(@cearn := @cearn + pub_earn) as cumm_earn,0 as cumm_paid 

			FROM

			  (

				SELECT t1.date_time,tf.account_id,SUM(t1.`dj_publisher_earnings`)  as pub_earn FROM `ox_data_summary_ad_hourly` 

				as t1 JOIN ox_zones as tz ON tz.zoneid=t1.zone_id JOIN ox_affiliates as tf  ON tf.affiliateid=tz.affiliateid, (SELECT @cearn:=0) as temp 

				WHERE tf.account_id=$account_id GROUP BY YEAR(t1.date_time),MONTH(t1.date_time) 

			   )as final

			UNION

			SELECT invoice_paid_date as date,0 as accountid,0 as pub_earn,0 as cumm_earn,(@csum := @csum + invoice_amount) as cumm_paid

			FROM 

			  (

				SELECT invoice_paid_date, SUM(invoice_net_amount) as invoice_amount

				from djax_invoice,(SELECT @csum:=0) as t WHERE account_id=$account_id AND invoice_status=1 GROUP BY YEAR(invoice_paid_date),MONTH(invoice_paid_date)

			  ) as t

            ) as l_final GROUP BY YEAR(date),MONTH(date)

        )as td,(SELECT @final_paid:=0) as final_paid GROUP BY year,month";

	    $result=$this->db->query($sql);

		$data=$result->result_array();

		if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		} 

	}

	

  /*

   * 

   * name  : fetch_pub_date_wise_payment

   * @param: account_id,month,year

   * @return:detailed info of publisher payments history 

   * 

   */ 

   public function fetch_pub_date_wise_payment($month=FALSE,$year=FALSE,$account_id=FALSE)

	{   

	   $sql="SELECT DATE(date)as date,ROUND(SUM(pub_earn),4) as pub_earn,ROUND(SUM(cumm_earn),4) as cumm_earn,

		   ROUND(SUM(cumm_paid),4) as cumm_paid,accountid FROM 

		   (

			SELECT date_time as date,account_id as accountid,pub_earn,(@cearn := @cearn + pub_earn) as cumm_earn,0 as cumm_paid 

			FROM

			  (

				SELECT t1.date_time,tf.account_id,SUM(t1.`dj_publisher_earnings`)  as pub_earn FROM `ox_data_summary_ad_hourly` 

				as t1 JOIN ox_zones as tz ON tz.zoneid=t1.zone_id JOIN ox_affiliates as tf  ON tf.affiliateid=tz.affiliateid,

				(SELECT @cearn:=0) as temp WHERE tf.account_id=$account_id GROUP BY DATE(t1.date_time) 

			   )as final

			UNION

			SELECT invoice_date as date,0 as accountid,0 as pub_earn,0 as cumm_earn,(@csum := @csum + invoice_amount) as cumm_paid

			FROM 

			  (

				select invoice_date, SUM(invoice_net_amount) as invoice_amount

				from djax_invoice,(SELECT @csum:=0) as t WHERE account_id=$account_id GROUP BY MONTH(invoice_date)

			  ) as t

            ) as l_final WHERE MONTH(date)=$month AND YEAR(date)=$year GROUP BY date ";

	   $result=$this->db->query($sql);

	   $data=$result->result_array();

	   if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		} 

	}

	

	/*

   * ADMIN PANEL

   * name  : advertiser_payment_history

   * @param: none

   * @return:detailed info of advertiser payments history 

   * 

   */  

	public function advertiser_payment_history($agencyid)

	{

	   $sql= "SELECT name,ROUND(SUM(spend),4) as tot_spend,ROUND(SUM(paid),4) as tot_paid,ROUND((SUM(paid) - SUM(spend)),4) as balance,month,year,month_number,account_id

	    FROM 

		  (SELECT tcl.contact as name,sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE tcl.agencyid=$agencyid AND tds.date_time BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW())  GROUP BY MONTH(tds.date_time) , `tcl`.`account_id`

	UNION

	SELECT tcl.contact as name,0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year,MONTH(approved_date)as month_number, dpt.account_id as account_id FROM `djax_payment_transaction` as dpt JOIN ox_clients as tcl ON dpt.account_id=tcl.account_id WHERE dpt.approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW()) AND  dpt.transaction = 'credit'  AND dpt.admin_approval_status = 1 AND tcl.agencyid=$agencyid GROUP BY MONTH(dpt.approved_date),account_id

) as final GROUP BY month,account_id ORDER BY month_number DESC";

	   $result=$this->db->query($sql);

	   $data=$result->result_array();

	   if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		} 

	}

	/*

   * ADMIN PANEL

   * name  : fetch_advertiser_date_wise_payment_history

   * @param: account_id,month,year

   * @return:detailed info of advertiser payments history date wise

   * 

   */

	public function fetch_advertiser_date_wise_payment_history($month=FALSE,$year=FALSE,$account_id=FALSE)

	{

	   $sql= "SELECT name,email,payment_type,ROUND(SUM(amount),4) as paid_amt,DATE(approved_date) as date, 		  	        

	   YEAR(approved_date) as year,account_id,admin_approval_status as approve FROM djax_payment_transaction 

	   WHERE approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW()) AND transaction='credit' AND admin_approval_status=1 AND account_id=$account_id 

	   AND MONTH(approved_date)=$month AND YEAR(approved_date)=$year GROUP BY date ORDER BY MONTH(approved_date)";

	   $result=$this->db->query($sql);

	   $data=$result->result_array();

	   if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		}

	}

   

   /*

   * ADMIN PANEL

   * name  : publisher_payment_history

   * @param: none

   * @return:detailed info of publisher payments history 

   * 

   */  

	public function publisher_payment_history($agencyid)

	{

	   $sql="SELECT dpt.name,ROUND(SUM(dpt.amount),4) as paid_amt,MONTHNAME(dpt.approved_date) as month,MONTH(dpt.approved_date) as 		  	        

	   month_number,YEAR(dpt.approved_date) as year,dpt.account_id,0 as spend_amt FROM djax_payment_transaction as dpt JOIN ox_affiliates as dof ON dpt.account_id=dof.account_id

	   WHERE dpt.approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW() - INTERVAL 1 MONTH) AND dpt.transaction='debit' AND dpt.admin_approval_status=1 

	   AND dof.agencyid=$agencyid GROUP BY YEAR(dpt.approved_date),MONTH(dpt.approved_date),account_id ORDER BY DATE(dpt.approved_date)";

	   $result=$this->db->query($sql);

	   $data=$result->result_array();

	   if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		}

	}

	

   /*

   * ADMIN PANEL

   * name  : fetch_publisher_date_wise_payment_history

   * @param: account_id,month,year

   * @return:detailed info of publisher payments history date wise

   * 

   */

	public function fetch_publisher_date_wise_payment_history($month=FALSE,$year=FALSE,$account_id=FALSE)

	{

	   $sql= "SELECT name,email,payment_type,ROUND(SUM(amount),4) as paid_amt,DATE(approved_date) as date, 		  	        

	   YEAR(approved_date) as year,account_id,admin_approval_status as approve FROM djax_payment_transaction 

	   WHERE approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW() - INTERVAL 1 MONTH) AND transaction='debit' AND 	          			       admin_approval_status=1 AND account_id=$account_id AND MONTH(approved_date)=$month AND YEAR(approved_date)=$year GROUP BY date ORDER BY date";

	   $result=$this->db->query($sql);

	   $data=$result->result_array();

	   if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		}

	}

	

	/*

   * ADMIN PANEL

   * name  : fetch_admin_payment_history

   * @param: none

   * @return:detailed info of every month payment history

   */

	public function fetch_admin_payment_history($agencyid)

	{

	   $sql="SELECT ROUND(SUM(adv_amt),4) as total_credit,ROUND(SUM(pub_amt),4) as total_debit,(ROUND(SUM(adv_amt),4)-ROUND(SUM(pub_amt),4)) as revenue,month,year

			FROM (

			   SELECT SUM(dpt.amount) as adv_amt, 0 as pub_amt,MONTHNAME(dpt.approved_date) as month,YEAR(dpt.approved_date) as year,dpt.approved_date as app

			  FROM  djax_payment_transaction as dpt JOIN ox_clients as dcl ON dpt.account_id=dcl.account_id

			  WHERE dpt.transaction='credit' AND dpt.admin_approval_status=1 AND dcl.agencyid=$agencyid GROUP BY MONTH(dpt.approved_date)

			  UNION 

			   SELECT 0 as adv_amt,SUM(dpt.amount) as pub_amt,MONTHNAME(dpt.approved_date) as month,YEAR(dpt.approved_date) as year,dpt.approved_date as app

			  FROM  djax_payment_transaction as dpt JOIN ox_affiliates as dcl ON dpt.account_id=dcl.account_id 

			  WHERE dpt.transaction='debit' AND dpt.admin_approval_status=1 AND dcl.agencyid=$agencyid GROUP BY MONTH(dpt.approved_date)

			) AS final  GROUP BY year,month ORDER BY year,month";

	   $result=$this->db->query($sql);

	   $data=$result->result_array();

	   if($data){

	    return $data;

		}

		else

		{

		  return FALSE;

		}

	

	}

  

  

   /*

   * ADMIN PANEL

   * name  : reject_invoice_payment

   * @param: invoice_id

   * @return: invoice Payment canceled by admin

   */	

   public function reject_invoice_payment($invoice_id)

   {

       if($invoice_id)

          $this->db->select('account_id');

		  $this->db->where('invoice_id',$invoice_id);

		  $result=$this->db->get(TAB_INVOICE);

		  $account_id=$result->result_array();

		  if($account_id)

		  	  //CHANGE THE INVOICE STATUS TO CANCEL AND RETURN account_id

			  $data=array('invoice_status'=>2);

			  $this->db->where('invoice_id',$invoice_id);

			  $this->db->update(TAB_INVOICE,$data);

			  $acc_id=$account_id[0]['account_id'];

			  return $acc_id;

    }

    

    /*

   * ADVERTISER PANEL

   * name  : fetch_deposit_list

   * @param: invoice_id

   * @return: invoice Payment canceled by admin

   */

    public function fetch_deposit_list($account_id)

    {

		/*$this->db->select('*');

	    $this->db->where('transaction',"credit");

	    $this->db->where('account_id',$account_id);

	    $this->db->order_by('date');

	    $query = $this->db->get(TAB_PAY_TRANS);

	    $result=$query->result_array();

	    if($result)

		{

		  return $result;

		}

	    else

		{

		   return FALSE;

		}*/

		$this->db->select('*');

		$this->db->where('tpt.transaction',"credit");

        $this->db->where('tpt.account_id',$account_id);

		$this->db->from(TAB_PAY_TRANS. ' as tpt ');

        $this->db->join(TAB_BILL_INFO. ' as tbi ','tpt.ref_billing_id=tbi.billing_id');

        $query = $this->db->get();

	    $result=$query->result_array();

	    if($result)

		{

		  return $result;

		}

	    else

		{

		   return FALSE;

		}

	}

	

	/*

   * ADMIN PANEL

   * name  : fetch_adv_deposit_list

   * @param: invoice_id

   * @return: Advertiser Deposit Payment

   */

   public function fetch_adv_deposit_list($agencyid)

   {   

	    $this->db->select('*');

		$this->db->where('tpt.transaction',"credit");

		$this->db->where('tpt.admin_approval_status',1);
		
		$this->db->where('tc.agencyid',$agencyid);

        $this->db->where_not_in('tpt.account_id',0);

		$this->db->from(TAB_PAY_TRANS. ' as tpt ');

        $this->db->join(TAB_BILL_INFO. ' as tbi ','tpt.ref_billing_id=tbi.billing_id');
		
		$this->db->join(TAB_CLIENTS. ' as tc ','tc.account_id=tpt.account_id');

        $query = $this->db->get();

	    $result=$query->result_array();

	    if($result)

		{

		  return $result;

		}

	    else

		{

		   return FALSE;

		}

   }

   

   /*

   * ADMIN PANEL

   * name  : fetch_billing_details

   * @param: invoice_id

   * @return: Advertiser Billing Details

   */

   public function fetch_billing_details($bi_id)

   {

	    $this->db->select('*');

	    $this->db->where('billing_id',$bi_id);

	    $query = $this->db->get(TAB_BILL_INFO);

	    $result=$query->result_array();

		if($result)

		{

		  return $result;

		}

		else

		{

		   return FALSE;

		}

   }

   

   

   /*

   * ADMIN PANEL

   * name  : check_payment_process

   * @param: pay_id

   * @return: return its approved or rejected

  */

   public function check_payment_process($pay_id)

   {

       $query=$this->db->get_where(TAB_PAY_TRANS,array('admin_approval_status'=>0,'id'=>$pay_id));

	   if($query->num_rows>0)

	          return TRUE;

	   else

	          return FALSE;

   }

   

      /*

   * ADMIN PANEL

   * name  : check_invoice_payment_process

   * @param: invoice_id

   * @return: return its approved or rejected

  */

   public function check_invoice_payment_process($invoice_id)

   {

       $query=$this->db->get_where(TAB_INVOICE,array('invoice_id'=>$invoice_id,'invoice_status'=>0));

	   if($query->num_rows>0)

	          return TRUE;

	   else

	          return FALSE;

   }

   

   /*

   * ADMIN PANEL

   * name  : fetch_admin_revenue_details

   * @param: agencyid

   * @return: return month wise revenue details

  */

   public function fetch_admin_revenue_details($agencyid)

   {

      $SQL = "SELECT IFNULL(ROUND(SUM(oxds.dj_total_revenue) - SUM(oxds.dj_publisher_earnings),2),0) as tot_revenue,MONTHNAME(oxds.date_time) as month_name,

	            MONTH(oxds.date_time) as month,oxa.agencyid as agencyid,YEAR(oxds.date_time) as year

				FROM ".TAB_DATA_SUM_AD_HOURLY." as oxds

				JOIN ".TAB_ZONES." as oxz ON oxz.zoneid=oxds.zone_id

				JOIN ".TAB_AFFILIATE." as oxa ON (oxa.affiliateid=oxz.affiliateid AND oxa.agencyid={$agencyid}) GROUP BY MONTH(oxds.date_time) DESC

				";  

		$query = $this->db->query($SQL);

		

		$result = $query->result_array();		

		

		if($result)

		{			

				return $result;

		}

		else

		{

			return FALSE;

		}

   }

   

   

    /*

   * ADMIN PANEL

   * name  : fetch_admin_revenue_details_date_wise

   * @param: month,year,agencyid

   * @return: return date wise revenue details

  */

   public function fetch_admin_revenue_details_date_wise($month,$year,$agencyid)

   {

        $SQL = "SELECT IFNULL(ROUND(SUM(oxds.dj_total_revenue) - SUM(oxds.dj_publisher_earnings),4),0) as tot_revenue,DATE(oxds.date_time) as date

				FROM ".TAB_DATA_SUM_AD_HOURLY." as oxds

				JOIN ".TAB_ZONES." as oxz ON oxz.zoneid=oxds.zone_id

				JOIN ".TAB_AFFILIATE." as oxa ON (oxa.affiliateid=oxz.affiliateid AND oxa.agencyid={$agencyid}) WHERE MONTH(oxds.date_time)={$month} AND YEAR(oxds.date_time)={$year}

				GROUP BY DATE(oxds.date_time)";  

				

		$query = $this->db->query($SQL);

		

		$result = $query->result_array();		

		

		if($result)

		{			

				return $result;

		}

		else

		{

			return FALSE;

		}

   

   }





/*	
	* name: publisher_invoice_viewmore	
	* @param : $invoice_id	
	* @return :detailed list of publisher payment 	
	*/
	public function fetch_aff_individual_invoice($invoice_id = FALSE)
	{
		$this->db->select('ti.invoice_id as id,ti.invoice_net_amount as total_earn,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,tu.contact_name as name,tu.email_address as email,tii.item_code,tii.item_desc,tii.amount,tii.currency,`ta`.`name` as nw_name, `ta`.`email` as nw_email');
		$this->db->from(TAB_INVOICE . ' as ti ');
		$this->db->join(TAB_INVOICE_ITEM . ' as tii ', 'tii.invoice_id=ti.invoice_id');
		$this->db->join(TAB_NWK_MANAGERS . ' as tnm ', 'tnm.manager_account_id=ti.nw_mngr_acc_id');
		$this->db->join(TAB_NETWORKS . ' as tn ', 'tn.network_id=tnm.network_account_id');
		$this->db->join(TAB_USERS . ' as tu ', 'tu.user_id=tn.default_user_id');
		$this->db->join(TAB_AGENCY . ' as ta', 'ta.agencyid=tnm.agency_id');
		$this->db->where('ti.type', 1);
		$this->db->where('ti.invoice_id', $invoice_id);
		$query  = $this->db->get();
		$result = $query->result_array();
		//echo $this->db->last_query();exit;
		if ($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	
	/*
	
	* name: fetch_affiliate_invoice_list
	
	* @param : none
	
	* @return :detailed list of affiliate payment 
	
	*/
	public function fetch_affiliate_invoice_list($agencyid = FALSE)
	{
		$this->db->select('tu.contact_name as name,MONTHNAME(ti.invoice_date)as month,YEAR(ti.invoice_date)as year,ti.invoice_status,ti.invoice_id,ti.invoice_code,ti.invoice_net_amount as netamount,`tu`.`email_address` as email, `ta`.`name` as nw_name, `ta`.`email` as nw_email');
		$this->db->from(TAB_INVOICE . ' as ti ');
		$this->db->join(TAB_NWK_MANAGERS . ' as tnm ', 'tnm.manager_account_id=ti.nw_mngr_acc_id');
		$this->db->join(TAB_NETWORKS . ' as tn ', 'tn.network_id=tnm.network_account_id');
		$this->db->join(TAB_USERS . ' as tu ', 'tu.user_id=tn.default_user_id');
		$this->db->join(TAB_AGENCY . ' as ta', 'ta.agencyid=tnm.agency_id');
		$this->db->where('ti.type', 1);
		if ($agencyid != FALSE && $agencyid != 1)
		{
			$this->db->where('tnm.agency_id', $agencyid);
		}
		$query  = $this->db->get();
		//echo $this->db->last_query();exit;
		$result = $query->result_array();
		if ($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	/* get network details
	  * 
	  *   djax_app_configurations AND djax_networks
	  * ---------------------
	  *  	new_user_approval_type 	
	  * 	email_address 
	  * 
	  * */
	  
	  function get_network_details()
	  {
		  	  
		$query="Select app.config_value as approval_type,
							djn.first_name  as firstname,
							djn.last_name as lastname,
							djn.email_address as email,
							djn.date_added as app_date from ".TAB_APP_CONFIG."  as app
							JOIN ".TAB_NETWORKS." as djn ON  djn.account_id = 1 
							Where djn.is_super_admin=	1 AND app.config_key='new_user_approval_type'";	  
			   
		/*$where	=	array(
							'djn.is_super_admin'=>	1,
							'app.config_key'=>	'new_user_approval_type',							
							);		
		$join='djn.account_id = 1';
		$this->db->select( 'app.config_value as approval_type,
							djn.first_name  as firstname,
							djn.last_name as lastname,
							djn.email_address as email,
							djn.date_added as app_date'							
							);
		$this->db->from(TAB_APP_CONFIG.' as app');
		$this->db->join(TAB_NETWORKS.' as djn',$join);		
		$this->db->where($where); */
		$query = $this->db->query($query);
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			return $result[0];
		}else{
			return FALSE;	
		}	
		
	  }	
	
	

}





   

