<?php 
class Vast_mediation extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->adnetwork();
	}

	/*
	 * name: adnetwork
	 * @param : null
	 * @return :manage all adnetwork.
	 */	

	public function adnetwork()
	{
		$data['page_title'] = 	"Manage DSP/Video Adnetwork";
		$data['breadcrumb'] = 	'';
		$data['content'] 	= 	$this->load->view('vast_mediation/video_adnetwork',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}	

	/*
	 * name		:adnetwork_ajax
	 * @param   :Null
	 * @return  :List all the Video/DSP adnetwork
	 */	

	public function fetch_adnetwork()
	{

		$adnetwork			=	$this->rest->get('api/v1/vast_mediation/fetch',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($adnetwork);
	}

	/*
	 * name		: add_dsp
	 * @param   : Null
	 * @return  : Fetch modal box for add dsp
	 */	
	public function add_dsp()
	{	
		$data['page_title'] = 	"Add DSP/Video Adnetwork";
		$data['breadcrumb'] = 	'';
		$data['countries'] = $this->rest->get('api/v1/utilities/fetch_target_countries',array('api_key'=>get_session('api_key')),'php');
		$data['publishers'] = $this->rest->get('api/v1/vast_mediation/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		//print_r($data['page_title']);exit;
		$data['content'] = $this->load->view('vast_mediation/add_dsp', $data, TRUE);

		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

	/*
	 * name		: edit_dsp
	 * @param   : Null
	 * @return  : Fetch modal box for edit dsp
	 */	
	public function edit_dsp($dsp_id)
	{	
		$data['page_title'] = 	"Edit DSP/Video Adnetwork";
		$data['breadcrumb'] = 	'';
		$data['countries'] = $this->rest->get('api/v1/utilities/fetch_target_countries',array('api_key'=>get_session('api_key')),'php');
		$data['publishers'] = $this->rest->get('api/v1/vast_mediation/fetch_publisher',array('api_key'=>get_session('api_key')),'php');

		$pubs = $this->rest->get('api/v1/vast_mediation/fetch_dsp_publisher',array('api_key'=>get_session('api_key'), 'dsp_id' => $dsp_id),'php');
		//print_r($pubs);die("__dq");
		$data['selected_publisher'] = explode(',', $pubs[0]['account_ids']);
		 
		$countries = $this->rest->get('api/v1/vast_mediation/fetch_dsp_country',array('api_key'=>get_session('api_key'), 'dsp_id' => $dsp_id),'php');
		$data['selected_country'] = explode(',', $countries[0]['country_codes']);

		$country_weights = json_decode($this->rest->get('api/v1/vast_mediation/fetch_country_weight',array('api_key'=>get_session('api_key'), 'dsp_id' => $dsp_id),'json'));

		$country_weight = array();
		foreach($country_weights->msg as $cw){
			$country_weight[$cw->country_code] = $cw->country_weight;
		}
		$data['country_weight'] = $country_weight;
		$data['dsp_details'] = $this->rest->get('api/v1/vast_mediation/fetch',array('api_key'=>get_session('api_key'), 'dsp_id' => $dsp_id),'php');
		
		$data['content'] = $this->load->view('vast_mediation/edit_dsp', $data, TRUE);

		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

		public function upload_csv_country_dsp($dsp_id=FALSE)

	{	

		if($dsp_id)

		{

			$data['dsp_id']	=	$dsp_id;

			echo $this->load->view('vast_mediation/modal_vast_mediation/content/upload_country_csv',$data);

		}

	}


}
