<?php
class Users_inventory extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}	
	
	function index()
	{
		campaigns();
	}
	
	/*
	 * 
	 * name: campaigns
	 * @param : null
	 * @return :List of campaigns under advertisers.
	 */	
	function campaigns($account_id=FALSE) 
	{
		$data['page_title'] = 	$this->lang->line('campaigns');
		$data['breadcrumb'] = 	'';
		$data['account_id']	=	$account_id;
		$data['content'] 	= 	$this->load->view('inventory/campaigns',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_campaigns
	 * @param : null
	 * @return :List of campaigns under advertisers.
	 */
	public function fetch_campaigns($account_id=false)
	{
		if($account_id)
		{
		
		$campaigns		= $this->rest->get('api/v1/inventory/fetch_camp/',array("acc_id" =>$account_id,"api_key"=>get_session('api_key')),'json');
		}
		else
		{
		$campaigns		= $this->rest->get('api/v1/inventory/fetch_camp',array("api_key"=>get_session('api_key')),'json');
		}
		echo convert_to_datatable_format($campaigns);
	}
	
	/*
	 * 
	 * name: creatives
	 * @param : null
	 * @return :List of campaigns under advertisers.
	 */
	function creatives($campaign_id=FALSE,$account_id=FALSE) 
	{
		$data['page_title'] = 	$this->lang->line('campaigns');
		$data['breadcrumb'] = 	'';
		$data['campaign_id']	=	$campaign_id;
		$data['account_id']		=	$account_id;
		$data['content'] 	= 	$this->load->view('inventory/manage_creatives',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	} 
	
	/*
	 * 
	 * name: fetch_creatives
	 * @param : null
	 * @return :List of campaigns under advertisers.
	 */
	function fetch_creative($campaign_id=FALSE,$account_id=FALSE) 
	{
		$creatives		= $this->rest->get('api/v1/inventory/fetch_creatives/',array("camp_id" =>$campaign_id,"acc_id" =>$account_id,"api_key"=>get_session('api_key')),'json');
		echo convert_to_datatable_format($creatives);
	}
	
	/*
	 * 
	 * name: sites
	 * @param : null
	 * @return :List of campaigns under advertisers.
	 */
	function sites($account_id=FALSE) 
	{
		$data['page_title'] = 	$this->lang->line('sites');
		$data['breadcrumb'] = 	'';
		$data['account_id']	=	$account_id;
		$data['content'] 	= 	$this->load->view('inventory/manage_sites',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	} 
	
	/*
	 * 
	 * name: fetch_sites
	 * @param : null
	 * @return :List of campaigns under advertisers.
	 */
	function fetch_sites($account_id=false) 
	{
		$sites		= $this->rest->get('api/v1/inventory/fetch_site/',array("acc_id" =>$account_id,"api_key"=>get_session('api_key')),'json');
			#$this->rest->debug();
		
		echo convert_to_datatable_format($sites);
	}
	
	/*
	 * 
	 * name: web_adblocks
	 * @param : null
	 * @return :List of web adblocks under publishers.
	 */
	function web_adblocks($site_id=FALSE,$account_id=FALSE)
	{
		$data['page_title'] = 	$this->lang->line('Web_Adblocks');
		$data['breadcrumb'] = 	'';
		$data['site_id']	=	$site_id;
		$data['account_id']	=	$account_id;
		$data['content'] 	= 	$this->load->view('inventory/manage_web_adblocks',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_web_adblocks
	 * @param : null
	 * @return :List of web adblocks under publishers.
	 */
	function fetch_web_adblocks($site_id=FALSE,$account_id=FALSE) 
	{
		$api_key = get_session('api_key');
		
		$adblocks		= $this->rest->get('api/v1/inventory/fetch_adblocks',array("site_id"=>$site_id,"account_id"=>$account_id,"api_key"=>$api_key),'json');
		#$this->rest->debug();
		
		echo convert_to_datatable_format($adblocks);
	}
	
	/*
	 * 
	 * name: mobile_adblocks
	 * @param : null
	 * @return :List of web adblocks under publishers.
	 */
	function mobile_adblocks($site_id=FALSE,$account_id=FALSE)
	{
		$data['page_title'] = 	$this->lang->line('Mobile_Adblocks');
		$data['breadcrumb'] = 	'';
		$data['site_id']	=	$site_id;
		$data['account_id']	=	$account_id;
		$data['content'] 	= 	$this->load->view('inventory/manage_mobile_adblocks',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_mobile_adblocks
	 * @param : null
	 * @return :List of web adblocks under publishers.
	 */
	function fetch_mobile_adblocks($site_id=FALSE,$account_id=FALSE) 
	{
		$api_key = get_session('api_key');
		
		$adblocks		= $this->rest->get('api/v1/inventory/fetch_adblocks_mobile',array("site_id"=>$site_id,"account_id"=>$account_id,"api_key"=>$api_key),'json');
		#$this->rest->debug();
		
		echo convert_to_datatable_format($adblocks);
	}
	 
}
