<?php 

class Users extends CI_Controller

{

    function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		//$this->load->model('api_v.1/do_creative','asd');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}



	function index()

	{

		$this->managers();

	}



	/*

	 * 

	 * name: managers

	 * @param : null

	 * @return :manage all managers.

	 */	



	public function managers()

	{

		$data['page_title'] = 	$this->lang->line('managers');



		$data['breadcrumb'] = 	'';

		

		$data['content'] 	= 	$this->load->view('users/managers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}	

	

	/*

	 * 

	 * name		:manager_ajax

	 * @param   :Null

	 * @return  :List all the managers for admin

	 */	



	public function fetch_manager()

	{
		$exchangeval = $this->config->item('exchangeRate');

		$manager	=	$this->rest->get('api/v1/manager/fetch',array('account_id'=>''),'json');

		

		echo convert_to_datatable_format($manager);

	}

	

	/*

	 * 

	 * name		: add_manager

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_manager()

	{	

		echo $this->load->view('users/modal_users/content/add_manager');

	}

	

	/*

	 * 

	 * name		: edit_manager

	 * @param   : Null

	 * @return  : Fetch individual manager details

	 */	

	 	

	public function edit_manager($account_id=FALSE)

	{	

		if($account_id)

		{

			$manager			=	$this->rest->get('api/v1/manager/fetch',array('account_id'=>$account_id),'php');

			$data['manager']	=	$manager[0];

			

			echo $this->load->view('users/modal_users/content/edit_manager',$data);

		}

	}

   

   

    /*

	 * 

	 * name: advertisers

	 * @param : null

	 * @return : manage all advertisers.

	 */	



	public function advertisers($account_id = FALSE)

	{
		
		$data['page_title']	 	= 	$this->lang->line('manager_advertiser');



		$data['breadcrumb'] 	= 	'';

		

		$adv_count = $this->rest->get('api/v1/advertiser/adv_count', array('api_key' => get_session('api_key')), 'json');

		if ($adv_count != 'null') {

			$data['adv_count'] = $adv_count;

		} else {

			$data['adv_count'] = 0;

		}

		$camp_count				=	$this->rest->get('api/v1/advertiser/campaign_count',array('api_key'	=> get_session('api_key')),'json');

		if($camp_count!='null')

		{

			$data['camp_count']	=	$camp_count;

		}

		else

		{

			$data['camp_count']	=	0;

		}

		$creative_count			=	$this->rest->get('api/v1/advertiser/creative_count',array('api_key'=>get_session('api_key')),'json');

		

		if($creative_count!='null')

		{

			$data['creative_count']	=	$creative_count;

		}

		else

		{

			$data['creative_count']	=	0;

		}
		
		//Fetch the advertisers along with their affiliate name,email 
		
		$agency_name = $this->rest->get('api/v1/manager/fetch_agency_name',array('api_key' => get_session('api_key'), 'account_id' => $account_id),'php');
	
		if($agency_name)
		{
			$data['agency_details'] = $agency_name[0];
		}
		else
		{
			$data['agency_details'] = '';
		}

		// To fetch advertisers according to the affiliate's (using agencyid)
		
		$data['account_id'] = $account_id;

		$data['content'] 		= 	$this->load->view('users/advertisers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:advertiser_ajax

	 * @param   :Null

	 * @return  :List all the advertiser for admin

	 */	



	public function fetch_advertiser($man_account_id)

	{

		#$network_account_id	=	get_session('network_account_id');

		#$network_id			=	get_session('account_id');

		$exchangeval = $this->config->item('exchangeRate');
		$advertiser			=	$this->rest->get('api/v1/advertiser/fetch',array('api_key'=>get_session('api_key'),'man_account_id' => $man_account_id, 'exchangeval'=> $exchangeval),'json');
		

		//$this->rest->debug();

		echo convert_to_datatable_format($advertiser);

	}

	

	/*

	 * 

	 * name		: add_advertiser

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_advertiser()

	{	
		$data['geo_fencing']			=	$this->rest->get('api/v1/app_settings/geo_fencing',array('api_key'=>get_session('api_key')),'php');
		echo $this->load->view('users/modal_users/content/add_advertiser',$data);

	}

	

	/*

	 * 

	 * name		: edit_advertiser

	 * @param   : Null

	 * @return  : Fetch individual advertiser details

	 */	

	 	

	public function edit_advertiser_old($account_id=FALSE)

	{	

		if($account_id)

		{

			#$network_account_id	=	get_session('network_account_id');

			#$network_id			=	get_session('account_id');

			

	        $advertiser			=	$this->rest->get('api/v1/advertiser/fetch',array('api_key'=>get_session('api_key'),'account_id'=>$account_id),'php');

			$data['account_id']	=	$account_id;
			$data['advertiser']	=	$advertiser[0];

			

			echo $this->load->view('users/modal_users/content/edit_advertiser',$data);

		}

	}

	
	public function edit_advertiser($account_id=FALSE)

	{	

		if($account_id)

		{
			$data['geo_fencing']			=	$this->rest->get('api/v1/app_settings/geo_fencing',array('api_key'=>get_session('api_key')),'php');

	        $advertiser			=	$this->rest->get('api/v1/advertiser/fetch_aff_advertiser',array('api_key'=>get_session('api_key'),'account_id'=>$account_id),'php');
			//print_r($advertiser); exit();
			$data['account_id']	=	$account_id;
			$data['advertiser']	=	$advertiser[0];

			echo $this->load->view('users/modal_users/content/edit_advertiser',$data);

		}

	}

	

	/*

	 * 

	 * name		: fetch_campaign_count

	 * @param   : Null

	 * @return  : Fetch individual campaign count for advertiser

	 */	

	 	

	public function fetch_campaign_count($account_id=FALSE,$clientid=FALSE)

	{	

		if($account_id && $clientid)

		{

			$count	=	$this->rest->get('api/v1/advertiser/campaign_count',array('api_key'=>get_session('api_key'),'account_id'=>$account_id,'client_id'=>$clientid),'json');

			if($count!=0)

			{

				echo $count;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	

	/*

	 * 

	 * name		: fetch_spend_amount

	 * @param   : Null

	 * @return  : Fetch individual spend amount for advertiser

	 */	

	 	

	public function fetch_spend_amount($account_id=FALSE,$clientid=FALSE)

	{	

		if($account_id && $clientid)

		{

			$amount	=	$this->rest->get('api/v1/advertiser/spend_amount',array('api_key'=>get_session('api_key'),'account_id'=>$account_id,'client_id'=>$clientid),'json');

			if($amount!=0)

			{

				echo $amount;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	

	/*

	* 

	* name: publishers

	* @param : null

	* @return : manager all publishers.

	*/	



	public function publishers($account_id)

	{

		$data['page_title'] 	= 	$this->lang->line('manager_publisher');

		$data['breadcrumb']	 	= 	'';

		$site_count				=	$this->rest->get('api/v1/publisher/site_count',array('api_key'=>get_session('api_key')),'json');



		if($site_count!='null')

		{

			$data['site_count']	=	$site_count;

		}

		else

		{

			$data['site_count']	=	0;

		}


		$pub_count = $this->rest->get('api/v1/publisher/pub_count', array('api_key' => get_session('api_key')), 'json');

		if ($pub_count != 'null') {

			$data['pub_count'] = $pub_count;

		} else {

			$data['pub_count'] = 0;

		}

		$ad_block_count			=	$this->rest->get('api/v1/publisher/ad_block_count',array('api_key'=>get_session('api_key')),'json');



		if($ad_block_count!='null')

		{

			$data['ad_block_count']	=	$ad_block_count;

		}

		else

		{

			$data['ad_block_count']	=	0;

		}
		
		//Fetch the publishers along with their affiliate name,email 
		
		$agency_name = $this->rest->get('api/v1/manager/fetch_agency_name',array('api_key' => get_session('api_key'), 'account_id' => $account_id),'php');
	
		if($agency_name)
		{
			$data['agency_details'] = $agency_name[0];
		}
		else
		{
			$data['agency_details'] = '';
		}
		
		// To fetch publishers according to the affiliate's (using agencyid)
			
		$data['account_id'] 		= 	$account_id;
		
		$data['content'] 		= 	$this->load->view('users/publishers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:publisher_ajax

	 * @param   :Null

	 * @return  :List all the publisher for admin

	 */	



	public function fetch_publisher($man_account_id)

	{

		$exchangeval = $this->config->item('exchangeRate');
		$publisher			=	$this->rest->get('api/v1/publisher/fetch',array('api_key'=>get_session('api_key'),'man_account_id' =>$man_account_id,  'exchangeval'=> $exchangeval),'json');

		echo convert_to_datatable_format($publisher);

	}

	

	/*

	 * 

	 * name		: add_publisher

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_publisher()

	{	
		$data['geo_fencing']			=	$this->rest->get('api/v1/app_settings/geo_fencing',array('api_key'=>get_session('api_key')),'php');
		echo $this->load->view('users/modal_users/content/add_publisher',$data);

	}

	

	/*

	 * 

	 * name		: edit_publisher

	 * @param   : Null

	 * @return  : Fetch individual publisher details

	 */	

	 	

	public function edit_publisher($account_id=FALSE)

	{	

		if($account_id)

		{

			#$network_account_id	=	get_session('network_account_id');

			#$network_id			=	get_session('account_id');
			$data['geo_fencing']			=	$this->rest->get('api/v1/app_settings/geo_fencing',array('api_key'=>get_session('api_key')),'php');

			$publisher			=	$this->rest->get('api/v1/publisher/fetch_aff_publisher',array('api_key'=>get_session('api_key'),'account_id'	=>	$account_id),'php');

			$data['publisher']	=	$publisher[0];
			$data['account_id']	=	$account_id;

			echo $this->load->view('users/modal_users/content/edit_publisher',$data);

		}

	}

	

	/*

	 * 

	 * name		: fetch_site_count

	 * @param   : Null

	 * @return  : Fetch individual site count for publisher

	 */	

	 	

	public function fetch_site_count($account_id=FALSE)

	{	

		if($account_id)

		{

			$count	=	$this->rest->get('api/v1/publisher/site_count',array('account_id'=>$account_id),'json');

			if($count!=0)

			{

				echo $count;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	

}


