<?php 
class Targeting extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->category();		 
	}
	
	/*
	 * 
	 * name	    : category
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function category()
	{	
		$data['page_title'] = $this->lang->line('category');	
		$data['breadcrumb'] = '';
		
		$data['category_list']		= $this->rest->get('api/v1/targeting/fetch_category_main',array('api_key'=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('targeting/category',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		: fetch_category
	 * @param   : Null
	 * @return  : List all the categoryies added by the admin
	 */	
	
	 public function fetch_category()
	 {
	    $cat_admin		= $this->rest->get('api/v1/targeting/fetch',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($cat_admin);
	 }
		
          /*
	 * 
	 * name	    : add_sub_category
	 * @param   : Null
	 * @return  : add the sub Category for admin
	 */	
	 	
	public function add_sub_category()

	{
		$data['category_list']		= $this->rest->get('api/v1/targeting/fetch_category_main',array('api_key'=>get_session('api_key')),'php');	
		echo $this->load->view('targeting/modal_targeting/content/add_category',$data);
	}


	/*
	* 
	* name		: keyword
	* @param   : Null
	* @return  : List all the keyword for admin
	*/	
		
	public function keyword()
	{	
		$data['page_title'] = "Keywords";	
		$data['breadcrumb'] = '';	
		
		$data['content'] = $this->load->view('targeting/keyword',$data,TRUE);	
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	/*
	* 
	* name		: fetch_keyword
	* @param   : Null
	* @return  : List all the keyword added by the admin
	*/	

	public function fetch_keyword()
	{
		$key_admin		= $this->rest->get('api/v1/targeting/fetch_keyword',array('api_key'=>get_session('api_key')),'json');
		
		
		echo convert_to_datatable_format($key_admin);
		
	}  
	/*
	 * 
	* name		: add keyword
	* @param   : Null
	* @return  : Add keyword for admin
	*/	
		
	public function add_keyword()
	{	
		echo $this->load->view('targeting/modal_targeting/content/add_keyword');
	}
	/*
	* 
	* name		: edit keyword
	* @param   : Null
	* @return  : edit the keyword for admin
	*/	
		
	public function edit_keyword($keyword_id=FALSE)
	{
		
		if($keyword_id)
		{	
			$key_list				=	$this->rest->get('api/v1/targeting/fetch_keyword',array('api_key'=>get_session('api_key'),'keyword_id'=>$keyword_id),'php');
			$data['keyword_details']=	$key_list[0];
			$data['keyword_id']		=	$keyword_id;
			echo $this->load->view('targeting/modal_targeting/content/edit_keyword',$data);
		}
	}

         /*
	 * 
	 * name		: add_category
	 * @param   : Null
	 * @return  : add the main Category for admin
	 */	
	 	
	public function add_category()
	{
		echo $this->load->view('targeting/modal_targeting/content/add_main_category',$data);
	}



	/*
	 * 
	 * name	    : editcategory
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
         

	public function edit_category($category_id=FALSE)
	{	
		$cat_list					= $this->rest->get('api/v1/targeting/category',array('api_key'=>get_session('api_key'),'category_id'=>$category_id),'php');
		$par_value					= $cat_list[0]['parent_category_id'];
		$data['category_details']	= $cat_list[0];
		$data['root_val'] 			= $this->rest->get('api/v1/targeting/category_root',array('api_key'=>get_session('api_key'),'par_id'=>$par_value),'php');
		echo $this->load->view('targeting/modal_targeting/content/edit_category',$data);
	}

	
	/*
	 * 
	 * name		: Operating System
	 * @param   : Null
	 * @return  : List all the operating system for admin
	 */	
	 	
	public function operating_system()
	{	
		$data['page_title'] = $this->lang->line('operating_system');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/operating_system',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	 /*
	 * 
	 * name	    : fetch_os
	 * @param   : Null
	 * @return  : List all the os added by the admin
	 */	
	
	 public function fetch_os()
	 {
	    $os_admin		= $this->rest->get('api/v1/targeting/fetch_os',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($os_admin);
	 }

         /*
	 * 
	 * name     : add_os
	 * @param   : Null
	 * @return  : List all the OS for admin
	 */	
	 	
	public function add_os()
	{
		echo $this->load->view('targeting/modal_targeting/content/add_operating_system',$data);
	}


	 /*
	 * 
	 * name	    : edit_os
	 * @param   : Null
	 * @return  : List all the OS for admin
	 */	
	 	
	public function edit_os($id=FALSE)
	{	
		$os_list=$this->rest->get('api/v1/targeting/os_list',array('id'=>$id,'api_key'=>get_session('api_key')),'php');
		$data['os_details']=$os_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_operating_system',$data);
	}

	/*
	 * 
	 * name	    : Browsers
	 * @param   : Null
	 * @return  : List all the browsers for admin
	 */	
	 	
	public function browsers()
	{	
		$data['page_title'] = $this->lang->line('browsers');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/browsers',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		: fetch_browsers
	 * @param   : Null
	 * @return  : List all the browsers added by the admin
	 */	
	
	 public function fetch_browsers()
	 {
	    $browser_admin		= $this->rest->get('api/v1/targeting/fetch_browsers',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($browser_admin);
	 }

  	 /*
	 * 
	 * name		: add_browsers
	 * @param   : Null
	 * @return  : List all browsers for admin
	 */	
	 	
	public function add_browsers()
	{
		echo $this->load->view('targeting/modal_targeting/content/add_browsers',$data);
	}


	  /*
	 * 
	 * name	    : edit_browser
	 * @param   : Null
	 * @return  : List all the browsers for admin
	 */	
	 	
	public function edit_browser($id=FALSE)
	{	
		$browser_list=$this->rest->get('api/v1/targeting/browser_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['browser_details']=$browser_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_browser',$data);
	}


	/*
	 * 
	 * name	    : manufacturers
	 * @param   : Null
	 * @return  : List all the manufacturers for admin
	 */	
	 	
	public function manufacturers()
	{	
		$data['page_title'] = $this->lang->line('manufacturers');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/manufacturers',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name	    : fetch_manufacturers
	 * @param   : Null
	 * @return  : List all the manufacturers added by the admin
	 */	
	
	 public function fetch_manufacturers()
	 {
	    $manu_admin		= $this->rest->get('api/v1/targeting/fetch_manu',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($manu_admin);
	 }
         
         /*
	 * 
	 * name	    : add_mobile_manufacturers
	 * @param   : Null
	 * @return  : List all the mobile manufacturers for admin
	 */	
	 	
	public function add_mobile_manufacturers()
	{	
		
		echo $this->load->view('targeting/modal_targeting/content/add_mobile_manufacturers',$data);
	}


          /*
	 * 
	 * name	    : edit_manufacturers
	 * @param   : Null
	 * @return  : List all the manufacturers for admin
	 */	
	 	
	public function edit_manufacturers($id=FALSE)
	{	
		$manu_list=$this->rest->get('api/v1/targeting/manu_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['manu_details']=$manu_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_manufacturers',$data);
	}
	 
	
	/*
	 * 
	 * name	    : Mobile Operating System
	 * @param   : Null
	 * @return  : List all the Mobile operating system for admin
	 */	
	 	
	public function mobile_operating_system()
	{	
		$data['page_title'] = $this->lang->line('mobile_operating_system');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/mobile_operating_system',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	
	 /*
	 * 
	 * name	    : fetch_mobile_os
	 * @param   : Null
	 * @return  : List all the Mobile os added by the admin
	 */	
	
	 public function fetch_mobile_os()
	 {
	    $os_admin		= $this->rest->get('api/v1/targeting/fetch_mobile_os',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($os_admin);
	 }

         /*
	 * 
	 * name	    : add_mobile_os
	 * @param   : Null
	 * @return  : List all the mobile os for admin
	 */	
	 	
	public function add_mobile_os($id=FALSE)
	{			
	
		echo $this->load->view('targeting/modal_targeting/content/add_mobile_operating_system',$data);
	}	

	 /*
	 * 
	 * name	    : edit_mobile_os
	 * @param   : Null
	 * @return  : List all the  mobile os for admin
	 */	
	 	
	public function edit_mobile_os($id=FALSE)
	{			
		$os_list=$this->rest->get('api/v1/targeting/mobile_os_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['os_details']=$os_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_mobile_operating_system',$data);
	}	
	
	
	/*
	 * 
	 * name		: Mobile manufacturers
	 * @param   : Null
	 * @return  : List all the Mobile manufacturer for admin
	 */	
	 	
	public function mobile_manufacturers()
	{	
		$data['page_title'] = $this->lang->line('mobile_manufacturers');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/mobile_manufacturers',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	
	 /*
	 * 
	 * name	    : fetch_mobile_manufacturers
	 * @param   : Null
	 * @return  : List all the Mobile manufacturer added by the admin
	 */	
	
	 public function fetch_mobile_manufacturers()
	 {
	    $manufacturer_admin		= $this->rest->get('api/v1/targeting/fetch_mobile_manufacturers',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($manufacturer_admin);
	 }

	 /*
	 * 
	 * name	    : edit_mobile_manufacturers
	 * @param   : Null
	 * @return  : List all the Mobile manufacturers for admin
	 */	
	 	
	public function edit_mobile_manufacturers($id=FALSE)
	{			
		$manufacturer_list=$this->rest->get('api/v1/targeting/mobile_manufacturers_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['mobile_manufacturer_details']=$manufacturer_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_mobile_manufacturers',$data);
	}	
	
	
	/*
	 * 
	 * name	    : Mobile capability
	 * @param   : Null
	 * @return  : List all the Mobile capability for admin
	 */	
	 	
	public function mobile_capability()
	{	
		$data['page_title'] = $this->lang->line('mobile_capability');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/mobile_capability',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	
	 /*
	 * 
	 * name		: fetch_mobile_capability
	 * @param   : Null
	 * @return  : List all the Mobile Capability added by the admin
	 */	
	
	 public function fetch_mobile_capability()
	 {
	    $capability_admin		= $this->rest->get('api/v1/targeting/fetch_mobile_capability',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($capability_admin);
	 }
        
         /*
	 * 
	 * name	    : add_mobile_capability
	 * @param   : Null
	 * @return  : List all the Mobile Capability for admin
	 */	
	 	
	public function add_mobile_capability()
	{	
		
		echo $this->load->view('targeting/modal_targeting/content/add_mobile_capability');
	}	


	 /*
	 * 
	 * name		: edit_mobile_capability
	 * @param   : Null
	 * @return  : List all the Mobile Capability for admin
	 */	
	 	
	public function edit_mobile_capability($id=FALSE)
	{	
		$capability_list=$this->rest->get('api/v1/targeting/mobile_capability_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['mobile_capability_details']=$capability_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_mobile_capability',$data);
	}	
	
	/*
	 * 
	 * name		: telecom_operators
	 * @param   : Null
	 * @return  : List all the Mobile telecom operators for admin
	*/	
	
	public function telecom_operators()
	{
		$data['page_title'] = $this->lang->line('Telecom_Operators');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/tele_operators',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: fetch_telecom_operators
	 * @param   : Null
	 * @return  : List all the Mobile telecom operators for admin
	*/
	public function fetch_telecom_operators()
	{
		$tele_vals		= $this->rest->get('api/v1/targeting/fetch_tele_operators',array('api_key'=>get_session('api_key')),'json');
			
		echo convert_to_datatable_format($tele_vals);
	}
	
	/*
	 * 
	 * name		: main_category
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function main_category()
	{	
		$data['page_title'] = $this->lang->line('Main_category');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/main_category',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		: fetch_main_category
	 * @param   : Null
	 * @return  : List all the categoryies added by the admin
	 */	
	
	public function fetch_main_category()
	{
		$cat_admin		= $this->rest->get('api/v1/targeting/fetch_category_main',array('api_key'=>get_session('api_key')),'json');
	 
		echo convert_to_datatable_format($cat_admin);
	}
	
	/*
	 * 
	 * name		: edit_main_category
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_main_category($category_id=FALSE)
	{	
		$cat_list=$this->rest->get('api/v1/targeting/category',array('api_key'=>get_session('api_key'),'category_id'=>$category_id),'php');
		$data['category_details']=$cat_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_main_category',$data);
	}


	/*
	 * 
	 * name		: main_category
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function domain()
	{
		$data['page_title'] = "Domain targeting";
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('targeting/manage_domain', $data, TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);

	}


	/*
	 * 
	 * name		: add_domain
	 * @param   : Null
	 * @return  : add the sub Category for admin
	 */	
	 	
	public function add_domain()
	{
		echo $this->load->view('targeting/modal_targeting/content/add_domain', $data);
	}


	/*
    *
    * name		: edit_domain
    * @param   : Null
    * @return  : List all the domain for admin
    */

	public function edit_domain($id = FALSE)
	{
		$domain_list = $this->rest->get('api/v1/targeting/domain_list', array('api_key' => get_session('api_key'), 'id' => $id), 'php');
		$data['domain_details'] = $domain_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_domain', $data);
	}


	/*
	 * 
	 * name	    : fetch_domain
	 * @param   : Null
	 * @return  : List all the domain added by the admin
	 */

	public function fetch_domain()
	{
		$browser_admin = $this->rest->get('api/v1/targeting/fetch_domain', array('api_key' => get_session('api_key')), 'json');
		echo convert_to_datatable_format($browser_admin);
	}

	/*
	 * 
	 * name	    : segmentation
	 * @param   : Null
	 * @return  : List all the domain added by the admin
	 */
	public function segmentation()
	{
		$data['page_title'] = $this->lang->line('segmentation');	
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('targeting/segmentation',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);	
	}
	 /*
	 * 
	 * name     : add_segment
	 * @param   : Null
	 * @return  : List all the segment for admin
	 */	
	 public function add_segment()
	{   $data['seg']='';
		echo $this->load->view('targeting/modal_targeting/content/add_segment',$data);
	}
	/*
	 * 
	 * name	    : edit_segment
	 * @param   : Null
	 * @return  : List all the Segment for admin
	 */	
	 	
	
	public function edit_segment($id=FALSE)
	{	
		$seg_list=$this->rest->get('api/v1/targeting/segment_list',array('id'=>$id,'api_key'=>get_session('api_key')),'php');
		$data['seg_details']=$seg_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_segment',$data);
	}
	/*
	 * 
	 * name	    : fetch_segment
	 * @param   : Null
	 * @return  : List all the segment added by the admin
	 */	
	
	 public function fetch_segment()
	 {
	    $seg_admin		= $this->rest->get('api/v1/targeting/fetch_segment',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($seg_admin);
	 }
	
	public function site()
	{	
		$data['page_title'] = $this->lang->line('site');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/site',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	 public function fetch_site()
	 {
	    $site		= $this->rest->get('api/v1/targeting/fetch_site',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($site);
	 }
	 
	public function add_site()
	{
		echo $this->load->view('targeting/modal_targeting/content/add_site',$data);
	}
	
    public function edit_site($id=FALSE)
	{	
		$site_list=$this->rest->get('api/v1/targeting/site_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		
		$data['site_details']=$site_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_site',$data);
	}
    public function sentiment()
	{	
		
		$data['page_title'] = $this->lang->line('sentiment');	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/sentiment',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	 public function fetch_sentiment()
	 {
	    $site		= $this->rest->get('api/v1/targeting/fetch_sentiment',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($site);
	 }
	 
	public function add_sentiment()
	{
		
		echo $this->load->view('targeting/modal_targeting/content/add_sentiment',$data);
	}
	
    public function edit_sentiment($id=FALSE)
	{	
		
		$sentiment_list=$this->rest->get('api/v1/targeting/sentiment_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');		
		$data['sentiment_details']=$sentiment_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_sentiment',$data);
	}
	
	public function custom_targeting1()
	{  		
		$data['page_title'] = $this->lang->line('custom_targeting1'); 	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/custom_targeting1',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	public function custom_targeting2()
	{  
		$data['page_title'] = $this->lang->line('custom_targeting2'); 	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/custom_targeting2',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	public function custom_targeting3()
	{
		$data['page_title'] = $this->lang->line('custom_targeting3'); 	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/custom_targeting3',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);	   	
	}
	public function custom_targeting4()
	{			
		$data['page_title'] = $this->lang->line('custom_targeting4'); 	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/custom_targeting4',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}	
	public function add_custom_targeting1()
	{  
		echo $this->load->view('targeting/modal_targeting/content/add_custom_targeting1',$data);
	}
	
	public function fetch_custom_targeting1()
	 {	 
	    $list		= $this->rest->get('api/v1/targeting/fetch_custom_targeting1',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($list);
	 }
	 
	public function edit_custom_targeting1($id=FALSE)
	{  
		$targeting_list=$this->rest->get('api/v1/targeting/custom_targeting1_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');		
		$data['targeting_details']=$targeting_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_custom_targeting1',$data);  
	}
	
	public function add_custom_targeting2()
	{  
		echo $this->load->view('targeting/modal_targeting/content/add_custom_targeting2',$data);
	}
	
	public function fetch_custom_targeting2()
	 {	 
	    $list		= $this->rest->get('api/v1/targeting/fetch_custom_targeting2',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($list);
	 }
	 
	public function edit_custom_targeting2($id=FALSE)
	{  
		$targeting_list=$this->rest->get('api/v1/targeting/custom_targeting2_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');		
		$data['targeting_details']=$targeting_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_custom_targeting2',$data);  
	}
	
	public function add_custom_targeting3()
	{  
		echo $this->load->view('targeting/modal_targeting/content/add_custom_targeting3',$data);
	}
	
	public function fetch_custom_targeting3()
	 {	 
	    $list		= $this->rest->get('api/v1/targeting/fetch_custom_targeting3',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($list);
	 }
	 
	public function edit_custom_targeting3($id=FALSE)
	{  
		$targeting_list=$this->rest->get('api/v1/targeting/custom_targeting3_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');		
		$data['targeting_details']=$targeting_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_custom_targeting3',$data);  
	}
	
	public function add_custom_targeting4()
	{  
		echo $this->load->view('targeting/modal_targeting/content/add_custom_targeting4',$data);
	}
	
	public function fetch_custom_targeting4()
	 {	 
	    $list		= $this->rest->get('api/v1/targeting/fetch_custom_targeting4',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($list);
	 }
	 
	public function edit_custom_targeting4($id=FALSE)
	{  
		$targeting_list=$this->rest->get('api/v1/targeting/custom_targeting4_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');		
		$data['targeting_details']=$targeting_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_custom_targeting4',$data);  
	}
	
}