<?php 
class Settings extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->personal_information();		
	}
	
	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List personal_information for Admin
	 * 		
	 */	
	
	public function personal_information()
	{		
		$data['page_title'] = $this->lang->line('personal_information');	
		$data['breadcrumb'] = '';	
		
		$personal_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
	
		
		$data['personal_info']=$personal_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');	
		
		$data['content'] = $this->load->view('settings/personal_information',$data,TRUE);		
	
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:company_information
	 * @param   :Null
	 * @return  :List company_information for Admin
	 */	
	
	public function company_information()
	{		
		$data['page_title'] = $this->lang->line('company_info');
		$data['breadcrumb'] = '';	
		$company_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');			
		$data['content'] = $this->load->view('settings/company_information',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:configurations
	 * @param   :Null
	 * @return  :List configurations for Admin
	 */	
	
	public function configurations()
	{			
		$data['page_title'] = $this->lang->line('configurations');	
		$data['breadcrumb'] = '';
		/* language set.. Added by murugeswari on 28-sep-2017 */
		$input['language'] = $this->config->item('language');
		if($input['language'] == "english")
		{
			$lang = "en";
		}else if($input['language'] == "azerbaijani")
		{
			$lang = "az";
		}else if($input['language'] == "russian")
		{
			$lang = "ru";
		}
		else
		{
			$lang = "tu";
		}
		// end	
		$api_key		=	get_session('api_key');
        $data['target']		= 	$this->rest->get('api/v1/utilities/fetch_target_time_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		//print_r($data['target']);exit;
		$config_item	= $this->rest->get('api/v1/app_settings/get_values',array("network_id"=>get_session('account_id'),"agency_id" => get_session('agencyid'),'api_key'=>get_session('api_key')),'php');		
		foreach($data['target'] as $targ)
		{
        $var.=$targ['timezone'].'|';
        
		}
		
		/*** Curreny List***/
		$data['currency']		= 	$this->rest->get('api/v1/utilities/fetch_currency',array("api_key"=>$api_key),'php');
		
		//$this->rest->debug();
		foreach($data['currency'] as $curr)
		{
			$cur_code	.=	$curr['code'].'|';        
		}
		/*** Curreny List***/
		
		
		//print_r($config_item);exit;
		if(!empty($config_item))
		{
		/*Modified for dynamic key field fetch by Suganiya.R on 20th feb,2016*/		
		foreach ($config_item as $key => $value) {	
				if($value['config_key'] == "zone")
				{
					$options[$value['title']][] = array('options' => $var , 'config_key' =>$value['config_key'] ,'config_value'=>$value['config_value'],'field_type' =>$value['field_type'] ,'description'=>$value['description']);									
				}
				//Currency Type
				elseif($value['config_key'] == "currency_code")
				{
					$options[$value['title']][] = array('options' => $cur_code , 'config_key' =>$value['config_key'] ,'config_value'=>$value['config_value'],'field_type' =>$value['field_type'] ,'description'=>$value['description']);									
				}
				else
				{		
					$options[$value['title']][] = array('options' => $value['options'] , 'config_key' =>$value['config_key'] ,'config_value'=>$value['config_value'],'field_type' =>$value['field_type'] ,'description'=>$value['description']);			
			    }
			}
		}		
		
		$data['config'] = $options;
		$data['content'] = $this->load->view('settings/configurations',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:billing_information
	 * @param   :Null
	 * @return  :List billing_information for Admin
	 */	
	
	public function billing_information()
	{		
		$data['page_title'] = "Billing Information";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/billing_information',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
		
	/*
	 * 
	 * name		:payment_settings
	 * @param   :Null
	 * @return  :List payment_settings for Admin
	 */	
	
	public function payment_settings()
	{		
		$data['page_title'] = $this->lang->line('payment_settings');	
		$data['breadcrumb'] = '';	
		$payment_info=$this->rest->get('api/v1/network/fetch_admin_payment_info',array('api_key'=>get_session('api_key')),'php');
		$paypal_info=$this->rest->get('api/v1/network/fetch_admin_paypal_info',array('api_key'=>get_session('api_key')),'php');
		$data['payment_details']=$payment_info[0];
		$data['paypal'] = $paypal_info[0];
		$data['content'] = $this->load->view('settings/payment_settings', $data, TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:email_preferences
	 * @param   :Null
	 * @return  :List email_preferences for Admin
	 */	
	
	public function email_preferences()
	{		
		$data['page_title'] = $this->lang->line('email_preferences');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/email_preferences',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: Manager_permissions
	 * @param   : Null
	 * @return  : Manager_permissions for Admin
	 */	
	
	public function manager_permissions()
	{		
		$data['page_title'] = $this->lang->line('Manager_Permissions');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/manager_permissions',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: web pages
	 * @param   : Null
	 * @return  : Web pages for Admin
	 */	
	
	public function web_pages()
	{		
		$data['page_title'] = $this->lang->line('Web_Pages');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/web_pages',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: News letters
	 * @param   : Null
	 * @return  : News letters for Admin
	 */	
	
	public function news_letters()
	{		
		$data['page_title'] = $this->lang->line('news_letters');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/news_letters',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: Event planner
	 * @param   : Null
	 * @return  : Event planner for Admin
	 */	
	
	public function event_planner()
	{		
		$data['page_title'] = $this->lang->line('event_planner');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/event_planner',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	
	/*
	 * 
	 * name		:referal_programs
	 * @param   :Null
	 * @return  :referal_programs for Admin
	 */	
	
	public function referal_programs()
	{		
		$data['page_title'] = $this->lang->line('Referal_Programs');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/referal_programs',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: account_settings
	 * @param   : Null
	 * @return  : account_settings for Admin
	 */	
	
	public function account_settings()
	{		
		$data['page_title'] = $this->lang->line('account_settings');	
		$data['breadcrumb'] = '';
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');			
		if(get_session('account_type')!='MANAGER')
		{ //IF ADMIN LOGIN
		  $account_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		  //print_r($account_info);exit;
		  $data['account_info']=$account_info[0];	
		  $data['content'] = $this->load->view('settings/account_settings',$data,TRUE);
		}
		else
		{ //IF MANAGER LOGIN
		  $account_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');
		  $data['account_info']=$account_info[0];	
		  $data['content'] = $this->load->view('settings/account_settings',$data,TRUE);
		}		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: mobile_screen_settings
	 * @param   : Null
	 * @return  : mobile screen for Admin
	*/
	public function mobile_screen_settings()
	{
		$data['page_title'] 	=	$this->lang->line('Mobile_Screen_Settings');
		$data['breadcrump']		=	"";
		$data['content'] = $this->load->view('mobile_screen/mobile_screens',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: fetch_screen_sizes
	 * @param   : Null
	 * @return  : mobile screen for Admin
	*/
	public function fetch_screen_sizes()
	{
		$screen_sizes = $this->rest->get('api/v1/network/fetch_mobile_screen',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($screen_sizes);
	}
	
	/*
	 * 
	 * name		: edit_screen_sizes
	 * @param   : Null
	 * @return  : edit mobile screen for Admin
	*/
	public function edit_screen_sizes($screen_id=FALSE)
	{	
		if($screen_id)
		{	
			$screen			=	$this->rest->get('api/v1/network/edit_screen_size',array('api_key'=>get_session('api_key'),'screen_id'=>$screen_id),'php');
			$data['mobile_data']	=	$screen[0];
			echo $this->load->view('mobile_screen/modal_screen/content/edit_screen',$data);
		}
	}
	
	
	/*
	 * 
	 * name		: add_new_screen
	 * @param   : Null
	 * @return  : add mobile screen for Admin
	*/
	public function add_new_screen()
	{
		echo $this->load->view('mobile_screen/modal_screen/content/add_screen');
	}
	/*
	 * 
	 * name		: targeting_time_zone
	 * @param   : Null
	 * @return  : add mobile screen for Admin
	*/
	public function targeting_time_zone()
	{
		$api_key		=	get_session('api_key');
		$data['time']		= 	$this->rest->get('api/v1/utilities/fetch_target_time_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		
		
		return $data;
	}
	/*
     * 
     * name		: Site_settings
     * @param   : Null
     * @return  : Site_settings for Admin and affiliates
     * Developer Sruthi P on 16 June 2017
     */
    public function site_settings()
    {
        $data['page_title']   = $this->lang->line('Site_Settings');
        $data['breadcrumb']   = '';
        $account_info         = $this->rest->get('api/v1/network/user_information', array(
            'api_key' => get_session('api_key')
        ), 'php');
        $data['account_info'] = $account_info[0];
        
        $data['content']      = $this->load->view('settings/site_settings', $data, TRUE);
        $this->template->set_layout('admin_layout');
        $this->template->build('view', $data);
    }
}
