<?php 

class Roles extends CI_Controller {

	

	function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}

	

	function index()

	{

		$this->manage_roles();		

	}

	

	/*

	 * 

	 * name		:add_role

	 * @param   :Null

	 * @return  :add role_permissions-information for Admin

	 * 		

	 */	

	public function add_role()

	{	

		$data['page_title'] = $this->lang->line('role_permissions');	

		$data['breadcrumb'] = '';		

		//$data['content'] = $this->load->view('roles/permission_settings',$data,TRUE);		
		$data['content'] = $this->load->view('roles/add_user_content',$data,TRUE);		

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);
		

	}

	/*

	 * 

	 * name		:add_user

	 * @param   :Null

	 * @return  :add role_permissions-information for Admin

	 * 		

	 */

	public function add_user()

	{	

		// $data['page_title'] = "Roles and permissions";	

		// $data['breadcrumb'] = '';		

		// $data['content'] = $this->load->view('roles/add_user_content',$data,TRUE);		

		// $this->template->set_layout('admin_layout');

		// $this->template->build('view', $data);

		echo $this->load->view('roles/add_user_content',$data,TRUE);;

	}

	

	/*

	 * 

	 * name		:edit_role

	 * @param   :Null

	 * @return  :edit role_permissions-information for Admin

	 * 		

	 */	

	public function edit_role($role_id)

	{	

		$data['page_title'] = $this->lang->line('edit_roles_perm');	

		$data['breadcrumb'] = '';

		$data['role']=$this->rest->get('api/v1/roles/fetch_role',array('id'=>$role_id,'api_key'=>get_session('api_key')),'php');

		$data['role_permissions']=json_decode($this->rest->get('api/v1/roles/fetch_role_permission',array('id'=>$role_id,'api_key'=>get_session('api_key')),'json'));

		$data['content'] = $this->load->view('roles/permission_settings',$data,TRUE);		

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:manage_user_role

	 * @param   :Null

	 * @return  :list user_role for Admin

	 * 		

	 */	

	public function manage_roles()

	{	

		$data['page_title'] = $this->lang->line('manage_roles');	

		$data['breadcrumb'] = '';

		$data['content'] = $this->load->view('roles/user_roles',$data,TRUE);		

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

    }

	

	/*

	 * 

	 * name		:fetch_user_roles

	 * @param   :Null

	 * @return  :list added-user_role_lists for Admin

	 * 		

	 */	

	public function fetch_user_roles()

	{

	   $user_role_list	  = $this->rest->get('api/v1/roles/fetch_user_role_list',array('api_key'=>get_session('api_key')),'json');

	   echo convert_to_datatable_format($user_role_list);

	}

}
