<?php 
class Reports extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
	}

	function index()
	{
		$this->advertisers(); 
	}

	/*
	 * 
	 * name: advertisers
	 * @param : null
	 * @return :list all advertiser statistics .
	 */	

	public function advertisers()
	{
		$data['page_title'] = $this->lang->line('adv_rep');

		$data['breadcrumb'] = '';
//~ exit("jjj");
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['adv_data'] =	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>get_session('api_key')),'php');
		


		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_ADVERTISER']['CHART']['DEFAULT_INTERVAL']);
		//~ print_r($data);exit("JJ");
		$data['content'] = $this->load->view('report/advertisers_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by advertiser
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_advertiser_stats($env='all',$adv_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		
		#$account_type 	= get_session('account_type');
		
		#$manager_role_id 	= get_session('manager_role_id');
		
		$page			= 'REPORT_ADVERTISER';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'adv_account_id'=>$adv_id,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($adv_id != 'all'){
			$input['adv_account_id'] = $adv_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}			  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		echo $data;
	}
   
   
    /*
	 * 
	 * name: advertisers_campaign
	 * @param : null
	 * @return :list all campaign statistics .
	 */	

	public function advertisers_campaign($adv_id=FALSE)
	{
		$data['page_title'] = $this->lang->line('camp_rep');

		$data['breadcrumb'] = '';

		$api_key	=	get_session('api_key');
		
		$data['adv_id']	= $adv_id;
		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns/all/'.$adv_id,array('api_key'=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data[$adv_id]=$adv_id;
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/advertisers_campaign',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_campaign_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE,$acc_id=FALSE)
	{
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_CAMPAIGN';
		$display_type	= 'TABLE';
		
		$input = array( 'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
			$input['adv_account_id']=$acc_id;
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != 'all' && $from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != 'all' && $to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		$input['language'] = $this->config->item('language');		
		$input['exchangeval'] = $this->config->item('exchangeRate');	 
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
	   
		echo $data;
		
		//echo convert_to_datatable_format($data);
	}
	
	
	/*
	 * 
	 * name: advertisers_creative
	 * @param : null
	 * @return :list all creative statistics .
	 */	

	public function advertisers_creative($cam_id=FALSE)
	{
		$data['page_title'] = $this->lang->line('crtv_rep');

		$data['breadcrumb'] = '';

		$api_key	=	get_session('api_key');
		$data['camp_id']	= $cam_id;
		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns/'.$cam_id,array('api_key'=>$api_key),'php');
	
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_CREATIVE']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/advertisers_creative',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

	/*
	 * Lists the Statistics by creative
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_creative_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_CREATIVE';
		
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'search_term'=>$_REQUEST['sSearch']
					  );
		
		$input['display_type'] 	= 'TABLE';
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		// Pagination Parameters
		if(isset($_REQUEST['sEcho'])){
		
		}
		
		// GET TOTAL RECORDS
		$input['result_type'] 	= 'COUNT';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		$records = json_decode($data); 		
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		
		
		$input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	
	}
	
	/*
	 * 
	 * name: publisher
	 * @param : null
	 * @return : list all publisher statistics .
	 */	

	public function publishers()
	{
	
		$data['page_title'] = $this->lang->line('pub_rep');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_PUBLISHER']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/publishers_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function dsp()
	{	

		$data['page_title'] = $this->lang->line('dsp_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		//dateformat
		$data['date_format'] =	$this->rest->get('api/v1/report/fetch_app_config_date_format',array('api_key'=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);

		$data['content'] = $this->load->view('report/dsp_report',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: dsp
	 * @param : null
	 * @return : list all dsp statistics .
	 */	

	public function dsp_date($exchange_id=false,$from_date=false,$to_date=false)
	{	
		//$data['page_title'] = $this->lang->line('dsp_date_report'); 
		 $data['page_title'] =  $this->lang->line('dsp_datewise_per');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['date_format'] =	$this->rest->get('api/v1/report/fetch_app_config_date_format',array('api_key'=>get_session('api_key')),'php');

		$data['exchange_id']	=	$exchange_id;
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		
		$data['from_date'] = $from_date;
		$data['to_date'] = $to_date;
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		//$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/dsp_date_report',$data,TRUE);
		
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: dsp_details
	 * @param : null
	 * @return : list all dsp under date statistics .
	 */	

	public function dsp_details($exchange_id=false,$date=false)
	{	
		
		// $data['page_title'] = $this->lang->line('dsp_detail_report'); //  
		
		$data['page_title'] = $this->lang->line('dsp_detail_rep');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['exchange_id']	=	$exchange_id;
		$data['date']			=	$date;
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/dsp_detail_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: ssp
	 * @param : null
	 * @return : list all ssp statistics .
	 */	

	public function ssp()
	{	
		$data['page_title'] = $this->lang->line('ssp_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/ssp_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function ssp_date($exchange_id=false,$exchange_name=false,$from_date=false,$to_date=false)
	{	
		
		$data['page_title'] =  $this->lang->line('ssp_date_report');
		$data['breadcrumb'] = '';
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		$data['date_format'] =	$this->rest->get('api/v1/report/fetch_app_config_date_format',array('api_key'=>get_session('api_key')),'php');
		$data['exchange_id']	=	$exchange_id;
		$data['exchange_name']	=	$exchange_name;
		$data['from_date']	=	$from_date;
		$data['to_date']	=	$to_date;
		
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		$data['content'] = $this->load->view('report/ssp_date_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name: ssp_details
	 * @param : null
	 * @return : list all ssp under date statistics .
	 */	

	public function ssp_details($exchange_id=false)
	{	
		$data['page_title'] = $this->lang->line('ssp_detail_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['exchange_id']		=	$exchange_id;
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/ssp_detail_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by advertiser
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_publisher_stats($env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_PUBLISHER';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'pub_account_id'=>$pub_id,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');		  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		

		echo $data;
	}
	
	/*
	 * 
	 * name: publisher_site
	 * @param : null
	 * @return : list all publisher statistics .
	 */	

	public function publishers_site($pub_id=FALSE)
	{
		$data['page_title'] = $this->lang->line('sites_report');

		$data['breadcrumb'] = '';
		
		$api_key	=	get_session('api_key');
		
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites/all/'.$pub_id,array('api_key'=>$api_key),'php');
		
				
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['pub_id']=$pub_id;
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_SITE']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/publishers_site',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_sites_stats($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE,$pub_id=FALSE)
	{
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_SITE';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE && $from_date !='all'){
			$input['date_from'] = $from_date;
		}	
		if($pub_id!=FALSE)
		{
			$input['pub_account_id'] = $pub_id;
		}
		if($to_date != FALSE && $to_date !='all'){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');			  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		echo $data;
	}
	
	/*
	 * 
	 * name: publisher
	 * @param : null
	 * @return : list all publisher statistics .
	 */	

	public function publishers_adblock($site_id=FALSE)
	{
		$data['page_title'] = $this->lang->line('adblk_report');

		$data['breadcrumb'] = '';
		if($site_id)
		{
		$data['site_id'] = $site_id;
		}
		$api_key	=	get_session('api_key');
		
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites/'.$site_id,array('api_key'=>$api_key),'php');
		
		
				
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_ADBLOCK']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/publishers_adblock',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblock_stats($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_ADBLOCK';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');		  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
        
		echo $data;
	}
	
	
	
	/*
	 * 
	 * name: geo_report
	 * @param : null
	 * @return : list all geographical statistics .
	 */	

	public function geo_report()
	{
		$data['page_title'] = $this->lang->line('geo_rep');

		$data['breadcrumb'] = '';

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$api_key	=	get_session('api_key');

		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		
		$data['content'] = $this->load->view('report/geo_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

	public function fetch_country_stat($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$account_type 	= get_session('account_type');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY',
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
	
	    $input['language'] = $this->config->item('language');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
	
		echo $data;
	}
	
	
	 /*
	 * 
	 * name: earnings_report
	 * @param : null
	 * @return : list all earnings statistics .
	 */	

	public function earnings_report()
	{
		$data['page_title'] = $this->lang->line('earning_repo');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('report/earnings_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: adx_report
	 * @param : null
	 * @return : list all adexchangeperformance statistics .
	 */	

	public function adx_report()
	{
		$data['page_title'] = $this->lang->line('ad_per_repo');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('report/adx_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: environment_report
	 * @param : null
	 * @return : list all environment statistics .
	 */	

	public function environment_report()
	{
		$data['page_title'] = $this->lang->line('env_per_repo');

		$data['breadcrumb'] = '';
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_ENVIRONMENT']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/environment_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_environment_stats($env='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_ENVIRONMENT';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		 $input['language'] = $this->config->item('language');			  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		echo convert_to_datatable_format($data);
	}
	
	
	public function generate_csv()
	{
		
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CREATIVE';
		
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'search_term'=>''
					  );
		
		$input['display_type'] 	= 'TABLE';
		
		
		
		
		$input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch',$input,'csv');
		
		$this->rest->debug();
		exit;
		
		header('Content-type: text/csv');
		header('Content-Disposition: attachment; filename="downloaded.csv"');
			 
		
		
		echo $data;
		
	}
	
	public function fetch_dsp_stats($from_date=FALSE,$to_date=FALSE)
	{
	
			
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
												
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');

		$data	= 	$this->rest->post('api/v1/report/fetch_dsp',$input,'json');
		
		echo $data;
	}
	
	public function fetch_dsp_date_stats($exchange_id=false,$from_date=FALSE,$to_date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id						
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data	= 	$this->rest->post('api/v1/report/fetch_dsp_date',$input,'json');
		
		echo $data;
	}
	
	public function fetch_dsp_detail_stats($exchange_id=false,$date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id,
						'date'			=>	$date						
					  );		
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}		  
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
							
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		
		 $input['language'] = $this->config->item('language');		  
		$data	= 	$this->rest->post('api/v1/report/fetch_dsp_detail',$input,'json');

	

		echo $data;
	}
	
	public function fetch_ssp_stats($from_date=FALSE,$to_date=FALSE)
	{		
		
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$page			= 'REPORT_SSP';
		$display_type	= 'TABLE';
		
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'=>$page,
						'display_type'=>$display_type,					
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data	= 	$this->rest->post('api/v1/report/fetch_ssp',$input,'json');
		//print_r($data);exit;

		echo $data;
	}
	
	public function fetch_ssp_detail_stats($exchange_id=FALSE,$from_date=FALSE,$to_date=FALSE)
	{		
		
		
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id						
					  );		
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}
		else
		{
			$input['date_to'] = $date['to_date'];
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}		  
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
							
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		
					  
		$data	= 	$this->rest->post('api/v1/report/fetch_ssp_detail',$input,'json');

	 $input['language'] = $this->config->item('language');

		echo $data;
	}
// added by Murugeswari S  for vast mediation on 18-05-17 
	/*
	 * 
	 * name: video_adnetwork
	 * @param : null
	 * List all video adnetwork statistics
	 */	
	


	public function video_adnetwork()
	{
		$data['page_title'] = $this->lang->line('video_ad_repo');
		$data['breadcrumb'] = '';

		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_video_adnetwork',array('api_key'=>get_session('api_key')),'php');
		//print_r($data['pub_data']);exit;
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_VIDEOADNETWORK']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/video_adnetwork_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_video_adnetwork_stats
	 * @param : null
	 * returns the JSON Object for datatable
	 */	

public function fetch_video_adnetwork_stats($env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_VIDEOADNETWORK';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'VIDEO',
						'pub_account_id'=>$pub_id,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		 $input['language'] = $this->config->item('language');
		//print_r($input);exit;	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');


		echo $data;
	}
	// added by Murugeswari S  for video_creative on 18-05-17 
	/*
	 * 
	 * name: video_creative
	 * @param : null
	 * List all video creative report
	 */	


	 public function video_creative()
	{
		$data['page_title'] = $this->lang->line('video_adblock_report');
		$data['breadcrumb'] = '';
		$data['adblock_data'] =	$this->rest->get('api/v1/report/fetch_video_adblock',array('api_key'=>get_session('api_key')),'php');
	
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_VIDEOADBLOCK']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] =$this->load->view('report/video_adblock_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name: fetch_video_adblock_stats
	 * @param : null
	 * returns the JSON Object for datatable
	 */	
	public function fetch_video_adblock_stats($env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_VIDEOADBLOCK';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'VIDEO',
						'pub_account_id'=>$pub_id,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		 $input['language'] = $this->config->item('language'); 
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
	
		echo $data;
	}
	public function affiliate_report()
	{
		$data['page_title'] = $this->lang->line('affiliate_reports');
		
		$data['breadcrumb'] = '';
		
		//dateformat
		$data['date_format'] =	$this->rest->get('api/v1/report/fetch_app_config_date_format',array('api_key'=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_AFFILIATE']['TABLE']['DEFAULT_INTERVAL']);

		$data['content'] = $this->load->view('report/affiliate_report',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}	
	
	public function fetch_manager($env='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_AFFILIATE';
		$display_type	= 'TABLE';

		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'currency'=>get_session('currency')
					  );

		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}			  
		
		$input['datatable_obj'] = $_REQUEST;
	
		$input['result_type'] 	= 'DATA';
		 $input['language'] = $this->config->item('language');
		//print_r($input);	 die('--------');		  
		$data			= $this->rest->post('api/v1/report/fetch_affiliate',$input,'json');	

		
		echo $data;
	}
	
	/*
	
	 * name		:video
	 * @param   :Null
	 * @return  :Generate admin reports for video.
	 */	

	public function video($adv_id=null)
	{
		$data['page_title'] = $this->lang->line('video_report');

		$data['breadcrumb'] = '';
		
		//~ $data['creative_data']				= 	$this->rest->get('api/v1/report/fetch_video_creative',array("api_key"=>get_session('api_key')),'php');
		$api_key	=	get_session('api_key');
	
		$data['adv_id']	= $adv_id;
		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns/all/'.$adv_id,array('api_key'=>$api_key),'php');
	    //~ print_r($data['campaign_data']);exit;
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_VIDEO']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('report/video',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}	
	
	public function fetch_video_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		
		$api_key 	= get_session('api_key');
		#$account_type 	= get_session('account_type');
		#$manager_role_id 	= get_session('manager_role_id');
		$page			= 'REPORT_VIDEO';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'VIDEO',
						'campaign_id'=>$cam_id
					  );
		$input['adv_account_id']=$cam_id;

		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  

    	if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';			  
		 $input['language'] = $this->config->item('language');
		 $input['exchangeval'] = $this->config->item('exchangeRate');
		//print_r($_REQUEST);exit;						  			  
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		//print_r($data);exit;	
		//$this->rest->debug();exit;			
		echo $data;
	}
	public function video_report($site_id=FALSE)
	{
		$data['page_title'] = $this->lang->line('video_report');
		$data['breadcrumb'] = '';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key=get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites/'.$site_id,array("api_key"=>$api_key),'php');
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['site_id'] = $site_id;
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_VIDEOADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/video',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	
	public function fetch_video_report_stats($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_VIDEOADBLOCK';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'VIDEO',
						'site_id'=>$site_id
					  );
	
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';
		$input['language'] = $this->config->item('language');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	
	/*
	 * 
	 * name: city_report
	 * @param : null
	 * @return : list all city statistics .
	 */	

public function city_report()
	{
		$data['page_title'] = $this->lang->line('city_report');

		$data['breadcrumb'] = '';

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$api_key	=	get_session('api_key');

		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_CITY_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		 
		
		$data['content'] = $this->load->view('report/city_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	public function fetch_city_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		
		$api_key 	= get_session('api_key');
		$account_type 	= get_session('account_type');
		$page			= 'REPORT_CITY_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CITY',
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
	     $input['language'] = $this->config->item('language');
	//~ print_r($input);exit;
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
	
		//~ 
  //~ $this->rest->debug();
		echo $data;
	}
		//ended by Murugeswari on 18.05.17
		
		
	public function fetch_ssp_date_stats($exchange_id=false,$from_date=FALSE,$to_date=FALSE)
	{	
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id						
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		 $input['language'] = $this->config->item('language');
		$data	= 	$this->rest->post('api/v1/report/fetch_ssp_date',$input,'json');
		
		echo $data;
	}

	/*
	 * 
	 * name		:Site Report
	 * @param   :Null
	 * @return  :Generate admin reports by site.
	 */	

	public function site()
	{
		
		$data['page_title'] = "Site Report";
		$data['breadcrumb'] = '';

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$api_key	=	get_session('api_key');

		//$data['sites'] = $this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
						
		$data['sites']=$this->rest->get('api/v1/report/fetch_targeting_sites',array("api_key"=>$api_key),'php');
				
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_SITES']['TABLE']['DEFAULT_INTERVAL']);
		 
		
		$data['content'] = $this->load->view('report/site',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by site
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_site_stats($env='all',$site='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_SITES';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'SITES'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site != 'all'){
			$input['site'] = $site;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		//echo $this->rest->debug();  die("gg");
//~ print_r($data); exit;
		echo $data;
	}
/*
	 * 
	 * name		:Sentiment Report
	 * @param   :Null
	 * @return  :Generate aadmin reports by sentiment.
	 */	

	public function sentiment()
	{
		$data['page_title'] = "Sentiment Report";

		$data['breadcrumb'] = '';

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$api_key	=	get_session('api_key');

		//$data['sites'] = $this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['sentiment']=$this->rest->get('api/v1/report/fetch_targeting_sentiment',array("api_key"=>$api_key),'php');		
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_SENTIMENT']['TABLE']['DEFAULT_INTERVAL']);
		 
		
		$data['content'] = $this->load->view('report/sentiment',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * Lists the Statistics by sentiment
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_sentiment_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		
		
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_SENTIMENT';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'SENTIMENT'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site'] = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		echo $data;
	}	
	
	/*
	 * 
	 * name		:GENDER Report
	 * @param   :Null
	 * @return  :Generate admin reports by gender.
	 */	

	public function gender()
	{
	    $data['page_title'] = "Gender Report";

		$data['breadcrumb'] = '';

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$api_key	=	get_session('api_key');

		//$data['sites'] = $this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['gender']=$this->rest->get('api/v1/report/fetch_targeting_gender',array("api_key"=>$api_key),'php');		
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_GENDER']['TABLE']['DEFAULT_INTERVAL']);
		 
		
		$data['content'] = $this->load->view('report/gender',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by gender
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_gender_stats($env='all',$gender='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_GENDER';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'GENDER'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($gender != 'all'){
			$input['site'] = $gender;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');	
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//echo $this->rest->debug();
		
		print_r($data);;exit;
		echo $data;
	}
	
	/*
	 * 
	 * name		:Age Report
	 * @param   :Null
	 * @return  :Generate admin reports by age.
	 */	

	public function age()
	{
		 $data['page_title'] = "Age Report";

		$data['breadcrumb'] = '';

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$api_key	=	get_session('api_key');

		//$data['sites'] = $this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		
		$data['age']=$this->rest->get('api/v1/report/fetch_targeting_age',array("api_key"=>$api_key),'php');  			
		
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_AGE']['TABLE']['DEFAULT_INTERVAL']);
		 
		
		$data['content'] = $this->load->view('report/age',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * Lists the Statistics by age
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_age_stats($env='all',$age='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_AGE';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'AGE'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($age != 'all'){
			$input['site']  = $age;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');

		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			
		print_r($data); exit;
		echo $data;
	}
	
	public function custom_targeting1()
	{
		$data['page_title'] = $this->lang->line('custom_targeting1');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_CUSTOMTARG1']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg1']=$this->rest->get('api/v1/report/fetch_custom_targeting1',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('report/customtarg1',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg1_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG1';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG1'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		//~ print_r($data); exit;
		echo $data;
	}
	
	public function custom_targeting2()
	{
		$data['page_title'] = $this->lang->line('custom_targeting2');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_CUSTOMTARG2']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg2']=$this->rest->get('api/v1/report/fetch_custom_targeting2',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('report/customtarg2',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg2_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG2';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG2'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		echo $data;
	}
	
	public function custom_targeting3()
	{
		$data['page_title'] = $this->lang->line('custom_targeting3');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_CUSTOMTARG3']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg3']=$this->rest->get('api/v1/report/fetch_custom_targeting3',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('report/customtarg3',$data,TRUE);
		//~ print_r($data);exit;
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg3_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG3';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG3'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		echo $data;
	}
	
	public function custom_targeting4()
	{
		$data['page_title'] = $this->lang->line('custom_targeting4');
		$data['breadcrumb'] = '';		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_CUSTOMTARG4']['TABLE']['DEFAULT_INTERVAL']);
		$api_key=get_session('api_key');
		$data['customtarg4']=$this->rest->get('api/v1/report/fetch_custom_targeting4',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('report/customtarg4',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_customtarg4_stats($env='all',$sentiment='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CUSTOMTARG4';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CUSTOMTARG4'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($sentiment != 'all'){
			$input['site']  = $sentiment;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');	
		$input['exchangeval'] = $this->config->item('exchangeRate');
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');					
		echo $data;
	}
	
}
