<?php
/**
 * PayPal_Lib Controller Class (Paypal IPN Class)
 *
 * Paypal controller that provides functionality to the creation for PayPal forms, 
 * submissions, success and cancel requests, as well as IPN responses.
 *
 * The class requires the use of the PayPal_Lib library and config files.
 *
 * @package     CodeIgniter
 * @subpackage  Libraries
 * @category    Commerce
 * @author      Ran Aroussi <ran@aroussi.com>
 * @copyright   Copyright (c) 2006, http://aroussi.com/ci/
 *
 */

class Paypal extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		//installCheck();
		$this->load->library('Paypal_Lib');
		$this->load->model('Do_payments');
		/* Libraries */
		$this->load->library('email');
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
	}

	function index()
	{
		$this->form();
	}
	
	/*
	 * Triggers the form for add fund or make payment according to type
	 * Method: form_get()
	 * @params : 
	 * @return :
	*/
	function form()
	{
		
		
		
		 // GET Administrator PAYPAL Account ID 
		
		//$this->db->where('accountid',2); 
		//$admin_details	=	$this->db->get('djax_admin_payment_details')->row();
		 
		 $admin_details = 'dineshangappa@gmail.com';
		 $paypal_id = 'dinesh.merchant@dreamajax.com';
		 $account_id= $this->get('account_details');
		 $amount = $this->get('amount'); 
		 
		 
		// ASSIGN Administrator PAY PAL Account EMAIL ID 
		 
		$this->paypal_lib->add_field('business',$admin_details->paypal_id);
	    $this->paypal_lib->add_field('return', site_url('api/v1/paypal/success'));
	    $this->paypal_lib->add_field('cancel_return', site_url('api/v1/paypal/cancel'));
	    $this->paypal_lib->add_field('notify_url', site_url('api/v1//paypal/ipn')); // <-- IPN url
	    $this->paypal_lib->add_field('custom', $account_id); // <-- Verify return

	    $this->paypal_lib->add_field('item_name', 'Add Fund to Ad Network');
	    $this->paypal_lib->add_field('item_number', '1');
		$this->paypal_lib->add_field('currency_code', $this->config->item('currency_transaction_symbol'));
	    $this->paypal_lib->add_field('amount', $amount);

		// if you want an image button use this:
		$this->paypal_lib->image('button_03.gif');
		
		// otherwise, don't write anything or (if you want to 
		// change the default button text), write this:
		// $this->paypal_lib->button('Click to Pay!');
		
	    $data['paypal_form'] = $this->paypal_lib->paypal_form();
	
            $this->load->view('advertiser/paypal/form', $data);
        
	}

function get_invoice_details($type ='default')
	{
		if($this->input->is_ajax_request())
		{
			$id = $this->input->post('invoice_id');
			$payment_type = $this->input->post('payment_type');
			$payment_detail = $this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$id,'payment_type'=>$payment_type,'api_key'=>get_session('api_key')),'php'); 
					
			$this->auto_form1($type,$payment_detail[0]);
		}
	}
	
	function auto_form1($type,$payment_detail)
	{
		if($this->input->is_ajax_request())
		{
			$admin_details = $payment_detail['email'];
			$paypal_id = $payment_detail['paypal_id'];
			$invoice_id = $payment_detail['id'];
			$amount = round($payment_detail['amount'],2);
			$account_id = $payment_detail['account_id'];
			$custom = $account_id.':'.$invoice_id; 	
			$currency = $payment_detail['currency'];
			
			//$paypal_id = 'dinesh.a-facilitator@dreamajax.com';//'dinesh.merchant@dreamajax.com';
			 //$account_id= $accoun;//$this->get('account_details');
			 //$amount = '0.01';//$this->get('amount'); 
			 
			
			 
			
			// ASSIGN Administrator PAY PAL Account EMAIL ID 
			 
			$this->paypal_lib->add_field('business',$paypal_id);
			
			$this->paypal_lib->add_field('return', site_url('admin/paypal/success'));
			$this->paypal_lib->add_field('cancel_return', site_url('admin/paypal/cancel'));
			$this->paypal_lib->add_field('notify_url', site_url('admin/paypal/ipn')); // <-- IPN url
			$this->paypal_lib->add_field('custom', $custom); // <-- Verify return

			$this->paypal_lib->add_field('item_name', 'Make Payment');
			$this->paypal_lib->add_field('item_number', '1');
			$this->paypal_lib->add_field('currency_code', $currency);
 
			$this->paypal_lib->add_field('amount', $amount);
	
			//$data['button']=$this->paypal_lib->get_button_content();
			//$data['form']=$this->paypal_lib->get_paypal_form_content();
			//$data['page_content'] = $this->load->view("advertiser/paypal/auto_form", $data,true);
			//$this->template->set_layout('advertiser_layout');
			//$this->template->build('page', $data);	
			if($type==='default')
			{
				$this->paypal_lib->paypal_auto_form();
			}else{
			
				$this->paypal_lib->paypal_auto_form_custom();
			}
		}else{
			echo 'No permission';	
		}
	}
	function auto_form($type ='default')
	{
		
		if($this->input->is_ajax_request())
		{
			$admin_details = 'dineshangappa@gmail.com';
			$paypal_id = $this->input->post('paypal_id');
			$invoice_id = $this->input->post('invoice_id');
			$amount = $this->input->post('amount');
			$account_id = $this->input->post('account_id');
			$custom = $account_id.':'.$invoice_id; 	
			
			//$paypal_id = 'dinesh.a-facilitator@dreamajax.com';//'dinesh.merchant@dreamajax.com';
			 //$account_id= $accoun;//$this->get('account_details');
			 //$amount = '0.01';//$this->get('amount'); 
			 
			
			 
			
			// ASSIGN Administrator PAY PAL Account EMAIL ID 
			 
			$this->paypal_lib->add_field('business',$paypal_id);
			
			$this->paypal_lib->add_field('return', site_url('admin/paypal/success'));
			$this->paypal_lib->add_field('cancel_return', site_url('admin/paypal/cancel'));
			$this->paypal_lib->add_field('notify_url', site_url('admin/paypal/ipn')); // <-- IPN url
			$this->paypal_lib->add_field('custom', $custom); // <-- Verify return

			$this->paypal_lib->add_field('item_name', 'Make Payment');
			$this->paypal_lib->add_field('item_number', '1');
			$this->paypal_lib->add_field('currency_code', $this->config->item('currency_transaction_symbol'));
 
			$this->paypal_lib->add_field('amount', $amount);
	
			//$data['button']=$this->paypal_lib->get_button_content();
			//$data['form']=$this->paypal_lib->get_paypal_form_content();
			//$data['page_content'] = $this->load->view("advertiser/paypal/auto_form", $data,true);
			//$this->template->set_layout('advertiser_layout');
			//$this->template->build('page', $data);	
			if($type==='default')
			{
				$this->paypal_lib->paypal_auto_form();
			}else{
			
				$this->paypal_lib->paypal_auto_form_custom();
			}
		}else{
			echo 'No permission';	
		}
	}
	
	function cancel()
	{
            log_message('info', 'We are in Failure...');
            /*-------------------------------------------------------------
                Breadcrumb Setup Start
             -------------------------------------------------------------*/
            $link = breadcrumb();
            $data['breadcrumb'] = $link;
            /*-------------------------------------------------------------
                    Embed current page content into template layout
             -------------------------------------------------------------*/
            $data['content']	= $this->load->view('admin/paypal/cancel',$data,true);
            $this->template->set_layout('admin_layout');
		$this->template->build('view', $data);	
	}
	
	function success()
	{
		// This is where you would probably want to thank the user for their order
		// or what have you.  The order information at this point is in POST 
		// variables.  However, you don't want to "process" the order until you
		// get validation from the IPN.  That's where you would have the code to
		// email an admin, update the database with payment status, activate a
		// membership, etc.
	
		// You could also simply re-direct them to another page, or your own 
		// order status page which presents the user with the status of their
		// order based on a database (which can be modified with the IPN code 
		// below).
                log_message('info', 'We are Success...');
                
               
                
                
                $data['pp_info'] = $this->input->post();
		
                /*-------------------------------------------------------------
                    Breadcrumb Setup Start
                 -------------------------------------------------------------*/
                $link = breadcrumb();
                $data['breadcrumb'] = $link;
                /*-------------------------------------------------------------
                        Embed current page content into template layout
                 -------------------------------------------------------------*/
           $data['content']	= $this->load->view('admin/paypal/success',$data,true);
           $this->template->set_layout('admin_layout');
		   $this->template->build('view', $data);
			
	}
	
	function ipn()
	{
		
		
		mail("anantharubini.r@dreamajax.com","testing ipn","testing");
		
		// Payment has been received and IPN is verified.  This is where you
		// update your database to activate or process the order, or setup
		// the database with the user's order details, email an administrator,
		// etc. You can access a slew of information via the ipn_data() array.
 
		// Check the paypal documentation for specifics on what information
		// is available in the IPN POST variables.  Basically, all the POST vars
		// which paypal sends, which we send back for validation, are now stored
		// in the ipn_data() array.
 
		// For this example, we'll just email ourselves ALL the data.
		//$to = 'dineshangappa@gmail.com';
                //log_message('info', 'We are in IPN...');
               // log_message('info','Dinesh');
				//log_message('info','advertiser name');
		
		log_message('error', 'We are in IPN...');	
				
		if ($this->paypal_lib->validate_ipn()) 
		{
			
		
                        /* Store Paypal IPN data into Database */
                        $accountid     = $this->paypal_lib->ipn_data['custom'];
                        $custom  =  $this->paypal_lib->ipn_data['custom'];
                        $explode_custom= explode(":",$custom);
					
                        $invid=$explode_custom[1];
                        $amount = $explode_custom[2];
                        $payer_email    = $this->paypal_lib->ipn_data['payer_email'];
                        $receiver_email = $this->paypal_lib->ipn_data['receiver_email'];
                        $txn_id         = $this->paypal_lib->ipn_data['txn_id'];
                        $ipn_track_id   = $this->paypal_lib->ipn_data['ipn_track_id'];
                        $payment_gross  = $this->paypal_lib->ipn_data['payment_gross'];
                        $mc_currency    = $this->paypal_lib->ipn_data['mc_currency'];
                        $item_name      = $this->paypal_lib->ipn_data['item_name'];
                        $item_number    = $this->paypal_lib->ipn_data['item_number'];
                        $quantity       = $this->paypal_lib->ipn_data['quantity'];
                        $payer_status   = $this->paypal_lib->ipn_data['payer_status'];
                        $payment_status = $this->paypal_lib->ipn_data['payment_status'];
                        $payment_date   = $this->paypal_lib->ipn_data['payment_date'];
                        $country_code   = $this->paypal_lib->ipn_data['address_country_code'];

                        $this->session->set_userdata('paid_amount',$payment_gross);

                         $paypal_order = array(
                            'account_id'     =>  $accountid,
                            'payment_type'	 => '2',
                            'payment_request_id' => $invid,
                            'payer_email'   =>  $payer_email,
                            'receiver_email'=>  $receiver_email,
							'txn_id'        =>  $txn_id,
                            'ipn_track_id'  =>  $ipn_track_id,
                            'payment_gross' =>  $amount,
                            'mc_currency'   =>  $mc_currency,
                            'item_name'     =>  $item_name,
                            'item_number'   =>  $item_number,
                            'quantity'      =>  $quantity,
                            'payer_status'  =>  $payer_status,
                            'payment_status'=>  1,
                            'payment_date'  =>  date('Y-m-d H:00:00'),
                            'address_country_code'=> $country_code,
                            'payment_paid_date' => date('Y-m-d H:i:s')
                        );
            /* $check_exist_txn_id	=	$this->db->query('select count(*) as duplicate from djax_payment_response where txn_id="'.$paypal_order['txn_id'].'"');
		$check=$check_exist_txn_id->result_array();
		if($check[0]['duplicate']==0)
		{
			$this->db->insert(TAB_PAY_RES,$paypal_order);
			$payment_response_id = $this->db->insert_id();
			
		}*/		        
              $last_order_id = $this->Do_payments->insert_paypal_order($paypal_order);
                       
                   
         
				//return $payment_response_id;
	   if($last_order_id)

		{
		if($payment_status =='Completed')
		{
			$invoice_id = $paypal_order['payment_request_id'];
			//Get the Invoice Details based on invoice_id

			$invoice_details = $this->Do_payments->fetch_invoice_account_details($invoice_id);
			$invoice_details = $invoice_details[0];
			//Get the Account details 

			$account_details = $this->Do_payments->fetch_publisher_account_details($invoice_details['account_id']);
			// Billing information name to be considered

			$ins_pay_trans = array('account_id'=>$account_details['account_id'],

							   'name'=>$invoice_details['name'],

							   'email'=>$invoice_details['email'],

							   'payment_type'=>$account_details['payment_type'],

							   'date'=>date('Y-m-d H:i:s'),

							   'amount'=>$invoice_details['amount'],

							   'currency'=>$account_details['currency_code'],

							   'account_no'=>$account_details['bank_account_no'],

							   'clearing_date'=>date('Y-m-d H:i:s'),

							   'status'=>1,

							   'transaction'=>'debit',

							   'payment_response_id'=>$payment_response_id,

							   'admin_approval_status'=>1

							);

		

			//$this->db->insert(TAB_PAY_TRANS,$ins_pay_trans);					
			$payment_transaction_id=$this->Do_payments->insert_paypal_transaction($ins_pay_trans);
			

			//$payment_transaction_id = $this->db->insert_id();

			}
			else{

				$payment_transaction_id = '';

			}

		

		if($payment_transaction_id)

		{						

			//Insert one mapping table for further reference

			$ins_pay_invoice_payment = array('payment_id'=>$payment_transaction_id,

											'invoice_id'=>$invoice_details['id']

										);

			$invoice_payment_id=$this->Do_payments->insert_paypal_invoice_payment($ins_pay_invoice_payment);							

			//$this->db->insert(TAB_INVOICE_PAY,$ins_pay_invoice_payment);

		}
		else{
		  	$invoice_payment_id='';
		}

		
		if($invoice_payment_id){
		//Update the Billing Information

		
		$billing_address = $invoice_details['address'].','.$invoice_details['city'].','.$invoice_details['state'].','.$invoice_details['country'];

		

		$ins_bill_info = array('name'=>$invoice_details['name'],

							   'email'=>$invoice_details['email'],

							   'company_name'=>$invoice_details['company_name'],

							   'billing_address'=>$billing_address,

							   'payment_type'=>$account_details['payment_type'],

							   'bank_name'=>$account_details['bank_name'],		

							   'bank_address'=>$account_details['bank_address'],		

							   'swift_bic'=>$account_details['swift_bic'],		

							   'iban'=>$account_details['iban'],	

							   'routing_number'=>$account_details['routing_number'],		

							   'bank_account_no'=>$account_details['bank_account_no'],		

							   'account_holder_name'=>$account_details['account_holder_name'],		

							   'paypal_id'=>$account_details['paypal_id'],

							   'created_Date'=>date('Y-m-d H:i:s')		

						);

		$billing_id=$this->Do_payments->update_billing_info($ins_bill_info);				

			//$this->db->insert(TAB_BILL_INFO,$ins_bill_info);

			

			//$billing_id = $this->db->insert_id();			

		}
		else{
			$billing_id='';
		}

		//Updates the Invoice is paid
		if($billing_id){
		
		$up_invoice = array('invoice_status'=>1,
							'billing_id' => $billing_id,
							'invoice_id'=>$invoice_details['id']

										);
		
		$invoiceid =$this->Do_payments->update_invoice_info($up_invoice);
		//$this->db->update(TAB_INVOICE,array('invoice_status'=>1,'billing_id'=>$billing_id),array('invoice_id'=>$invoice_details['id'])); 
		}
		else
		{
			$invoiceid='';
		}
		
		}
		    /*------------------------------------------------------------------------
				GET PREVIOUS FUND VALUE FOR ADDING NEW FUND
			--------------------------------------------------------------------------*/
			/*$existing_fund	=	$this->mod_payments->getFund($advertiser);
							
			$current_value	=($existing_fund + $payment_gross);
		
			if($existing_fund != FALSE)
			{
				$this->mod_payments->update_fund($advertiser,$current_value);
			}
			else
			{
				$this->mod_payments->insert_fund($advertiser,$current_value);
			} */
			
			//$this->mod_payments->insert_advertiser_fund_details_paypal($advertiser,$payment_gross);
                        
                        //$this->mod_payments->insert_paypal_fund($advertiser,$payment_gross);
                        
		/*	if(!empty($last_order_id))
			{
			  
				$payer_name  = $this->paypal_lib->ipn_data['first_name'];
		  
				$payer_email= $this->paypal_lib->ipn_data['payer_email'] . ' on '.date('m/d/Y') . ' at ' . date('g:i A') . "\n\n";                     $data['payment_gross'] = $payment_gross;
			    $data['payment_status']= $payment_status;
			    $data['payment_date'] = $payment_date;
			    $data['txn_id']= $txn_id;
			    $data['ipn_track_id'] = $ipn_track_id;
			    $data['payer_name']= $payer_name;
			    $data['payer_email']= $payer_email;
			    $content= $this->load->view('email/registration/advertiser_payment',$data,TRUE);
			    $data['content']	=$content;
			    $mail_content=$this->load->view('email/registration/email_tpl',$data,TRUE);
			    $message=$mail_content;
			    $subject=$this->lang->line('advertiser_payment_email_subject');
			    $config['protocol'] = "sendmail";
                 	    $config['wordwrap'] = TRUE;		
		            $config['mailtype']	='html';
		            $config['charset']	='UTF-8'; 
                            $this->email->initialize($config);
			    $this->email->to($to);
              		    $this->email->from($this->paypal_lib->ipn_data['payer_email'], $this->paypal_lib->ipn_data['payer_name']);
			    $this->email->subject($subject);
			    $this->email->message($message);	
			    $this->email->send();
                   
                          
            }*/
           
			//$this->rest->post('api/v1/paypal/ipn',array('ipn_data'=>$this->paypal_lib->ipn_data,'transaction_type'=>'debit'),'json');
        }
	}
	
	
	
}
?>
