<?php 
class Payments extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('pdf');
		$exchangeval = $this->config->item('exchangeRate');
	}

	function index()
	{
		$this->advertiser_invoice();
	}

	/*
	 * 
	 * name: advertiser invoice
	 * @param : null
	 * @return :lsit all the advertiser invoice list.
	 */	

	public function advertiser_invoice()
	{
		$data['page_title'] = $this->lang->line('Advertiser_Invoice');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/advertiser_invoice',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
   
    /*
	 * 
	 * name: advertiser invoice view more 
	 * @param : null
	 * @return :detailed payment datas.
	 */	

	public function advertiser_invoice_viewmore()
	{
		$data['page_title'] = $this->lang->line('Advertiser_Invoice');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/advertiser_invoice_viewmore',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	
	 
   	/*
	 * 
	 * name: affiliate invoice
	 * @param : null
	 * @return :list all the affiliate invoice list.
	 */	

	public function affiliate_invoice()
	{
		$data['page_title'] = $this->lang->line('affiliate_invoice');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/affiliate_invoice',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	   /*
   * 
   * name: fetch_affilaite_invoice_list
   * @param : null
   * @return : all the affiliate payment invoice details.
   */
   public function fetch_affilaite_invoice_list()
   {
       $aff_invoice_list	  = $this->rest->get('api/v1/payments/fetch_affiliate_invoice_list',array('api_key'=>get_session('api_key')),'json');
      
	   echo convert_to_datatable_format($aff_invoice_list);
   }
   
    /*
	 * 
	 * name: affiliate invoice view more 
	 * @param : null
	 * @return :detailed payment datas.
	 */	

	public function affiliate_invoice_viewmore()
	{  
		$data['page_title'] = $this->lang->line('affiliate_invoice');
		$data['breadcrumb'] = '';
		$invoice_id=$this->uri->segment(4);
		$data['invoice_details']=$this->rest->get('api/v1/approval/affiliate_invoice_viewmore',array('id'=>$invoice_id, 'api_key'=>get_session('api_key')),'php'); 
		
		$data['invoice_id'] = $invoice_id;
		$data['content'] = $this->load->view('payments/affiliate_invoice_viewmore',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	
	
	
	
	
	 
		/*
	 * 
	 * name: publisher invoice
	 * @param : null
	 * @return :lsit all the publisher invoice list.
	 */	

	public function publisher_invoice()
	{
		$data['page_title'] = $this->lang->line('Publisher_Invoice');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/publisher_invoice',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
   
    /*
	 * 
	 * name: publisher invoice view more 
	 * @param : null
	 * @return :detailed payment datas.
	 */	

	public function publisher_invoice_viewmore()
	{  
		$data['page_title'] = $this->lang->line('Publisher_Invoice');
		$data['breadcrumb'] = '';
		$invoice_id=$this->uri->segment(4);
		$data['invoice_details']=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id,'api_key'=>get_session('api_key')),'php');
		$data['invoice_id'] = $invoice_id;
		// added by karthika on dec 27	-- to get admin emai id 
		$agencyid = $data['invoice_details'][0]['agencyid'];
		$data['admin_email']=$this->rest->get('api/v1/approval/publisher_invoice_get_admin',array('id'=>$agencyid,'api_key'=>get_session('api_key')),'php');
		//	end	
		//print_r($data['invoice_details']);exit;	
		$data['content'] = $this->load->view('payments/publisher_invoice_viewmore',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
   /*
	* 
	* name: payment history 
	* @param : null
	* @return : all the payment history details.
	*/	
	public function payment_history()
	{
		$data['page_title'] = $this->lang->line('Payment_History');
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('payments/payment_history',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
   
   /*
   * 
   * name: fetch_publisher_invoice_list
   * @param : null
   * @return : all the publisher payment invoice details.
   */
   public function fetch_publisher_invoice_list()
   {
	   $exchangeval = $this->config->item('exchangeRate');
      // $invoice_list	  = $this->rest->get('api/v1/payments/fetch_publisher_invoice_list','','json');
      $invoice_list=$this->rest->get('api/v1/payments/fetch_publisher_invoice_list',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json'); 
	   echo convert_to_datatable_format($invoice_list);
   }
   
   /*
   * 
   * name: publisher_payments_history
   * @param : null
   * @return : all the publisher payment invoice details.
   */
   public function publisher_payments_history()
   {
        $data['page_title'] = $this->lang->line('Payment_History');
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('payments/publisher_payment_history',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
   }
   
   /*
   * 
   * name: list_advertiser_payment_details
   * @param : account id
   * @return : all the advertiser payment  details.
   */ 
   public function list_advertiser_payment_details()
   {
	   $exchangeval = $this->config->item('exchangeRate');
	   $payment_list=$this->rest->get('api/v1/payments/list_advertiser_payment_details',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json'); 
	   echo convert_to_datatable_format($payment_list);
   }
   
    /*
   * 
   * name: get_advertiser_date_wise_payment_history
   * @param : account id
   * @return : all the advertiser payment  details.
   */
   public function get_advertiser_date_wise_payment_history()
   {
	  $month=$this->input->post('month');
	  $year=$this->input->post('year');
	  $account_id=$this->input->post('accountid');
	  $datewise=$this->rest->post('api/v1/payments/list_advertiser_payment_date_wise',array('account_id'=>$account_id,'month'=>$month,'year'=>$year,'api_key'=>get_session('api_key')),'json');
	  echo convert_to_datatable_format($datewise);
	}
	
	/*
   * 
   * name: list_publisher_payment_details
   * @param : none
   * @return : all the publisher payment  details.
   */ 
   public function list_publisher_payment_details()
   {
	   $exchangeval = $this->config->item('exchangeRate');

	   $payment_list=$this->rest->get('api/v1/payments/list_publisher_payment_history',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json'); 
	   echo convert_to_datatable_format($payment_list);
   }
   
   
   	/*
   * 
   * name: list_publisher_payment_details
   * @param : none
   * @return : all the publisher payment  details.
   */ 
   public function get_publisher_date_wise_payment_history()
   {
       $month_check=$this->input->post('month');
	   $year=$this->input->post('year');
	   $month = date('m', strtotime($month_check));;

	   $account_id=$this->input->post('accountid');
	   $datewise=$this->rest->post('api/v1/payments/list_publisher_payment_date_wise',array('api_key'=>get_session('api_key'),'account_id'=>$account_id,'month'=>$month,'year'=>$year),'json');
	   echo convert_to_datatable_format($datewise);
   }
   
   
   public function fetch_admin_payment_history()
   {
	   $exchangeval = $this->config->item('exchangeRate');

	   $payment_history=$this->rest->get('api/v1/payments/fetch_admin_payment_history',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json');
	   echo convert_to_datatable_format($payment_history);
   }
   
   /*
   * 
   * name: advertiser_deposit
   * @param : none
   * @return : all the advertiser payment details.
   */
   public function advertiser_deposit()
   {
	    $data['page_title'] = $this->lang->line('Deposit_Amount_Details');
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('payments/deposits/deposit_details',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
   }
   
   /*
   * 
   * name: fetch_advertiser_deposit_list
   * @param : none
   * @return : all the advertiser payment details.
   */
   public function fetch_advertiser_deposit_list()
   {
	    $exchangeval = $this->config->item('exchangeRate');
		$deposit_list	  = $this->rest->get('api/v1/payments/fetch_advertiser_deposit_amount_list',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json');
		
		echo convert_to_datatable_format($deposit_list);	
   }
   
   /*
   * 
   * name: fetch_billing_information
   * @param : none
   * @return : all the advertiser billing details.
   */
   public function fetch_billing_information()
   {	   
		$b_id=$this->input->post("b_id");
		$data['billing_details']=$this->rest->get('api/v1/payments/advertiser_billing_details',array('api_key'=>get_session('api_key'),'billing_id'=>$b_id),'php');
		$content = $this->load->view('payments/billing_preview',$data,TRUE);
   }
   
  
    /*
   * 
   * name: earnings_report
   * @param : none
   * @return : call to view file.
   */  
   public function earnings_report()
   {
        $data['page_title'] = $this->lang->line('Earnings_Details');
		$data['breadcrumb'] = '';
		$data['third_party']=	$this->rest->get('api/v1/payments/third_party',array('api_key'=>get_session('api_key')),'php');
		$data['content'] = $this->load->view('payments/revenue_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
   }
   
    /*
   * 
   * name: fetch_admin_revenue_list
   * @param : none
   * @return : all the revenue details in month wise.
   */
   public function fetch_admin_revenue_list() 
   {
	 $exchangeval = $this->config->item('exchangeRate');
     $agencyid=get_session('agencyid');
	 $revenue_list=$this->rest->get('api/v1/payments/admin_revenue_list',array('agencyid'=>$agencyid,'api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json');
	
	 echo convert_to_datatable_format($revenue_list);
   }
   
    /*
   * 
   * name: fetch_date_wise_revenue_details
   * @param : month,year,agencyid
   * @return : all the revenue details in date wise.
   */
   public function fetch_date_wise_revenue_details()	
   {
 	

      $month=$this->input->post('month'); 
	  $year=$this->input->post('year');
	  $agency_id=$this->input->post('agency_id');
	  
	  $revenue_list=$this->rest->get('api/v1/payments/admin_revenue_list_date_wise',array('month'=>$month,'year'=>$year,'agency_id'=>$agency_id,'api_key'=>get_session('api_key')),'json');
	  
	  
	
	  echo convert_to_datatable_format($revenue_list);
   }
   
   /*
   * 
   * name: download_invoice_details
   * @param : invoice_id
   * @return : downloads the invoice in pdf version
   */
   
   public function download_invoice_details($invoice_id)
	{

	    //$invoice_information=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id),'php');
	    
	    
	    $invoice_information=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id,'api_key'=>get_session('api_key')),'php');
	 
	 	if($invoice_information)
		{
			$data['invoice_details'] = $invoice_information;
			// added by karthika on dec 27	-- to get admin emai id 
			$agencyid = $data['invoice_details'][0]['agencyid'];
			$data['admin_email']=$this->rest->get('api/v1/approval/publisher_invoice_get_admin',array('id'=>$agencyid,'api_key'=>get_session('api_key')),'php');
			//	end	 			
			//$view = $this->load->view('admin/invoice_pub',$data,true);
			#$payment_date = date('Y-m-d',strtotime($data['payment_info']['invoice_paid_date']));
			#$pdf_name = 'invoice_'.$data['payment_info']['invoice_code'].'_'.$payment_date;
			$pdf_name = 'Your_invoice';
			$this->pdf->load_view('publisher/payments/download_invoice',$data);
			$this->pdf->render();
			$this->pdf->stream("$pdf_name.pdf");
			#$this->load->view('publisher/payments/download_invoice',$data);	
		}else{
			return FALSE;
		}
	}
    public function download_aff_invoice_details($invoice_id)
	{
	
	    $invoice_information=$this->rest->get('api/v1/approval/affiliate_invoice_viewmore',array('id'=>$invoice_id,'api_key'=>get_session('api_key')),'php');
	    
	   
	 	if($invoice_information)
		{
			$data['invoice_details'] = $invoice_information;
			$pdf_name = 'Your_invoice';
			$this->pdf->load_view('admin/payments/download_invoice',$data);
			$this->pdf->render();
			$this->pdf->stream("$pdf_name.pdf");	
		}else{
			return FALSE;
		}
	}
}
