<?php 

class Managers extends CI_Controller

{

    function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		//$this->load->model('api_v.1/do_creative','asd');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}



	function index()

	{

		$this->managers();
		//~ $this->users($account_id = 2);
		#redirect('admin/managers/users/2');

	}



	/*

	 * 

	 * name: managers

	 * @param : null

	 * @return :manage all managers.

	 */	



	public function managers()

	{
		$data['page_title'] = 	$this->lang->line('man_aff');



		$data['breadcrumb'] = 	'';

		

		$data['content'] 	= 	$this->load->view('users/managers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}	

	

	/*

	 * 

	 * name		:manager_ajax

	 * @param   :Null

	 * @return  :List all the managers for admin

	 */	



	public function fetch_manager()

	{

		$manager	=	$this->rest->get('api/v1/manager/fetch_all_manager',array('api_key'=>get_session('api_key')),'json');

	    //this->rest->debug();
	echo convert_to_datatable_format($manager);

	}

	

	/*

	 * 

	 * name		: add_manager

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_manager()

	{	

		echo $this->load->view('users/modal_users/content/add_manager');

	}

	

	/*

	 * 

	 * name		: edit_manager

	 * @param   : Null

	 * @return  : Fetch individual manager details

	 */	

	 	

	public function edit_manager($account_id=FALSE)

	{	

		if($account_id)

		{
			$api_details  =  (json_decode($this->rest->get('api/v1/manager/get_manager_api_key',array('api_key'=>get_session('api_key'),'account_id'=>$account_id),'json'))); 
			
			if($api_details!='')
			 {
				$api_key=$api_details->api_key;
				 
				$manager			=	$this->rest->get('api/v1/manager/fetch',array('api_key'=>$api_key),'php');

				$data['manager']	=	$manager[0];
	
				echo $this->load->view('users/modal_users/content/edit_manager',$data);
			}

		}

	}

   

   

    /*

	 * 

	 * name: advertisers

	 * @param : null

	 * @return : manage all users.

	 */	



	public function users($account_id = FALSE)

	{  
	 
		$account_type=get_session('account_type');
		
		if($account_type == 'ADMIN')
		{
			if(empty($account_id))
			{
				if(get_session('account_id')==1)
				{
					$account_id = 2;
				}
				else
				{
					$account_id = get_session('account_id');
				}
			}	
			//~ perform operations to redirect to admin users page
			//~ redirect('admin/managers/users/2');	
		}
		
		
	    if($account_type=='MANAGER')
		{
		   $account_id  = get_session('account_id');
		   $api_details = (json_decode($this->rest->get('api/v1/manager/get_manager_api_key',array('api_key'=>get_session('api_key'),'account_id'=>$account_id),'json')));
		   $api_key = $api_details->api_key;
		}

		if(is_numeric($account_id))

		{

			$data['page_title']	 	= 	$this->lang->line('man_manager_aff');

			$data['breadcrumb'] = 	'';
			
			$data['account_id'] = $account_id;
			
			if($account_type!='MANAGER'){
			 $api_key  = get_session('api_key');
			}
            
			$manager_users=	$this->rest->get('api/v1/manager/fetch_manager_details',array('api_key'=>$api_key,'account_id'=>$account_id),'php');

			$data['manager_name']=$manager_users[0];

			$data['content'] 	= 	$this->load->view('users/manager_users',$data,TRUE);

			$this->template->set_layout('admin_layout');

			$this->template->build('view', $data);

		}else{

			

			redirect('admin/managers');	

		}

	}

	

	/*

	 * 

	 * name		:fetch_manager_user

	 * @param   :Null

	 * @return  :List all the users associated with the manager

	 */	



	public function fetch_manager_user($account_id=FALSE)

	{  
		 
		$api_details  =  (json_decode($this->rest->get('api/v1/manager/get_manager_api_key',array('api_key'=>get_session('api_key'),'account_id'=>$account_id),'json')));
		if($api_details){
		 $api_key = $api_details->api_key;
		}
		else{
		  $api_key='';
		}
		 $manager_users			=	$this->rest->get('api/v1/manager/fetch_users',array('api_key'=>$api_key),'json');

		 echo convert_to_datatable_format($manager_users);
	}

	

	/*

	 * 

	 * name		: add_advertiser

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_advertiser()

	{	

		echo $this->load->view('users/modal_users/content/add_advertiser_user');

	}

	

	/*

	 * 

	 * name		: edit_advertiser

	 * @param   : Null

	 * @return  : Fetch individual advertiser details

	 */	

	 	

	public function edit_advertiser($account_id=FALSE)

	{	

		if($account_id)

		{

			$network_account_id	=	get_session('network_account_id');

			$network_id			=	get_session('account_id');

			

			$advertiser			=	$this->rest->get('api/v1/advertiser/fetch',array('api_key'=>get_session('api_key'),'network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id,'account_id'	=>	$account_id),'php');

			$data['advertiser']	=	$advertiser[0];

			

			echo $this->load->view('users/modal_users/content/edit_advertiser',$data);

		}

	}

	

	/*

	 * 

	 * name		: fetch_campaign_count

	 * @param   : Null

	 * @return  : Fetch individual campaign count for advertiser

	 */	

	 	

	public function fetch_campaign_count($account_id=FALSE,$clientid=FALSE)

	{	

		if($account_id && $clientid)

		{

			$count	=	$this->rest->get('api/v1/advertiser/campaign_count',array('api_key'=>get_session('api_key'),'account_id'=>$account_id,'client_id'=>$clientid),'json');

			if($count!=0)

			{

				echo $count;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	

	/*

	 * 

	 * name		: fetch_spend_amount

	 * @param   : Null

	 * @return  : Fetch individual spend amount for advertiser

	 */	

	 	

	public function fetch_spend_amount($account_id=FALSE,$clientid=FALSE)

	{	

		if($account_id && $clientid)

		{

			$amount	=	$this->rest->get('api/v1/advertiser/spend_amount',array('api_key'=>get_session('api_key'),'account_id'=>$account_id,'client_id'=>$clientid),'json');

			if($amount!=0)

			{

				echo $amount;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	

	/*

	* 

	* name: publishers

	* @param : null

	* @return : manager all publishers.

	*/	



	public function publishers()

	{

		$data['page_title'] 	= 	$this->lang->line('manager_publisher');



		$data['breadcrumb']	 	= 	'';

		

		$network_id				=	get_session('account_id');

		

		$network_account_id		=	get_session('network_account_id');

		

		$site_count				=	$this->rest->get('api/v1/publisher/site_count',array('api_key'=>get_session('api_key'),'network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'json');

		

		if($site_count!='null')

		{

			$data['site_count']	=	$site_count;

		}

		else

		{

			$data['site_count']	=	0;

		}

		

		$ad_block_count			=	$this->rest->get('api/v1/publisher/ad_block_count',array('api_key'=>get_session('api_key'),'network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'json');

		

		if($ad_block_count!='null')

		{

			$data['ad_block_count']	=	$ad_block_count;

		}

		else

		{

			$data['ad_block_count']	=	0;

		}

		

		$data['content'] 		= 	$this->load->view('users/publishers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:publisher_ajax

	 * @param   :Null

	 * @return  :List all the publisher for admin

	 */	



	public function fetch_publisher()

	{

		$network_account_id	=	get_session('network_account_id');

		$network_id			=	get_session('account_id');

		$publisher			=	$this->rest->get('api/v1/publisher/fetch',array('api_key'=>get_session('api_key'),'network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'json');

		

		

		echo convert_to_datatable_format($publisher);

	}

	

	/*

	 * 

	 * name		: add_publisher

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_publisher()

	{	

		echo $this->load->view('users/modal_users/content/add_publisher');

	}

	

	/*

	 * 

	 * name		: edit_publisher

	 * @param   : Null

	 * @return  : Fetch individual publisher details

	 */	

	 	

	public function edit_publisher($account_id=FALSE)

	{	

		if($account_id)

		{

			$network_account_id	=	get_session('network_account_id');

			$network_id			=	get_session('account_id');

			$publisher			=	$this->rest->get('api/v1/publisher/fetch',array('network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id,'account_id'	=>	$account_id,'api_key'=>get_session('api_key')),'php');

			$data['publisher']	=	$publisher[0];

			

			echo $this->load->view('users/modal_users/content/edit_publisher',$data);

		}

	}

	

	/*

	 * 

	 * name		: fetch_site_count

	 * @param   : Null

	 * @return  : Fetch individual site count for publisher

	 */	

	 	

	public function fetch_site_count($account_id=FALSE)

	{	

		if($account_id)

		{

			$count	=	$this->rest->get('api/v1/publisher/site_count',array('api_key'=>get_session('api_key'),'account_id'=>$account_id),'json');

			if($count!=0)

			{

				echo $count;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	/*

	 * 

	 * name		: add_manager

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_manager_user($account_id = FALSE)

	{


		$data['account_id'] = $account_id;	

		$data['roles'] = $this->rest->get('api/v1/manager/fetch_roles',array('api_key'=>get_session('api_key')),'php');
		
		echo $this->load->view('users/modal_users/content/add_manager_user',$data);

	}

	

  /*

	 * 

	 * name		: edit_manager_user

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function edit_manager_user($user_id = FALSE,$account_id = FALSE)

	{

		#$data['user_id'] = $account_id;	

		$details = $this->rest->get('api/v1/manager/fetch_manager_users',array('api_key'=>get_session('api_key'),'user_id'=>$user_id,'account_id'=>$account_id),'php');

		$data['roles_details']=$details[0];
		
		//ACTIVE ROLES
		$data['roles_active'] = $this->rest->get('api/v1/manager/fetch_roles',array('api_key'=>get_session('api_key')),'php');

		//ALL ROLES
		$data['roles'] = $this->rest->get('api/v1/manager/edit_fetch_roles',array('api_key'=>get_session('api_key')),'php');

		echo $this->load->view('users/modal_users/content/edit_manager_user',$data);

	}

	

	

	

}

