<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');
class Maintenance extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->file_permission();
	}	
	
	/*
	 * 
	 * name		: Clear Logs
	 * @param   : Null
	 * @return  : Clear All configured logs
	 */	
	 	
	public function clear_logs()
	{	
		$data['logs_list'] 		= $this->config->item('logs_list');
		$data['page_title'] 	= $this->lang->line('clr_log_files');	
		$data['breadcrumb'] 	= '';	
		$data['message'] 		= '';

		$days = ($this->config->item('clear_before') != '' && $this->config->item('clear_before') != 0) ? $this->config->item('clear_before') : 1;
		if(isset($_POST['clear_submit']) && isset($_POST['clear_log']))
		{
			foreach ($_POST['clear_log'] as $clear_log) 
			{
				$dir = getcwd().'/'.$data['logs_list'][$clear_log].'/';
				$dir_array = explode('/', $data['logs_list'][$clear_log]);				
				$writable = 1;
				$var = '';
				foreach($dir_array as $direct)
				{
					$var = $var.'/'.$direct;
					if(!is_writable(getcwd().$var))
					{
						echo getcwd().$var." - is not writable.<br/>";
						$writable = 0;
					}
				}
				if($writable == 1)
				{
					foreach (new DirectoryIterator($dir) as $fileInfo) 
					{
				        if ($fileInfo->isDot()) 
				        {
							continue;
				        }
				        if (time() - $fileInfo->getCTime() >= $days*24*60*60) 
				        {
				        	$data['message'] = 'Logs removed.';
				            unlink($fileInfo->getRealPath());
				        }
				    }
				}
			}
		}
		$this->load->view('maintenance/clear_logs', $data);
	}

	public function file_permission()
	{
		$data['permission_list'] 		= $this->config->item('permission_list');
		$data['page_title'] 	= 	$this->lang->line('file_permission');	
		$data['breadcrumb'] 	= 	'';
		$this->load->view('maintenance/file_permission', $data);
	}
	/* Function to generate invoice for the user by Suganiya.R on Feb 29,2016 */
	public function generate_invoice($period_days=FALSE)
	{	       		
		$this->load->library('default_configurations');
		$this->load->model('api.v_1/Do_invoices','do_invoices');
		$t=$this->do_invoices->generate_invoices($period_days);
		print_r($t);
	}
	public function generate_affiliate_invoice($period_days=FALSE)
	{	      
		$conf = $this->load->library('default_configurations');
		$this->load->model('api.v_1/So_invoices','do_invoices');
		$t=$this->do_invoices->generate_network_invoices($period_days);
		print_r($t);
	}	
}
