<?php 

class Feeds extends CI_Controller
{
    function __construct()
	{

		parent::__construct();
		
		$this->load->config('feeds');
		
		$this->load->config('report_configurations');

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}

	function index()
	{
		$this->network();
	}

	/*

	* 

	* name: network

	* @param : null

	* @return :manage all xml needs.

	*/	


	public function network()
	{
		
		$data['page_title'] = 	$this->lang->line('feed_network');

		$data['breadcrumb'] = 	'';		

		$data['content'] 	= 	$this->load->view('xml_feeds/feed_network',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}	

	
	/*

	* 

	* name		:fetch_feed_network

	* @param   :Null

	* @return  :List all the feed network for admin

	*/	

	public function fetch_feed_network()
	{

		$feed_network	=	$this->rest->get('api/v1/xml_feeds/fetch',array("api_key"=>get_session('api_key')),'json');		

		echo convert_to_datatable_format($feed_network);

	}
	
	/*

	* 

	* name		: view_feed_performance

	* @param   : Null

	* @return  : Fetch modal box for view feed performance

	*/		 	

	public function view_feed_performance($feed_network_id=FALSE)
	{
		if($feed_network_id!=FALSE)
		{	
			$data['page_title'] 		= 	$this->lang->line('feed_network_repo');

			$data['breadcrumb'] 		= 	'';
			
			$data['feed_network_id']	=	$feed_network_id;
			
			// GET DEFAULT PERIOD FROM CONFIG FILE
			
			$set 				= 	$this->config->item('report_config');
			$data['search_date']= 	get_search_date($set['ADMIN']['XML']['CHART']['DEFAULT_INTERVAL']);
			
			$data['content'] 	= 	$this->load->view('xml_feeds/xml_feed_report',$data,TRUE);
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		}
		else
		{
			$this->network();
		}
	}
	
	/*
	 * Lists the Statistics by date,keyword,browser,country
	 * 
	 * name		:fetch_feed_performance
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_feed_performance($feed_network_id=FALSE,$rtype='overview',$env='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['XML']['CHART']['DEFAULT_INTERVAL']);
	
		$input 		= 	array(
							'api_key'			=>	$api_key,
							'feed_network_id'	=>	$feed_network_id,
							'report_type'		=>	$rtype		
						);
		
		if($env != 'all'){
			$input['environment'] = $env;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}	
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data		= 	$this->rest->post('api/v1/xml_feeds/fetch_feed_performance',$input,'json');

		//$this->rest->debug();		exit;

		echo $data;
	}
	
	/*

	* 

	* name		: set_feed_limitations

	* @param   : Null

	* @return  : Set feed limtations

	*/		 	

	public function set_feed_limitations($feed_network_id=FALSE)
	{	
		if($feed_network_id!=FALSE)
		{
			$data['limitations']		=	$this->rest->get('api/v1/xml_feeds/feed_limitations',array("api_key"=>get_session('api_key'),"feed_network_id"=>$feed_network_id),'php');	
			$data['feed_network_id']	=	$feed_network_id;
			echo $this->load->view('xml_feeds/modal_feeds/content/feed_limitations',$data);
		}		
	}
	
	/*

	* 

	* name		: add_network

	* @param   : Null

	* @return  : Fetch modal box for add network

	*/		 	

	public function add_network()
	{	
		$data['feed_config']			=	$this->config->item('feed_config');
		$data['feed_config_dis_name']	=	$this->config->item('feed_config_display_name');
		$data['publisher']				=	$this->rest->get('api/v1/publisher/fetch',array("api_key"=>get_session('api_key')),'php');	
		echo $this->load->view('xml_feeds/modal_feeds/content/add_network',$data);
	}
	
	/*

	* 

	* name		: edit_network

	* @param   : Null

	* @return  : Fetch individual feed network details

	*/	
 	
	public function edit_network($feed_id=FALSE)
	{
		if($feed_id)
		{
			$data['publisher']			=	$this->rest->get('api/v1/publisher/fetch',array("api_key"=>get_session('api_key')),'php');	
			
			$data['mapped_publisher']	=	$this->rest->get('api/v1/xml_feeds/mapped_publisher',array("api_key"=>get_session('api_key'),'feed_id'=>$feed_id),'php');
			
			$feed						=	$this->rest->get('api/v1/xml_feeds/fetch',array("api_key"=>get_session('api_key'),'feed_id'=>$feed_id),'php');

			$data['feed']				=	$feed[0];		
			
			$data['feed_network_id']	=	$feed_id;	

			echo $this->load->view('xml_feeds/modal_feeds/content/edit_network',$data);
		}
	}
	
	/*

	* 

	* name		: publisher_feed_performance

	* @param   : Null

	* @return  : Fetch publisher feed performance

	*/		 	

	public function publisher_feed_performance()
	{
		$data['page_title'] 	= 	$this->lang->line('publisher_performance');

		$data['breadcrumb'] 	= 	'';
		
		$data['feed_network']	=	$this->rest->get('api/v1/xml_feeds/fetch',array("api_key"=>get_session('api_key')),'php');		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date']	= 	get_search_date($set['ADMIN']['XML']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('xml_feeds/publisher_feed_performance',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	/*
	 * Lists the Statistics by publisher
	 * 
	 * name		:fetch_pub_feed_performance
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_pub_feed_performance($feed_network_id=FALSE,$env='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= 	get_session('api_key');
		
		$set 		=	$this->config->item('report_config');
		$date		= 	get_search_date($set['ADMIN']['XML']['CHART']['DEFAULT_INTERVAL']);
	
		$input 		= 	array(
							'api_key'	=>	$api_key
						);
		
		if($env != 'all'){
			$input['environment'] 		= 	$env;
		}
		
		if($feed_network_id != FALSE){
			$input['feed_network_id'] 	= 	$feed_network_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = 	$from_date;
		}
		else
		{
			$input['date_from'] = 	$date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= 	$to_date;
		}	
		else
		{
			$input['date_to'] 	= 	$date['to_date'];
		}	
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
					  
		$data	= 	$this->rest->post('api/v1/xml_feeds/fetch_publisher_performance',$input,'json');

		//$this->rest->debug();exit;

		echo $data;
	}

}

