<?php 
class Approvals extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->advertiser_approvals();
	}

	/*
	 * 
	 * name: advertiser approvals
	 * @param : null
	 * @return :list of advertiser need to be approve.
	 */	

	public function advertiser_approvals()
	{
		
		$data['page_title'] = $this->lang->line('Advertiser_Approvals');
		$data['breadcrumb'] = '';
		//$data['adv_app']=$this->rest->get('api/v1/approval/fetch_user','','php');
		$data['content'] = $this->load->view('approvals/advertiser_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
   
   
    /*
	 * 
	 * name: publisher
	 * @param : null
	 * @return : list of publisher need to be approve.
	 */	

	public function publisher_approvals()
	{
		$data['page_title'] = $this->lang->line('Publisher_Approvals');
		$data['breadcrumb'] = '';
		//$data['adv_app']=$this->rest->get('api/v1/approval/fetch_user','','php');
		$data['content'] = $this->load->view('approvals/publisher_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	 /*
	 * 
	 * name: creatives
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function creative_approvals()
	{
		$data['page_title'] = $this->lang->line('Creative_Approvals');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('approvals/creative_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function fetch_creative()
	{
	    //$agencyid=get_session('agencyid');
		$fetch_creative		= $this->rest->get('api/v1/approval/fetch_creative',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($fetch_creative);
	}
	
	/*
	 * 
	 * name: preview_creative
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function preview_creative($banner_id=FALSE)
	{  
		$data['creative_list']=$this->rest->get('api/v1/approval/preview_creative',array('banner_id'=>$banner_id,'api_key'=>get_session('api_key')),'php'); 
		echo $this->load->view('approvals/modal_approvals/content/preview_creative',$data);
	}
	
	/*
	 * 
	 * name: advertiser_payment_approvals
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function advertiser_payment_approvals()
	{
		$data['page_title'] = $this->lang->line('Payment_Approvals');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('approvals/payment_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
   /*
	* 
    * name: publisher_payment_approvals
	* @param : null
	* @return : list of creatives need to be approve.
	*/	
	public function publisher_payment_approvals()
	{
		$data['page_title'] = $this->lang->line('Publisher_Payment_Approvals');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('approvals/publisher_payment_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_payment_list
	 * @param : null
	 * @return : list of payments need to be approve.
	 */	

	public function fetch_payment_list()
	{
		//$agencyid=get_session('agencyid');
		$exchangeval = $this->config->item('exchangeRate');
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_payment_list',array('api_key'=>get_session('api_key'),  'exchangeval'=> $exchangeval),'json');
		#echo $this->rest->debug();exit;
		echo convert_to_datatable_format($payment_list);
	}
	
	/*
	 * 
	 * name: payment_details_viewmore
	 * @param : null
	 * @return : show the modalbox with payment details.
	 */	 
	 public function payment_details_viewmore($id=FALSE)
	 {
	   $exchangeval = $this->config->item('exchangeRate');
	   $payment_detail=$this->rest->get('api/v1/approval/payment_viewmore',array('id'=>$id,'api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'php'); 
	   $data['payment_list']=$payment_detail[0];
	   echo $this->load->view('approvals/modal_approvals/content/payment_detail_viewmore',$data); 
	 }
	 
	 
	/*
	* 
	* name: fetch_publisher_payment_list
	* @param : null
	* @return : list of payments need to be approve.
    */	
	public function fetch_publisher_payment_list()
	{
		$exchangeval = $this->config->item('exchangeRate');
		//$agencyid=get_session('agencyid');
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_pub_payment_list',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json');
		
    	echo convert_to_datatable_format($payment_list);
	}
	
	
	/*
	* 
	* name: publisher_invoice_details
	* @param : null
	* @return : list of selected invoice id details.
    */	
	public function publisher_invoice_details($id=FALSE)
	{ 
	   $exchangeval = $this->config->item('exchangeRate');
	   $data['invoice_details']=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$id,'api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'php'); 
	   //$data['invoice_list']=$invoice_detail[0];
	   echo $this->load->view('approvals/modal_approvals/content/publisher_invoice_details',$data); 
	}
	
	/*
	* 
	* name: fetch_approval_advertiser
	* @param : null
	* @return : list the  advertiser need to be approve.
	*/	
	 public function fetch_approval_advertiser()
	 {  
	    $account_type = 'ADVERTISER';
		$app_adv	  = $this->rest->get('api/v1/approval/fetch_user',array("account_type"=>$account_type,"api_key"=>get_session('api_key')),'json');
		 echo convert_to_datatable_format($app_adv);
	 }
	 

	 /*
	 * 
	 * name: fetch_approval_publisher
	 * @param : null
	 * @return : list the  publisher need to be approve.
	 */	
	 public function fetch_approval_publisher()
	 {  
	    $account_type   = 'TRAFFICKER';
		$app_pub		= $this->rest->get('api/v1/approval/fetch_user',array("account_type"=>$account_type,"api_key"=>get_session('api_key')),'json');
		echo convert_to_datatable_format($app_pub);
	 }
	 
	 
	/*** Affiliate Payment Functionality ***/	
	  /*
	* 
    * name: affiliate_payment_approvals
	* @param : null
	* @return : list of affiliate payments need to be approve.
	*/
	public function affiliate_payment_approvals()
	{
		$data['page_title'] = $this->lang->line('affiliate_payment_approvals');

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('approvals/affiliate_payment_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	* 
	* name: fetch_affiliate_payment_list
	* @param : null
	* @return : list of payments need to be approve.
    */	
	public function fetch_affiliate_payment_list()
	{
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_aff_payment_list',array('api_key'=>get_session('api_key')),'json');
	//	$this->rest->debug();exit;
		echo convert_to_datatable_format($payment_list);
	}
	/*
	* 
	* name: affiliate_invoice_details
	* @param : null
	* @return : list of selected invoice id details.
    */	
	public function affiliate_invoice_details($id=FALSE)
	{ 	 
		
	  $data['invoice_details']=$this->rest->get('api/v1/approval/affiliate_invoice_viewmore',array('id'=>$id,'api_key'=>get_session('api_key')),'php'); 
	 //print_r($data); exit;
	   echo $this->load->view('approvals/modal_approvals/content/affiliate_invoice_details',$data); 
	}
	


	/*$data=array('xml_feed_params'=>array('xtype'=>$xml_feed_params[0],'xformat'=>$xml_feed_params[1],'xfwd
'=>$xml_feed_params[2],'via'=>$xml_feed_params[3],'affid'=>$xml_feed_params[4],'keywords'=>$xml_feed_params[5],'ip'=>$xml_feed_params[6],'agent'=>$xml_feed_params[7],'agent'=>$xml_feed_params[8],'serveurl'=>$xml_feed_params[9],'maxcount'=>$xml_feed_params[10]));*/

	 /*
	 * 
	 * name: site
	 * @param : null
	 * @return : list of sites need to be approve.
	 */	

     /* Added by murugeswari on 15-nov-2017
     * Site Approval functionality*/

	public function site_approvals()
	{
		
			$data['page_title'] = "Site Approvals";
			$data['breadcrumb'] = '';
			$data['content'] = $this->load->view('approvals/site_approvals',$data,TRUE);
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
	}
	 /* Added by murugeswari on 15-nov-2017
	fetch all sites*/


	public function fetch_site()
	{
		$fetch_site		= $this->rest->get('api/v1/approval/fetch_site1',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($fetch_site);
	}
	 /* Added by murugeswari on 15-nov-2017
     * Site preview functionality*/
	public function preview_site($site_id=FALSE)
	{  
			$sites	=	$this->rest->get('api/v1/approval/preview_site',array("api_key"=>get_session('api_key'),'site_id'=>$site_id),'php'); 
            
			if(is_array($sites))
					{
						$data['site_list'] = $sites;
					}
					else
					{
						$data['site_list']='';
			
					}
			
			$this->template->set_layout('admin_layout');
			echo $this->load->view('approvals/modal_approvals/content/preview_site',$data);
	}

}
