<?php 
class Antifraud_click_stats extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->anti_fraud();		
	}
	
	/*
	 * 
	 * name		:anti-fraud clicking
	 * @param   :Null
	 * @return  :List antifraud_information for Admin
	 * 		
	 */	
	public function anti_fraud()
	{		
		$data['page_title'] = $this->lang->line('anti_fraud_clicking');	
		$data['breadcrumb'] = '';
                $data['created_date'] = date('Y-m-d', strtotime('today - 30 days'));		
		$data['content'] = $this->load->view('analytics/anti_fraud',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:fetch_anti_fraud_stats_list
	 * @param   :Null
	 * @return  :List antifraud_valid click information for Admin
	 * 		
	 */	
	public function fetch_anti_fraud_stats_list()
	{
		$antifraud_stats	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_list',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($antifraud_stats);
	}
	/*
	 * 
	 * name		:fetch_anti_valid_list
	 * @param   :Null
	 * @return  :List antifraud_valid click information for Admin
	 * 		
	 */	
	public function fetch_anti_valid_list()
	{
	
		$antifraud_valid_list	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_valid_stats_list',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($antifraud_valid_list);
	}
	
	/*
	 * 
	 * name		:fetch_anti_penality_list
	 * @param   :Null
	 * @return  :List antifraud_penality information for Admin
	 * 		
	 */	
	public function fetch_anti_penality_list()
	{
		$antifraud_penality	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_penality_list',array('api_key'=>get_session('api_key')),'json');
		
		echo convert_to_datatable_format($antifraud_penality);
	}	
	
	public function fetch_anti_fraud_stats_filter($from_date=FALSE,$to_date=FALSE)
	{
		$antifraud_stats	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_filter',array('api_key'=>get_session('api_key'),'f_date'=>$from_date,'t_date'=>$to_date),'json');
		
		echo convert_to_datatable_format($antifraud_stats);
	}
	
	public function fetch_anti_penality_filter($from_date=FALSE,$to_date=FALSE)
	{
		$antifraud_stats	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_penality_stats_filter',array('api_key'=>get_session('api_key'),'f_date'=>$from_date,'t_date'=>$to_date),'json');
		
		echo convert_to_datatable_format($antifraud_stats);
	}
	
	public function fetch_anti_valid_filter($from_date=FALSE,$to_date=FALSE)
	{
		
		$antifraud_valid_list	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_filter',array('api_key'=>get_session('api_key'),'f_date'=>$from_date,'t_date'=>$to_date),'json');
		
		echo convert_to_datatable_format($antifraud_valid_list);
	}
}
