<?php 
class Analytics extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->load->library('utilities');
		$this->browsers();		
	}
	
	/*
	 * 
	 * name		:anti-fraud clicking
	 * @param   :Null
	 * @return  :List antifraud_information for Admin
	 * 		
	 */	
	public function anti_fraud()
	{		
		$data['page_title'] = $this->lang->line('anti_fraud_clicking');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('analytics/anti_fraud',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:browser_stats
	 * @param   :Null
	 * @return  :List browser_stats_information for Admin
	 * 		
	 */	
	public function browsers()
	{	
		/*$browser = get_browser($_SERVER['HTTP_USER_AGENT']);
		print_r($browser);exit;*/
			
		$data['page_title'] = $this->lang->line('browser_track_report');	
		$data['breadcrumb'] = '';	
		
		$network_account_id	=	get_session('network_account_id');
		$network_id			=	get_session('account_id');
		$data['pub_data'] 	=	$this->rest->get('api/v1/report/fetch_publisher',array('network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'php');
		
		//$val=$this->rest->get('api/v1/analytics/fetch_ver',array('network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'php');
		//$this->rest->debug();
		//print_r($val);exit;
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_BROWSER']['CHART']['DEFAULT_INTERVAL']);
			
		$data['content'] = $this->load->view('analytics/browser_stats',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by browser
	 * 
	 * name		:fetch_browser_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_browser_stats($env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$network_account_id	=	get_session('network_account_id');
		$account_id 	= 	get_session('account_id');
		$account_type 	= 	get_session('account_type');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_BROWSER']['CHART']['DEFAULT_INTERVAL']);
	
		$input 		= 	array(
						'network_account_id'=>	$network_account_id,
						'account_id'		=>	$account_id,
						'account_type'		=>	$account_type			
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}	
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data		= 	$this->rest->post('api/v1/analytics/fetch_browser_stats',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	/*
	 * 
	 * name   : edit_web_creative
	 * @param : Null
	 * @return: Loads web creative details in a modal box
	 */	
	public function fetch_version($browser=false,$env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		if($browser)
		{
			$network_account_id	=	get_session('network_account_id');
			$account_id 	= 	get_session('account_id');
			$account_type 	= 	get_session('account_type');
		
			$set 			=	$this->config->item('report_config');
			$date			= 	get_search_date($set['ADMIN']['REPORT_BROWSER']['CHART']['DEFAULT_INTERVAL']);
		
			$input 		= 	array(
							'network_account_id'=>	$network_account_id,
							'account_id'		=>	$account_id,
							'account_type'		=>	$account_type,
							'browser'			=>	$browser	
						  );
			
			if($env != 'all'){
				$input['environment'] = $env;
			}	
			
			if($pub_id != 'all'){
				$input['pub_account_id'] = $pub_id;
			}
			
			if($from_date != FALSE){
				$input['date_from'] = $from_date;
			}
			else
			{
				$input['date_from'] = $date['from_date'];
			}	
			
			if($to_date != FALSE){
				$input['date_to'] 	= $to_date;
			}	
			else
			{
				$input['date_to'] = $date['to_date'];
			}	
		
			$val				=	$this->rest->post('api/v1/analytics/fetch_version',$input,'php');
			
			//print_r($val);
			//$this->rest->debug();
			
			if(!empty($val))
			{
				$data['brows_data']	=	$val[0];
			}
			else
			{
				$data['brows_data']	=	'';
			}
			echo $this->load->view('analytics/modal/content/browser_version',$data);
		}
	}
	
	public function client_os()
	{
		$data['page_title'] = $this->lang->line('Client_OS_Track_Reports');

		$data['breadcrumb'] = '';
		
		$network_account_id	=	get_session('network_account_id');
		$network_id			=	get_session('account_id');
		$data['pub_data'] 	=	$this->rest->get('api/v1/report/fetch_publisher',array('network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'php');
		
		$data['flash'] 		=	$this->rest->get('api/v1/analytics/fetch_client_filter',array('client_filter'	=>	'flash_version'),'php');
		
		$data['screen'] 	=	$this->rest->get('api/v1/analytics/fetch_client_filter',array('client_filter'	=>	'screen_resolution'),'php');
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_CLIENT_OS']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('analytics/client_os_stats',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_client_stats($env='all',$pub_id='all',$flash='all',$screen='all',$from_date=FALSE,$to_date=FALSE)
	{
		$network_account_id	=	get_session('network_account_id');
		$account_id 	= 	get_session('account_id');
		$account_type 	= 	get_session('account_type');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_CLIENT_OS']['TABLE']['DEFAULT_INTERVAL']);
	
		$input 		= 	array(
						'network_account_id'=>	$network_account_id,
						'account_id'		=>	$account_id,
						'account_type'		=>	$account_type			
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
		
		if($flash != 'all'){
			$input['flash'] = $flash;
		}
		
		if($screen != 'all'){
			$input['screen'] = $screen;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
							  
		$data		= 	$this->rest->post('api/v1/analytics/fetch_client_stats',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	public function mobile_device()
	{
		$data['page_title'] = 	$this->lang->line('Mobile_Device_Track_Reports');

		$data['breadcrumb'] = 	'';
		
		$network_account_id	=	get_session('network_account_id');
		$network_id			=	get_session('account_id');
		$data['pub_data'] 	=	$this->rest->get('api/v1/report/fetch_publisher',array('network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'php');
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_MOBILE_DEVICE']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('analytics/mobile_device_stats',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_mobile_device_stats($env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$network_account_id	=	get_session('network_account_id');
		$account_id 	= 	get_session('account_id');
		$account_type 	= 	get_session('account_type');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_MOBILE_DEVICE']['TABLE']['DEFAULT_INTERVAL']);
	
		$input 		= 	array(
						'network_account_id'=>	$network_account_id,
						'account_id'		=>	$account_id,
						'account_type'		=>	$account_type			
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
							  
		$data		= 	$this->rest->post('api/v1/analytics/fetch_mobile_device_stats',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	public function sites()
	{
		$data['page_title'] = $this->lang->line('Site_Analytics');

		$data['breadcrumb'] = '';
		
		$network_account_id	=	get_session('network_account_id');
		$network_id			=	get_session('account_id');
		$data['pub_data'] 	=	$this->rest->get('api/v1/report/fetch_publisher',array('network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'php');
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DOMAIN_SITES']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('analytics/domain_sites_stats',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_domain_stats($env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$network_account_id	=	get_session('network_account_id');
		$account_id 	= 	get_session('account_id');
		$account_type 	= 	get_session('account_type');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_DOMAIN_SITES']['TABLE']['DEFAULT_INTERVAL']);
	
		$input 		= 	array(
						'network_account_id'=>	$network_account_id,
						'account_id'		=>	$account_id,
						'account_type'		=>	$account_type			
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}
		
		if($pub_id != 'all'){
				$input['pub_account_id'] = $pub_id;
			}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		
						  
		$data		= 	$this->rest->post('api/v1/analytics/fetch_domain_stats',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	
	
	/*
	 * 
	 * name   : fetch sites
	 * @param : Null
	 * @return: Loads fetch sites details in a modal box
	 */	
	public function fetch_sites($domain=FALSE,$env='all',$pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		if($domain!=FALSE)
		{
			$data['page_title'] = $this->lang->line('Site_Referrals');

			$data['breadcrumb'] = '';
			
			$data['search_date'] = array(
										'from_date'=>$from_date,
										'to_date'=>$to_date
										);
			$data['domain'] = $domain;
			
			$network_account_id	=	get_session('network_account_id');
			$network_id			=	get_session('account_id');
			$data['pub_data'] 	=	$this->rest->get('api/v1/report/fetch_publisher',array('network_id'	=>	$network_id,'network_account_id'	=>	$network_account_id),'php');
			
			$data['pub_id'] = $pub_id;
			
			$data['env'] = $env;
			
			$data['content'] = $this->load->view('analytics/domain_inner_sites_stats',$data,TRUE);
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		}
	}
	
	public function fetch_referral_sites($domain='all',  $env='all', $pub_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$network_account_id	=	get_session('network_account_id');
		$account_id 	= 	get_session('account_id');
		$account_type 	= 	get_session('account_type');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_REFERRAL_SITES']['TABLE']['DEFAULT_INTERVAL']);
	
		$input 		= 	array(
						'network_account_id'=>	$network_account_id,
						'account_id'		=>	$account_id,
						'account_type'		=>	$account_type			
					  );
					  
		if($domain != 'all')
		{
			$input['domain'] = str_replace('-','.',$domain);
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
				$input['pub_account_id'] = $pub_id;
			}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		
						  
		$data		= 	$this->rest->post('api/v1/analytics/fetch_referral_stats',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
}
