<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * CodeIgniter Wurfl
 * With this Wurfl library, able to get the Device details.
 *
 * @package         CodeIgniter
 * @subpackage      Libraries
 * @category        Libraries
 * @author          dJAX Adserver
 * @license         MIT
 * @link            http://djaxadserver.com/
 * @version         1.8.0.0-evaluation
 */

class Wurfl 
{
	private $_ci;
	
    function __construct($config = array())
    {
        $this->ci =& get_instance();
        //Include support files
        require_once(APPPATH . 'third_party/wurfl/TeraWurfl.php');
	}
	
	function getDevice()
	{    
		$wurflObj = new TeraWurfl();
		$wurflObj->getDeviceCapabilitiesFromRequest();

		$ca  	 = $wurflObj->capabilities;
		$vca     = $wurflObj->getAllVirtualCapabilities();
		
		$device = array();
		
		if(isset($vca['form_factor']) && $vca['form_factor'] == 'Desktop'){
			$device['type'] = 'desktop';
		}
		else if(isset($vca['form_factor']) && $vca['form_factor'] == 'Smartphone' && $vca['is_mobile'] ){
			$device['type'] = 'mobile';
		}
		$device['name'] = $vca['device_name'];
		$device['os'] = $vca['advertised_device_os'];
		$device['os_version'] = $vca['advertised_device_os_version'];
		$device['browser'] = $vca['advertised_browser'];
		$device['browser_version'] = $vca['advertised_browser_version'];
		$device['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
		$device['width'] = intval($ca['display']['resolution_width']);
		$device['height'] = intval($ca['display']['resolution_height']);
		$device['model'] = isset($ca['model_name']) ? $ca['model_name'] : '';
		$device['manufacturer'] = isset($ca['manufacturer_name']) ? $ca['manufacturer_name'] : '';
		
		return $device;
	}
}
