<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * CodeIgniter MaxMind GeoIP
 * With this MaxMind GeoIP library, able to get the Geo details from IP Address. 
 *
 * @package         CodeIgniter
 * @subpackage      Libraries
 * @category        Libraries
 * @author          dJAX Adserver
 * @license         MIT
 * @link            http://djaxadserver.com/
 * @version         1.0.0
 */

class Maxmind_geoip 
{
	private $_ci;
	
    function __construct($config = array())
    {
		if (!empty($config))
		{
			$this->initialize($config);
		}
        $this->ci =& get_instance();
        //Including the Vendor files
        require_once(APPPATH . 'third_party/MaxMind_GeoIP/vendor/autoload.php');
	}
	
	function initialize($config = array())
	{
		foreach ($config as $key => $val)
		{
			$this->{'_'.$key} = $val;
		}
	}
	
	function getIP($ip = "24.24.24.24")
	{
		$gi  = geoip_open(APPPATH . "third_party/MaxMind_GeoIP/dat/GeoLiteCity.dat", GEOIP_STANDARD);
		$rec = geoip_record_by_addr($gi, $ip);
		$geo = array();
		if(is_object($rec)){
			$geo['latitude'] = floatval($rec->latitude);
			$geo['longitude'] = floatval($rec->longitude);
			$geo['country_code'] = $rec->country_code;
			$geo['ip_address'] = $ip;
		}
		geoip_close($gi);
		return $geo;
	}
}
