<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/* Include By DAC020 For SSH key*/
require_once(dirname(__FILE__) . '/vendor/autoload.php');
include(dirname(__FILE__) . '/vendor/phpseclib/phpseclib/phpseclib/Net/SFTP.php');
include(dirname(__FILE__) . '/vendor/phpseclib/phpseclib/phpseclib/Crypt/RSA.php');

class MY_Image_lib extends CI_Image_lib {

   	public function __construct()
    {
        parent::__construct();

     }

	/*
	 * name:move_creative_to_tmp_location
	 * @param
	 * @return:Image details
	 * 
	 * This method is used to upload a creative to tmp location
	 */	

    public function move_creative_to_tmp_location($creative=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'jpeg|jpg|png|swf|gif';
		$config['max_size']			= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$creative['tmp_name'];
		$config['source_name']   	= 	$creative['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);
		

		if ( ! $ci_obj->upload->do_upload('creative'))
		{
			return FALSE;
			//$data = array('upload_data' => $ci_obj->upload->display_errors());
			//print_r($data);  die();
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	/*
	 * name:move_video_creative_to_tmp_location
	 * @param
	 * @return:Video details
	 * 
	 * This method is used to upload a creative to tmp location
	 */	

    public function move_video_creative_to_tmp_location($creative=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		$file_element_name 			= 	'creative';
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'*';
		$config['max_size']			= 	$ci_obj->config->item('video_creative_max_size');
		$config['encrypt_name']   	= 	TRUE;
		
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if(!$ci_obj->upload->do_upload($file_element_name))
		{
			$error = array('upload_data' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	/*
	 * name:move_swf_creative_to_tmp_location
	 * @param
	 * @return:SWF details
	 * 
	 * This method is used to upload a creative to tmp location
	 */	

    public function move_swf_creative_to_tmp_location($creative=FALSE)
	{
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'swf';
		$config['max_size']			= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$creative['tmp_name'];
		$config['source_name']   	= 	$creative['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;
		
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('creative'))
		{
			$error = array('upload_data' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	/*
	 * name:move_attach_image_to_tmp_location
	 * @param
	 * @return:Image details
	 * 
	 * This method is used to upload a attachment to tmp location
	 */	

    public function move_attach_image_to_tmp_location($attachment=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('message_tmp_upload_path');
        $config['allowed_types'] 	= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$attachment['tmp_name'];
		$config['source_name']   	= 	$attachment['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('attachment'))
		{
			$error 	= 	array('error' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data 	= 	array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	/*
	 * name:move_attach_file_to_tmp_location
	 * @param
	 * @return:File details
	 * 
	 * This method is used to upload a attachment to tmp location
	 */	

    public function move_attach_file_to_tmp_location($attach=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('message_tmp_upload_path');
        $config['allowed_types'] 	= 	'*';
        $config['non_allowed_types']= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$ci_obj->config->item('message_max_file_size');
		$config['source_image']   	= 	$attach['tmp_name'];
		$config['source_name']   	= 	$attach['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('attachment'))
		{
			$error 	= 	array('error' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data 	= 	array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}

	/*
	 * name:move_creative_to_original_location
	 * @param:$creative_name 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to move a creative from temporary
	 * location to it's original location
	 */	
	 
	public function move_creative_to_ffmpeg_location($creative_name=FALSE)
	{
		
		$ci_obj = & get_instance();
		if($creative_name)
		{
			 $tmp_file_path	= 	$ci_obj->config->item('creative_tmp_upload_path').$creative_name;
			 $moved_to		=	$ci_obj->config->item('creative_upload_path_ffmpeg').$creative_name;
			if(copy($tmp_file_path,$moved_to))
			{
			
				//Delete in temporary location
				//~ $this->delete_creative_in_tmp_location($creative_name);
				return TRUE;
			}
			else
			
				return FALSE;
		}
	
	}
	
   /* public function move_creative_to_original_location($creative_name=FALSE)
	{		
		$ci_obj = & get_instance();*/
        /*if($creative_name)
        {
            $tmp_file_path    =     $ci_obj->config->item('creative_tmp_upload_path').$creative_name;
             //Move to another server (adelivery server)
            $strServer = $ci_obj->config->item('ssh_server_host');
            $strServerUsername = $ci_obj->config->item('ssh_server_username');
            $remote_location = $ci_obj->config->item('ssh_image_move_path').$creative_name;  
						
			$rsa = new \phpseclib\Crypt\RSA();
			$rsa->loadKey(file_get_contents($ci_obj->config->item('ssh_privatekey')));  
			$sftp = new \phpseclib\Net\SFTP($strServer);
			if (!$sftp->login($strServerUsername, $rsa))  
			{
				return FALSE;
			}
			else
			{
				$sftp->put($remote_location, file_get_contents($tmp_file_path), NET_SFTP_LOCAL_FILE);
				$this->delete_creative_in_tmp_location($creative_name);
				return TRUE;				
			}
									
			//$resConnection = ssh2_connect($strServer, $strServerPort);
			
			        /*if(ssh2_auth_password($resConnection, $strServerUsername, $strServerPassword))
					{  
						$resSFTP = ssh2_sftp($resConnection);				
						$copy=ssh2_scp_send($resConnection, $tmp_file_path,$remote_location,0644);
						if($copy)
						{  
							//Delete in temporary location
							$this->delete_creative_in_tmp_location($creative_name);
							return TRUE;
						}
						else
						{  
							return FALSE;
						}
						
					}
					else
					{   
						return FALSE;
					}      
					*/
					
            //}
	
	//} 

	public function move_creative_to_original_location($creative_name=FALSE)
	{
		
		$ci_obj = & get_instance();
		if($creative_name)
		{
			 $tmp_file_path	= 	$ci_obj->config->item('creative_tmp_upload_path').$creative_name;
			 $moved_to		=	$ci_obj->config->item('creative_upload_path').$creative_name;
			if(copy($tmp_file_path,$moved_to))
			{
				//Delete in temporary location
				$this->delete_creative_in_tmp_location($creative_name);
				return TRUE;
			}
			else
			
				return FALSE;
		}
	
	}
	
	/*
	 * name:move_creative_to_original_location
	 * @param:$creative_name 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to move a creative from temporary
	 * location to it's original location
	 */	

    public function move_attach_to_original_location($attach_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($attach_name)
		{
			$tmp_file_path	= 	$ci_obj->config->item('message_tmp_upload_path').$attach_name;
			$moved_to		=	$ci_obj->config->item('message_upload_path').$attach_name;
			if(copy($tmp_file_path,$moved_to))
			{
				//Delete in temporary location
				$this->delete_attach_in_tmp_location($attach_name);
				return TRUE;
			}
			else
				return FALSE;
		}
	
	}
	
	/*
	 * name:delete_creative_in_original_location
	 * @param:$creative_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from original
	 *
	 */	

    public function delete_creative_in_original_location($creative_name=FALSE)
	{  
		$ci_obj = & get_instance();
		if($creative_name)
        {
			
            $tmp_file_path    =    $ci_obj->config->item('creative_upload_path').$creative_name;
            //Delete to another server 
			$strServer = $ci_obj->config->item('ssh_server_host');
            $strServerUsername = $ci_obj->config->item('ssh_server_username');
            $remote_location=$ci_obj->config->item('ssh_image_move_path').$creative_name;   
			
            $rsa = new \phpseclib\Crypt\RSA();
			$rsa->loadKey(file_get_contents($ci_obj->config->item('ssh_privatekey')));  
			$sftp = new \phpseclib\Net\SFTP($strServer);
			if (!$sftp->login($strServerUsername, $rsa))  
			{
				//exit('Login Failed');    
				return FALSE;
			}
			else
			{
				if($sftp->delete($remote_location))
				{
					return TRUE;
				}
				else
				{
					return FALSE;
				}
				
			}		
					
		}
       
	}
	/*
	 * name:delete_creative_in_tmp_location
	 * @param:$creative_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from temporary
	 *
	 */	

    public function delete_creative_in_tmp_location($creative_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($creative_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('creative_tmp_upload_path').$creative_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;
			
		}
	
	}
	
	/*
	 * name:delete_attach_in_tmp_location
	 * @param:$attach_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from temporary
	 *
	 */	

    public function delete_attach_in_tmp_location($attach_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($attach_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('message_tmp_upload_path').$attach_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;			
		}	
	}
	
	/*
	 * name:delete_attach_in_original_location
	 * @param:$attach_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from original
	 *
	 */	

    public function delete_attach_in_original_location($attach_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($attach_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('message_upload_path').$attach_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;			
		}	
	}
	
	
	/*
	 * name:update_profile_image
	 * @param:$profile_image 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to resize the Profile Image
	 * location to it's original location
	 */	
	 public function update_profile_image($profile_image=FALSE)
	{
		$ci_obj = & get_instance(); 
		
		/* upload the image */ 

		$config['image_library']  	= 	'gd2';		  
		$config['upload_path'] 		= 	$ci_obj->config->item('profile_image_upload_path');				
        $config['allowed_types'] 	= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$ci_obj->config->item('profile_max_size');
		$config['source_image']   	= 	$profile_image['source_name'];
		$config['source_name']   	= 	$profile_image['source_name'];		
		$config['width']          	= 	27;
		$config['height']         	= 	27; 
		$config['encrypt_name']   	= 	TRUE;
		$config['maintain_ratio'] 	= 	FALSE;	
		

		$ci_obj->load->library('upload');		
		$ci_obj->upload->initialize($config);	
		
		if ( ! $ci_obj->upload->do_upload('profile_image'))
		{
			$error = array('error' => $ci_obj->upload->display_errors());			
			return $error;
		}
		else
		{ 
			$profile_image_data = array('upload_data' => $ci_obj->upload->data());
			
			$file_name=$profile_image_data['upload_data']['file_name'];
			
		
			$config['new_image'] = $ci_obj->config->item('profile_image_upload_path_resize').$file_name;		
				
			$this->initialize($config);
			if(! $this->resize())
			{
				$error 	= 	array('error' => $this->display_errors());
				return $error; 	    
			}
			else
			{						
				$data 	= 	array('upload_data' => $ci_obj->upload->data());
				return $data;
			}					  
		}
	}

	
		/*
	 * name:delete_profile_image
	 * @param:$delete_profile_Image
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a profile image from thumb & original folder
	 *
	 */	

    public function delete_profile_image($delete_profile_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($delete_profile_name)
		{
			$original_file_path	=	$ci_obj->config->item('profile_image_upload_path').$delete_profile_name;
			$thumb_file_path	=	$ci_obj->config->item('profile_image_upload_path_resize').$delete_profile_name;
			
			if(file_exists($original_file_path) || file_exists($thumb_file_path) )
			{
				if(unlink($original_file_path) && unlink($thumb_file_path) )
					return TRUE;
				else
					return FALSE;
			}
			
			else
				return FALSE;
			
		}
	
	}


	//BELOW METHODS NEED TO BE OPTIMIZED

    public function image_resize($details=FALSE)
	{
		$config['image_library']  = 	'gd2';
		$config['source_image']   = 	$details['source_name'];
		$config['source_name']   	= 	$details['source_name'];
		$config['allowed_types']  = 	'gif|png|jpg|jpeg|swf';
		$config['max_size']       = 	'10000';
		$config['new_image']      = 	'./uploads/resize/'.$details['file_name'];
		$config['upload_path'] 	= 	'./uploads/resize/';
		$config['encrypt_name']   = 	FALSE;
		$config['overwrite']		= 	TRUE;
        $config['maintain_ratio'] = 	FALSE;
		$config['width']          = 	$details['width'];
		$config['height']         = 	$details['height'];
		$ci_obj 	= 	& get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);
		if ( ! $ci_obj->upload->do_upload())
		{
			$error = array('error' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{  //for resize the image
			$this->initialize($config);   
			if(! $this->resize())
			{
				$error 	= 	array('error' => $this->display_errors());
				return $error; 	    
			}
			else
			{
				$ci_obj = 	& get_instance();
				$ci_obj->load->library('encrypt');
				
				$file_name 				= 	$details['file'];
				
				$encrypt_name			=	$ci_obj->encrypt->encode($file_name); //encrypted file name
				$dot=".";
				$image['file_name']		=	$encrypt_name.$dot.$details['extension']; // join with extension
				$decrypt_name			=	$ci_obj->encrypt->decode($encrypt_name);
				$image['decryp_name']	=	$decrypt_name.$dot.$details['extension']; //decrypted file name
				$data 					= 	array('upload_data' => $image,'error'=>'sucess');
				return $data;
			}					  
		}
	}
		  
	 /****************************************
	 @ getting file extension
	 @method:get_extension
	 @params:imagedetails(need only image temp_name)
	 @return:image_type
	 ****************************************/
	 
	 public function upload_files($details=FALSE)
	 {
	     $temp_name           	= 	$details['source_name'];
		 $val                 	= 	getimagesize($temp_name);
		 $mime                	= 	explode("/",$val['mime']);
		 $path				  	= 	(pathinfo("./uploads/resize/".$details['file_name'])); //print_r($path);exit;
		 $details['extension']	= 	$path['extension']; 
		 $details['file']     	= 	$path['filename']; //filename without extension
		 if($val['mime']!='')
		 {  
			$uploaded_image	=	$this->config_image_resize($details);
			return $uploaded_image;
		 }
		 else
		 {
			$uploaded_file	=	$this->config_files();
			return $uploaded_file;
		 }
	 }
	 
	 
	 /****************************************
	 @Uploading only videos and files
	 @method:config_files
	 @params:no need to pass
	 @return:pass uploaded data or error
	 ****************************************/
	public function config_files()
	{
	   	$config['upload_path'] 	 	= 	'./uploads/resize';
		$config['allowed_types'] 	= 	'flv|csv|pdf|xls|doc|docx|txt';
		$config['max_size']	     	= 	'10000';
		$config['max_width']     	= 	'1024';
		$config['max_height']   	= 	'768';
		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);
		if ( ! $ci_obj->upload->do_upload())
		{
			$error 	= 	array('error' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data 	= 	array('upload_data' => $ci_obj->upload->data(),'error'=>'sucess');
            return $data;
		}
	}
	
	/*
	 * name:update_logo_image
	 * @param:$logo_image 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to resize the Profile Image
	 * location to it's original location
	 * Added by Ramya P for logo change on 4 May
	 */	
	 public function update_logo_image($logo_image=FALSE,$logo_sett=FALSE)
	{
		$ci_obj = & get_instance(); 
		
		/* upload the image */ 

		$config['image_library']  	= 	'gd2';		  
		$config['upload_path'] 		= 	$ci_obj->config->item('logo_image_upload_path');				
        $config['allowed_types'] 	= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$ci_obj->config->item('logo_max_size');
		$config['source_image']   	= 	$logo_image['source_name'];
		$config['source_name']   	= 	$logo_image['source_name'];		
		if($logo_sett=='Logo with site name')
		{		
		$config['width']          	= 	22;
		$config['height']         	= 	22; 
		}
		else
		{
		$config['width']          	= 	120;
		$config['height']         	= 	25; 
		}
		$config['encrypt_name']   	= 	TRUE;
		$config['maintain_ratio'] 	= 	FALSE;	
		

		$ci_obj->load->library('upload');		
		$ci_obj->upload->initialize($config);	
		
		if ( ! $ci_obj->upload->do_upload('logo_image'))
		{
			$error = array('error' => $ci_obj->upload->display_errors());			
			return $error;
		}
		else
		{ 
			$logo_image_data = array('upload_data' => $ci_obj->upload->data());
			
			$file_name=$logo_image_data['upload_data']['file_name'];
			
		
			$config['new_image'] = $ci_obj->config->item('logo_image_upload_path_resize').$file_name;		
				
			$this->initialize($config);
			if(! $this->resize())
			{
				$error 	= 	array('error' => $this->display_errors());
				return $error; 	    
			}
			else
			{						
				$data 	= 	array('upload_data' => $ci_obj->upload->data());
				return $data;
			}					  
		}
	}

	
		/*
	 * name:delete_logo_image
	 * @param:$delete_logo_Image
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a logo image from thumb & original folder
	 *
	 */	

    public function delete_logo_image($delete_logo_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($delete_logo_name)
		{
			$original_file_path	=	$ci_obj->config->item('logo_image_upload_path').$delete_logo_name;
			$thumb_file_path	=	$ci_obj->config->item('logo_image_upload_path_resize').$delete_logo_name;
			
			if(file_exists($original_file_path) || file_exists($thumb_file_path) )
			{
				if(unlink($original_file_path) && unlink($thumb_file_path) )
					return TRUE;
				else
					return FALSE;
			}
			
			else
				return FALSE;
			
		}
	
	}

	public function move_html_creative_to_original_location($creative_name=FALSE,$creative_id=FALSE)
	{
	
		$ci_obj = & get_instance();
		
		if($creative_name)
		{
			 $tmp_file_path	= 	$ci_obj->config->item('creative_tmp_upload_path').$creative_name;
			 $structure= $ci_obj->config->item('creative_upload_path').'banner_'.$creative_id.'/';
			 $folder=mkdir($structure, 0777, true);		
			  $moved_to		=	$structure.$creative_name;
			 
			if(copy($tmp_file_path,$moved_to))
			{
				
				//~ $zip = new ZipArchive();
				//~ $x = $zip->open($moved_to);
				//~ 
				//~ if ($x === true) {
					//~ $name=$zip->extractTo($structure); 
					//~ $filename = $zip->getNameIndex(0);
					//~ $file_name=explode('/',$filename);
					//~ $folder_name=$file_name[0];
					//~ $zip->close();
					//~ unlink($moved_to);
					//~ }
					
				 require_once('pclzip.lib.php');
				 $zip = new PclZip($moved_to);	
				
				 $list = $zip->extract($structure);
				  //print_r($list);exit;
				 $filename = $list['1']['filename'];
				 //print_r($filename);exit;
				 $file_name=explode('/',$filename);	
				  //print_r($file_name);exit;
				 $folder_name=$file_name[4];
				 //print_r($folder_name);exit;
				 //~ $zip->close();
				 unlink($moved_to);
				//Delete in temporary location
				$this->delete_creative_in_tmp_html_location($creative_name);
				return $folder_name;
			}
			else
			
				return FALSE;
		}
	
	}

	public function delete_creative_in_tmp_html_location($creative_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($creative_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('creative_tmp_upload_path').$creative_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;
			
		}
	
	}

	  public function move_creative_to_tmp_html_location($creative=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'*';
		$config['source_image']   	= 	$creative['tmp_name'];
		$config['source_name']   	= 	$creative['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);


		if ( ! $ci_obj->upload->do_upload('creative'))
		{
			
			return FALSE;
			//$data = array('upload_data' => $ci_obj->upload->display_errors());
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}

	
 }

/* End of file Image_lib.php */
/* Location: ./application/libraries/MY_Image_lib.php */
