<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class MY_Form_validation extends CI_Form_validation {

   function __construct($config){
        parent::__construct($config);
    }

    function error_array(){
        return $this->_error_array; 
    }
    
    function valid_url($url)
    {
        //$pattern = "/^(http|https|ftp):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i";
        return (bool) filter_var($url, FILTER_VALIDATE_URL);
        
        //return (bool) preg_match($pattern, $url);
    }
    
    function url_exists($url){                                   
        $url_data = parse_url($url); // scheme, host, port, path, query
        if(!@fsockopen($url_data['host'], isset($url_data['port']) ? $url_data['port'] : 80)){
            $this->set_message('url_exists', 'The URL you entered is not accessible.So provide a valid url');
            return FALSE;
        }               
         
        return TRUE;
    }  
    
    //checking unique  for updating entry
	function edit_unique($value, $params) 
	{

		$CI =& get_instance();
		$CI->load->database();
	
		$CI->form_validation->set_message('edit_unique', "That %s is already being entered.");
	
		list($table, $field, $field2,$current_id) = explode("~", $params);
	
		$query = $CI->db->select()->from($table)->where($field, $value)->limit(1)->get();
	
		if ($query->row() && $query->row()->$field2 != $current_id)
		{			
			return FALSE;
		}
	}  
	
   //Checks alpha numeric with dash and space
	function alpha_numeric_dash_space($str)
    	{
		$this->CI->form_validation->set_message('alpha_numeric_dash_space', 'The %s must be a valid Characters.');    	    
		return ( ! preg_match("/^([-a-z0-9_ ])+$/i", $str)) ? FALSE : TRUE;
    	}
	
	//Checks first letter is alphabets 
	function first_alpha_check($str)
    	{
		$this->CI->form_validation->set_message('first_alpha_check', 'The First character %s must be a valid alphabet letters.');    	    
		return ( !preg_match("/^[a-zA-Z]{1}/",$str)) ? FALSE : TRUE;
    	}
    
     /**
	 * Check the Image Size is greater than IAB guidelines
	 *
	 * 
	 * @access	public
	 * @param	string {$bytes}
	 * @param	string {$precision}
	 * @return	formatted file size
	*/
    
    function check_image_size($filename)
    {
		if($filename)
		{
			$headers  = get_headers($filename, 1);

			$fsize    = $headers['Content-Length'];
			
			//$fsize = curl_get_file_size($filename);
			
			
			if($fsize >= convertToBytes('250KB') || $fsize ==='-1')
			{
				$this->CI->form_validation->set_message('check_image_size', 'Entered Image is '.formatBytes($fsize).' and it exceeds 250KB');  	
				return FALSE;
			}
			return TRUE;
		}else{
			return FALSE;	
		}	
		
		
	}
    	
    
}
?>
