<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Autoacl
 *
 * Access control library
 *
 * @package         Autoacl
 * @author          Ardinoto Wahono
 * @version         8.11.1
 * @copyright        Copyright (c) 2009-2011 Ardinoto Wahono
 * @copyright        Copyright (c) Wiredesignz & Maxximus 2009-10-03
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

class Autoacl
{
    function __construct()
    {
        $this->ci =& get_instance();
        $this->ci->load->helper('url');
        $this->ci->load->library('session');
        $this->ci->load->config('autoacl');
		$this->ci->load->language('autoacl');
        $this->ci->load->helper('string');
		 $this->ci->load->helper('utilities');
		
        // Clear error_uri session
        $this->ci->session->unset_userdata('error_uri');

        // Auto check ACL
        $this->check_acl();
		
    }

    /**
     * check_acl
     * autoacl control logic
     * @return	bool
     * 
     */
    function check_acl()
    {
        $current_page = $this->current_uri(); 
       
        $role_id = ($this->get_role_id()) ? $this->get_role_id() : $this->ci->config->item('default_role');
        $config_page = $this->ci->config->item('page_control');
        $config_vpp_page = $this->ci->config->item('vpp_control');
		
		if($role_id != 'PUBLIC'){
			$this->is_user_valid();
		}
		
		if($this->ci->router->class === 'user_login'){
			
			// CHECK Previous Login
		
			if($role_id != 'PUBLIC' AND $this->is_login_method($this->ci->router->method))
			{
				
				if($this->ci->router->method !== strtolower($role_id) AND strtolower($role_id)!=='trafficker'){
					
					$landing_page = urlencode(base64_encode($this->get_landing_page(strtolower($role_id))));
					
					redirect('error/more_login/'.$landing_page, 'refresh');	
				}
				else if($this->ci->router->method !== strtolower($role_id) AND strtolower($role_id)==='trafficker'){
					$landing_page = urlencode(base64_encode($this->get_landing_page(strtolower($role_id))));
					//echo 'Another User already login..'; die();
					redirect('error/more_login/'.$landing_page, 'refresh');	
				}				
				else
				{
					redirect($this->get_landing_page(strtolower($role_id)), 'refresh');
				}	
			}
		
		}
		
		
	
		
		if ($this->is_allowed($current_page, $role_id, $config_page, $config_vpp_page))
        {
      		return TRUE;
        }
        else
        {
           $error_uri = $this->ci->session->userdata('error_uri');
           redirect($error_uri, 'refresh');
        }
    }
	/*Modified by Suganiya.R for user roles on 25th Feb 2016*/
	function is_user_valid(){
	
		$account_id 	= get_session('account_id');
		$account_type 	= get_session('account_type');
		$manager_user_id 	= get_session('manager_user_id');
			
		switch(strtoupper($account_type)){
			case 'ADMIN':
				$query = $this->ci->db->query("SELECT * FROM `djax_networks` WHERE `account_id`={$account_id} AND `is_approved`=1 AND `is_denied`=0 AND `is_deleted`=0");
				if($query->num_rows() >0){
					return TRUE;
				}
				else
				{
					$this->ci->session->sess_destroy();
					redirect();
				}
				break;
			case 'ADVERTISER':
				$query = $this->ci->db->query("SELECT * FROM `ox_clients` WHERE `account_id`={$account_id} AND `dj_is_denied`=0 AND `dj_is_deleted`=0 AND `dj_approval_status`=1");
				if($query->num_rows() >0){
					return TRUE;
				}
				else
				{
					$ajax = $this->ci->input->is_ajax_request();
					if($ajax == 1)
					{
						$this->ci->session->sess_destroy();	
						return FALSE;
					}
					else
					{
						$this->ci->session->sess_destroy();
						redirect();
					}
				}
				break;
			case 'TRAFFICKER':
				$query = $this->ci->db->query("SELECT * FROM `ox_affiliates` WHERE `account_id`={$account_id} AND `dj_approval_status`=1 AND `dj_is_denied`=0 AND `dj_is_deleted`=0");
				if($query->num_rows() >0){
					return TRUE;
				}
				else
				{
					$ajax = $this->ci->input->is_ajax_request();
					if($ajax == 1)
					{
						$this->ci->session->sess_destroy();	
						return FALSE;
					}
					else
					{
						$this->ci->session->sess_destroy();
						redirect();
					}
				}
				break;	
			case 'MANAGER':
		
			if($manager_user_id=='')
			{
				$query = $this->ci->db->query("SELECT * FROM `djax_network_managers` WHERE `manager_account_id`={$account_id} AND `manager_status`=1 AND  `is_deleted`=0");
				if($query->num_rows() >0){
					return TRUE;
				}
				else
				{
					$this->ci->session->sess_destroy();
					redirect();
				}
				break;	
			}	
			else
			{
				
				$query = $this->ci->db->query("SELECT * FROM `ox_users` as u  JOIN `djax_user_role_assoc` as d ON u.`user_id`=d.`user_id` WHERE u.`default_account_id`={$account_id} AND u.active = 1 and d.`user_status`=1 AND  d.`user_id`={$manager_user_id} ");
				if($query->num_rows() >0){
					return TRUE;
				}
				else
				{
					$this->ci->session->sess_destroy();
					redirect();
				}
				break;		
			}	
						
		}
	}
	
	function is_login_method($method){
		$methods_arr = array('admin','advertiser','publisher','manager');
		if(in_array(strtolower($method),$methods_arr)){
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	function get_landing_page($role){
		
		$landing_arr = array('admin'=>'admin/dashboard','advertiser'=>'advertiser/dashboard','trafficker'=>'publisher/dashboard','manager'=>'admin/dashboard');
		
		if(array_key_exists($role,$landing_arr)){
			return $landing_arr[$role];
		}
		else
		{
			return FALSE;
		}
	}

    /**
     * autoacl general check
     *
     * @return	bool
     */
    function is_allowed($current_page, $role_id, $config_page, $config_vpp_page)
    {
        log_message('debug', "autoacl -> You're trying to access this page: ".$current_page);
        log_message('debug', "autoacl -> Your role_id is: ".$role_id);
        $filter_page = trim($this->segments_filter($current_page, $config_page, $config_vpp_page));
        
        if ($filter_page)
        {
            log_message('debug', "autoacl -> FILTER PAGE return TRUE");
			
            if (isset($config_page[$filter_page]['allowed']))
            {
                log_message('debug', "autoacl -> FILTER PAGE INSIDE THE FIRST ISSET");
				
				if (in_array($role_id, $config_page[$filter_page]['allowed']))
                {
                 	log_message('debug', "autoacl -> This page is controlled. But you CAN access.");
                    
                    // CHECK MANAGER PERMISSION
                    $manager_role_id = get_session('manager_role_id');
                    if(strtoupper(get_session('account_type')) === 'MANAGER' && $manager_role_id!=''){
						 if(isset($config_page[$filter_page]['permission_value']))
						{
						 $account_id 	= get_session('account_id');
						$account_type 	= get_session('account_type');
						 
						 $manager_user_id = get_session('manager_user_id');
						 $arr_data = array('manager_user_id'=>$manager_user_id,
								 'account_id'=>$account_id,
								 'account_type'=>$account_type,
								 'manager_role_id'=>$manager_role_id 
							);
							
							
								if($this->has_manager_permissions($arr_data,$config_page,$filter_page))
								{
									return TRUE;		
								}else{
									  $config_manager_restriction=$this->ci->config->item('manager_restriction');
									 $this->ci->session->set_userdata('error_uri', $config_manager_restriction['manager_restricted_uri']);
									$this->ci->session->set_flashdata('error_msg', $this->ci->lang->line($config_manager_restriction['manager_restricted_msg']));
									return FALSE;
								}
						   }
					}
					
					return TRUE;
				}
				
                log_message('debug', "autoacl -> READY TO ENTER SECOND ISSET");
            }
            
            if (isset($config_vpp_page[$filter_page]['allowed']))
            {
                log_message('debug', "autoacl -> FILTER PAGE INSIDE THE SECOND ISSET");
                if (in_array($role_id, $config_vpp_page[$filter_page]['allowed']))
                {
                    log_message('debug', "autoacl -> This page is VPP controlled. You're ROLE IS ACCEPTED.");
                    
                    // Run function to check vpp
                    if ($this->vpp_check($config_vpp_page, $filter_page))
                    {
                        log_message('debug', "autoacl -> This page is VPP controlled. You're VPP IS ACCEPTED.");
                        return TRUE;
                    }
                    else
                    {
                        log_message('debug', "autoacl -> This page is VPP controlled. But you CAN'T access.");
                        log_message('debug', "autoacl -> ERROR_URI: ".$config_vpp_page[$filter_page]['error_uri']);
                        log_message('debug', "autoacl -> ERROR_MSG: ".$config_vpp_page[$filter_page]['error_msg']);
                        $this->ci->session->set_userdata('error_uri', $config_vpp_page[$filter_page]['error_uri']);
                        $this->ci->session->set_flashdata('error_msg', 'Session has been expired or unauthorized access to this page.');
                        return FALSE;
                    }
                }
                else
                {
                    log_message('debug', "autoacl -> This page is VPP controlled. But you CAN'T access.");
                    log_message('debug', "autoacl -> ERROR_URI: ".$config_vpp_page[$filter_page]['error_uri']);
                    log_message('debug', "autoacl -> ERROR_MSG: ".$config_vpp_page[$filter_page]['error_msg']);
                    $this->ci->session->set_userdata('error_uri', $config_vpp_page[$filter_page]['error_uri']);
                    $this->ci->session->set_flashdata('error_msg', 'Session has been expired or unauthorized access to this page.');
                    return FALSE;
                }
            }
            else
            {
                log_message('debug', "autoacl -> This page is controlled. But you CAN'T access.");
                $this->ci->session->set_userdata('error_uri', $config_page[$filter_page]['error_uri']);
                $this->ci->session->set_flashdata('error_msg', 'Session has been expired or unauthorized access to this page.');
                return FALSE;
            }
        }
        else
        {
            log_message('debug', 'autoacl -> This page is UNCONTROLLED');
            return TRUE;
        }
    }

    /**
     * Get role_id
     *
     * @return	string
     */
    function get_role_id()
    {
        log_message('debug', 'autoacl -> get_role_id INITIALIZED');
    	
        // For example
        // return 2;
		
		
		
        return get_session($this->ci->config->item('sess_role_var'));//$this->ci->session->userdata($this->ci->config->item('sess_role_var'));
    }

    /**
     * Get key id from session
     * In common, key id is user_id or username
     *
     * @return	string
     */
    function get_key_id_sess($config_vpp_page, $filter_page)
    {
        log_message('debug', 'autoacl -> get_key_id_sess INITIALIZED');
        
        // For example
        // return 15;
        return $this->ci->session->userdata($config_vpp_page[$filter_page]['vpp_sess_name']);

    }

    /**
     * Get is_admin
     *
     * @return	bool
     */
    function is_admin()
    {
        if ($this->get_role_id() == 1)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }

    /**
     * Get current_uri
     * Also remove index or index.php from uri
     *
     * @return	string
     */
    function current_uri($uri = '')
    {
        $segments = $this->ci->uri->segment_array();

        // Remove index and index.php from array
        $segments = array_diff($segments, array('index', 'index.php'));

        // Reindex array
        $segments = array_values($segments);

        foreach ($segments as $segment)
        {
            $uri .= $segment.'/';
        }
        return $uri;
    }

    /**
     * Filter current uri so that sub module or sub controller also can be controlled
     *
     * @return	string bool
     */
    function segments_filter($current_page, $config_page, $config_vpp_page)
    {
        log_message('debug', 'autoacl -> segments_filter INITIALIZED');
        if (array_key_exists($current_page, $config_page))
        {
            log_message('debug', 'autoacl -> DIRECT DETECTION');
            return $current_page;
        }
        else
        {
            $segments = explode("/", $current_page);
            $filter_check_uri = "";
            $true_val = array();
            for ($i = 1; $i <= $this->ci->config->item('segment_max'); $i++)
            {
                $segment_num = $i - 1;
                if (isset($segments[$segment_num]))
                {
                    $filter_check_uri .= $segments[$segment_num].'/';
                }
                log_message('debug', 'autoacl -> CHECKED URI: '.$filter_check_uri );
                if (array_key_exists(trim($filter_check_uri), $config_page))
                {
                    $true_val[] = $filter_check_uri;
                    log_message('debug', 'autoacl -> FOUND THE PAGE THAT SHOULD BE CONTROLLED');
                }
                if (array_key_exists(trim($filter_check_uri), $config_vpp_page))
                {
                    $true_val[] = $filter_check_uri;
                    log_message('debug', 'autoacl -> FOUND THE VPP PAGE THAT SHOULD BE CONTROLLED');
                }
            }
            if (end($true_val))
            {
                $filter_page = trim(end($true_val));
                log_message('debug', 'autoacl -> THIS URI IS NEED TO BE CONTROLLED: '.$filter_page);
                return $filter_page;
            }
        }
        return FALSE;
    }

    /**
     * vpp_check
     * Compare key id session with key id from uri
     *
     * @return	bool
     */
    function vpp_check($config_vpp_page, $filter_page)
    {
        $key_id_sess = $this->get_key_id_sess($config_vpp_page, $filter_page);
        $key_segment_num = $config_vpp_page[$filter_page]['vpp_key'];
        $key_id_page =  $this->ci->uri->segment($key_segment_num);
        if ($key_id_page == $key_id_sess)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
    
    /**
     * has_manager_permissions
     * Compare the manager user with respect to the role
     * 
     * @return  bool
     */
      function has_manager_permissions($data,$config_page,$filter_page)
      {
		  
		  $role_id = $data['manager_role_id'];
		 // $current_page = $this->current_uri(); 
		  
		  $query = $this->ci->db->query("SELECT roles.role_id,roles.role_name,GROUP_CONCAT(permission_value) as permission_value FROM `djax_roles` as roles JOIN djax_role_permission_assoc as role_per ON role_per.role_id=roles.role_id WHERE roles.role_id={$role_id} AND roles.`status`=1 GROUP BY roles.role_id");
		  
		  if($query->num_rows() >0)
		  {
			  	//$this->ci->config->set_item($current_page,'1003');
			  	
			  	$result = $query->result_array();
			  	
			   //echo $this->ci->config->item($current_page);
			   //echo $config_page[$filter_page]['permission_value'];
			   //exit;
			  	
			  	if(in_array($config_page[$filter_page]['permission_value'],explode(',',$result[0]['permission_value'])))
			  	{
					return TRUE;
				}else{
					return FALSE;
				}
			  	//exit;
			  
		  }else{
			return TRUE;	
		   }
		  	
			
		  
	  }
     
    
}

?>
