<?php
/*
| -------------------------------------------------------------------------
| Hooks Classes
| -------------------------------------------------------------------------
| This file lets you define "hooks classes - Set_adnetwork_timezone" to set the dynamic timezone according to the package
| files.  Please see the user guide for info:
|
|	http://codeigniter.com/user_guide/general/hooks.html
|
*/

class Layout
{
	public $items_array;
	
	 /**
     * Sets the Default Sidebar according to the role
     * @param string $items
     * @return set of menu items
     */
	
	function Set_default_sidebar()
	{
		$CI = &get_instance();
		$CI->load->helper('sidebar_widget');
		$CI->load->library('template');
		$CI->config->load('sidebar_settings');
		
		$module_name = $CI->router->fetch_module();		
		
		if($module_name !== "api.v_1"){	
		
				$config_datas = $CI->config->item(strtoupper($module_name));
				
			if(!empty($config_datas))
				{
				$matched =0; //Matching Flag	
				foreach($config_datas as $key=>$role_data)
				{
					if($key===$CI->router->fetch_class())
					{
						$data['sidebar_widgets'] = sidebar_widgets($config_datas[$key]);
						$matched = 1;	
					}	
				}
				
				if($matched===0)
				{
					$data['sidebar_widgets'] = sidebar_widgets($config_datas['default_sidebar']);	
				}
				
				
				
				$CI->template->build('view',$data);
			}
		}	
		
	}
	
	
	function dynamic_menu()
	{
		$CI = &get_instance();
		$CI->config->load('menu_configurations');
		$CI->load->library('template_widget');
		$CI->load->helper('utilities');	
		
		$menu = $CI->config->item('menu');
		
		$module_name = $CI->router->fetch_module();
		
		if($module_name !== "api.v_1"){	
		
			if(isset($menu[strtoupper($module_name)]))
			{
				if(strtoupper($module_name) ==='ADMIN' && get_session('account_type') =='MANAGER' )
				{
					$menu[strtoupper($module_name)] = $this->has_manager_permissions($menu[strtoupper($module_name)]);
				
					$data['menu'] = $CI->template_widget->MakeMenu($menu[strtoupper($module_name)]);
				
				}else{
					$data['menu'] = $CI->template_widget->MakeMenu($menu[strtoupper($module_name)]);
				}
				$CI->template->build('view',$data);
			}
		}
		
	}

	

	/**
     * has_manager_permissions
     * Compare the manager user with respect to the role
     * 
     * @return  bool
     */
      private function has_manager_permissions($menu,$filter_page=FALSE)
      {
		  $CI = &get_instance();
		  
		  $config_page = $CI->config->item('page_control');
		  
          		
		 $role_id = get_session('manager_role_id');
		 
		 // $current_page = $this->current_uri(); 
        if($role_id!=''){
		  $query = $CI->db->query("SELECT roles.role_id,roles.role_name,GROUP_CONCAT(permission_value) as permission_value FROM `djax_roles` as roles JOIN djax_role_permission_assoc as role_per ON role_per.role_id=roles.role_id WHERE roles.role_id={$role_id} AND roles.`status`=1 GROUP BY roles.role_id");
		  
		  if($query->num_rows() >0)
		  {
			  	//$this->ci->config->set_item($current_page,'1003');

			  	$result = $query->result_array();
			  	
			  	//$CI->config->set_item('menu_items','');
			  	
			  	//print_r($menu);
			  	
			  	//Helper Function
			  	array_walk($menu, 'walk_array');//array($this, 'walk_array'));
			  	
			  	$menu_items = $CI->config->item('menu_items');
			   
				if(!empty($menu_items))
			  	{
					$new_menu = array();
					foreach($menu_items as $key=>$value)
					{
						
						//echo $value;exit;
						//echo ' : ';
						//echo $value;echo '<br/>';
						if($value	===	'admin/managers/users/2')
						{
							
							unset($menu['Network users'][$key]);
							//unset($menu['Network users']);
							$menu['Network users']['Manager Users'] = 'admin/managers/users';
							$value = 'admin/managers/users';
							//unset($menu['Targeting']);
							//unset($menu['Approvals']['User approvals']['Advertiser']);
							//unset($menu['Approvals']['User approvals']['Publisher']);
							//$menu['Approvals']['Payments approvals']['Affiliate']  = 'admin/approvals/affiliate_payment_approvals';
							//$value = 'admin/approvals/affiliate_payment_approvals';
						}
					
						
						
						if(is_array($value))
						{
							foreach($value as $arr_value)
							{
								//ADD FWD SLASH IN MENUS
								$new_value=substr($arr_value,-1);
								if($new_value!='/')
								{
								  $new_value=$arr_value.''.'/';
								}
								else
								{
								  $new_value=$arr_value;
								}
								if(isset($config_page[$new_value]['permission_value']))
								{
									if(!in_array($config_page[$new_value]['permission_value'],explode(',',$result[0]['permission_value'])))
									{
										
										recursiveRemoval($menu,$arr_value);
									}
								}
							}
						}else{
						
							//ADD FWD SLASH IN MENUS
							$new_value=substr($value,-1);
							if($new_value!='/')
							{
							  $new_value=$value.''.'/';
							}
							else
							{
							  $new_value=$value;
							}
							if(isset($config_page[$new_value]['permission_value']))
							{
								if(!in_array($config_page[$new_value]['permission_value'],explode(',',$result[0]['permission_value'])))
								{
									
									recursiveRemoval($menu,$value);
								}
							}
						}
					}	
					 
					//exit;
				}
				
								
				//Helper to remove the empty string array key
				$menu = array_filter_recursive($menu);
				
		
				//$menu = array_diff($menu,$new_menu);
				return $menu;
				
			}
			else{
				return $menu;
			}
			 
		}	 return $menu;
	}
	
	
	/* Assigns the permissions value for the module by dynamically defining variables */
	
	function assign_permissions_value()
	{
		$CI = &get_instance();
		$CI->load->database();
		
		$query = $CI->db->query("SELECT per_var,permission_value FROM djax_manager_module_permissions WHERE status=1");
		
		if($query->num_rows() >0)
		{
			foreach($query->result_array() as $per)
			{
				define(strtoupper($per['per_var']),$per['permission_value']);	
			}
		}
			
		
	}
	
	
	/* Browsers Back Button reload the page using hooks */
	function browser_back_btn()
	{
		$CI = &get_instance();
		$CI->load->helper('utilities');
		
		if($CI->router->fetch_module() =='user_login' && $CI->router->fetch_method() !='logout')
		{
			$account_type = get_session('account_type');
		
			switch($account_type)
			{
				case 'TRAFFICKER':
					redirect('publisher/dashboard');	
					break;
				case 'ADVERTISER':
					redirect('advertiser/dashboard');	
					break;
				case 'ADMIN':
					redirect('admin/dashboard');
					break;
				case 'MANAGER':
					redirect('admin/dashboard');
					break;
			}	
			
		} 
	}
	
	
}
/* End of file hooks.classes.php */
/* Location: ./application/hooks/hooks.classes.php */
