<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| Hooks Classes
| -------------------------------------------------------------------------
| This file lets you define "hooks classes - Language" to extend CI without hacking the core
| files.  Please see the user guide for info:
|
|	http://codeigniter.com/user_guide/general/hooks.html
|
*/

class LanguageLoader
{
	private $languages;	
	
	function __construct()
	{
		global $CFG;
		$this->languages = ($CFG->config['supported_languages']) ? $CFG->config['supported_languages'] : FALSE;
	}
	
    function initialize() 
    {
		if($this->languages)
		{
			include_once(APPPATH.'helpers/MY_language_helper.php');
			//@session_start();
			$language = default_lang();
			$CI_config =& load_class('Config');
			$CI_config->set_item('language', $this->languages[$language]);
			$_SESSION['language'] = $language;
			if($language == 'ru'){
				$CI_config->set_item('notify_spend_details', 'Этот график будет обновляться каждые один час.');
			}
			else if($language == 'az'){
				$CI_config->set_item('notify_spend_details', 'Bu Grafik Her Bir Saatte Yenilenir Olacaktır.');
			}
			else{
				$CI_config->set_item('notify_spend_details', 'This Chart will be updated every one hour.');
			}
		}
    }
}
