<?php

/*

| -------------------------------------------------------------------------

| Hooks Classes

| -------------------------------------------------------------------------

| This file lets you define "hooks classes - Profiler Enabler" to extend CI without hacking the core

| files.  Please see the user guide for info:

|

|	http://codeigniter.com/user_guide/general/hooks.html

|

*/

class Generate_invoice

{

	function generate_invoice_pub()

	{

		$CI =& get_instance();

		$CI->load->library('session');

		$CI->load->library('default_configurations');

		$CI->load->model('api.v_1/Do_invoices','Do_invoices');

		

		

		$invoice_rows = $CI->Do_invoices->retreive_count_invoices();

		

		$start_date = $CI->Do_invoices->retreive_last_invoice_generation();
		

		$period_days = $CI->default_configurations->get('pub_invoice_period');
		
		$end_date = date('Y-m-d',strtotime('-1 days'));

	
		

		if($start_date == date('Y-m-d',strtotime('-'.$period_days.' days')))

		{

			$CI->Do_invoices->generate_invoices($start_date,$end_date,$period_days);

			return TRUE;	

		}else{

			return FALSE;

		} 

		

	}

	

	function generate_invoice_spl_adv()

	{

		$CI =& get_instance();

		$CI->load->library('session');

		

		//$CI->load->model('mod_invoices');

		

		$invoice_rows = $CI->mod_spl_adv_invoices->retreive_count_invoices();

		$start_date = $CI->mod_spl_adv_invoices->retreive_last_invoice_generation();

		$period_days = $CI->default_configurations->get('adexchange_invoice_period');

		$end_date = date('Y-m-d',strtotime('-1 days'));

		

		//Checks first time generation of invoices

		if($invoice_rows ==0 && $start_date == date('Y-m-d',strtotime('-'.$period_days.' days')))

		{

			$CI->mod_spl_adv_invoices->generate_invoices($start_date,$end_date,$period_days);

			return TRUE;	

		}else if($start_date == date('Y-m-d',strtotime('-'.$period_days.' days')))

		{

			$CI->mod_spl_adv_invoices->generate_invoices($start_date,$end_date,$period_days);

			return TRUE;	

		}else{

			return FALSE;

		}

	}

	  
    function generate_invoice_aff()
    {
        $CI =& get_instance();
        $CI->load->library('session');
        $CI->load->library('default_configurations');
        $CI->load->model('api.v_1/Do_invoices', 'Do_invoices');
        $invoice_rows = $CI->Do_invoices->retreive_aff_count_invoices();
        $start_date   = $CI->Do_invoices->retreive_last_aff_invoice_generation();
        $period_days  = $CI->default_configurations->get('pub_invoice_period');
        $end_date     = date('Y-m-d', strtotime('-1 days'));
        if ($start_date == date('Y-m-d', strtotime('-' . $period_days . ' days')))
        {
            $CI->Do_invoices->generate_network_invoices($start_date, $end_date, $period_days);
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }

}

/* End of file hooks.classes.php */

/* Location: ./application/hooks/hooks.classes.php */

