<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


function switch_uri($lang)
{
	$CI =& get_instance();
	$uri = $CI->uri->uri_string();
	if ((!empty($uri)) && (array_key_exists($lang, $CI->config->item('supported_languages'))))
	{
		$uri_segment = get_uri_lang($uri);
		if (is_array($uri_segment) && $uri_segment['lang'] != NULL)
		{
			$uri_segment['parts'][0] = $lang;
			$uri                     = implode('/', $uri_segment['parts']);
		}
		else
			$uri = $lang . '/' . $uri;
	}
	else
		$uri = $lang . '/' . $uri;
	return $uri;
}


// default language: Session or browser or first element of $config->supported_languages
function default_lang()
{
	global $CFG, $URI;
	$browser_lang = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? strtok(strip_tags($_SERVER['HTTP_ACCEPT_LANGUAGE']), ',') : '';
	$browser_lang = substr($browser_lang, 0, 2);
	$uri_segment  = get_uri_lang($URI->uri_string);	
	$sess_lang	  = isset($_SESSION['language']) ? $_SESSION['language'] : FALSE;
	
	if ($uri_segment['lang'])
		return $uri_segment['lang'];
	elseif (isset($sess_lang) && array_key_exists((string)$sess_lang, $CFG->config['supported_languages']))
		return $sess_lang;
	elseif (array_key_exists((string)$browser_lang, $CFG->config['supported_languages']))
		return $browser_lang;
	elseif ($config_lang = array_search($CFG->config['language'], $CFG->config['supported_languages']))
		return $config_lang;
	else
		return key($CFG->config['supported_languages']);
}


//check if the language exists
//when true returns an array with lang abbreviation + rest
function get_uri_lang($uri = '')
{
	global $CFG;
	if (!empty($uri))
	{
		$uri                  = ($uri[0] == '/') ? substr($uri, 1) : $uri;
		$uri_expl             = explode('/', $uri, 2);
		$uri_segment['lang']  = NULL;
		$uri_segment['parts'] = $uri_expl;
		if (array_key_exists($uri_expl[0], $CFG->config['supported_languages']))
		{
			$uri_segment['lang'] = $uri_expl[0];
		}
		return $uri_segment;
	}
	else
		return FALSE;
}
/* End of file MY_language_helper.php */
/* Location: ./application/helpers/MY_language_helper */
