<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code



/*
|--------------------------------------------------------------------------
| Define Constants for Managers
|--------------------------------------------------------------------------
|
*/
define('MANAGER_ROLE_FINANCE',	'FINANCE');
define('MANAGER_ROLE_OPERATION',	'OPERATION');
define('MANAGER_ROLE_ADMIN',	'ADMIN');

/*
|--------------------------------------------------------------------------
| Define Constants for PHYSICAL PATH for Image Upload
|--------------------------------------------------------------------------
|
*/

define('USER_PROFILE_IMAGE','user_profile');
define('USER_PROFILE_IMAGE_THUMB','user_profile/thumb/');


/*
|--------------------------------------------------------------------------
| Define Constants for creatives
|--------------------------------------------------------------------------
|
*/

#cross Ad Blocks/zones
define('CROSS_AD_BLOCK_BANNER',	'C_A_BAN'); //Delivery no. - 8
define('CROSS_AD_BLOCK_TEXT',	'C_A_TEXT');//Delivery no. - 9
define('CROSS_AD_BLOCK_INLINE',	'C_A_IN');//Delivery no. - 10
define('CROSS_AD_BLOCK_OVERLAY',	'C_A_OL');//Delivery no. - 11

#WEB CREATIVE
define('WEB_CREATIVE_SQL',		'W_SQL'); //Delivery no. - 0,1
define('WEB_CREATIVE_URL',		'W_URL'); //Delivery no. - 0,1
define('WEB_CREATIVE_WEB',		'W_IMG'); //Delivery no. - 0,1
define('WEB_CREATIVE_HTML',		'W_HTML'); //Delivery no. - 0,1
define('WEB_CREATIVE_SWF',		'W_SWF'); //Delivery no. - 0,1
define('WEB_CREATIVE_TEXT',		'W_TEXT'); //Delivery no. - 3

#VIDEO CREATIVE
define('VIDEO_CREATIVE_OVERLAY',	'V_OL'); //Delivery no. - 7
define('VIDEO_CREATIVE_INLINE',		'V_IN'); //Delivery no. - 6

#MOBILE CREATIVE
define('MOBILE_IMAGE_CREATIVE',		'M_IMG'); //Delivery no. - 0
define('MOBILE_TEXT_CREATIVE',		'M_TEXT'); //Delivery no. - 0
define('MOBILE_HTML_CREATIVE',		'M_HTML'); //Delivery no. - 0
define('MOBILE_NATIVE_IMAGE_CREATIVE', 'M_NAT_IMG');
define('MOBILE_HTML5_CREATIVE',		'M_HTML5'); //Delivery no. - 0

#MRAIDS
define('MOBILE_MRAID_CREATIVE_EXPAND',		'M_MR_EXP'); //Delivery no. - 0
define('MOBILE_MRAID_CREATIVE_REVEAL',		'M_MR_REV'); //Delivery no. - 0
define('MOBILE_MRAID_CREATIVE_INTERSTITAL',	'M_MR_INT'); //Delivery no. - 0

#IAB Raising stars
define('MOBILE_RS_CREATIVE_FLEX',		'M_RS_FL'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_ADHESION',	'M_RS_ADH'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_PULL',		'M_RS_PL'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_SLIDER',		'M_RS_SL'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_FILMSTRIP',	'M_RS_FS'); //Delivery no. - 0

#MOBILE VIDEO CREATIVE
define('MOBILE_COMPANION_IMAGE_CREATIVE',		'MC_IMG'); //Delivery no. - 
define('MOBILE_VIDEO_CREATIVE_OVERLAY',	'MV_OL'); //Delivery no. - 
define('MOBILE_VIDEO_CREATIVE_INLINE',		'MV_IN'); //Delivery no. - 		
//Interstital video 	
define('MOBILE_VIDEO_CREATIVE_INTERSTITAL',		'MV_IR'); //Delivery no. - 
define('MOBILE_VIDEO_CREATIVE_NATIVE',		'M_NAT_VID'); //Delivery no. - 
define('MOBILE_VIDEO_CREATIVE_REWARDED',		'MV_RW'); //Delivery no - 14
define('MOBILE_VIDEO_CREATIVE_PAUSE', 'MV_CP');
#SWF CREATIVE

define ('swf_tag_identify', 		 "FWS");
define ('swf_tag_compressed', 		 "CWS");
define ('swf_tag_geturl',   		 "\x83");
define ('swf_tag_null',     		 "\x00");
define ('swf_tag_actionpush', 		 "\x96");
define ('swf_tag_actiongetvariable', "\x1C");
define ('swf_tag_actiongeturl2', 	 "\x9A\x01");
define ('swf_tag_actiongetmember', 	 "\x4E");

/*
|--------------------------------------------------------------------------
| Define Constants for Ad Blocks /Zones
|--------------------------------------------------------------------------
|
*/

#WEB Ad Blocks/Zones
define('WEB_AD_BLOCK_BANNER',	'W_BAN'); //Delivery no. - 0
define('WEB_AD_BLOCK_DHTML',	'W_DHTML'); //Delivery no. - 1
define('WEB_AD_BLOCK_TEXT',		'W_TEXT'); //Delivery no. - 3
define('WEB_AD_BLOCK_EMAIL_NL',	'W_EMAIL'); //Delivery no. - 4

#VIDEO Ad Blocks/Zones
define('VIDEO_AD_BLOCK_OVERLAY','V_A_OL'); //Delivery no. - 7
define('VIDEO_AD_BLOCK_INLINE',	'V_A_IN'); //Delivery no. - 6

#MOBILE Ad Blocks/Zones - BASIC
define('MOBILE_AD_BLOCK_IMAGE','M_A_IM'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_TEXT','M_A_TXT'); //Delivery no. - 0

#MOBILE Ad Blocks/Zones - MRAID
define('MOBILE_AD_BLOCK_INTERSTITIAL','M_A_INT'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_EXPAND','M_A_EXD'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_REVEAL','M_A_RVL'); //Delivery no. - 0 
#Interstital video 
define('MOBILE_AD_BLOCK_INTERSTITIAL_VIDEO','M_A_IR');
#Native Video
define('MOBILE_AD_BLOCK_NATIVE_VIDEO','M_A_NATIVE');
#MOBILE Ad Blocks/Zones - RISING
define('MOBILE_AD_BLOCK_FLEX','M_A_FX'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_ADHESION','M_A_AD'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_FLIMSTRIP','M_A_FS'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_SLIDER','M_A_SLI'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_PULL','M_A_PULL'); //Delivery no. - 0

#MOBILE VIDEO Ad Blocks/Zones
define('MOBILE_AD_BLOCK_INLINE','M_A_IN'); //Delivery no. - 7
define('MOBILE_AD_BLOCK_OVERLAY','M_A_OL'); //Delivery no. - 6
define('MOBILE_AD_BLOCK_REWARDED','M_A_RW'); //Delivery no. - 14
define('MOBILE_AD_BLOCK_PAUSE','M_A_PV'); //Delivery no. - 15
define('MOBILE_AD_BLOCK_DHTML',	'M_A_DHTML'); //Delivery no. - 16
define('MOBILE_AD_BLOCK_NATIVE_IMAGE','M_A_IMG_NAT'); //Delivery no. - 17
define('MOBILE_AD_BLOCK_DHTML5',	'M_A_DHTML5'); //Delivery no. - 18
define('MOBILE_AD_BLOCK_INTERSTITIAL_SWIPE_IMAGE',	'M_A_ISI'); //Delivery no. - 19
/*
|--------------------------------------------------------------------------
| Define Constants for mobile creatives
|--------------------------------------------------------------------------
|
*/

define('MOBILE_CREATIVE_BASE',		'BASE');
define('MOBILE_CREATIVE_BACKGROUND', 'BGI');
define('MOBILE_CREATIVE_HORIZONTAL', 'HOR');
define('MOBILE_CREATIVE_VERTICAL',	'VER');
define('MOBILE_CREATIVE_NAVIGATION','NAVICO');
define('MOBILE_CREATIVE_CONTENT',	'CONT');
define('MOBILE_CREATIVE_SWIPE',	'SWIPE');
define('MOBILE_CREATIVE_LANDSCAPE',	'LAND');
define('MOBILE_CREATIVE_TABLET_LANDSCAPE', 'TAB_LAND');
define('MOBILE_CREATIVE_TABLET_PORTRAIT',	'TAB_PORT');
define('MOBILE_CREATIVE_PORTRAIT',	'PORT');
define('MOBILE_CREATIVE_FILMSTRIP',	'FILM');
define('MOBILE_CREATIVE_ADHESION',	'ADHESION');
define('MOBILE_CREATIVE_EXPAND',	'EXP');
define('MOBILE_CREATIVE_REVEAL',	'REV');
define('MOBILE_CREATIVE_NAVIGATION_VIDEO','N_VIDEO');
define('MOBILE_CREATIVE_NAVIGATION_MESSAGE','N_MSG');
define('MOBILE_CREATIVE_NAVIGATION_SOCIAL','N_SOC');
define('MOBILE_CREATIVE_NAVIGATION_ICON','N_ICON');

define('MOBILE_CREATIVE_NAVIGATION_TAB', 'TABLET');

define('MOBILE_CREATIVE',		'MOB');

define('MOBILE_SMARTPHONE_WIDE_CREATIVE',	'S_WIDE');
define('MOBILE_SMARTPHONE_STATIC_CREATIVE',	'S_STAT');
define('MOBILE_SMARTPHONE_INTERSTITIAL_CREATIVE', 'S_INT');
define('MOBILE_FEATURE_PHONE_LARGE_CREATIVE',	'F_LARGE');
define('MOBILE_FEATURE_PHONE_MEDIUM_CREATIVE',	'F_MEDIUM');
define('MOBILE_FEATURE_PHONE_SMALL_CREATIVE',	'F_SMALL');
define('MOBILE_TABLET_PHONE_LARGE_CREATIVE',	'T_LARGE');
define('MOBILE_TABLET_PHONE_MEDIUM_CREATIVE',	'T_MEDIUM');
define('MOBILE_TABLET_PHONE_SMALL_CREATIVE',	'T_SMALL');


//Display size
define('XX_LARGE', 'XXL');
define('X_LARGE',	'XL');
define('LARGE',	'L');
define('MEDIUM',	'M');
define('SMALL',	'S');

/*
|--------------------------------------------------------------------------
| Database Tables for dJAX Ad Exchange Product
|--------------------------------------------------------------------------
|
*/

define('TAB_APP_CONFIG','djax_app_configurations');
define('TAB_BAN_CAM_ASSOC','djax_banner_campaign_assoc');
define('TAB_BROWESR_STAT','djax_browsers_stats ');
define('TAB_CLIENT_STAT','djax_clients_stats ');
define('TAB_CONF_BANNER_SIZE','djax_conf_banner_sizes ');
define('TAB_CONF_CAM_STATUS','djax_conf_campaign_status');
define('TAB_CONF_REVENUE_TYPE','djax_conf_revenue_type ');
define('TAB_CONF_ZONE_TYPE','djax_conf_zone_type ');
define('TAB_CURRENCY','djax_conf_currency');
define('TAB_GEO_STATS','djax_geographical_stats ');
define('TAB_MOB_BANNERS','djax_mobile_banners ');
define('TAB_MOB_DEVICE_STAT','djax_mobile_devices_stats');
define('TAB_MOB_MANUFACT','djax_mobile_manufacturer');
define('TAB_MOB_OS','djax_mobile_os');
define('TAB_NETWORKS','djax_networks  ');
define('TAB_NWK_MANAGERS','djax_network_managers  ');
define('TAB_PUB_SITES','djax_publisher_sites  ');
define('TAB_SITES_STATS','djax_sites_stats  ');
define('TAB_SITE_CATEGORIES','djax_site_categories  ');
define('TAB_TARG_DOMAIN', 'djax_targ_domain ');

define('TAB_SITE_CAT_ASSOC','djax_site_category_assoc ');

define('TAB_SITE_BL_CAT_ASSOC', 'djax_site_blocked_category_assoc');

define('TAB_TARG_BROWSERS','djax_targ_browsers');
define('TAB_TARG_CONTINENT','djax_conf_targ_continent ');
define('TAB_TARG_COUNTRY','djax_conf_targ_country');
define('TAB_TARG_COUNTRY_REGION','djax_conf_targ_country_region');
define('TAB_TARG_MOB_CAPA','djax_targ_mobile_capability');
define('TAB_TARG_MOB_MANU','djax_targ_mobile_manufacturer');
define('TAB_TARG_MOB_OS','djax_targ_mobile_os');
define('TAB_TARG_MOB_TC','djax_targ_mobile_telecom_circle');
define('TAB_TARG_MOBILE_CARRIER','djax_targ_carrier_detail');

define('TAB_AD_FRAUD_CLK','djax_ad_fraud_click');
define('TAB_AD_ZONE_CLK','djax_ad_zone_click');
define('TAB_PENALITIES','djax_penalties');

define('TAB_TARG_OS','djax_targ_operating_system ');
define('TAB_TEMP_USER','djax_temp_user ');
define('TAB_TZ','djax_conf_timezone ');
define('TAB_TRACK_AD_REQ','djax_track_ad_requests ');
define('TAB_TRACK_AD_RES','djax_track_ad_responses ');
define('TAB_TRACK_VIEWERS','djax_track_viewers ');
define('TAB_VIEWER_STATS','djax_viewer_stats ');
define('TAB_ACCOUNTS','ox_accounts');
define('TAB_ACC_PER_ASSOC','ox_account_preference_assoc');
define('TAB_ACC_USER_ASSOC','ox_account_user_assoc');
define('TAB_ACC_USER_PER_ASSOC','ox_account_user_permission_assoc');
define('TAB_ACLS','ox_acls ');
define('TAB_ACLS_CHANNEL','ox_acls_channel');
define('TAB_AD_CAT_ASSOC','ox_ad_category_assoc');
define('TAB_AD_ZONE_ASSOC','ox_ad_zone_assoc');
define('TAB_AFFILIATE','ox_affiliates');
define('TAB_AFF_EXT','ox_affiliates_extra');
define('TAB_AGENCY','ox_agency');
define('TAB_APP_VAR','ox_application_variable');
define('TAB_AUDIT','ox_audit');
define('TAB_BANNERS','ox_banners ');
define('TAB_BAN_VAST_ELE','ox_banner_vast_element ');
define('TAB_CAMPAIGNS','ox_campaigns ');
define('TAB_CAM_TRACKERS','ox_campaigns_trackers ');
define('TAB_CATEGORY','ox_category ');
define('TAB_CHANNEL','ox_channel ');
define('TAB_CLIENTS','ox_clients ');
define('TAB_DB_ACTION','ox_database_action');
define('TAB_DATA_BKT_A','ox_data_bkt_a ');
define('TAB_DATA_BKT_A_VAR','ox_data_bkt_a_var  ');
define('TAB_DATA_BKT_C','ox_data_bkt_c ');
define('TAB_DATA_BKT_M','ox_data_bkt_m ');
define('TAB_DATA_BKT_R','ox_data_bkt_r ');
define('TAB_DATA_BKT_VAST_E','ox_data_bkt_vast_e  ');
define('TAB_DATA_IM_AD','ox_data_intermediate_ad  ');
define('TAB_DATA_IM_AD_CON','ox_data_intermediate_ad_connection ');
define('TAB_DATA_IM_AD_VAR_VALUE','ox_data_intermediate_ad_variable_value ');
define('TAB_DATA_RAW_AD_CLK','ox_data_raw_ad_click');
define('TAB_DATA_RAW_AD_IMP','ox_data_raw_ad_impression');
define('TAB_DATA_RAW_AD_REQ','ox_data_raw_ad_request');
define('TAB_DATA_RAW_TRACKER_IMP','ox_data_raw_tracker_impression ');
define('TAB_DATA_RAW_TRACKER_VAR_VALUE','ox_data_raw_tracker_variable_value ');
define('TAB_DATA_SUM_AD_HOURLY','ox_data_summary_ad_hourly');
define('TAB_DATA_SUM_AD_ZONE_ASSOC','ox_data_summary_ad_zone_assoc');
define('TAB_DATA_SUM_CHANNEL_DAILY','ox_data_summary_channel_daily');
define('TAB_DATA_SUM_ZONE_IMP_HISTORY','ox_data_summary_zone_impression_history');
define('TAB_EXT_MKT_ADV','ox_ext_market_advertiser');
define('TAB_MKT_ASSOC_DATA','ox_ext_market_assoc_data ');
define('TAB_EXT_MKT_CAM_PREF','ox_ext_market_campaign_pref ');
define('TAB_EXT_MKT_GEN_PREF','ox_ext_market_general_pref ');
define('TAB_EXT_MKT_PLUGIN_VAR','ox_ext_market_plugin_variable');
define('TAB_EXT_MKT_SETTING','ox_ext_market_setting');
define('TAB_EXT_MKT_STATS','ox_ext_market_stats');
define('TAB_EXT_MKT_WEB_PREF','ox_ext_market_website_pref');
define('TAB_EXT_MKT_WEB_STATS','ox_ext_market_web_stats');
define('TAB_IMAGES','ox_images');
define('TAB_LOG_MAT_FORECAST','ox_log_maintenance_forecasting');
define('TAB_LOG_MAT_PRIORITY','ox_log_maintenance_priority ');
define('TAB_LOG_MAT_STAT','ox_log_maintenance_statistics');
define('TAB_PWD_RECOVERY','ox_password_recovery');
define('TAB_PLACE_ZONE_ASSOC','ox_placement_zone_assoc');
define('TAB_PREFERENCES','ox_preferences');
define('TAB_SESSION','ox_session');
define('TAB_STATS_VAST','ox_stats_vast');
define('TAB_TARGET','ox_targetstats');
define('TAB_TRACKERS','ox_trackers');
define('TAB_TKR_APP','ox_tracker_append');
define('TAB_UPGRADE_ACTION','ox_upgrade_action');
define('TAB_USERLOG','ox_userlog');
define('TAB_USERS','ox_users');
define('TAB_VAR','ox_variables');
define('TAB_VAR_PUB','ox_variable_publisher');
define('TAB_ZONES','ox_zones');
define('TAB_BAN_DEPEND','djax_additional_banners');
define('TAB_SITE_ZONE_ASSOC','djax_site_zone_assoc');
define('TAB_CONF_MOBILE_SCREEN_SIZE','djax_conf_mobile_screen_sizes');
define('TAB_CAMPAIGNS_CATEGORY_ASSOC','djax_campaign_category_assoc');
define('TAB_ADMIN_PAYD','djax_admin_payment_details');
define('TAB_BILL_INFO','djax_billing_information');
define('TAB_INVOICE','djax_invoice');
define('TAB_INVOICE_ITEM','djax_invoice_item');
define('TAB_INVOICE_GEN','djax_invoice_generation');
define('TAB_INVOICE_PAY','djax_invoice_payment');
define('TAB_PAY_PERIOD','djax_payment_period');
define('TAB_PAY_RES','djax_payment_response');
define('TAB_PAY_TRANS','djax_payment_transaction');
define('TAB_PUB_PAYD','djax_publisher_payment_details');
define('TAB_MESSAGES','djax_messages');
define('TAB_ANTI_FRAUD','djax_anti_fraud_stats'); 
define('TAB_ROLES','djax_roles'); 
define('TAB_ROLE_PERMISSION_ASSOC','djax_role_permission_assoc');
define('TAB_USER_ROLE_ASSOC','djax_user_role_assoc');
define('TAB_USER_APIKEY','djax_user_apikey');
define('TAB_LOGIN_INFO','djax_login_info');
define('TAB_NET_STATS','djax_network_stats');
define('TAB_GEO_SETTING','djax_cpm_geo_settings');
define('TAB_TARG_TIME','djax_targ_time');
define('TAB_TARG_DAYS','djax_targ_days');
define('TAB_TARG_KEYWORD','djax_targ_keywords');
// DSP and SSP
//OpenRTB
define('TAB_PARTY_ADX','djax_3rd_party_ad_exchange' );
define('TAB_DSP_BID_REQ','djax_dsp_bid_request');
define('TAB_DSP_RESPONSE','djax_dsp_response');
define('TAB_DSP_WIN_NOTICE','djax_dsp_win_notice');
define('TAB_3RD_ADX',' djax_3rd_party_ad_exchange');
define('TAB_RTB_REQUEST','djax_ad_requests_rtb_buyers');
define('TAB_RTB_RESPONSE','djax_ad_response_rtb_buyers');
/* End of file constants.php */
/* Location: ./application/config/constants.php */

/*Added by Murugeswari 17-05-17*/
// VAST mediation
define('TAB_VIDEO_ADNETWORK','djax_video_adnetwork' );
define('TAB_DSP_PUB_ASSOC','djax_dsp_publisher_assoc' );
define('TAB_DSP_TAR_PUBLISHER','djax_dsp_target_publisher' );
define('TAB_DSP_TAR_COUNTRY','djax_dsp_target_country' );
define('TAB_DSP_COUNTRY_WEIGHT','djax_dsp_country_weight' );
/*Added by Murugeswari 17-05-17*/

/*dsp field - start */
define('TAB_DSP_AFF_ASSOC','dj_aff_dsp_assoc');
define('TAB_DSP_CREATIVE','ox_dsp_creatives');
/*dsp field - end */
/**************************************SSP jayashree added***************************/
define('TAB_SSP_ADMIN_CONFIG','djax_ssp_admin_configuration' );

/*dmp*/
define('TAB_TARG_SEGMENT','djax_targ_segment' );
/*dmp*/

/**** CURRENCY *****/
define('TAB_CURRENCIES','djax_currencies');
/**** CURRENCY *****/
define('TAB_TARG_SITES','djax_targ_sites');
define('TAB_TARG_SENTIMENTS','djax_targ_sentiments');
define('TAB_CUSTOM_TARGETING1','djax_targ_custom_targeting1');
define('TAB_CUSTOM_TARGETING2','djax_targ_custom_targeting2');
define('TAB_CUSTOM_TARGETING3','djax_targ_custom_targeting3');
define('TAB_CUSTOM_TARGETING4','djax_targ_custom_targeting4');
define('TAB_CUSTOM_TARGETING1_STATS','djax_customtarg1_stats');
define('TAB_CUSTOM_TARGETING2_STATS','djax_customtarg2_stats');
define('TAB_CUSTOM_TARGETING3_STATS','djax_customtarg3_stats');
define('TAB_CUSTOM_TARGETING4_STATS','djax_customtarg4_stats');

