<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/
// Require the initialisation file
require_once '../../../../init.php';
//~ ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
//~ ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
require_once MAX_PATH . '/lib/OA/Admin/TemplatePlugin.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/OX/Plugin/Component.php';
require_once MAX_PATH . '/www/admin/config.php';



if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];



// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

// Load translation class
$oTranslation = new OX_Translation();

 $query = OA_Dal_Delivery_query("select * from ".$table_prefix ."brandsafety");
   
		
$form = buildForm($query);

if ($form->validate()) {
    //process submitted values
     $query = OA_Dal_Delivery_query("select * from ".$table_prefix ."brandsafety");


    processForm($aformdata, $form,$query);
}
else { 
	
	//either validation failed or form was not submitted, display the form
    displayPage($aformdata, $form);
}



/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function buildForm($query)
{
	$aformdata = array();
		
	 while($row = OA_Dal_Delivery_fetchAssoc($query))
   {
		$name = $row['name'];
		if($row['id']==1)
		{
			$aformdata['cache']=$name/60;
		}
		else if($row['id']==2)
		{
			$aformdata['grapeapi']=$name;
		}
		else if($row['id']==3)
		{
			$aformdata['apiresponse']=$name/60;
		}
		else if($row['id']==4)
		{
			$aformdata['retryurl']=$name;
	    }
		else if($row['id']==5)
		{
			$aformdata['cookie']=$name/60;
	    }
	    
	  
   }
	
   
    $form = new OA_Admin_UI_Component_Form("forms", "POST", $_SERVER['SCRIPT_NAME']);
    $form->forceClientValidation(true);
    $form->addElement('header', 'header_basic', 'Brandsafety Management');
	$form->addElement('text', 'cache', 'Cache expiration Time (Minutes)'  , array ( 'class' => 'small' ) );
	$form->addElement('text', 'cookie', 'Cookie expiration Time (Minutes)'  , array ( 'class' => 'small' ) );
	$form->addElement('text', 'apiresponse', 'API response Time (Minutes)'  , array ( 'class' => 'small' ) );
	$form->addElement('text', 'retryurl', 'Number of retry URL'  , array ( 'class' => 'small' ) );
	$form->addElement('text', 'grapeapi', 'Grapeshot API '  );
	$form->addRule('dmp_url','Required', 'required');
    $form->addRule('dmp_api','Required', 'required');
    $form->addElement('submit', 'submit', 'Save');
	$form->setDefaults($aformdata);
    return $form;
}


/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
function processForm($aformdata, $form,$query)
{
	
	  $aFields = $form->exportValues ();
	  
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	$row = OA_Dal_Delivery_fetchAssoc($query);
	
	
	if($row)
	{
			$cache=1;
			$grapeapi=2;
			$apiresponse=3;
			$retryurl=4;
			$cookie=5;
			$cache1=$_POST['cache']*60;
			$grapeapi1=$_POST['grapeapi'];
			$apiresponse1=$_POST['apiresponse']*60;
			$retryurl1=$_POST['retryurl'];
			$cookie1=$_POST['cookie']*60;
	
			OA_Dal_Delivery_query("update ".$table_prefix ."brandsafety set name = '".$cache1."' where id =".$cache);
			OA_Dal_Delivery_query("update ".$table_prefix ."brandsafety set name = '".$grapeapi1."' where id =".$grapeapi);
			OA_Dal_Delivery_query("update ".$table_prefix ."brandsafety set name = '".$apiresponse1."' where id =".$apiresponse);
			OA_Dal_Delivery_query("update ".$table_prefix ."brandsafety set name = '".$retryurl1."' where id =".$retryurl);
			OA_Dal_Delivery_query("update ".$table_prefix ."brandsafety set name = '".$cookie1."' where id =".$cookie);
		
		
	}
	else
	{
		
		
		
			$cache1=$_POST['cache']*60;
			$grapeapi1=$_POST['grapeapi'];
			$apiresponse1=$_POST['apiresponse']*60;
			$retryurl1=$_POST['retryurl'];
			$cookie1=$_POST['cookie']*60;
	
			
			OA_Dal_Delivery_query("insert into ".$table_prefix ."brandsafety(id,name)values(1,'".$cache1."')");
			 
			OA_Dal_Delivery_query("insert into ".$table_prefix ."brandsafety(id,name)values(2,'".$grapeapi1."')");
			 
			OA_Dal_Delivery_query("insert into ".$table_prefix ."brandsafety(id,name)values(3,'".$apiresponse1."')");
			 
			OA_Dal_Delivery_query("insert into ".$table_prefix ."brandsafety(id,name)values(4,'".$retryurl1."')");
			OA_Dal_Delivery_query("insert into ".$table_prefix ."brandsafety(id,name)values(4,'".$retryurl1."')");
			OA_Dal_Delivery_query("insert into ".$table_prefix ."brandsafety(id,name)values(5,'".$cookie1."')");
			 
			
		
	}
		
		// Queue confirmation message
        $translation = new OX_Translation ();
        $translated_message = $translation->translate ('<b>Brandsafety</b> Has Been Updated');
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

        // Go to next page
        OX_Admin_Redirect::redirect("plugins/brandSafety/brandsafety.php");
		
		exit;
	
	
	      
	
}

 
/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($aformdata, $form)
{


$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel('Brandsafety Management');
$oHeaderModel->setIconClass('iconTargetingChannelsLarge');
$oHeaderModel->setpageType('list');
phpAds_PageHeader('brand-safety-index', $oHeaderModel);


     //get template and display form
    $oTpl = new OA_Plugin_Template('settings.html','brandSafety');
    
    $oTpl->assign('form', $form->serialize());
    $oTpl->display();
    
    
phpAds_PageFooter();


}
