<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitations.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's useragent.
 *
 * Valid comparison operators:
 * ==, !=, =~, !~, =x, !x
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Parameter_Brandsafety extends Plugins_DeliveryLimitations
{
	//~CUSTOM
	function init($data)
    {
		if(isset($_POST['submit']) && $_POST['submit'])
		{
			$data['data'] =$data['data']."@@".$_REQUEST['bannerid'];
		}
		else
		{
			$data['data'] = explode('@@',$data['data'])[0]; 
    	}
    	
    	parent::init($data);

        $this->nameEnglish = 'Segments';
    }

    function __construct()
    {
        parent::__construct();
        $this->columnName = '';
        $this->nameEnglish = 'Brand Safety';
    }
    
    function displayData()
    {
    	global $tabindex;
        echo "<textarea type='text'  style='min-width:60%;min-height:45px;' name='acl[{$this->executionorder}][data]' tabindex='".($tabindex++)."' >".htmlspecialchars(isset($this->data) ? $this->data : "")."</textarea>";
    }
    
      
}

?>
