<?php
// Application middleware

// e.g: $app->add(new \Slim\Csrf\Guard);
//$app = new Slim();
//$app->add(new Slim_Middleware_ContentTypes());

$app->add(new \Slim\Middleware\HttpBasicAuthentication([
    
	"secure" => false,
    "relaxed" => ["localhost","65.2.51.215","rvphp.djaxbidder.com"],
    "path" => "/token",
    "users" => [
        "root" => "root"
    ],
	"error" => function ($request, $response, $arguments) {
        $data = [];
        $data["status"] = "error";
        $data["message"] = $arguments["message"];
        return $response->write(json_encode($data, JSON_UNESCAPED_SLASHES));
	}
]));

$app->add(new \Slim\Middleware\JwtAuthentication([
      "secure" => false,
    "relaxed" => ["localhost","65.2.51.215","rvphp.djaxbidder.com"],
    "secret" => "supersecretkeyyoushouldnotcommittogithub",
    "rules" => [
        new \Slim\Middleware\JwtAuthentication\RequestPathRule([
            "path" => "/",
            "passthrough" => ["/token"]
        ])
		
    ],
	"error" => function ($request, $response, $arguments) {
        $data = [];
        $data["status"] = "error";
        $data["message"] = $arguments["message"];
        return $response->write(json_encode($data, JSON_UNESCAPED_SLASHES));
	}
])); 

use Ramsey\Uuid\Uuid;
use Firebase\JWT\JWT;
use Tuupola\Base62;

$app->post("/token", function ($request, $response, $arguments) {
    $now = new DateTime();
    $future = new DateTime("now +8760 hours");
    $server = $request->getServerParams();

    $payload = [
        "iat" => $now->getTimeStamp(),
        "exp" => $future->getTimeStamp(),
        "sub" => $server["PHP_AUTH_USER"],
    ];
    $secret = "supersecretkeyyoushouldnotcommittogithub";
    $token = JWT::encode($payload, $secret, "HS256");
    $data["status"] = "ok";
    $data["token"] = $token;

    return $response->withStatus(201)
        ->withHeader("Content-Type", "application/json")
        ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
});
