<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file

require_once '../../init.php';

// Required files
require_once MAX_PATH . '/www/admin/config.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';

require_once MAX_PATH . '/lib/OA/Dal.php';

require_once MAX_PATH . '/lib/pear/Date.php';
//DAC connect DB

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}else if($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
     require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
//DAC connect DB

// Security check

OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN,OA_ACCOUNT_TRAFFICKER,OA_ACCOUNT_ADVERTISER);


$oPluginManager = new OX_PluginManager();
$oComponentGroupManager = new OX_Plugin_ComponentGroupManager();
phpAds_PageHeader('Sitevariable', $oHeaderModel);

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];



/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

// Initialise some parameters
$pageName = basename($_SERVER['SCRIPT_NAME']);
$tabindex = 1;

	$_period = !empty($_POST['period_preset']) ? $_POST['period_preset'] : '';

if($_POST['period_preset']!='')
{

	if($_POST['period_preset']=='today')
	{
		$start=date('Y-m-d');
		$end=date('Y-m-d');
	}
	else if($_POST['period_preset']=='yesterday')
	{
		$start=date('Y-m-d', strtotime('Yesterday'));
		$end=date('Y-m-d', strtotime('Yesterday'));

	}
	else if($_POST['period_preset']=='this_week')
	{
		$start=date('Y-m-d', strtotime('this week Monday'));
		$end=date('Y-m-d');
	}
	else if($_POST['period_preset']=='last_week')
	{
		$start=date('Y-m-d', strtotime('previous Monday'));
		$end=date('Y-m-d', strtotime('previous Sunday'));
	}
	else if($_POST['period_preset']=='last_7_days')
	{
		$start=date('Y-m-d', strtotime('Today - 7 Day'));
		//~ $end=date('Y-m-d');
		$end=date('Y-m-d', strtotime('Today - 1 Day'));
	}
	else if($_POST['period_preset']=='this_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$end=date('Y-m-d');
	}
	else if($_POST['period_preset']=='last_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		$end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
	}
	else if($_POST['period_preset']=='all_stats')
	{
		$start='0000-00-00';
		$end=date('Y-m-d');$period_preset='all_stats';
	}
	else if($_POST['period_preset']=='specific')
	{
		$start=$_POST['period_start'];
		$end=$_POST['period_end'];
	}

}
else
{
	$start=date('Y-m-d');
	$end=date('Y-m-d');
}


$start_date=$start;
$end_date=$end;
/*Convert start date and end date into timezone format*/
if($period_preset=='all_stats')
{
	$start_date="0000-00-00 00:00:00";
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
}
else if($start_date=='' && $end_date=='')
{ 
	$start_day=new Date(date('Y-m-d H:i:00'));
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
}
else
{
	$end_day=new Date($end_date);
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');

	$start_day=new Date($start_date);
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
}







//~ $start = $start." 00:00:00";
//~ $end = $end." 23:59:59";


if($start == '' && $end == '')
    {
	
	 $query = OA_Dal_Delivery_query("SELECT sum(d.impressions) as imps,sum(d.clicks) as clks,d.variable as variable,d.value as value FROM {$table_prefix}zone_variable_summary as d group by variable");
	 
	  

     }
    else 
    {		
		
		$query = OA_Dal_Delivery_query("SELECT sum(d.impressions) as imps,sum(d.clicks) as clks,d.variable as variable,d.value as value FROM {$table_prefix}zone_variable_summary as d WHERE d.datetime BETWEEN '".$start_date."' and '".$end_date."' group by variable");	
		
     }

$issl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' : 'http://';
$impath = $GLOBALS['_MAX']['CONF']['webpath']['admin'];

$path='http://'.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/assets/images/excel.gif';
?>
<form method='post'>
        <select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>
            <option value='today' selected='selected'>Today</option>

            <option value='yesterday' <?php if($_period == "yesterday") : ?> selected="selected" <?php endif; ?> >Yesterday</option>
            <option value='this_week' <?php if($_period == "this_week") : ?> selected="selected" <?php endif; ?> >This week</option>
            <option value='last_week' <?php if($_period == "last_week") : ?> selected="selected" <?php endif; ?> > Last week</option>
            <option value='last_7_days' <?php if($_period == "last_7_days") : ?> selected="selected" <?php endif; ?> >Last 7 days</option>
            <option value='this_month' <?php if($_period == "this_month") : ?> selected="selected" <?php endif; ?> >This month</option>
            <option value='last_month' <?php if($_period == "last_month") : ?> selected="selected" <?php endif; ?> >Last month</option>

            <option value='all_stats' <?php if($_period == "all_stats") : ?> selected="selected" <?php endif; ?> >All statistics</option>
            <option value='specific' <?php if($_period == "specific") : ?> selected="selected" <?php endif; ?> >Specific dates</option>
        </select>

        <label for='period_start' style='margin-left: 1em'></label>
        <input class="date" name="period_start" id="period_start" type="text" value="<?php  if(!empty($start)){ echo $start;}else{ echo date('Y-m-d');}?>" tabindex="2"/>
        <input type='image' src='assets/images/icon-calendar-d.gif' id='period_start_button' align='absmiddle' border='0' tabindex='3' />
        <label for='period_end' style='margin-left: 1em'> </label>

        <input class="date" name="period_end" id="period_end" type="text" value="<?php if(!empty($end)){ echo $end;}else{ echo date('Y-m-d');} ?>" tabindex="4" /> 
<input type='image' src='assets/images/icon-calendar-d.gif' id='period_end_button' align='absmiddle' border='0' tabindex='3' />
	<a href='' onclick='return periodFormSubmit()'>
        <img src='assets/images/ltr/go_blue.gif' border='0' tabindex='6' /></a>
	


</form>

<?php

if(OA_Dal_Delivery_numRows($query)>0)
{	
	
$i=0;
while($val=OA_Dal_Delivery_fetchAssoc($query))
{ 
	$valdet[]=$val;
	if($i != 0){
       $jsonResult .=',';
       $jsonResultclk .=',';
       
   }    
   if(empty($val['variable']))
   {
	   $variable='Others';
	  }
	  else
	  {
		  $variable=$val['variable'];
	  }
   $jsonResult .=  json_encode(array('name' =>$variable,'y'=>intval($val['imps'])));
    $jsonResultclk .=  json_encode(array('name' =>$variable,'y'=>intval($val['clks'])));
 $i++;
}



?>
<table align='center'><tr>
	
<script src="assets/js/jschartmap/highcharts.js"></script>
<script src="assets/js/jschartmap/exporting.js"></script>
<script src="assets/js/jschartmap/export-data.js"></script>
<table width=100%>
	<tr>
	<td>
<div id="container" style="min-width: 310px; height: 400px; max-width: 300px; margin: 0 auto"></div>
<script>

//~ var dat1 = <?php echo  json_encode($jsonResult)?>;
//~ console.log(dat);
// Build the chart
Highcharts.chart('container', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie'
    },
    title: {
        text: 'Shares of Impressions'
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.y}</b>'
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: false
            }
        }
    },
    series: [{
        name: 'Impressions',
        colorByPoint: true,
        data: [<?php echo $jsonResult?>]
    }]
});
</script>	
</td>
<td>
<div id="container1" style="min-width: 310px; height: 400px; max-width: 300px; margin: 0 auto"></div>
<script>

// Build the chart
Highcharts.chart('container1', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie'
    },
    title: {
        text: 'Shares of Clicks'
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.y}</b>'
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: false
            }
        }
    },
    series: [{
        name: 'Clicks',
        colorByPoint: true,
        data: [<?php echo $jsonResultclk?>]
    }]
});
</script>
</td>
 
</tr>

</table>

  <table cellspacing="0" cellpadding="0" border="0" width="100%" class="table" style="border: 1px solid #80808066;">
	    <tr>
		<td colspan="4" align="center"><font size="4" color="#333399"><b> Variable Statistics</b></font></td>
		<td width="13%" align="center"><a style="text-decoration: none;" accesskey="e" href="stats-variable-export-csv.php?start_date=<?php echo $start_date;?>&end_date=<?php echo $end_date;?>"><img src="<?php echo $path; ?>">CSV</a></td>
	</tr>
	
	<tr>
		<th class="aleft" style="font-size:13px;" id="variable">Variable</th></th>
		
		<th class="aleft" style="font-size:13px;" id="variable">Value</th></th>
	 
		<th class="aleft" style="font-size:13px;" id="imp">Impression</th>
		
		<th class="aleft" style="font-size:13px;" id="clk">Clicks</th>
		
		<th class="aleft" style="font-size:13px;" id="ctr">CTR</th>               
	</tr>
            
<?php

foreach($valdet as $key=>$value)
{	
	 if(empty($value['variable']))
   {
	   $variable='Others';
	  }
	  else
	  {
		  $variable=$value['variable'];
	  }
	  
	?>
	<tr>
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $variable;?></td>
	   <td class="aleft" style="font-size:12px;" id="request"><?php echo $value['value'];?></td>
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $value['imps'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="impression"><?php echo $value['clks'];?></td>
		<?php
		if($value['imps'] !== '0')
		{
		$ctr= (($value['clks'] / $value['imps'])*100);
		}
		else
		{
			$ctr= 0;	
		}
		?>
		<td class="aleft" style="font-size:12px;" id="revenue"><?php echo number_format((float)$ctr, 2, '.', '')."%";?></td>
    </tr>
    <?php
}
}else{
	
	echo '<div style="margin-top: 2em;" class="errormessage"><img border="0" align="absmiddle" width="16" height="16" src="assets/images/info.gif" class="errormessage">There are currently no statistics available</div>';	
	
}

?>
</table>
        <script type='text/javascript'>
        <!--
        Calendar.setup({
            inputField : 'period_start',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_start_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });
        Calendar.setup({
            inputField : 'period_end',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_end_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });

       
        //-->
 function periodFormChange(bAutoSubmit)
        {
 	    var o = document.getElementById('period_preset');
            var periodSelectName = o.options[o.selectedIndex].value;
            var specific = periodSelectName == 'specific';
 	    var periodTabIndex = 2;

 document.getElementById('period_start').readOnly = !specific;
            document.getElementById('period_start_button').disabled = !specific;
            document.getElementById('period_end').readOnly = !specific;
            document.getElementById('period_end_button').disabled = !specific;

            if (!specific) {
                document.getElementById('period_start').style.backgroundColor = '#CCCCCC';
                document.getElementById('period_end').style.backgroundColor = '#CCCCCC';
                document.getElementById('period_start').tabIndex = null;
                document.getElementById('period_start_button').tabIndex = null;
                document.getElementById('period_end').tabIndex = null;
                document.getElementById('period_end_button').tabIndex = null;
		document.getElementById('period_start_button').src = 'assets/images/icon-calendar-d.gif';
           	document.getElementById('period_end_button').src = 'assets/images/icon-calendar-d.gif' ;

            } else {
                document.getElementById('period_start').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_end').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_start').tabIndex = periodTabIndex;
                document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
                document.getElementById('period_end').tabIndex = periodTabIndex + 2;
                document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
	        document.getElementById('period_start_button').src = 'assets/images/icon-calendar.gif';
           	document.getElementById('period_end_button').src = 'assets/images/icon-calendar.gif' ;
            }

            document.getElementById('period_start_button').readOnly = !specific;
            document.getElementById('period_end_button').readOnly = !specific;
          
            document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
            document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

            if (!specific && bAutoSubmit) {
                o.form.submit();
            }
}
periodFormChange(0);

    function periodFormSubmit() {
            var form = document.getElementById('period_preset').form;
            if (checkDates(form)) {
              form.submit();
            }
            return false;
        }
    function checkDates(form)
        {
          var startField = form.period_start;
          var endField = form.period_end;

          if (!startField.disabled && startField.value != '') {
            var start = Date.parseDate(startField.value, '%Y-%m-%d');
          }
          if (!startField.disabled && endField.value != '') {
            var end = Date.parseDate(endField.value, '%Y-%m-%d');
          }

          if ((start != undefined && end != undefined) && (start.getTime() > end.getTime())) {
            alert('\'From\' date must be earlier then \'To\' date');
            return false;
          }
          return true;
        }


        </script>


<style type='text/css'>

table {
    margin-top: 25px;
}


</style>


        
       <?php

$tempQuery2 = $_SESSION['query2'];


if (count($tempQuery2) > 0) {
    for ($i = 0; $i < count($tempQuery2); $i++) {
        //~ echo "<pre>";
        //~ print_r($tempQuery2);
        if ($i % 2 == 0) {
            
            $class   = "class=dark";
            $classtd = "dark";
            
            
        } else {
            
            $class   = "class=light";
            $classtd = "light";
            
        }
        
    }    
}
else {
    
?>
           
<?php
}

//_echoDeliveryCappingJs();

phpAds_PageFooter();

?>
