<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file

require_once '../../init.php';

// Required files
require_once MAX_PATH . '/www/admin/config.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';

require_once MAX_PATH . '/lib/OA/Dal.php';

require_once MAX_PATH . '/lib/pear/Date.php';
//DAC connect DB

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}else if($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
     require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
//DAC connect DB

// Security check

OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN,OA_ACCOUNT_TRAFFICKER,OA_ACCOUNT_ADVERTISER);


$oPluginManager = new OX_PluginManager();
$oComponentGroupManager = new OX_Plugin_ComponentGroupManager();
phpAds_PageHeader('Geostats', $oHeaderModel);

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];



/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

// Initialise some parameters
$pageName = basename($_SERVER['SCRIPT_NAME']);
$tabindex = 1;

	$_period = !empty($_POST['period_preset']) ? $_POST['period_preset'] : '';

if($_POST['period_preset']!='')
{

	if($_POST['period_preset']=='today')
	{
		$start=date('Y-m-d');
		$end=date('Y-m-d');
	}
	else if($_POST['period_preset']=='yesterday')
	{
		$start=date('Y-m-d', strtotime('Yesterday'));
		$end=date('Y-m-d', strtotime('Yesterday'));

	}
	else if($_POST['period_preset']=='this_week')
	{
		$start=date('Y-m-d', strtotime('this week Monday'));
		$end=date('Y-m-d');
	}
	else if($_POST['period_preset']=='last_week')
	{
		$start=date('Y-m-d', strtotime('previous Monday'));
		$end=date('Y-m-d', strtotime('previous Sunday'));
	}
	else if($_POST['period_preset']=='last_7_days')
	{
		$start=date('Y-m-d', strtotime('Today - 7 Day'));
		$end=date('Y-m-d', strtotime('Today - 1 Day'));
	}
	else if($_POST['period_preset']=='this_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$end=date('Y-m-d');
	}
	else if($_POST['period_preset']=='last_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		$end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
	}
	//~ else if($_POST['period_preset']=='all_stats')
	//~ {
		//~ $start='0000-00-00';
		//~ $end=date('Y-m-d');
	//~ }
	else if($_POST['period_preset']=='specific')
	{
		$start=$_POST['period_start'];
		$end=$_POST['period_end'];
	}

}
else
{
	$start=date('Y-m-d');
	$end=date('Y-m-d');
}


$start_date=$start;
$end_date=$end;
/*Convert start date and end date into timezone format*/
if($period_preset=='all_stats')
{
	$start_date="0000-00-00 00:00:00";
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
}
else if($start_date=='' && $end_date=='')
{ 
	$start_day=new Date(date('Y-m-d H:i:00'));
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
}
else
{
	$end_day=new Date($end_date);
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');

	$start_day=new Date($start_date);
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
}







//~ $start = $start." 00:00:00";
//~ $end = $end." 23:59:59";

$groupby = $_POST['group_by']? $_POST['group_by']:'country';	



$exdat=OA_Dal_Delivery_query("SELECT a.*, sum(a.impressions) AS impressions,sum(a.clicks) AS clicks FROM {$table_prefix}stats_country AS a where a.date_time>='$start_date' and a.date_time<='$end_date' group by a.$groupby order by a.date_time");


$issl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' : 'http://';
$impath = $GLOBALS['_MAX']['CONF']['webpath']['admin'];

$path='http://'.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/assets/images/excel.gif';

?>
<form method='post'>
        <select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>
            <option value='today' selected='selected'>Today</option>

            <option value='yesterday' <?php if($_period == "yesterday") : ?> selected="selected" <?php endif; ?> >Yesterday</option>
            <option value='this_week' <?php if($_period == "this_week") : ?> selected="selected" <?php endif; ?> >This week</option>
            <option value='last_week' <?php if($_period == "last_week") : ?> selected="selected" <?php endif; ?> > Last week</option>
            <option value='last_7_days' <?php if($_period == "last_7_days") : ?> selected="selected" <?php endif; ?> >Last 7 days</option>
            <option value='this_month' <?php if($_period == "this_month") : ?> selected="selected" <?php endif; ?> >This month</option>
            <option value='last_month' <?php if($_period == "last_month") : ?> selected="selected" <?php endif; ?> >Last month</option>

<!--
            <option value='all_stats' <?php if($_period == "all_stats") : ?> selected="selected" <?php endif; ?> >All statistics</option>
-->
            <option value='specific' <?php if($_period == "specific") : ?> selected="selected" <?php endif; ?> >Specific dates</option>
        </select>

        <label for='period_start' style='margin-left: 1em'></label>
        <input class="date" name="period_start" id="period_start" type="text" value="<?php  if(!empty($start)){ echo $start;}else{ echo date('Y-m-d');}?>" tabindex="2"/>
        <input type='image' src='assets/images/icon-calendar-d.gif' id='period_start_button' align='absmiddle' border='0' tabindex='3' />
        <label for='period_end' style='margin-left: 1em'> </label>

        <input class="date" name="period_end" id="period_end" type="text" value="<?php if(!empty($end)){ echo $end;}else{ echo date('Y-m-d');} ?>" tabindex="4" /> 
<input type='image' src='assets/images/icon-calendar-d.gif' id='period_end_button' align='absmiddle' border='0' tabindex='3' />
	<label style="padding-left: 10px;">Group By</label>
		<select name="group_by" id="group_by">
		
			<option value='country' <?php if($groupby == "country") : ?> selected="selected" <?php endif; ?> >Country</option>
						
			<option value='region' <?php if($groupby == "region") : ?> selected="selected" <?php endif; ?> >Region</option>
			
			<option value='city' <?php if($groupby == "city") : ?> selected="selected" <?php endif; ?> >City</option>
			
			<option value='latitude' <?php if($groupby == "latitude") : ?> selected="selected" <?php endif; ?> >latitude</option>
			
			<option value='longitude' <?php if($groupby == "longitude") : ?> selected="selected" <?php endif; ?> >longitude</option>
		
		
		</select>
	<a href='' onclick='return periodFormSubmit()'>
        <img src='assets/images/ltr/go_blue.gif' border='0' tabindex='6' /></a>
	


</form>
<?php
if(!empty($_GET['clientid']))
{
$clientid=$_GET['clientid'];

?>
<a accesskey="e" href="excel.php?start=<?php echo $start;?>&end=<?php echo $end;?>&clientid=<?php echo $clientid;?>">
<?php }else if(!empty($_GET['affiliateid'])){ $pubid=$_GET['affiliateid'];?>

<a accesskey="e" href="excel.php?start=<?php echo $start;?>&end=<?php echo $end;?>&affiliateid=<?php echo $pubid;?>">
<?php
}else{?>

<a accesskey="e" href="excel.php?start=<?php echo $start;?>&end=<?php echo $end;?>">

<?php }
?>

<!--
                <img border="0" alt="" src="<?php echo $issl.$impath.'/assets/images/excel.gif';?>"> <u>E</u>xport Statistics to Excel                
-->
                </a>

<!--
<div style='height:50px;'></div>
-->
<?php
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

if(OA_Dal_Delivery_numRows($exdat)>0)
{
	$geoexdat=OA_Dal_Delivery_query("SELECT sum(impressions) AS impressions,sum(clicks) AS clicks,country FROM {$table_prefix}stats_country where date_time>='$start_date' and date_time<='$end_date' group by country order by date_time");
	//~ print_r("SELECT sum(impressions) AS impressions,sum(clicks) AS clicks,country FROM {$table_prefix}stats_country where date_time>='$start' and date_time<='$end' group by country order by date_time");
	
	$i =0;	
$jsonResult ='[';
while($geovaldet=OA_Dal_Delivery_fetchAssoc($geoexdat))
{
	if($i != 0){
       $jsonResult .=',';
   }    
   $jsonResult .=  json_encode(array('Impressions' => $geovaldet['impressions'],'code'=>$geovaldet['country'],'Clicks'=>$geovaldet['clicks']));
 $i++;
}
$jsonResult .= ']';
?>
<script src="assets/js/jschartmap/highmaps.js"></script>
<script src="assets/js/jschartmap/data.js"></script>
<script src="assets/js/jschartmap/exporting.js"></script>
<script src="assets/js/jschartmap/world.js"></script>

<div id="container" style="min-width: 310px; max-width: 800px; height: 400px; margin: 0 auto;padding-top:30px;"></div>

<script>
	
	
			var dat = <?php echo  json_encode($jsonResult) ?>;
			//~ alert(dat);
			var data =  JSON.parse(dat);
//~ var data =  [ {"count":"15","code":"IN","name":"India"}];
			console.log(data);
            //~ $.getJSON('<?php echo $revivepath; ?>geo_map.php<?php echo $params; ?>', function (data) {

                // Add lower case codes to the data set for inclusion in the tooltip.pointFormat
                $.each(data, function () {
                    this.flag = this.code.replace('UK', 'GB').toLowerCase();
                });

                // Initiate the chart
                Highcharts.mapChart('container', {

                    title: {
                        text: 'Geo-statics density by country'
                    },

                    legend: {
                        title: {
                            text: 'Geo-Statics by Count',
                            style: {
                                color: (Highcharts.theme && Highcharts.theme.textColor) || 'black'
                            }
                        }
                    },

                    mapNavigation: {
                        enabled: true,
                        buttonOptions: {
                            verticalAlign: 'bottom'
                        }
                    },

                    tooltip: {
                        backgroundColor: 'none',
                        borderWidth: 0,
                        shadow: false,
                        useHTML: true,
                        padding: 0,
                        pointFormat: '<span class="f32"><span class="flag {point.flag}">' +
                        '</span></span> {point.name}<br>' +
                        '<span style="font-size:16px">{point.Impressions} Impressions</span><br>'+
                        '<span style="font-size:16px">{point.Clicks} Clicks</span>',
                        positioner: function () {
                            return {x: 0, y: 250};
                        }
                    },

                    colorAxis: {
                        min: 1,
                        max: 1000,
                        type: 'logarithmic'
                    },

                    series: [{
                        data: data,
                        mapData: Highcharts.maps['custom/world'],
                        joinBy: ['iso-a2', 'code'],
                        name: 'Geo-Statistics density',
                        states: {
                            hover: {
                                color: '#a4edba'
                            }
                        }
                    }]
                 });

            
        </script>
        

<br/>
<table>
 <tr>
		<td width="13%" align="center"><a style="text-decoration: none;" accesskey="e" href="stats-geo-export-csv.php?start_date=<?php echo $start_date;?>&end_date=<?php echo $end_date;?>&groupby=<?php echo $groupby;?>"><img src="<?php echo $path; ?>">CSV</a></td>
	</tr>
	</table>
<table cellspacing="0" cellpadding="0" border="0" width="100%" class="table" style="border: 1px solid #80808066;">
	  
	<tr>
		<th class="aleft" style="font-size:13px;" >	Country Name</th>
	 	 
		<th class="aleft" style="font-size:13px;" id="imp">Impressions</th>
		
		<th class="aleft" style="font-size:13px;" id="clk">Clicks</th>
		
		<th class="aleft" style="font-size:13px;" id="ctr">CTR</th>    
		<?php if($groupby!='country' || $groupby=='region' || $groupby=='city'){?>
		<th class="aleft" style="font-size:13px;" >	State</th>
		<?php if($groupby!='region' || $groupby=='city'){?>
		<th class="aleft" style="font-size:13px;" >	City</th>
		
		<th class="aleft" style="font-size:13px;" >	Postal code</th>
		
		<th class="aleft" style="font-size:13px;" >	latitude</th>
		
		<th class="aleft" style="font-size:13px;" >	longitude</th>     
		
		<th class="aleft" style="font-size:13px;" >	Area code</th>     
		
		<th class="aleft" style="font-size:13px;" >	ISP</th>     
		
		<th class="aleft" style="font-size:13px;" >	DMA</th>     
		<?php }} ?>      
	</tr>

<?php
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

while($valdet=OA_Dal_Delivery_fetchAssoc($exdat))
{
	$getcountry=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select name AS country from {$table_prefix}country where country_code='".$valdet['country']."'"));
	
	$getregion=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select region_name from {$table_prefix}djax_region where region_code='".$valdet['region']."' and country_code='".$valdet['country']."'"));
	
?>

<tr>
		<td class="aleft" style="font-size:12px;" id="request"><?php if($getcountry['country']!='')
		{
			echo $getcountry['country'];
		}
		else
		{
			echo 'Others';
		}
		?></td>
	 
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['impressions'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="impression"><?php echo $valdet['clicks'];?></td>
		
			<?php
		if($valdet['impressions'] !== '0')
		{
		$ctr= (($valdet['clicks'] / $valdet['impressions'])*100);
		}
		else
		{
			$ctr= 0;	
		}
		?>
		<td class="aleft" style="font-size:12px;" id="revenue"><?php echo round($ctr,2)."%";?></td>
		<?php if($groupby!='country' || $groupby=='region' || $groupby=='city'){?>

		<td class="aleft" style="font-size:12px;" id="request"><?php echo $getregion['region_name'];?></td>
		<?php if($groupby!='region' || $groupby=='city'){?>
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['city'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['postalcode'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['latitude'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['longitude'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['areacode'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['ISP'];?></td>
		
		<td class="aleft" style="font-size:12px;" id="request"><?php echo $valdet['DMA'];?></td>
		<?php }} ?>
    </tr>
    <?php



}}
else{
echo '<div style="margin-top: 2em;" class="errormessage"><img border="0" align="absmiddle" width="16" height="16" src="assets/images/info.gif" class="errormessage">There are currently no statistics available for the period '.$start.' to '.$end.'</div>';
}
?>
</table>

        <script type='text/javascript'>
        <!--
        Calendar.setup({
            inputField : 'period_start',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_start_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });
        Calendar.setup({
            inputField : 'period_end',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_end_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });

       
        //-->
 function periodFormChange(bAutoSubmit)
        {
 	    var o = document.getElementById('period_preset');
            var periodSelectName = o.options[o.selectedIndex].value;
            var specific = periodSelectName == 'specific';
 	    var periodTabIndex = 2;

 document.getElementById('period_start').readOnly = !specific;
            document.getElementById('period_start_button').disabled = !specific;
            document.getElementById('period_end').readOnly = !specific;
            document.getElementById('period_end_button').disabled = !specific;

            if (!specific) {
                document.getElementById('period_start').style.backgroundColor = '#CCCCCC';
                document.getElementById('period_end').style.backgroundColor = '#CCCCCC';
                document.getElementById('period_start').tabIndex = null;
                document.getElementById('period_start_button').tabIndex = null;
                document.getElementById('period_end').tabIndex = null;
                document.getElementById('period_end_button').tabIndex = null;
		document.getElementById('period_start_button').src = 'assets/images/icon-calendar-d.gif';
           	document.getElementById('period_end_button').src = 'assets/images/icon-calendar-d.gif' ;

            } else {
                document.getElementById('period_start').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_end').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_start').tabIndex = periodTabIndex;
                document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
                document.getElementById('period_end').tabIndex = periodTabIndex + 2;
                document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
	        document.getElementById('period_start_button').src = 'assets/images/icon-calendar.gif';
           	document.getElementById('period_end_button').src = 'assets/images/icon-calendar.gif' ;
            }

            document.getElementById('period_start_button').readOnly = !specific;
            document.getElementById('period_end_button').readOnly = !specific;
          
            document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
            document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

            if (!specific && bAutoSubmit) {
                o.form.submit();
            }
}
periodFormChange(0);

    function periodFormSubmit() {
            var form = document.getElementById('period_preset').form;
            if (checkDates(form)) {
              form.submit();
            }
            return false;
        }
    function checkDates(form)
        {
          var startField = form.period_start;
          var endField = form.period_end;

          if (!startField.disabled && startField.value != '') {
            var start = Date.parseDate(startField.value, '%Y-%m-%d');
          }
          if (!startField.disabled && endField.value != '') {
            var end = Date.parseDate(endField.value, '%Y-%m-%d');
          }

          if ((start != undefined && end != undefined) && (start.getTime() > end.getTime())) {
            alert('\'From\' date must be earlier then \'To\' date');
            return false;
          }
          return true;
        }


        </script>




<?php

//_echoDeliveryCappingJs();

phpAds_PageFooter();

?>


