<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/www/admin/lib-size.inc.php';
require_once MAX_PATH . '/lib/max/Admin_DA.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Admin/NumberFormat.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';}

// Register input variables
phpAds_registerGlobalUnslashed(
    'zonename',
    'description',
    'delivery',
    'sizetype',
    'size',
    'width',
    'height',
    'submit',
    'comments'
);

/*-------------------------------------------------------*/
/* Affiliate interface security                          */
/*-------------------------------------------------------*/

OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid);
OA_Permission::enforceAccessToObject('zones', $zoneid, true);

if (OA_Permission::isAccount(OA_ACCOUNT_TRAFFICKER)) {
    if (!empty($zoneid)) {
        OA_Permission::enforceAllowed(OA_PERM_ZONE_EDIT);
    } else {
        OA_Permission::enforceAllowed(OA_PERM_ZONE_ADD);
    }
}

/*-------------------------------------------------------*/
/* Store preferences                                     */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* Initialise data                                       */
/*-------------------------------------------------------*/
if (!empty($zoneid)) {
    $doZones = OA_Dal::factoryDO('zones');
    $doZones->zoneid = $zoneid;
    if ($doZones->find() && $doZones->fetch()) {
        $zone = $doZones->toArray();
    }

    if ($zone['width'] == -1) $zone['width'] = '*';
    if ($zone['height'] == -1) $zone['height'] = '*';
}
else {
    $doAffiliates = OA_Dal::factoryDO('affiliates');
    $doAffiliates->affiliateid = $affiliateid;

    if ($doAffiliates->find() && $doAffiliates->fetch() && $affiliate = $doAffiliates->toArray())
        $zone["zonename"] = $affiliate['name'].' - ';
    else {
        $zone["zonename"] = '';
    }

    $zone['zonename']        .= $GLOBALS['strDefault'];
    $zone['description']     = '';
    $zone['width']           = '468';
    $zone['height']          = '60';
    $zone['delivery']        = phpAds_ZoneBanner;
    $zone['comments'] = null;
}
$zone['affiliateid']     = $affiliateid;


/*-------------------------------------------------------*/
/* MAIN REQUEST PROCESSING                               */
/*-------------------------------------------------------*/
//build form
$zoneForm = buildZoneForm($zone, $oComponent);

if ($zoneForm->validate()) {
    //process submitted values
    $errors = processForm($zoneForm, $oComponent);

    if(!empty($errors)) {
    }
}
//display the page - show any validation errors that may have occurred
displayPage($zone, $zoneForm, $errors);


/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function buildZoneForm($zone, $oComponent = null)
{
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    global $conf;
    $newZone = empty($zone['zoneid']);

    $form = new OA_Admin_UI_Component_Form("zoneform", "POST", $_SERVER['SCRIPT_NAME']);
    $form->forceClientValidation(true);
    $form->addElement('hidden', 'zoneid', $zone['zoneid']);
    $form->addElement('hidden', 'delivery_type', $zone['delivery']);
    $form->addElement('hidden', 'affiliateid', $zone['affiliateid']);

    $form->addElement('header', 'zone_basic_info', $GLOBALS['strBasicInformation']);
    $form->addElement('text', 'zonename', $GLOBALS['strName']);
    $form->addElement('text', 'description', $GLOBALS['strDescription']);

    //zone type group
    $zoneTypes[] = $form->createElement('radio', 'delivery', '',
        "<img src='".OX::assetPath()."/images/icon-zone.gif' align='absmiddle'>&nbsp;".$GLOBALS['strBannerButtonRectangle'],
        phpAds_ZoneBanner, array('id' => 'delivery-b',
            'onClick' => 'phpAds_formEnableSize();',
            'onChange' => 'oa_hide("warning_change_zone_type");'));
    if ($conf['oxInvocationTags']['isAllowedAdlayer'] || $zone['delivery'] == phpAds_ZoneInterstitial) {
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-interstitial.gif' align='absmiddle'>&nbsp;".$GLOBALS['strInterstitial'],
            phpAds_ZoneInterstitial, array('id' => 'delivery-i',
                'onClick' => 'phpAds_formEnableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
    }
    if ($conf['oxInvocationTags']['isAllowedPopup'] || $zone['delivery'] == phpAds_ZonePopup) {
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-popup.gif' align='absmiddle'>&nbsp;".$GLOBALS['strPopup'],
            phpAds_ZonePopup, array('id' => 'delivery-p',
                'onClick' => 'phpAds_formEnableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
    }
    $zoneTypes[] = $form->createElement('radio', 'delivery', '',
        "<img src='".OX::assetPath()."/images/icon-textzone.gif' align='absmiddle'>&nbsp;".$GLOBALS['strTextAdZone'],
        phpAds_ZoneText, array('id' => 'delivery-t', 'onClick' => 'phpAds_formDisableSize();',
            'onChange' => 'oa_hide("warning_change_zone_type");'));
    $zoneTypes[] = $form->createElement('radio', 'delivery', '',
        "<img src='".OX::assetPath()."/images/icon-zone-email.gif' align='absmiddle'>&nbsp;".$GLOBALS['strEmailAdZone'],
        MAX_ZoneEmail, array('id' => 'delivery-e', 'onClick' => 'phpAds_formEnableSize();',
            'onChange' => 'oa_hide("warning_change_zone_type");'));
    if (!empty($conf['allowedBanners']['video'])) {
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-zone-video-instream.png' align='absmiddle'>&nbsp;".$GLOBALS['strZoneVideoInstream'],
            OX_ZoneVideoInstream, array('id' => 'delivery-vi', 'onClick' => 'phpAds_formDisableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-zone-video-overlay.png' align='absmiddle'>&nbsp;".$GLOBALS['strZoneVideoOverlay'],
            OX_ZoneVideoOverlay, array('id' => 'delivery-vo', 'onClick' => 'phpAds_formDisableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));

        //~CUSTOM ZONE TYPE-outsream        
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-zone-video-instream.png' align='absmiddle'>&nbsp;Outsream Video Ad",
            OX_ZoneVideoOutstream, array('id' => 'delivery-tb', 'onClick' => 'phpAds_formDisableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
    }

    $form->addGroup($zoneTypes, 'zone_types', $GLOBALS['strZoneType'], "<br/>");


    //~CUSTOM FIELDS START

    $vidtype=array('0'=>'Select Video Type','12'=>'InArticle','9'=>'Native','10'=>'Interstitial','13'=>'InFeed','14'=>'InBanner','8'=>'Rewarded');
      
    $videlement = $form->createElement('select', 'vidtype', 'Select Video Type',$vidtype);
    $videlement->setAttribute('id', 'vidtype');
    $form->addElement($videlement);

    //~CUSTOM REWARDED FIELDS
    $layoutsize=array('landscape'=>'landscape','portrait'=>'portrait');
    
    foreach($layoutsize as $id=>$value)
    {
        $arraylayoutsize[$id]=$value;
    }

    $aDefaultSizes['text1']=$form->createElement('text', 'reward[0]', null,
    array('id' => 'rvpoint_0', 'placeholder' => 'Reward'));    
    $aDefaultSizes['text']=$form->createElement('text', 'amount[0]', null,array('id' => 'rvamount_0', 'placeholder' => 'Amount'));
    
    $form->addGroup($aDefaultSizes, '{$table_prefix}video', 'Rewards', array('id' => 'rvgroup', 'class' => 'medium'));
    $rewardadd['addreward']=$form->addElement('button', 'add_reward', 'Add Reward',array('id' => 'rvaddrw'));   
    $rewardadd['delreward']=$form->addElement('button', 'del_reward', 'Delete Reward',array('id' => 'rvdelrw'));
    $form->addGroup($rewardadd, 'ad_rewardss', 'Additional Rewards', array('id' => 'rvaddgroup'),"<br/>");
    $pos_element= $form->createElement('select', 'position', 'Select Video Orientation / Layout',$layoutsize);
    $pos_element->setAttribute('id', 'position');
    $form->addElement($pos_element);

    //~CUSTOM NATIVE FIELDS    
    $aDefaultSizesnative['textpos']=$form->createElement('text', 'adposition', null,
    array('id' => 'nativepos', 'placeholder' => '1,2,3','class' => 'medium'),"<br/>");
    
    $aDefaultSizesnativeads['textads']=$form->createElement('text', 'adinterval', null,
    array('id' => 'nativeads', 'placeholder' => 'Enter Ads Interval','class' => 'medium'),"<br/>");

    $aDefaultNatImg['textpos']=$form->createElement('text', 'natimg_position', null,
    array('id' => 'natimg_position', 'placeholder' => '1,2,3','class' => 'medium'),"<br/>");
    
    $aDefaultNatInterval['textads']=$form->createElement('text', 'natimg_interval', null,
    array('id' => 'natimg_interval', 'placeholder' => 'Enter Ads Interval','class' => 'medium'),"<br/>");

    $form->addGroup($aDefaultSizesnative, '','Ad Positions', array('id' => 'adpositions'),"<br/>");
    $form->addGroup($aDefaultSizesnativeads, '', ' ', array('id' => 'adpositionsnative'),"<br/>");


    //~CUSTOM INTERSTITIAL FIELDS       
    $form->addElement('select', 'layout', 'Select Video Orientation / Layout',$arraylayoutsize);

    //~CUSTOM INFEED FIELDS    
    $aDefaultSizeInfeed['textpos']=$form->createElement('text', 'infeedpos', null,
    array('id' => 'infeedpos', 'placeholder' => '1,2,3','class' => 'medium'),"<br/>");
    
    $aDefaultSizesInfeed['textads']=$form->createElement('text', 'infeedads', null,
    array('id' => 'infeedads', 'placeholder' => 'Enter Ads Interval','class' => 'medium'),"<br/>");

    $form->addGroup($aDefaultSizeInfeed, '','Ad Positions', array('id' => 'adpositions'),"<br/>");
    $form->addGroup($aDefaultSizesInfeed, '', ' ', array('id' => 'adpositionsnative'),"<br/>");

    //~CUSTOM FIELDS END

    //size
    global $phpAds_IAB;
    switch ($zone['delivery']) {
        case phpAds_ZoneText:
        case OX_ZoneVideoInstream:
        case OX_ZoneVideoOutstream:
        case OX_ZoneVideoOverlay:
            $sizeDisabled = true;
            $zone['width'] = '*';
            $zone['height'] = '*';
        break;
        default:
            $sizeDisabled = false;
        break;

    }

    $aDefaultSize['radio'] = $form->createElement('radio', 'sizetype', '', '',
        'default', array('id' => 'size-d'));
    foreach (array_keys($phpAds_IAB) as $key)
    {
        $iabSizes[$phpAds_IAB[$key]['width']."x".$phpAds_IAB[$key]['height']] =
            $GLOBALS['strIab'][$key];
    }
    $iabSizes['-'] = $GLOBALS['strCustom'];
    $aDefaultSize['select'] = $form->createElement('select', 'size', null, $iabSizes,
        array('onchange' => 'phpAds_formSelectSize(this); oa_sizeChangeUpdateMessage("warning_change_zone_size");', 'class' => 'medium'));


    $aCustomSize['radio'] = $form->createElement('radio', 'sizetype', '', '', 'custom',
        array('id' => 'size-c'));

    $aCustomSize['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].':',
        array('onkeydown' => 'phpAds_formEditSize();',
            'onChange' => 'oa_sizeChangeUpdateMessage("warning_change_zone_size");'));
    $aCustomSize['width']->setSize(5);
    $aCustomSize['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].':',
        array('onkeydown' => 'phpAds_formEditSize();',
            'onChange' => 'oa_sizeChangeUpdateMessage("warning_change_zone_size");'));
    $aCustomSize['height']->setSize(5);

    $sizeTypes['default'] = $form->createElement('group', 'defaultSizeG', null, $aDefaultSize, null, false);
    $sizeTypes['custom'] = $form->createElement('group', 'customSizeG', null, $aCustomSize, null, false);

    //disable fields if necessary
    if ($sizeDisabled) {
        $aDefaultSize['radio']->setAttribute('disabled', $sizeDisabled);
        $aDefaultSize['select']->setAttribute('disabled', $sizeDisabled);
        $aCustomSize['radio']->setAttribute('disabled', $sizeDisabled);
        $aCustomSize['width']->setAttribute('disabled', $sizeDisabled);
        $aCustomSize['height']->setAttribute('disabled', $sizeDisabled);
    }

    $form->addGroup($sizeTypes, 'size_types', $GLOBALS['strSize'], "<br/>");

    $form->addElement('textarea', 'comments', $GLOBALS['strComments']);

    if ($oComponent && method_exists($oComponent, 'extendZoneForm')) {
        $oComponent->extendZoneForm($form, $zone, $newZone);
    }

    $form->addElement('controls', 'form-controls');
    $form->addElement('submit', 'submit', $GLOBALS['strSaveChanges']);


    //validation rules
    $translation = new OX_Translation();
    $urlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strName']));
    $form->addRule('zonename', $urlRequiredMsg, 'required');


    /*
    TODO
    max_formSetRequirements('width', '<?php echo addslashes($strWidth); ?>', true, 'number*');
    max_formSetRequirements('height', '<?php echo addslashes($strHeight); ?>', true, 'number*');
    */

    //set form values
    $form->setDefaults($zone);

        //sizes radio
    if (phpAds_sizeExists ($zone['width'], $zone['height'])) {
        $size = $zone['width']."x".$zone['height'];
        $sizeType = 'default';
    }
    else {
        $size = "-";
        $sizeType = 'custom';
    }
    $form->setDefaults(array('size' => $size, 'sizetype' => $sizeType));


    return $form;
}


/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
/**
 * Processes submit values of zone form
 *
 * @param OA_Admin_UI_Component_Form $form form to process
 * @return An array of Pear::Error objects if any
 */
function processForm($form, $oComponent = null)
{
    $aFields = $form->exportValues();


    switch ($aFields['delivery']) {
        case phpAds_ZoneText:
            $aFields['width'] = $aFields['height'] = 0;
            break;
        case OX_ZoneVideoOverlay:
            $aFields['width'] = $aFields['height'] = -2;
            break;
        case OX_ZoneVideoInstream:
            $aFields['width'] = $aFields['height'] = -3;
            break;
        case OX_ZoneVideoOutstream:
            $aFields['width'] = $aFields['height'] = -10;
            break;
        default:
            if ($aFields['sizetype'] == 'custom') {
                if (isset($aFields['width']) && $aFields['width'] == '*') {
                    $aFields['width'] = -1;
                }
                if (isset($aFields['height']) && $aFields['height'] == '*') {
                    $aFields['height'] = -1;
                }
            } else {
                list($aFields['width'], $aFields['height']) = explode ('x', $aFields['size']);
            }
        break;
    }

    if (!(is_numeric($aFields['oac_category_id'])) || ($aFields['oac_category_id'] <= 0)) {
            $aFields['oac_category_id'] = 'NULL';
    }
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

    if (empty($errors)) {

        // Edit
        if (!empty($aFields['zoneid']))
        {
            // before we commit any changes to db, store whether the size has changed
            $aZone = Admin_DA::getZone($aFields['zoneid']);
            $size_changed = ($aFields['width'] != $aZone['width'] || $aFields['height'] != $aZone['height']) ? true : false;
            $type_changed = ($aFields['delivery'] != $aZone['type']) ? true : false;

            $doZones = OA_Dal::factoryDO('zones');
            $doZones->zonename = $aFields['zonename'];
            $doZones->description = $aFields['description'];
            $doZones->width = $aFields['width'];
            $doZones->height = $aFields['height'];
            $doZones->comments = $aFields['comments'];
            $doZones->delivery = $aFields['delivery'];
            if ($aFields['delivery'] != phpAds_ZoneText && $aFields['delivery'] != phpAds_ZoneBanner) {
                $doZones->prepend = '';
                $doZones->append = '';
            }

            $doZones->oac_category_id  = $aFields['oac_category_id'];
            $doZones->zoneid = $aFields['zoneid'];
            $doZones->update();


            //// ***************************** CUSTOM WORK START ********************************** ///
            
            if($_POST['vidtype'] == 8)
            {
                if(isset($aFields['reward']) && isset($aFields['amount']))
                {
                    $reward = implode("|",$_POST['reward']);
                    $amt = implode("|",$_POST['amount']);
                    OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=8, width='-10', height='-10', reward='".$reward."', amount='".$amt."', position='".$aFields['position']."', layout='', adinterval='', adposition='', natimg_position='', infeedads='', infeedpos='', natimg_interval='' WHERE zoneid =".$aFields['zoneid']);
                }       
            }
            
            if($_POST['vidtype'] == 9)
            {       
                $nativepos = $_POST['adposition'];
                $nativeads = $_POST['adinterval'];

                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=9, width='-10', height='-10', adposition='".$nativepos."',adinterval='".$nativeads."', layout='', position='', amount='', reward='', natimg_position='', infeedads='', infeedpos='', natimg_interval='' WHERE zoneid =".$aFields['zoneid']);
            }

            if($_POST['vidtype'] == 10)
            {
                $layoutposition=$_POST['layout'];
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=10, width='-10', height='-10', layout='".$layoutposition."', position='', amount='', reward='', natimg_position='', natimg_interval='', adposition='', infeedads='', infeedpos='', adinterval='' WHERE zoneid=".$aFields['zoneid']);
            }

            if ($oComponent && method_exists($oComponent, 'processZoneForm')) {
                $oComponent->processZoneForm($aFields);
            }

            if($_POST['vidtype'] == 11)
            {
                $natimg_position = $_POST['natimg_position'];
                $natimg_interval = $_POST['natimg_interval'];

                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=11, natimg_position = '".$natimg_position."',natimg_interval = '".$natimg_interval."', layout='', position='', amount='', reward='', adposition='', infeedads='', infeedpos='', adinterval='' WHERE zoneid =".$aFields['zoneid']);
                
            }

            if($_POST['vidtype'] == 13)
            {
                $infeedads = $_POST['infeedads'];
                $infeedpos = $_POST['infeedpos'];

                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=13, infeedads = '".$infeedads."', infeedpos= '".$infeedpos."', natimg_position = '',natimg_interval = '', layout='', position='', amount='', reward='', adposition='', adinterval='' WHERE zoneid =".$aFields['zoneid']);
                
            }

            if($_POST['vidtype'] != 8 && $_POST['vidtype'] != 9 && $_POST['vidtype'] != 10 && $_POST['vidtype'] != 11 && $_POST['vidtype'] != 13)
            {
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set layout='', infeedads='', infeedpos='', position='', amount='', reward='', natimg_position='', natimg_interval='', adposition='', adinterval='' WHERE zoneid=".$aFields['zoneid']);
            }

            //// ***************************** CUSTOM WORK END ********************************** ///


            // Reset append codes which called this zone
            $doZones = OA_Dal::factoryDO('zones');
            $doZones->appendtype = phpAds_ZoneAppendZone;

            if (OA_Permission::isAccount(OA_ACCOUNT_MANAGER))
            {
                $doZones->addReferenceFilter('agency', OA_Permission::getEntityId());
            }
            elseif (OA_Permission::isAccount(OA_ACCOUNT_TRAFFICKER))
            {
                  $doZones->addReferenceFilter('affiliates', OA_Permission::getEntityId());
            }
            $doZones->find();

            while ($doZones->fetch() && $row = $doZones->toArray())
            {
                $append = phpAds_ZoneParseAppendCode($row['append']);

                if ($append[0]['zoneid'] == $aFields['zoneid'])
                {
                    $doZonesClone = clone($doZones);
                    $doZonesClone->appendtype = phpAds_ZoneAppendRaw;
                    $doZonesClone->append = '';
                    $doZonesClone->update();
                }
            }

            if ($type_changed && $aFields['delivery'] == MAX_ZoneEmail) {
                // Unlink all campaigns/banners linked to this zone
                $aPlacementZones = Admin_DA::getPlacementZones(array('zone_id' => $aFields['zoneid']), true, 'placement_id');
                if (!empty($aPlacementZones)) {
                    foreach ($aPlacementZones as $placementId => $aPlacementZone) {
                        Admin_DA::deletePlacementZones(array('zone_id' => $aFields['zoneid'], 'placement_id' => $placementId));
                    }
                }
                $aAdZones = Admin_DA::getAdZones(array('zone_id' => $aFields['zoneid']), false, 'ad_id');
                if (!empty($aAdZones)) {
                    foreach ($aAdZones as $adId => $aAdZone) {
                        Admin_DA::deleteAdZones(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                    }
                }
            }
            else if ($size_changed) {
                $aZone = Admin_DA::getZone($aFields['zoneid']);

                // Loop through all appended banners and make sure that they still fit...
                $aAds = Admin_DA::getAdZones(array('zone_id' => $aFields['zoneid']), false, 'ad_id');
                if (!empty($aAds)) {
                 foreach ($aAds as $adId => $aAd) {
                    $aAd = Admin_DA::getAd($adId);
                        if ( (($aZone['type'] == phpAds_ZoneText) && ($aAd['type'] != 'txt'))
                        || (($aAd['width'] != $aZone['width']) && ($aZone['width'] != -1))
                        || (($aAd['height'] != $aZone['height']) && ($aZone['height'] != -1)) ) {
                            Admin_DA::deleteAdZones(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                        }
                    }
                }

                // Check if any campaigns linked to this zone have ads that now fit.
                // If so, link them to the zone.
                $aPlacementZones = Admin_DA::getPlacementZones(array('zone_id' => $aFields['zoneid']), true);
                if (!empty($aPlacementZones)) {
                    foreach($aPlacementZones as $aPlacementZone) {
                    // get ads in this campaign
                    $aAds = Admin_DA::getAds(array('placement_id' => $aPlacementZone['placement_id']), true);
                        foreach ($aAds as $adId => $aAd) {
                            Admin_DA::addAdZone(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                        }
                    }
                }
            }
            if ($oComponent && method_exists($oComponent, 'processZoneForm')) {
                $oComponent->processZoneForm($aFields);
            }


            //~CUSTOM UPDATE WORK START 
            $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];            
            $vidtype = $_POST['vidtype'];
            
            //~MOBILE ZONE OR WRB ZONE
            if($_POST['delivery'] == 8)
            {
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones SET vidtype = '".$_POST['vidtype']."' WHERE zoneid =".$aFields['zoneid']);
            }
            else
            {
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones SET vidtype = '' WHERE zoneid =".$aFields['zoneid']);
            }

            // Queue confirmation message
            $translation = new OX_Translation();
            $translated_message = $translation->translate ( $GLOBALS['strZoneHasBeenUpdated'],
                array(
                MAX::constructURL(MAX_URL_ADMIN, "zone-edit.php?affiliateid=".$aFields['affiliateid']."&zoneid=".$aFields['zoneid']),
                htmlspecialchars($aFields['zonename'])
                ));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

            OX_Admin_Redirect::redirect("zone-edit.php?affiliateid=".$aFields['affiliateid']."&zoneid=".$aFields['zoneid']);
        }
        // Add
        else
        {
            $doZones = OA_Dal::factoryDO('zones');
            $doZones->affiliateid = $aFields['affiliateid'];
            $doZones->zonename = $aFields['zonename'];
            $doZones->zonetype = phpAds_ZoneCampaign;
            $doZones->description = $aFields['description'];
            $doZones->comments = $aFields['comments'];
            $doZones->width = $aFields['width'];
            $doZones->height = $aFields['height'];
            $doZones->delivery = $aFields['delivery'];
            $doZones->oac_category_id  = $aFields['oac_category_id'];

            // The following fields are NOT NULL but do not get values set in the form.
            // Should these fields be changed to NULL in the schema or should they have a default value?
            $doZones->category = '';
            $doZones->ad_selection = '';
            $doZones->chain = '';
            $doZones->prepend = '';
            $doZones->append = '';

            $doZones->show_capped_no_cookie = 0;

            $aFields['zoneid'] = $doZones->insert();

            //// ***************************** CUSTOM WORK START ********************************** ///
            
            if($_POST['vidtype'] == 8)
            {
                if(isset($aFields['reward']) && isset($aFields['amount']))
                {
                    $reward = implode("|",$_POST['reward']);
                    $amt = implode("|",$_POST['amount']);
                    OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=8, width='-10', height='-10', reward='".$reward."', amount='".$amt."', position='".$aFields['position']."', layout='', adinterval='', adposition='', natimg_position='', infeedads='', infeedpos='', natimg_interval='' WHERE zoneid =".$aFields['zoneid']);
                }       
            }
            
            if($_POST['vidtype'] == 9)
            {       
                $nativepos = $_POST['adposition'];
                $nativeads = $_POST['adinterval'];

                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=9, width='-10', height='-10', adposition='".$nativepos."',adinterval='".$nativeads."', layout='', position='', amount='', reward='', natimg_position='', infeedads='', infeedpos='', natimg_interval='' WHERE zoneid =".$aFields['zoneid']);
            }

            if($_POST['vidtype'] == 10)
            {
                $layoutposition=$_POST['layout'];
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=10, width='-10', height='-10', layout='".$layoutposition."', position='', amount='', reward='', natimg_position='', natimg_interval='', adposition='', infeedads='', infeedpos='', adinterval='' WHERE zoneid=".$aFields['zoneid']);
            }

            if ($oComponent && method_exists($oComponent, 'processZoneForm')) {
                $oComponent->processZoneForm($aFields);
            }

            if($_POST['vidtype'] == 11)
            {
                $natimg_position = $_POST['natimg_position'];
                $natimg_interval = $_POST['natimg_interval'];

                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=11, natimg_position = '".$natimg_position."',natimg_interval = '".$natimg_interval."', layout='', position='', amount='', reward='', adposition='', infeedads='', infeedpos='', adinterval='' WHERE zoneid =".$aFields['zoneid']);
                
            }

            if($_POST['vidtype'] == 13)
            {
                $infeedads = $_POST['infeedads'];
                $infeedpos = $_POST['infeedpos'];

                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set vidtype=13, infeedads = '".$infeedads."', infeedpos= '".$infeedpos."', natimg_position = '',natimg_interval = '', layout='', position='', amount='', reward='', adposition='', adinterval='' WHERE zoneid =".$aFields['zoneid']);
                
            }

            if($_POST['vidtype'] != 8 && $_POST['vidtype'] != 9 && $_POST['vidtype'] != 10 && $_POST['vidtype'] != 11 && $_POST['vidtype'] != 13)
            {
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones set layout='', infeedads='', infeedpos='', position='', amount='', reward='', natimg_position='', natimg_interval='', adposition='', adinterval='' WHERE zoneid=".$aFields['zoneid']);
            }

            //// ***************************** CUSTOM WORK END ********************************** ///


            if ($oComponent && method_exists($oComponent, 'processZoneForm')) {
                $oComponent->processZoneForm($aFields);
            }

            //~CUSTOM UPDATE WORK START 
            $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];            
            $vidtype = $_POST['vidtype'];
            
            //~MOBILE ZONE OR WRB ZONE
            if($_POST['delivery'] == 8)
            {
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones SET vidtype = '".$_POST['vidtype']."' WHERE zoneid =".$aFields['zoneid']);
            }
            else
            {
                OA_Dal_Delivery_query("UPDATE {$table_prefix}zones SET vidtype = '' WHERE zoneid =".$aFields['zoneid']);
            }

            // Queue confirmation message
            $translation = new OX_Translation ();
            $translated_message = $translation->translate ( $GLOBALS['strZoneHasBeenAdded'], array(
                MAX::constructURL(MAX_URL_ADMIN, 'zone-edit.php?affiliateid=' .  $aFields['affiliateid'] . '&zoneid=' . $aFields['zoneid']),
                htmlspecialchars($aFields['zonename'])
            ));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

            OX_Admin_Redirect::redirect("affiliate-zones.php?affiliateid=".$aFields['affiliateid']);
        }
    }

    return $errors;
}


/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($zone, $form, $zoneErrors = null)
{
    //header and breadcrumbs
    $pageName = basename($_SERVER['SCRIPT_NAME']);
    $agencyId = OA_Permission::getAgencyId();
    $aEntities = array('affiliateid' => $zone['affiliateid'], 'zoneid' => $zone['zoneid']);

    $aOtherPublishers = Admin_DA::getPublishers(array('agency_id' => $agencyId));
    $aOtherZones = Admin_DA::getZones(array('publisher_id' => $zone['affiliateid']));
    MAX_displayNavigationZone($pageName, $aOtherPublishers, $aOtherZones, $aEntities);

    //get template and display form
    $oTpl = new OA_Admin_Template('zone-edit.html');
    $oTpl->assign('zoneid', $zone['zoneid']);
    $oTpl->assign('zoneHeight', $zone["height"]);
    $oTpl->assign('zoneWidth', $zone["width"]);

    $oTpl->assign('zoneErrors', $zoneErrors);
    $oTpl->assign('form', $form->serialize());

    $oTpl->display();

    //footer
    phpAds_PageFooter();
}

//~CUSTOM REWARDED FIELDS

$reward =explode("|",$zone['reward']);
$amount =explode("|",$zone['amount']);
$count_reward = (empty($zone['reward']) ? '0' :count($reward));
$app_select = (empty($zone['app_select']) ? '0' :1);
$vid_type = (empty($zone['vidtype']) ? '0' :$zone['vidtype']);

$php_array = $reward;
$reward_array = json_encode($php_array);

$php_array1 = $amount;
$amount_array = json_encode($php_array1);

?>

<script type="text/javascript">

    var delivery_type = $("input[name=delivery_type]").val();
    show_vidtype(delivery_type);

    function show_vidtype(delivery_type)
    {
        if(delivery_type == 8)
        {
            $("#vidtype").parent().parent().show();
            var video_type = $("#vidtype").val();
            vidtype_select(video_type);
        }
        else
        {
            $("#vidtype").parent().parent().hide();
            vidtype_select(0);
        }
    }

    $("input[name= delivery]").click(function()
    {
        show_vidtype($(this).val());
    });

    //~ONSELECT VIDEO TYPE START

    $("#vidtype").change(function()
    {
        vidtype_select($(this).val());
    });


    function vidtype_select(val)
    {

        if(val != 0)
        {
            if(val == '8')
            {
                reward(1);
                native(0);
                inter (0);
                infeed(0);
            }
            else if(val == '10')
            {
                reward(0);
                native(0);
                inter (1);
                infeed(0);
            }
            else if(val == '9')
            {
                reward(0);
                native(1);
                inter (0);
                infeed(0);
            }
            else if(val == '13')
            {
                reward(0);
                native(0);
                inter (0);
                infeed(1);
            }
            else if(val == '12' || val == '14')
            {
                reward(0);
                native(0);
                inter (0);
                infeed(0);
            }
        }
        else
        {
            reward(0);
            native(0);
            inter (0);
            infeed(0);
        }
    }


    function reward(val)
    {
        if(val == 1)
        {
            $("#rvpoint_0").parent().parent().show();
            $("#rvaddrw").parent().parent().show();
            $("#position").parent().parent().show();
        }
        else
        {
            $("#rvpoint_0").parent().parent().hide();
            $("#rvaddrw").parent().parent().hide();
            $("#position").parent().parent().hide();
        }
    }   

    function native(val)
    {
        if(val == 1)
        {
            $("#nativepos").parent().parent().show();
            $("#nativeads").parent().parent().show();
        }
        else
        {
            $("#nativepos").parent().parent().hide();
            $("#nativeads").parent().parent().hide();
        }
    }

    function inter(val)
    {
        if(val == 1)
        {
            $("#layout").parent().parent().show(); 
        }
        else
        {
            $("#layout").parent().parent().hide(); 
        }

    }

    function infeed(val)
    {

        if(val == 1)
        {
            $("#infeedpos").parent().parent().show();
            $("#infeedads").parent().parent().show();
        }
        else
        {
            $("#infeedpos").parent().parent().hide();
            $("#infeedads").parent().parent().hide();
        }
    }


        //~CUSTOM NATIIVE COMMANDS START
    
        $("#nativepos").before('<td>To place position controls, you must use the ad pacer code when integrating  SDK.<br>Note : the position in your current streaming is zero(0).<br><br>place ads in these positions<br></td>');
        $("#nativeads").before('<td>After placed  ads show ads every </td>');
        
        $("#infeedpos").before('<td>To place position controls, you must use the ad pacer code when integrating  SDK.<br>Note : the position in your current streaming is zero(0).<br><br>place ads in these positions<br></td>');
        $("#infeedads").before('<td>After placed  ads show ads every </td>');
       
 
        //~CUSTOM REWARDED ADD REWARD ACTION 

        var db_value = <?php echo $count_reward ?>-1;
        var db_value_count = <?php echo $count_reward ?>;
        var count =1;
        var i =0;
            
        if(db_value_count !='')
        {
            for(var j=0;j<db_value;j++)
            {
                var a = '<tr id="added_'+count+'"><td width="30"></td><td width="170" valign="top" style="padding-top: 5px"></td>&nbsp;<td width="100%"><input name="reward['+count+']" type="text" id="rvpoint_'+count+'" placeholder="Reward" class="x-small">&nbsp;<input name="amount['+count+']" type="text" id="rvamount_'+count+'" placeholder="Amount" class="x-small">&nbsp;</td></tr>';
            
                $("#rvamount_"+j).after(a);
                count++;
            }
            count =db_value_count;
            i=db_value;
        }   

        var reward_array =<?php echo $reward_array ?>;
        var amount_array =<?php echo $amount_array ?>;

        $.each(reward_array, function( index, value ) {

            $('#rvpoint_'+index).val(value);
          
        });
        $.each(amount_array, function( index, value ) {
            
            $('#rvamount_'+index).val(value);
          
        });


        $("#rvaddrw").click(function(){

            var a = '<tr id="added_'+count+'"><td width="30"></td><td width="170" valign="top" style="padding-top: 5px"></td>&nbsp;<td width="100%"><input name="reward['+count+']" type="text" id="rvpoint_'+count+'" placeholder="Reward" class="x-small">&nbsp;<input name="amount['+count+']" type="text" id="rvamount_'+count+'" placeholder="Amount" class="x-small">&nbsp;</td></tr>';
            
            $("#rvamount_"+i).after(a);
            count++;
            i++;
        
        });

        //~REWARD DELETE REWARD BUTTON ACTION

        $("#rvdelrw").click(function(){
            count--;
            i--;            
            $("#added_"+count).remove();
        });


</script>