<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file

require_once '../../../../init.php';
// Required files
require_once MAX_PATH . '/www/admin/config.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once MAX_PATH . '/lib/OA/Dal.php';

OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

	$isSsl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' : 'http://';
	$image_path = $isSsl.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/plugins/advaned_dsp_reports/images/';
	$js_path = $isSsl.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/plugins/advaned_dsp_reports/js/';
	$css_path = $isSsl.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/plugins/advaned_dsp_reports/css/';

$oDbh = &OA_DB::singleton();

$oPluginManager = new OX_PluginManager();
$oComponentGroupManager = new OX_Plugin_ComponentGroupManager();

$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel("User Gender Reports");
$oHeaderModel->setIconClass('iconTargetingChannelsLarge');
$oHeaderModel->setpageType('list');

phpAds_PageHeader('adr-user-gender', $oHeaderModel);
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$tab_advanced_report = $oDbh->quoteIdentifier($table_prefix . 'dj_dsp_advanced_reports',true);
$tab_advanced = $oDbh->quoteIdentifier($table_prefix . 'dj_dsp_adv_report_gender',true);

$pPass = $_GET;
$limit = 25;
$pn = ($_GET['p']) ? $_GET['p'] : 1;

	    
$_period = !empty($pPass['period_preset']) ? $pPass['period_preset'] : '';

if($pPass['period_preset']!='')
{
	if($pPass['period_preset']=='today')
	{
		$start=date('Y-m-d');
		$end=date('Y-m-d');
	}
	else if($pPass['period_preset']=='yesterday')
	{
		$start=date('Y-m-d', strtotime('Yesterday'));
		$end=date('Y-m-d', strtotime('Yesterday'));
	}
	else if($pPass['period_preset']=='this_week')
	{
		$start=date('Y-m-d', strtotime('this week Monday'));
		$end=date('Y-m-d');
	}
	else if($pPass['period_preset']=='last_week')
	{
		$start=date('Y-m-d', strtotime('previous Monday'));
		$end=date('Y-m-d', strtotime('previous Sunday'));
	}
	else if($pPass['period_preset']=='last_7_days')
	{
		$start=date('Y-m-d', strtotime('Today - 7 Day'));
		$end=date('Y-m-d', strtotime('Today - 1 Day'));
	}
	else if($pPass['period_preset']=='this_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$end=date('Y-m-d');
	}
	else if($pPass['period_preset']=='last_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		$end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
	}
	else if($pPass['period_preset']=='all_stats')
	{
		$start='0000-00-00';
		$end=date('Y-m-d'); $period_preset='all_stats';
	}
	else if($pPass['period_preset']=='specific')
	{
		$start=$pPass['period_start'];
		$end=$pPass['period_end'];
	}

}
else
{
	$start=date('Y-m-d');
	$end=date('Y-m-d');
}


$start_date=$start;
$end_date=$end;

/*Convert start date and end date into timezone format*/
if($period_preset=='all_stats')
{
	$start_date="0000-00-00 00:00:00";
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
}
else if($start_date=='' && $end_date=='')
{ 
	$start_day=new Date(date('Y-m-d H:i:00'));
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
	
}
else
{
	
	$end_day=new Date($end_date);
	
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');

	$start_day=new Date($start_date);
	
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	
}

$tb_select = "SELECT ".$tab_advanced.".gender ,
					sum(request_count) as request_count,
					sum(response_count) as response_count,
					sum(wing_notice_count) as wing_count";
					
$tb_from ="FROM ".$tab_advanced_report." INNER JOIN ".$tab_advanced." ON ".$tab_advanced_report.".gender = ".$tab_advanced.".id ";

$tb_where = (($start == '' && $end == "") ?  "" : "WHERE datatime BETWEEN '".$start_date."' and '".$end_date."' AND ".$tab_advanced.".gender !='' ");

$tb_group ="GROUP BY gender";
$query = $tb_select." ".$tb_from." ".$tb_where." ".$tb_group;

$rsReport = $oDbh->query($query)->fetchAll();
?>

<link rel="stylesheet" type="text/css" href="<?php echo $css_path.'adr_cs.css' ?>">
<script src="<?php echo $js_path.'highcharts.js'; ?>"></script>
<script src="<?php echo $js_path.'exporting.js'; ?>"></script>
<script src="<?php echo $js_path.'export-data.js'; ?>"></script>

<form method='get' class="oxn_form_at">
        <select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>
            <option value='today' selected='selected'>Today</option>

            <option value='yesterday' <?php if($_period == "yesterday") : ?> selected="selected" <?php endif; ?> >Yesterday</option>
            <option value='this_week' <?php if($_period == "this_week") : ?> selected="selected" <?php endif; ?> >This week</option>
            <option value='last_week' <?php if($_period == "last_week") : ?> selected="selected" <?php endif; ?> > Last week</option>
            <option value='last_7_days' <?php if($_period == "last_7_days") : ?> selected="selected" <?php endif; ?> >Last 7 days</option>
            <option value='this_month' <?php if($_period == "this_month") : ?> selected="selected" <?php endif; ?> >This month</option>
            <option value='last_month' <?php if($_period == "last_month") : ?> selected="selected" <?php endif; ?> >Last month</option>

            <option value='all_stats' <?php if($_period == "all_stats") : ?> selected="selected" <?php endif; ?> >All statistics</option>
            <option value='specific' <?php if($_period == "specific") : ?> selected="selected" <?php endif; ?> >Specific dates</option>
        </select>

        <label for='period_start' style='margin-left: 1em'></label>
        <input class="date" name="period_start" id="period_start" type="text" value="<?php  if(!empty($start)){ echo $start;}else{ echo date('Y-m-d');}?>" tabindex="2"/>
        <input type='image' src='<?php echo $image_path.'icon-calendar.gif';  ?>' id='period_start_button' align='absmiddle' border='0' tabindex='3' />
        <label for='period_end' style='margin-left: 1em'> </label>

        <input class="date" name="period_end" id="period_end" type="text" value="<?php if(!empty($end)){ echo $end;}else{ echo date('Y-m-d');} ?>" tabindex="4" /> 
<input type='image' src='<?php echo $image_path.'icon-calendar.gif'; ?>' id='period_end_button' align='absmiddle' border='0' tabindex='3' />
	<a href='' onclick='return periodFormSubmit()'>
       &nbsp; <img src='<?php echo $image_path.'go.gif'; ?>' border='0' tabindex='6' /></a>

</form>
<?php
if(count($rsReport))
{	
	$request_report = array();
	$response_report = array();
	$wing_report = array();
	
	foreach($rsReport as $Report)
	{

	if($Report['request_count']) { $request_report[] = array('name'=>$Report['gender'],'y'=> intval($Report['request_count']) ); }
	 if($Report['response_count']) { $response_report[] = array('name'=>$Report['gender'],'y'=> intval($Report['response_count']) ); }
	 if($Report['wing_count']) { $wing_report[] = array('name'=>$Report['gender'],'y'=> intval($Report['wing_count']) ); }
	}

	$request_report_data = json_encode($request_report);
	$response_report_data = json_encode($response_report);
	$wing_report_data = json_encode($wing_report);
	
?>
<table class="rtp_table">
<tr>
<?php
echo  ($request_report) ? '<td><div id="report_request"  class="obq_reports"></div></td>' : ''; 
echo  ($response_report) ? '<td><div id="report_response"  class="obq_reports"></div></td>': ''; 
echo  ($wing_report) ? '<td><div id="report_wing"  class="obq_reports"></div></td>' : ''; 
?>
</tr>
</table>
	
	<script>

	var option ={	chart: {	plotBackgroundColor: null,	plotBorderWidth: null,		plotShadow: false,		type: 'pie'	},
					tooltip: {	pointFormat: '{series.name}: <b>{point.y}</b>'	 },
					plotOptions: { pie: {	allowPointSelect: true,	cursor: 'pointer',dataLabels: {	enabled: false}	} },
				};
	<?php
		 if($request_report)
		{
			echo "var report_option = option;";	
			echo "report_option.title = {text: 'Shares of Request' };";	
			echo "report_option.series =	[{ name: 'Requests', colorByPoint: true, data: ".$request_report_data." }] ;";	
			echo "Highcharts.chart('report_request',report_option );";		
		}
		
		 if($response_report)
		{
			echo "var respose_option = option;";	
			echo "respose_option.title = {text: 'Shares of Response' };";	
			echo "respose_option.series =	[{ name: 'Response', colorByPoint: true, data: ".$response_report_data." }] ;";	
			echo "Highcharts.chart('report_response',respose_option );";		
		}
		
		 if($wing_report)
		{
			echo "var wing_option = option;";
			echo "wing_option.title = {text: 'Shares of Wing Notice' };";		
			echo "wing_option.series =	[{ name: 'Wing Notice', colorByPoint: true, data: ".$wing_report_data." }] ;";	
			echo "Highcharts.chart('report_wing',wing_option );";		
		}
?>

</script>
<?php
}


if(count($rsReport))
{	
	
	$start_data = ($pn-1) * $limit;    
	$end_data = $start_data + ($limit - 1);
	$end_data = ($end_data > (count($rsReport)-1) ) ?(count($rsReport)-1) : $end_data;
	
	?>

 <table class="ex_pn">
 
	<tr>
		<td><h3 class="grap">User Gender Statistics</h3></td>
		<td class="soul"><a  href="stats-user-gender-export-csv.php?start_date=<?php echo $start_date;?>&end_date=<?php echo $end_date;?>"><img src="<?php echo $image_path.'excel.gif'; ?>">CSV</a></td>
	</tr>
	
 </table>


  <table cellspacing="0" cellpadding="0" border="0" width="100%" class="tableAdvanced">
	  <thead>
	<tr>
		<th>Gender</th>
	 
		
		<th>Request</th>
	
		<th>Response</th>
		
		<th>Wing Notice</th>               
	</tr>
	  </thead>
	    </tbody>
            
<?php

for($i=$start_data; $i<=$end_data; $i++)
{	
	$Report = $rsReport[$i]
	?>
	<tr>
		<td><strong class="bk-tile"><?php echo $Report['gender'];?></strong></td>
	 
		<td><?php echo $Report['request_count'];?></td>
		
		<td><?php  echo $Report['response_count']; ?></td>
		<td><?php  echo $Report['wing_count']; ?></td>
		
    </tr>
    <?php
}
?>
</tbody>
</table>

<?php
      	$total_records = count($rsReport) ;   
		$data = $pPass;
		if($data['p']){ unset($data['p']); };
		if($data) { $data = '&amp;'.http_build_query($data,'&amp;'); } else { $data=""; }
        $total_pages = ceil($total_records / $limit);
        
        if($total_pages > 1)
        {
		
		echo "<ul class='pgn-oper'> ";

        $k = (($pn+3>$total_pages)?$total_pages-3:(($pn-3<1)?4:$pn));     
        $pagLink = ""; 
        if($pn>=2){ 
            echo "<li><a href='?p=1".$data."'>First</a></li>"; 
            echo "<li><a href='?p=".($pn-1).$data."'> Previous </a></li>"; 
        } 
        else
		{
			 echo "<li class='unRead' ><a >First</a></li>"; 
			 echo "<li  class='unRead' ><a > Previous </a></li>";
		}
		
		
		if($total_pages > 7){  $ic= -3 ; $ic_limit = 3;	}	 else  {$ic = 1; $ic_limit = $total_pages;  $k = 0;   }
		
        for ($i=$ic; $i<=$ic_limit; $i++) {  
          if($k+$i==$pn) 
            $pagLink .= "<li class='active'><a  >".($k+$i)."</a></li>"; 
          else
            $pagLink .= "<li><a href='?p=".($k+$i).$data."'>".($k+$i)."</a></li>";   
        }
		
           
        echo $pagLink; 
        if($pn<$total_pages){ 
            echo "<li><a href='?p=".($pn+1).$data."'> Next </a></li>"; 
            echo "<li><a href='?p=".$total_pages.$data."'> Last </a></li>"; 
        }  
        else
		{
			 echo "<li class='unRead' ><a >Next</a></li>"; 
			 echo "<li  class='unRead' ><a > Last </a></li>";
		}
        
       echo " </ul> ";
       

	}

}else{
	
	echo '<div class="errormessage none-of"><img  src="'.$image_path.'info.gif" >There are currently no statistics available</div>';	
	
}

?>






        <script type='text/javascript'>
     
        Calendar.setup({
            inputField : 'period_start',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_start_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });
        Calendar.setup({
            inputField : 'period_end',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_end_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });

       
      
 function periodFormChange(bAutoSubmit)
        {
 	    var o = document.getElementById('period_preset');
            var periodSelectName = o.options[o.selectedIndex].value;
            var specific = periodSelectName == 'specific';
 	    var periodTabIndex = 2;

		document.getElementById('period_start').readOnly = !specific;
            document.getElementById('period_start_button').disabled = !specific;
            document.getElementById('period_end').readOnly = !specific;
            document.getElementById('period_end_button').disabled = !specific;
           
		   if (!specific) {
				if(bAutoSubmit)
				{
					document.getElementById('period_start').disabled = true;
					document.getElementById('period_end').disabled =  true;	
				}
				
                document.getElementById('period_start').classList.add("disapp");
                document.getElementById('period_end').classList.add("disapp");
                document.getElementById('period_start').tabIndex = null;
                document.getElementById('period_start_button').tabIndex = null;
                document.getElementById('period_end').tabIndex = null;
                document.getElementById('period_end_button').tabIndex = null;
				document.getElementById('period_start_button').src = '<?php echo $image_path.'icon-calendar-d.gif';  ?>';
				document.getElementById('period_end_button').src = '<?php echo $image_path.'icon-calendar-d.gif';  ?>' ;

            } else {
                document.getElementById('period_start').classList.remove("disapp");
                document.getElementById('period_end').classList.remove("disapp");
                document.getElementById('period_start').tabIndex = periodTabIndex;
                document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
                document.getElementById('period_end').tabIndex = periodTabIndex + 2;
                document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
	        document.getElementById('period_start_button').src = '<?php echo $image_path.'icon-calendar.gif';  ?>';
           	document.getElementById('period_end_button').src = '<?php echo $image_path.'icon-calendar.gif';  ?>' ;
            }

            document.getElementById('period_start_button').readOnly = !specific;
            document.getElementById('period_end_button').readOnly = !specific;
          
            document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
            document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

            if (!specific && bAutoSubmit) {
                o.form.submit();
            }
}
periodFormChange(0);

    function periodFormSubmit() {
            var form = document.getElementById('period_preset').form;
            if (checkDates(form)) {
		
              form.submit();
            }
            return false;
        }
    function checkDates(form)
        {
          var startField = form.period_start;
          var endField = form.period_end;

          if (!startField.disabled && startField.value != '') {
            var start = Date.parseDate(startField.value, '%Y-%m-%d');
          }
          if (!startField.disabled && endField.value != '') {
            var end = Date.parseDate(endField.value, '%Y-%m-%d');
          }

          if ((start != undefined && end != undefined) && (start.getTime() > end.getTime())) {
            alert('\'From\' date must be earlier then \'To\' date');
            return false;
          }
          return true;
        }
       
</script>
        
       <?php

phpAds_PageFooter();
?>


