<?php
require_once '../../../../init.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once 'lib/Csv.php';
require_once MAX_PATH . '/www/admin/config.php';

$oDbh = &OA_DB::singleton();

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$tab_advanced_report = $oDbh->quoteIdentifier($table_prefix . 'dj_dsp_advanced_reports',true);
$tab_advanced = $oDbh->quoteIdentifier($table_prefix . 'dj_dsp_adv_report_ip',true);

$start_date = $_GET['start_date'];
$end_date = $_GET['end_date'];

$tb_select = "SELECT ".$tab_advanced.".ip ,
					sum(request_count) as request_count,
					sum(response_count) as response_count,
					sum(wing_notice_count) as wing_count,
					sum(impression) as impression,sum(click) as click,sum(conversion) as conversion,exchange_id";
					
$tb_from ="FROM ".$tab_advanced_report." INNER JOIN ".$tab_advanced." ON ".$tab_advanced_report.".ip = ".$tab_advanced.".id ";

$tb_where =  "WHERE datatime BETWEEN '".$start_date."' and '".$end_date."'  AND ".$tab_advanced.".ip !=''";
$tb_group ="GROUP BY ip,exchange_id";

$query = $tb_select." ".$tb_from." ".$tb_where." ".$tb_group;

$rsReport = $oDbh->query($query)->fetchAll();

$query="SELECT id,dsp_portal_name FROM `rv_dj_dsp`";
	$results = $oDbh->query($query)->fetchAll();
	$dspads=array();
	foreach($results as $key => $value)
	{
		$dspads[$value['id']]=$value['dsp_portal_name'];
	}
	
$columns=array(0=>'DSP Name',1=>'IP',2=>'Number of BidRequest',3=>'Number of BidResponse',4=>'Win Notice',5=>'Impressions','6'=>'Clicks','7'=>'Conversions');
$rows = array();

foreach($rsReport as $r)
{
	$dspname=$dspads[$r['exchange_id']];
	$rows[] =  array(0=>$dspname,1=>$r['ip'],2=>$r['request_count'],3=>$r['response_count'],4=>$r['wing_count'],5=>$r['impression'],6=>$r['click'],7=>$r['conversion']);
}

if(count($rows)>0)
{
	$toExport = array_merge(array( $columns ),$rows);
}
else{
	$rows[]= array(0=>'No stats avilable');
	$toExport = array_merge(array( $columns ),$rows);
}


if($_GET['period_preset']=='all_stats')
{
	$filename = 'IP_all_stats.csv';

}
else if(!empty($start_date) && !empty($end_date))
{
	$sdate=explode(' ',$start_date);
	$edate=explode(' ',$end_date);
	$filename = 'IP'.$sdate[0].'_to_'.$edate[0].'.csv';
}
else
{
	$filename = 'IP_Stats.csv'; 
}

header('Content-Disposition:attachment;filename='.$filename);
header('Content-Type:application/vnd.ms-excel');

$csv = '';
foreach($toExport as $row) {
	$csv .= OX_Vast_Common_Csv::formatCsvLine($row);
}
 
echo $csv; 
exit;
