<?php

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/www/admin/lib-maintenance-priority.inc.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/max/Plugin.php';
require_once MAX_PATH . '/lib/max/other/lib-acl.inc.php';
require_once MAX_PATH . '/lib/max/Delivery/cache.php';
require_once MAX_PATH . '/lib/max/other/capping/lib-capping.inc.php';

// Register input variables
phpAds_registerGlobalUnslashed('acl', 'action', 'submit');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
OA_Permission::enforceAccessToObject('clients',   $clientid);
OA_Permission::enforceAccessToObject('campaigns', $campaignid);
// OA_Permission::enforceAccessToObject('banners',   $bannerid);

/*-------------------------------------------------------*/
/* Store preferences                     */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

//Get banner-ids
    $doBanners = OA_Dal::factoryDO('banners');
        $doBanners->campaignid=$campaignid;
    $doBanners->find();

    while($doBanners->fetch() ) {
    $aBanners[] = $doBanners->bannerid;
    }

// Initialise some parameters
$pageName = basename($_SERVER['SCRIPT_NAME']);
$tabindex = 1;
$aEntities = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $aBanners);

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/
$entityId = OA_Permission::getEntityId();
if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
    $entityType = 'advertiser_id';
} else {
    $entityType = 'agency_id';
}

// Display navigation
$aOtherCampaigns = Admin_DA::getPlacements(array($entityType => $entityId));
$aOtherBanners = Admin_DA::getAds(array('placement_id' => $campaignid), false);

// Setup a fake record for the "Apply to all" entry
$aOtherBanners[-1] = array('name' => '--' . $GLOBALS['strAllBannersInCampaign'] . '--', 'ad_id' => -1, 'placement_id' => $campaignid);

MAX_displayNavigationCampaign($pageName, $aOtherCampaigns, $aOtherBanners, $aEntities);
// echo "test";exit;

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

//$aBanner = MAX_cacheGetAd($bannerid, false);

foreach($aBanners as $value) {
		$doBanner = OA_Dal::factoryDO('acls');
		$doBanner->bannerid=$value;
    $doBanner->find();
    while($doBanner->fetch() ) {
        $doAcls = $doBanner->toArray();
         break;  
    }
}

$bannerid = $doAcls['bannerid'];
$aParams = array('clientid' => $clientid, 'campaignid' => $campaignid);

//~ if(empty($aBanners)) {
    //~ echo "<div id='warning_change_zone_size' class='errormessage'>There are currently no banners available to set delivery limiataions</div>";
    //~ exit;
//~ }
//~ $sql1= "Select deal_id from {$table_prefix}campaigns WHERE campaignid={$campaignid}";
             //~ $fetch = OA_Dal_Delivery_query($sql1);
             //~ $row = OA_Dal_Delivery_fetchassoc($fetch);

          
             //~ if ($row['deal_id']=="" || $row['deal_id']=="null") {
                

echo "
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF'>";
  echo "<tr>
  <td><label>Deal Id</label></td>
  <td id='deal_m'>
	<input type='text' name='dealid[]' id='dealid'><button id='add_dealid' name='add_dealid' onclick='addElement(deal_m)'>+</button></td>
  </tr>";
echo "</table>
<br /><br /><br />";
echo "<input type='submit' name='submit' value='{$GLOBALS['strSaveChanges']}' tabindex='".($tabindex++)."'>

</form>";

//~ }
/*-------------------------------------------------------*/
/* Form requirements                                     */
/*-------------------------------------------------------*/
?>
<script>

function addElement(td) {
  var ni = document.getElementById(td);
  var br = document.createElement('br');
  var numi = document.getElementById('dealid');
  var num = (document.getElementById('dealid').value -1)+ 2;
  numi.value = num;
  var newdiv = document.createElement('div','br');
  newdiv.setAttribute('id',num);
  var unum="'+newdiv+','+num+'";
  newdiv.innerHTML ='<td><label>Deal Id '+num+'</label></td> <td><input id="t'+num+'" type="text" placeholder="Deal Id" name="deal_id[]" required><img id="del" onClick="removeElement('+unum+');" alt="del" src="assets/images/del.png"  width="15px" height="15px"/></td>';
  console.log(newdiv);
  ni.appendChild(newdiv);
  ni.appendChild(br.cloneNode());
}
//remove Element
//~ function removeElement(divNum,div) {
  //~ var d = document.getElementById(divNum);
  //~ var olddiv = document.getElementById(div);
  //~ d.removeChild(olddiv);
//~ }
</script>

<?php

_echoDeliveryCappingJs();

phpAds_PageFooter();

?>

