<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/RV/Admin/Languages.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/lib/OA/Dll/Publisher.php';
require_once MAX_PATH . '/lib/OA/Admin/Menu.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Admin/Template.php';
require_once MAX_PATH . '/lib/OA/Creative/File.php';

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
} else if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}

// Register input variables
phpAds_registerGlobalUnslashed ('move', 'name', 'website', 'contact', 'email',
                               'errormessage', 'submit', 'publiczones_old', 'formId');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid, true);


/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* Initialise data                                    */
/*-------------------------------------------------------*/
if ($affiliateid != "") {
    // Do not get this information if the page
    // is the result of an error message
    if (!isset($affiliate)) {
        $doAffiliates = OA_Dal::factoryDO('affiliates');
        if ($doAffiliates->get($affiliateid)) {
            $affiliate = $doAffiliates->toArray();
        }
    }
} else {
    //set some default
    $affiliate['website'] = 'http://';
}


/*-------------------------------------------------------*/
/* MAIN REQUEST PROCESSING                               */
/*-------------------------------------------------------*/
//  check if Thorium plugin is enabled
$oComponent = null;
if ( isset($GLOBALS['_MAX']['CONF']['plugins']['openXThorium']) &&
     $GLOBALS['_MAX']['CONF']['plugins']['openXThorium']) {
    $oComponent = &OX_Component::factory('admin', 'oxThorium', 'oxThorium');
}

//build form
$websiteForm = buildWebsiteForm($affiliate);

if ($websiteForm->validate()) {
    //process submitted values
    $oPublisherDll = processForm($affiliateid, $websiteForm, $oComponent);
    if ($oPublisherDll->_errorMessage || $oPublisherDll->_noticeMessage) {
        displayPage($affiliateid, $websiteForm, $oPublisherDll);
    }
}
else { //either validation failed or form was not submitted, display the form
    displayPage($affiliateid, $websiteForm);
}


/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function buildWebsiteForm($affiliate)
{
     
    $form = new OA_Admin_UI_Component_Form("affiliateform", "POST", $_SERVER['SCRIPT_NAME']);
    $form->forceClientValidation(true);
    $affiliateId = $affiliate['affiliateid'];
    $form->addElement('hidden', 'affiliateid', $affiliate['affiliateid']);

    //CUSTOM FIELDS
    $values = unserialize($affiliate['comments']);
    
    // echo "<pre>";print_r($values);exit;

    $form->addElement('hidden', 'apptype', $values['app_type']);
    $form->addElement('hidden', 'appversion', $values['app_version']);
    $form->addElement('hidden', 'bundleid', $values['bundle_id']);
    $form->addElement('hidden', 'appurl', $values['app_url']);
    // $form->addElement('hidden', 'privacy', $values['app_pp']);

    $form->addElement('header', 'basic_info', $GLOBALS['strBasicInformation']);

    /* CUSTOM FIELDS START */    

    $custom_dm['android'] = $form->createElement ( 'radio', 'app_type', '', 'Android', 1, array ('id' => 'app_type1') );
    $custom_dm['ios'] = $form->createElement ( 'radio', 'app_type', '', 'IOS', 3, array ('id' => 'app_type3') );
    $custom_dm['site'] = $form->createElement ( 'radio', 'app_type', '', 'Website', 2,array ('id' => 'app_type2') );
    $form->addElement( 'group', 'app_type', 'Inventory Type', $custom_dm, null, false );
    
    //~ Begins : WEbsite Fields
    $form->addElement('text', 'name', $GLOBALS['strName']);
    $form->addElement('text', 'contact', $GLOBALS['strContact']);
    $form->addElement('text', 'email', $GLOBALS['strEMail']);
    $form->addElement('text', 'website', $GLOBALS['strWebsiteURL']);
    //~ Ends : WEbsite Fields
    
    $form->addElement('text', 'app_name', 'App Name', array('value' => $values['app_name']));
    $form->addElement('text', 'bundle_id', 'App Bundle ID');
    $form->addElement('text', 'app_url', 'App Store URL');
    // $form->addElement('text', 'app_pp', 'Privacy Policy');
    
    //App Category Begins
    $mapp_category = array();
    $selectedCategory = unserialize($values['app_category']);
    $table_prefix  = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    $cat=OA_Dal_Delivery_query("SELECT category_id,category_name,value,parent_category_id FROM {$table_prefix}djax_site_categories GROUP BY value ");

    if(OA_Dal_Delivery_numRows($cat) > 0 ){
        while($row=OA_Dal_Delivery_fetchAssoc($cat)) 
        {
            $mapp_category[][] = $row;
            
        }   
    }
        $appCategory = '<div id="appCategories">
                <label>App Categories</label>
                 <select class="sel" name="app_category[]" multiple>';
            foreach ($mapp_category as $ab) {
                foreach ($ab as $a=>$b) 
                {
                    $catchild = explode("-", $b['value']);
                    $class = ($b['parent_category_id'] == 0  && empty($catchild[1])) ? 'class="hd"' : '';
                    $space = ($b['parent_category_id'] != 0 && !empty($catchild[1])) ? '' : '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; 
                    $selected = ''; 
                    if(is_array($selectedCategory) && in_array($b['category_id'],$selectedCategory))
                    {
                        $selected = "selected";
                    }
                    
                    $appCategory.='<option  '.$class.' value='.$b['category_id'].' '.$selected.'>'.$space.$b['category_name'].'</option>';
                } 
            } 
                
        $appCategory.='</select>
                    </div>
                    <style>
            #appCategories{
                display: -webkit-inline-box;
                padding-left: 28px;
            }
            #appCategories label{
                display: flex;
            }
            .sel{
                margin-left: 97px;
                width: 250px;
                height: 90px;
            }
            .sel option.hd
              {
                font-weight: bolder;
                font-size: 13px;
              }
                
            </style>';
            $form->addElement('html','app_category',$appCategory);
    //App Category Ends
    
    $app_iconImg.= '
        <style>
            #appIconImg{
                margin-left: 30px;
                display: -webkit-inline-box;
            }
            #iconUpload{
                padding-left: 32px;
                display: grid;
            }
            #blah{
                display: none;
            }
        </style>
        <div id="appIconImg">
            <label for="app_icon">App Icon<br> (Upload Image with 50x 50)</label>
            
        ';
    if($values['app_iconimage']){
        $path = $GLOBALS['_MAX']['SSL_REQUEST'] ? "https://" : "http://" ;
        $img_path = $path.$GLOBALS['_MAX']['CONF']['webpath']['images'].'/'.$values['app_iconimage'];
    }
    if(isset($values['app_iconimage']))
    {
        $app_iconImg.= '
            <div id="iconUpload">
                <img id="blah" style="display: block;" src="'.$img_path.'" height="50px" width="50px"><br>
                <input type="file" id="fileToUpload" name="fileToUpload" value="'.$values['app_iconimage'].'" >
                <input type="hidden" id="icon" name="icon" value="'.$values['app_iconimage'].'">
            </div>      
        
        </div>';
    }
    else{
        $app_iconImg.= '
            <div id="iconUpload">
                <img id="blah" src ="'.$img_path.'" height="50px" width="50px" style="background-color: #f3f3f3;"><br>
                <input type="file" id="fileToUpload" name="fileToUpload">
            </div>
        
        </div>';
    }
  
    $form->addElement('html', 'app_icon', $app_iconImg, 'App Icon (Upload Image with 50x 50)');

    //~ Ends : App Fields


    //~JS

    $form->addElement('html', 'jsForAffiliateForm', "


        <script type='text/javascript'>

            $('form').attr('enctype', 'multipart/form-data');

            var pub = $('#publisher_id').val();

            $('#publisher_id').click(function()
            {
                if(pub == null)
                {
                    alert('No Publisher available!');
                    return false;
                }
            });

            var apptype = $('input[name=apptype]').val();
            $('#app_type'+apptype).attr('checked', true);

            $('#bundle_id').val($('input[name=bundleid]').val());
            $('#app_url').val($('input[name=appurl]').val());
            $('#app_pp').val($('input[name=privacy]').val());

            if(apptype){
                show_appad(apptype);
            } else{

                if(!'".$_GET['affiliateid']."')
                {
                    $('#app_type1').trigger('click');
                    show_appad(1);
                }
                else
                {
                    show_appad(0);
                }
            }

            $('input[name=app_type]').click(function(){

                var type = $(this).val();
                show_appad(type);
            });

            function show_appad(type){
                if(type == 1 || type == 3){
                    $('#bundle_id').parent().parent().show();
                    $('#app_name').parent().parent().show();
                    $('#app_url').parent().parent().show();
                    $('#fileToUpload').parent().parent().show();
                    $('#app_pp').parent().parent().show();
                    $('#appCategories').parent().parent().show();
                    $('#email').parent().parent().show();
                    
                    $('#website').parent().parent().hide();
                    $('#name').parent().parent().hide();
                    $('#contact').parent().parent().hide();

                } else if(type == 2){
                    $('#bundle_id').parent().parent().hide();
                    $('#app_name').parent().parent().hide();
                    $('#app_url').parent().parent().hide();
                    $('#fileToUpload').parent().parent().hide();
                    $('#app_pp').parent().parent().hide();
                    $('#appCategories').parent().parent().hide();
                    
                    $('#website').parent().parent().show();
                    $('#name').parent().parent().show();
                    $('#contact').parent().parent().show();
                    $('#email').parent().parent().show();
                   
                }else{
                    $('#name').parent().parent().hide();
                    $('#contact').parent().parent().hide();
                    $('#email').parent().parent().hide();
                    $('#website').parent().parent().hide();

                    $('#bundle_id').parent().parent().hide();
                    $('#app_name').parent().parent().hide();
                    $('#app_url').parent().parent().hide();
                    $('#fileToUpload').parent().parent().hide();
                    $('#app_pp').parent().parent().hide();
                    $('#appCategories').parent().parent().hide();
                    $('input[name=is_mediation]').parent().parent().hide();
                   
                }
            }
            var _URL = window.URL || window.webkitURL;
            $('#fileToUpload').change(function(){
                var img, file;
                if ((file = this.files[0]))
                {
                    img = new Image();
                    console.log(img);
                    img.onload = function() 
                    {
                        $('#blah').css('display', 'block');
                        $('#blah').attr('src', this.src);

                        if((this.width != 50) && (this.height != 50))
                        {
                            alert('Upload image with (50x50) dimensions');
                            this.src = '';
                             $('#app_icon').val('');

                            return false;
                        }
                    };
                    img.onerror = function() {
                        // alert( 'not a valid file: ' + file.type);
                    };
                    img.src = _URL.createObjectURL(file);
                }
            });


        </script>
        ");

    /* CUSTOM FIELDS END */    


    $form->addElement('controls', 'form-controls');
    $form->addElement('submit', 'save', 'Save changes');

    //Form validation rules
    // $translation = new OX_Translation();
    // $urlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWebsiteURL']));
    //~ $form->addRule('website', $urlRequiredMsg, 'required');
    // $form->addRule('website', $GLOBALS['strInvalidWebsiteURL'], 'regex', '#^http(s?)\://.+$#');
    // $contactRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strContact']));
    //~ $form->addRule('contact', $contactRequiredMsg, 'required');
    // $nameRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strName']));
    //~ $form->addRule('name', $nameRequiredMsg, 'required');
    // $emailRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strEMail']));
    //~ $form->addRule('email', $emailRequiredMsg, 'required');
    // $form->addRule('email', $GLOBALS['strEmailField'], 'email');
    
    //set form  values
    $form->setDefaults($affiliate);
    return $form;
}

/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
 function processForm($affiliateid, $form, $oComponent)
{
    $aFields = $form->exportValues();
    
    $newWebsite = empty($aFields['affiliateid']);

    // Setup a new publisher object and set the fields passed in from the form:
    $oPublisher = new OA_Dll_PublisherInfo();
    
    if($_POST['app_type'] == 1 || $_POST['app_type'] == 3){
        $oPublisher->publisherName  = $aFields['app_name'];
    }
    else{       
        $oPublisher->publisherName  = $aFields['name'];
        $oPublisher->website        = $aFields['website'];
    }
    $oPublisher->agencyId       = $aFields['agencyid'];
    $oPublisher->contactName    = $aFields['contact'];
    $oPublisher->emailAddress   = $aFields['email'];
    $oPublisher->publisherId    = $aFields['affiliateid'];
    $oPublisher->affiliate_type = $aFields['app_type'];
    

    ///////Image Upload Starts ///////
    
    if($_FILES["fileToUpload"]["name"] != '') 
    {
        $dir = __DIR__;
        $im_path = (explode("admin",$dir));
        $name = $_FILES['fileToUpload']['name'];    
        $target_dir = $im_path[0] .'images/';
        $target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);

        // Select file type
        $imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
        $extensions_arr = array("jpg","jpeg","png","gif");

        // Check extension
         if( in_array($imageFileType,$extensions_arr) ){
         
            move_uploaded_file($_FILES['fileToUpload']['tmp_name'],$target_dir.$name);
        }
    } else{

        $name = $_POST['icon'];
    }

    ///////Image Upload Ends ///////
    $app_details = '';
    
    if($aFields['app_type'] == 1 || $aFields['app_type'] == 3)
    {
        $app_details = array(
                'app_type' => $aFields['app_type'],
                'app_name' => $aFields['app_name'],
                'app_iconimage' => $name,
                'bundle_id' => $aFields['bundle_id'],
                'app_url' => $aFields['app_url'],
                'app_pp' => $aFields['app_pp'],
                'app_category' => serialize($_POST['app_category']),
        );
    }

    else{

        $app_details = array(
            'app_type' => $aFields['app_type']
        );
    }

    $app_details = serialize($app_details);
  
    // process form data for oxThorium if this is edit existing website
    if (!$newWebsite && $oComponent)
    {
        $aFields['affiliateid'] = $oPublisher->publisherId;
        $oComponent->processAffiliateForm($aFields);
    }

    $oPublisherDll = new OA_Dll_Publisher();
    if ($oPublisherDll->modify($oPublisher) && !$oPublisherDll->_noticeMessage) {

        // Queue confirmation message
        $translation = new OX_Translation ();
        $table_prefix  = $GLOBALS['_MAX']['CONF']['table']['prefix'];

        if ($newWebsite) {

            //process form data for oxThorium for new website
            if ($oComponent)
            {
                $aFields['affiliateid'] = $oPublisher->publisherId;
                $oComponent->processAffiliateForm($aFields);
            }
            $translated_message = $translation->translate ( $GLOBALS['strWebsiteHasBeenAdded'], array(
                MAX::constructURL(MAX_URL_ADMIN, 'affiliate-edit.php?affiliateid=' .  $oPublisher->publisherId),
                htmlspecialchars($oPublisher->publisherName),
                MAX::constructURL(MAX_URL_ADMIN, 'zone-edit.php?affiliateid=' .  $oPublisher->publisherId),
            ));

            /* CUsSTOM FIELD UPDATE START */
         
            $oPublisher->programatic_deal = ($aFields['programatic_deal'] > 0) ? $aFields['programatic_deal']: 0;
            $oPublisher->open_market   = ($aFields['open_market']) ? $aFields['open_market']: 0;
            $oPublisher->margin   = ($aFields['margin']) ? $aFields['margin']: 0;
            $oPublisher->cpm   = ($aFields['cpm']) ? $aFields['cpm']: 0;
           
            if($aFields['app_type'] == 1 || $aFields['app_type'] == 3){
               
                OA_Dal_Delivery_query("UPDATE {$table_prefix}affiliates SET comments = '{$app_details}', affiliate_type = '{$aFields['app_type']}' WHERE affiliateid = {$oPublisher->publisherId} ");
                
            }else{

                OA_Dal_Delivery_query("UPDATE {$table_prefix}affiliates SET comments = '{$app_details}', affiliate_type = '{$aFields['app_type']}' WHERE affiliateid = {$oPublisher->publisherId} ");
            }
           
            /* CUSTOM FIELD UPDATE END */

            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
            $redirectURL = "website-index.php";
        }
        else {
            $translated_message = $translation->translate ( $GLOBALS['strWebsiteHasBeenUpdated'], array(
                MAX::constructURL(MAX_URL_ADMIN, 'affiliate-edit.php?affiliateid=' .  $oPublisher->publisherId),
                htmlspecialchars($oPublisher->publisherName),
            ));
            $redirectURL = "affiliate-edit.php?affiliateid={$oPublisher->publisherId}";

            /* CUSTOM FIELD UPDATE START */

            $oPublisher->programatic_deal = ($aFields['programatic_deal'] > 0) ? $aFields['programatic_deal']: 0;
            $oPublisher->open_market   = ($aFields['open_market']) ? $aFields['open_market']: 0;
            $oPublisher->margin   = ($aFields['margin']) ? $aFields['margin']: 0;
            $oPublisher->cpm   = ($aFields['cpm']) ? $aFields['cpm']: 0;

            if($aFields['app_type'] == 1 || $aFields['app_type'] == 3){

                OA_Dal_Delivery_query("UPDATE {$table_prefix}affiliates SET comments = '{$app_details}', website = '', affiliate_type = '{$aFields['app_type']}' WHERE affiliateid = {$oPublisher->publisherId} ");
            }else{

                OA_Dal_Delivery_query("UPDATE {$table_prefix}affiliates SET comments = '{$app_details}',affiliate_type = '{$aFields['app_type']}' WHERE affiliateid = {$oPublisher->publisherId} ");
            }
            
            /* CUSTOM FIELD UPDATE END */
        }
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
        OX_Admin_Redirect::redirect($redirectURL);

    }
    return $oPublisherDll;
}

/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($affiliateid, $form, $oPublisherDll = null)
{
    //header and breadcrumbs
    $oHeaderModel = MAX_displayWebsiteBreadcrumbs($affiliateid);
    if ($affiliateid != "") {
        OA_Admin_Menu::setPublisherPageContext($affiliateid, 'affiliate-edit.php');
        addWebsitePageTools($affiliateid);
        phpAds_PageHeader(null, $oHeaderModel);
    }
    else {
        phpAds_PageHeader("affiliate-edit_new", $oHeaderModel);
    }

    //get template and display form
    $oTpl = new OA_Admin_Template('affiliate-edit.html');
    $oTpl->assign('affiliateid', $affiliateid);
    $oTpl->assign('form', $form->serialize());

    if (isset($oPublisherDll)) {
        $oTpl->assign('error',  $oPublisherDll->_errorMessage);
        $oTpl->assign('notice', $oPublisherDll->_noticeMessage);
    }

    $oTpl->assign('showAdDirect', (defined('OA_AD_DIRECT_ENABLED') && OA_AD_DIRECT_ENABLED === true) ? true : false);
    $oTpl->assign('keyAddNew', $keyAddNew);

    $oTpl->display();

    //footer
    phpAds_PageFooter();
}
?>