<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/OX/Plugin/Component.php';
require_once MAX_PATH . '/www/admin/config.php';
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

// Load translation class
$oTranslation = new OX_Translation();

// Create a new option object for displaying the setting's page's HTML form
$oOptions = new OA_Admin_Option('settings');
$prefSection = "viewability-settings";

// This page depends on deliveryCacheStore plugins, so get the required
// information about all such plugins installed in this installation
$aDeliveryCacheStores = OX_Component::getComponents('deliveryCacheStore', null, false);

// This page depends on 3rdPartyServers plugins, so get the required
// information about all such plugins installed in this installation]
$a3rdPartyServers = &OX_Component::getComponents('3rdPartyServers');

// Prepare an array for storing error messages
$aErrormessage = array();

// If the settings page is a submission, deal with the form data
if (isset($_POST['submitok']) && $_POST['submitok'] == 'true') {
    // Prepare an array of the HTML elements to process, and the
    // location to save the values in the settings configuration
    // file
    $aElements = array();
    // Banner Delivery Cache Settings
    $aElements += array(
        'delivery_cacheExpire' => array('delivery' => 'cacheExpire'),
        'delivery_cacheStorePlugin' => array('delivery' => 'cacheStorePlugin')
    );

    // Banner Delivery Settings
    $aElements += array(
        'delivery_acls' => array(
            'delivery' => 'acls',
            'bool'     => true
        ),
        'delivery_aclsDirectSelection' => array(
            'delivery' => 'aclsDirectSelection',
            'bool'     => true
        ),
        'delivery_obfuscate' => array(
            'delivery' => 'obfuscate',
            'bool'     => true
        ),
        'delivery_execPhp' => array(
            'delivery' => 'execPhp',
            'bool'     => true
        ),
        'delivery_ctDelimiter' => array('delivery' => 'ctDelimiter'),
        'defaultBanner_imageUrl' => array('defaultBanner' => 'imageUrl')
    );
    // Invocation Defaults
    $aElements += array(
        'delivery_clicktracking' => array('delivery' => 'clicktracking')
    );
    // Privacy Settings
    $aElements += array(
        'privacy_disableViewerId' => array(
            'privacy'  => 'disableViewerId',
            'bool' => true
        ),
        'privacy_anonymiseIp' => array(
            'privacy'  => 'anonymiseIp',
            'bool' => true
        ),
    );
    // P3P Privacy Policies
    $aElements += array(
        'p3p_policies' => array(
            'p3p'  => 'policies',
            'bool' => true
        ),
        'p3p_compactPolicy'  => array('p3p' => 'compactPolicy'),
        'p3p_policyLocation' => array('p3p' => 'policyLocation')
    );
    // OpenX Server Access Paths
    $aElements += array(
        'webpath_admin' => array(
            'webpath'      => 'admin',
            'preg_match'   => '#/$#',
            'preg_replace' => ''
        ),
        'webpath_delivery' => array(
            'webpath'      => 'delivery',
            'preg_match'   => '#/$#',
            'preg_replace' => ''
        ),
        'webpath_deliverySSL' => array(
            'webpath'      => 'deliverySSL',
            'preg_match'   => '#/$#',
            'preg_replace' => ''
        ),
        'webpath_images' => array(
            'webpath'      => 'images',
            'preg_match'   => '#/$#',
            'preg_replace' => ''
        ),
        'webpath_imagesSSL' => array(
            'webpath'      => 'imagesSSL',
            'preg_match'   => '#/$#',
            'preg_replace' => ''
        )
    );
    // Delivery File Names
    $aElements += array(
        'file_click'           => array('file' => 'click'),
        'file_conversionvars'  => array('file' => 'conversionvars'),
        'file_content'         => array('file' => 'content'),
        'file_conversion'      => array('file' => 'conversion'),
        'file_conversionjs'    => array('file' => 'conversionjs'),
        'file_frame'           => array('file' => 'frame'),
        'file_image'           => array('file' => 'image'),
        'file_js'              => array('file' => 'js'),
        'file_layer'           => array('file' => 'layer'),
        'file_log'             => array('file' => 'log'),
        'file_popup'           => array('file' => 'popup'),
        'file_view'            => array('file' => 'view'),
        'file_xmlrpc'          => array('file' => 'xmlrpc'),
        'file_local'           => array('file' => 'local'),
        'file_frontcontroller' => array('file' => 'frontcontroller'),
        'file_flash'           => array('file' => 'flash'),
        'file_singlepagecall'  => array('file' => 'singlepagecall'),
        'file_spcjs'           => array('file' => 'spcjs')
    );
    // Test the suitability of the cache store type, if required
    MAX_commonRegisterGlobalsArray(array('delivery_cacheStorePlugin'));
    if (isset($delivery_cacheStorePlugin)) {
        // Check for problems in selected delivery store plugin
        $oDeliveryCacheStore = &OX_Component::factoryByComponentIdentifier($delivery_cacheStorePlugin);
        $result = $oDeliveryCacheStore->getStatus();
        if ($result !== true) {
            $aErrormessage[1][] = $oTranslation->translate(
                'ErrorInCacheStorePlugin',
                array($oDeliveryCacheStore->getName())
            );
            foreach ($result as $error) {
                $aErrormessage[1][] = " - ".$error;
            }
        }
    }
    if (empty($aErrormessage)) {
        // Create a new settings object, and save the settings!
        $oSettings = new OA_Admin_Settings();
        $result = $oSettings->processSettingsFromForm($aElements);
        if ($result) {
            // Queue confirmation message
            $setPref = $oOptions->getSettingsPreferences($prefSection);
            $title = $setPref[$prefSection]['name'];
            $translation = new OX_Translation ();
            $translated_message = $translation->translate($GLOBALS['strXSettingsHaveBeenUpdated'],
                array(htmlspecialchars($title)));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

            // The settings configuration file was written correctly,
            // go to the "next" settings page from here
            OX_Admin_Redirect::redirect(basename($_SERVER['SCRIPT_NAME']));
        }
        // Could not write the settings configuration file, store this
        // error message and continue
        $aErrormessage[0][] = $strUnableToWriteConfig;

    }
}

// Set the correct section of the settings pages and display the drop-down menu
$setPref = $oOptions->getSettingsPreferences($prefSection);
$title = $setPref[$prefSection]['name'];

// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('account-settings-index', $oHeaderModel);
if (isset($_POST['submit']))
{
	
	
	
		$keyword = $_POST['lang'];
		$key = $_POST['key'];
		if(!empty($keyword)) {

				$sql = "INSERT INTO {$table_prefix}djax_viewablity_targetting(percentage,seconds) VALUES('".$key."','".$keyword."')";
				OA_Dal_Delivery_query($sql);
		}
	

	$translation = new OX_Translation ();

		$translated_message = $translation->translate ("Viewability Capping Settings has been added");		
	
	OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);			
	header("Location: account-settings-viewability-settings.php");		
	
}

if (isset($_POST['update']))
{
    
		$keyword = $_POST['lang'];
		$key = $_POST['key'];
		if(!empty($keyword)) {

				$sql = "UPDATE {$table_prefix}djax_viewablity_targetting   SET  percentage ='".$key."',seconds='".$keyword."' WHERE  id= '".$_GET['id']."'";
				//print_r($sql);exit;
				OA_Dal_Delivery_query($sql);
		}


		$translation = new OX_Translation ();
		$translated_message = $translation->translate ("Viewability Capping Settings has been Updated");		

	OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);			
	header("Location: account-settings-viewability-settings.php");
}

$counts = OA_Dal_Delivery_query("select  count(*) as count from {$table_prefix}djax_viewablity_targetting");
?>
<style type="text/css">
 .w3-modal{
    z-index:9999;
    display:none;
    padding-top:100px;
    position:fixed;
    left:0;
    top:0;
    width:100%;
    height:100%;
    overflow:auto;
    background-color:rgb(0,0,0);
    background-color:rgba(0,0,0,0.4)
}
 .w3-modal-content{
    margin:auto;
    background-color:#fff;
    position:relative;
    padding:0;
    outline:0;
    width:600px
}
.w3-display-topright{
    position:absolute;
    right:0;
    top:0
}
.w3-btn,.w3-button{
    border:none;
    display:inline-block;
    padding:8px 16px;
    vertical-align:middle;
    overflow:hidden;
    text-decoration:none;
    color:inherit;
    background-color:inherit;
    text-align:center;
    cursor:pointer;
    white-space:nowrap
}

 .w3-container:after,.w3-container:before,.w3-panel:after,.w3-panel:before,.w3-row:after,.w3-row:before,.w3-row-padding:after,.w3-row-padding:before, .w3-cell-row:before,.w3-cell-row:after,.w3-clear:after,.w3-clear:before,.w3-bar:before,.w3-bar:after{
    content:"";
    display:table;
    clear:both
}

 .w3-container,.w3-panel{
    padding:2.01em 16px
}
</style>
 <table width='100%'>
        <tbody><tr>
            <td colspan='4' height='25'>
                <img src='/assets/images/icon-settings.gif' height='16' width='16' align='absmiddle'>&nbsp;
                <b>Viewability Capping Settings</b>
            </td>
        </tr>
        <tr height='1'>
            <td width='30' bgcolor='#888888'><img src='/assets/images/break.gif' height='1' width='30'></td>
            <td width='30' bgcolor='#888888'><img src='/assets/images/break.gif' height='1' width='250'></td>
            <td width='30' bgcolor='#888888'><img src='/assets/images/break.gif' height='1' width='1'></td>
            <td width='30' bgcolor='#888888'><img src='/assets/images/break.gif' height='1' width='30'></td>
        </tr>
        <tr>
         <td colspan='4' height='10'><img src='/assets/images/spacer.gif' height='1' width='30'></td>
        </tr>
</table>
<?php 

$count = OA_Dal_Delivery_fetchAssoc($counts);
if($count[count]==1)
{
    $resKeywords = OA_Dal_Delivery_query("select * from {$table_prefix}djax_viewablity_targetting");
    $rowKeywords = OA_Dal_Delivery_fetchAssoc($resKeywords);
    ?>

    <form action="account-settings-viewability-settings.php?id=<?php echo $rowKeywords['id']; ?>" method='POST'>
    <label>Percentage</label>&nbsp;
    <input type="text" name="key" id="key" value="<?php echo $rowKeywords['percentage']; ?>"/><br/><br/>
    <label>Seconds</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
    <input type="text" name="lang" id="lang" value="<?php echo $rowKeywords['seconds']; ?>" /><br/><br/>

    <input type="submit" value="update" name="update">
</form>
 <?php    
}
else{
?>
<form action="account-settings-viewability-settings.php" method='POST'>
	<label>Percentage </label>&nbsp;
	<input type="text" name="key" id="key" value=""/><br/><br/>
	<label>Seconds</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	<input type="text" name="lang" id="lang"/><br/><br/>
	
	<input type="submit" value="submit" name="submit">
</form>
<?php }






// Display the page footer
phpAds_PageFooter();

?>
