<!doctype html>
<html>
<head>
  <title>Fingerprintjs2 test</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body{
      font-family: sans-serif;
      max-width: 48em;
      margin: auto;
      padding: 0 5%;
      background: #222;
      color: #fff;
    }

    h1 {
      margin: 2em 0 0;
    }

    p {
      font-size: 1.2em
    }

    button {
      border: none;
      color: #fff;
      font-size: 1.2em;
      background: #27e;
      padding: 0.5em 0.75em 0.6em;
      border-radius: 3px;
      box-shadow: 0 3px 0 #05c;
      outline: none;
    }

    button:active {
      transform: translateY(3px);
      box-shadow: none;
    }

    strong {
      display: block;
      letter-spacing: 1px;
      word-wrap: break-word;
    }

    @media (min-width: 32em) {
      h1 {
        font-size: 4em;
      }

      strong {
        font-size: 1.5em;
      }
    }
  </style>
</head>
<body>
  <div id="container"></div>

  <h1>Fingerprintjs2</h1>
  <a href="https://github.com/Valve/fingerprintjs2"><img style="position: absolute; top: 0; right: 0; border: 0;" src="https://camo.githubusercontent.com/365986a132ccd6a44c23a9169022c0b5c890c387/68747470733a2f2f73332e616d617a6f6e6177732e636f6d2f6769746875622f726962626f6e732f666f726b6d655f72696768745f7265645f6161303030302e706e67" alt="Fork me on GitHub" data-canonical-src="https://s3.amazonaws.com/github/ribbons/forkme_right_red_aa0000.png"></a>
  
  <button type="button" id="btn">Get my fingerprint</button>
  <p>Your browser fingerprint: <strong id="fp"></strong></p>
  <p>Time took to calculate the fingerprint: <var id="time"></var> ms</p>
  <p><strong>Detailed information: </strong></p>
  <pre id="details"></pre>

  <script src="fingerprint2.js"></script>
  <script>
    var hasConsole = typeof console !== "undefined"

    var fingerprintReport = function () {
      var d1 = new Date()
      Fingerprint2.get(function(components) {
        var murmur = Fingerprint2.x64hash128(components.map(function (pair) { return pair.value }).join(), 31)
        var d2 = new Date()
        var time = d2 - d1
        document.querySelector("#time").textContent = time
        document.querySelector("#fp").textContent = murmur
        var details = ""
        if(hasConsole) {
          console.log("time", time)
          console.log("fingerprint hash", murmur)
        }
        for (var index in components) {
          var obj = components[index]
          var line = obj.key + " = " + String(obj.value).substr(0, 100)
          if (hasConsole) {
            console.log(line)
          }
          details += line + "\n"
        }
        document.querySelector("#details").textContent = details
      })
    }

    var cancelId
    var cancelFunction
    
    // see usage note in the README
    if (window.requestIdleCallback) {
      cancelId = requestIdleCallback(fingerprintReport)
      cancelFunction = cancelIdleCallback
    } else {
      cancelId = setTimeout(fingerprintReport, 500)
      cancelFunction = clearTimeout
    }

    document.querySelector("#btn").addEventListener("click", function () {
      if (cancelId) {
        cancelFunction(cancelId)
        cancelId = undefined
      }
      fingerprintReport()
    })
  </script>
</body>
</html>
