<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

use Sinergi\BrowserDetector\Browser;

/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's browser.
 *
 * Works with:
 * A comma separated list of valid browser codes. See the phpSniff.class.php
 * file for details of the valid browser codes.
 *
 * Valid comparison operators:
 * =~, !~
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Client_Screensize extends Plugins_DeliveryLimitations_CommaSeparatedData
{
protected static $aScreens = [];
  /*  protected static $aScreens = [
        '1366x768' => '1366x768',
        '1920x1080' => '1920x1080',
        '360x640' => '360x640',
        '360x640' => '360x640',
        '1440x900' => '1440x900',
        '1280x1024' => '1280x1024',
        '320x480' => '320x480',
        '1600x900' => '1600x900',
        '768x1024' => '768x1024',
        '1024x768' => '1024x768',
        '1680x1050' => '1680x1050',
        '360x640' => '360x640',
        '1920x1200' => '1920x1200',
        '720x1280' => '720x1280',
        '320x568' => '320x568',
        '1360x768' => '1360x768',
        '1280x720' => '1280x720',
     
    ];*/

    function __construct()
    {
        parent::__construct();
        $this->nameEnglish = 'Client - Screen-size';
    }

    /**
     * Outputs the HTML to display the data for this limitation
     *
     * @return void
     */
    function displayArrayData()
    {
        $tabindex =& $GLOBALS['tabindex'];
	
if (!function_exists('OA_Dal_Delivery_connect')) {
		
if(isset($GLOBALS['_MAX']['CONF']['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($GLOBALS['_MAX']['CONF']['origin']['type']) . '.php')) {
require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($GLOBALS['_MAX']['CONF']['origin']['type']) . '.php');
} else {
require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($GLOBALS['_MAX']['CONF']['database']['type']) . '.php');
}
}
   $i = 0;

		echo "<table cellpadding='3' cellspacing='3'>";
$getdet = OA_Dal_Delivery_query("Select width,height from rv_screensize ");
while($getdetrow = OA_Dal_Delivery_fetchAssoc($getdet))
{
	$key = $getdetrow['width'].'x'.$getdetrow['height'];
	$value = $getdetrow['width'].'x'.$getdetrow['height'];
	
           $value = htmlspecialchars($value, ENT_QUOTES);
          
			if ($i % 4 == 0) echo "<tr>";
			echo "<td><input type='checkbox' name='acl[{$this->executionorder}][data][]' value='$key'".(in_array($key, $this->data) ? ' checked="checked"' : '')." tabindex='".($tabindex++)."'>".$value."</td>";
			if (($i + 1) % 4 == 0) echo "</tr>";
			$i++;
		}
		if (($i + 1) % 4 != 0) echo "</tr>";
		echo "</table>";
    }

}
