<?php

require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

class Plugins_BannerTypeHTML_pushNotification_pushNotification extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
	 
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
	 
    function getOptionDescription()
    {
        return $this->translate("Push Notification");
    }

    function validateForm(&$form)
    {
        return true;
    }


	function processForm($insert, $bannerid, $aFields)
    {
    }
	 
	
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {

		$aFields['type'] = 'web';
		$aBanner['storagetype'] = 'web'	;
		
		if (!empty($_FILES['upload']) && $_FILES['upload']['size'] > 0) 
		{ //TODO refactor upload to be a valid quickform elem
				$oFile = OA_Creative_File::factoryUploadedFile('upload');
				checkForErrorFileUploaded($oFile);
				$oFile->store($aFields['type']);
				$aFile = $oFile->getFileDetails();

				if (!empty($aFile)) {
					$aVariables['filename']      = $aFile['filename'];
					$aVariables['contenttype']   = 'png';
				}

				$aVariables['width']         = $aFile['width'];
				$aVariables['height']        = $aFile['height'];
				$aVariables['pluginversion'] = $aFile['pluginversion'];
				$editSwf                     = $aFile['editswf'];

				// Delete old file for this banner
				if (!empty($aBanner['filename']) && ($aBanner['filename'] != $aFile['filename'])) {
					DataObjects_Banners::deleteBannerFile($aBanner['storagetype'], $aBanner['filename']);
				}
		}
			
			
		$prm = array();
		$prm['title'] = $aFields['push_noti_title'];
		$prm['description'] = $aFields['push_noti_description'];
		
		$aVariables['parameters'] = serialize($prm);
		
			$doBanners = OA_Dal::factoryDO('banners');
			// Get existing banner details
		if (!empty($bannerid)) 
		{
			if ($doBanners->get($bannerid)) 
			{
				$aBanner = $doBanners->toArray();
			}
		}
		
		
		$doBanners->setFrom($aVariables);			
		$doBanners->update();
		
		
		return true;
		
		
    }
    
	
    function buildForm(&$form, &$aBanner)
    {
		
		$prm = ($aBanner['parameters']) ? unserialize($aBanner['parameters']) : array() ;
		$aBanner['push_noti_title'] = (isset($prm['title'])) ? $prm['title'] : '';
		$aBanner['push_noti_description'] = (isset($prm['description'])) ? $prm['description'] : '';
			
			
		$header = $form->createElement('header', 'header_psuh', "Push notification Details");
        $form->addElement($header);
         
		$form->addElement('text', 'push_noti_title', 'Title');
		$form->addRule('push_noti_title', 'Title is required', 'required');
		
		$imageName = _getContentTypeIconImageName($aBanner['contenttype']);
        $size = _getBannerSizeText("web", $aBanner['filename']);

        addUploadGroup($form, $aBanner,
            array(
                'uploadName' => 'upload',
                'radioName' => 'replaceimage',
                'imageName'  => $imageName,
                'fileName'  => $aBanner['filename'],
                'fileSize'  => $size,
                'newLabel'  => $GLOBALS['strNewBannerFile'],
                'updateLabel'  => $GLOBALS['strUploadOrKeep'],
                'handleSWF' => true
              )
        );
        
        $form->addElement('text', 'url', 'Destination URL  (incl. http://)');


          if (!empty($aBanner['bannerid']))
          {
            $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
            $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
            $sizeG['width']->setSize(5);

            $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
            $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
            $sizeG['height']->setSize(5);
            $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);

            //validation rules
            $translation = new OX_Translation();
            $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
            $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
            $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
            $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
            $numericRule = array($GLOBALS['strNumericField'] , 'numeric');

            $form->addGroupRule('size', array(
                'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
                'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));
		  }

		$form->addElement('textarea', 'push_noti_description', 'Description');
  		$form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());

    }


	
}
