<?php

require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/common.php';



class Plugins_BannerTypeHTML_popUnder_popUnder extends Plugins_BannerTypeHTML
{
    
    
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
    
    function getStorageType()
    {
        return 'html';
    }
     
    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
    
    function getOptionDescription()
    {
        return $this->translate("Pop Under Ad");
    }
    
    function validateForm(&$form)
    {
        return true;
    }
    
    function processForm($insert, $bannerid, $aFields)
    {
		
		
		
	    
    }
    
    
    
    
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
		$prm = array();
		$prm['video_url'] = $aFields['video_url'];
		$aVariables['parameters'] = serialize($prm);
		
	}
    
   
    
    function buildForm(&$form, &$bannerRow)
    { 
        if ($form->isSubmitted()) {
            $form->addElement('html', 'video_form_error', VideoAdsHelper::getWarningMessage('Validation failed!'));
        }
        
        
        $prm = ($bannerRow['parameters']) ? unserialize($bannerRow['parameters']) : array() ;
		$bannerRow['video_url'] = (isset($prm['video_url'])) ? $prm['video_url'] : '';
		
        
        $header = $form->createElement('header', 'header_txt', "Pop Under Banner Specifications");
        $header->setAttribute('icon', 'icon-banner-text.gif');
        $form->addElement($header);
        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());      
		$this->addFormRequiredElement($form, array('text', 'video_url', "Pop Under Url"));	                 
        
    }

    
    function getLabelWithRequiredStar($label)
    {
        return $label . ' <font color="red">*</font>';
    }
    function setElementIsRequired($fieldName, $fieldNameWhenRequired, $fieldValueWhenRequired)
    {
        $this->requiredElement[] = array(
            $fieldName,
            $fieldNameWhenRequired,
            $fieldValueWhenRequired
        );
    }
    function addFormRequiredElement(&$form, $element, $fieldNameWhenRequired = null, $fieldValueWhenRequired = null)
    {
        // add the red star in the name
        $element[2] = $this->getLabelWithRequiredStar($element[2]);
        
        // we do not add the element as "required" in the form, as we need to test which fields
        // are required depending on overlay types, video delivery types, etc.
        call_user_func_array(array(
            $form,
            'addElement'
        ), $element);
        
        $fieldName = $element[1];
        $this->setElementIsRequired($fieldName, $fieldNameWhenRequired, $fieldValueWhenRequired);
    }
    
    
    
    function checkForErrorFileUploaded($oFile)
    {
        if (PEAR::isError($oFile)) {
            die('here');
            
            phpAds_PageHeader(1);
            phpAds_Die($GLOBALS['strErrorOccurred'], htmlspecialchars($oFile->getMessage()) . "<br>Please make sure you selected a valid file.");
        }
    }
    
    
    function _getContentTypeIconImageName($contentType)
    {
        $imageName = '';
        if (empty($contentType)) {
            return $imageName;
        }
        
        switch ($contentType) {
            case 'swf':
            case 'dcr':
                $imageName = 'icon-filetype-swf.gif';
                break;
            case 'jpeg':
                $imageName = 'icon-filetype-jpg.gif';
                break;
            case 'gif':
                $imageName = 'icon-filetype-gif.gif';
                break;
            case 'png':
                $imageName = 'icon-filetype-png.gif';
                break;
            case 'rpm':
                $imageName = 'icon-filetype-rpm.gif';
                break;
            case 'mov':
                $imageName = 'icon-filetype-mov.gif';
                break;
            default:
                $imageName = 'icon-banner-stored.gif';
                break;
        }
        
        return $imageName;
    }
    
    
    function _getBannerSizeText($type, $filename)
    {
        $size = phpAds_ImageSize($type, $filename);
        if (round($size / 1024) == 0) {
            $size = $size . " bytes";
        } else {
            $size = round($size / 1024) . " Kb";
        }
        
        return $size;
    }
    
}
?>
