<?php

require_once LIB_PATH . '/Extension/deliveryLog/BucketProcessingStrategyFactory.php';
require_once LIB_PATH . '/Extension/deliveryLog/DeliveryLog.php';

class Plugins_DeliveryLog_OxLogSite_LogClickSite extends Plugins_DeliveryLog
{

    public function getDependencies()
    {
        return array(
            'deliveryLog:oxLogSite:logClickSite' => array(
                'deliveryDataPrepare:oxDeliveryDataPrepare:dataCommon',
                'deliveryDataPrepare:oxDeliverySite:dataSite',
            ),
        );
    }

    public function getBucketName()
    {
        return 'data_bkt_site_c';
    }

    public function getBucketTableColumns()
    {
        $aColumns = array(
            'interval_start' => self::TIMESTAMP_WITHOUT_ZONE,
            'creative_id'    => self::INTEGER,
            'zone_id'        => self::INTEGER,           
            'variable'       => self::CHAR, 
             'value'       => self::CHAR,             
            'count'          => self::INTEGER
        );
        return $aColumns;
    }

    public function getStatisticsName()
    {
        return 'stats_site';
    }

    public function getStatisticsMigration()
    {
        $aMap = array(
            'method'           => 'aggregate',
            'bucketTable'      => $this->getBucketTableName(),
            'dateTimeColumn'   => 'interval_start',
            'groupSource'      => array(
                0 => 'interval_start',
                1 => 'creative_id',
                2 => 'zone_id',
                3 => 'variable',
                4 => 'value',
              

            ),
            'groupDestination' => array(
                0 => 'date_time',
                1 => 'creative_id',
                2 => 'zone_id',
                3 => 'variable',
                   4 => 'value',
              
            ),
            'sumSource'        => array(
                0 => 'count',
            ),
            'sumDestination'   => array(
                0 => 'clicks',
            ),
            'sumDefault'       => array(
                0 => 0,
            ),
        );
        return $aMap;
    }

}
