<?php

/**
 * @package    OpenXPlugin
 * @subpackage InvocationTags
 * @author     Radek Maciaszek <radek@m3.net>
 *
 */

require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_vmapinline extends Plugins_InvocationTags
{

    /**
     * Return name of plugin
     *
     * @return string
     */
    function getName()
    {
        return $this->translate("VMAP Video Tag");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    function getNameEN()
    {
        return 'VMAP Video Tag';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    function isAllowed($extra)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    function getOrder()
    {
        parent::getOrder();
        return 30;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
         $options = array (
            'limit'         => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
	    
            'withoutplayer'	=> MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'adposition'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD
        );

        return $options;

    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    function generateInvocationCode()
    {
        $aComments = array(
            'SSL Delivery Comment' => '',
            'Comment'              => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
            );
        parent::prepareCommonInvocationData($aComments);

	
	/*vmap*/
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    
    //print_r($protocol);die();
       
    $conf = $GLOBALS['_MAX']['CONF'];
    $mi = &$this->maxInvocation;
	$zoneid=$mi->zoneid;
	if ($GLOBALS['_MAX']['SSL_REQUEST']) {
					$djprotocol='https://';
					}
					else
					{
					$djprotocol='http://';
					}
	$way=$djprotocol.$conf['webpath']['deliverVastUrl'];
	
	//print_r($way);die();
	$vtype='preroll';
	
	if($mi->adposition==1)
	{
		$vtype='preroll';
	}
	else if($mi->adposition==2)	
	{
		$vtype='midroll';
	}
	else if($mi->adposition==3)	
	{
		$vtype='postroll';
	}
	else
	{
		$vtype='postroll';
	}
	
	
	$playurl =$_POST['withoutplayer'];
	//print_r($playurl);die();
	if(isset($mi->loc) && $mi->loc !== '') 
	    {
		  $loc = $mi->loc;
	    } 
	    if(isset($mi->limit) && $mi->limit !== '') 
	    {
		  $limit = $mi->limit;
	    } 
        
        $playerurl=$mi->withoutplayer;
        
	if(!empty($mi->withoutplayer))
	{
		$buffer .= $way."/fc.php?script=rmVideo&zoneid=$zoneid&type=$vtype&format=vmap&limit=$limit";
	}
	else
	{
        $buffer .= $way."/fc.php?script=rmVideo&zoneid=$zoneid&type=$vtype&format=vmap&limit=$limit";
	}

        return $buffer;
    }

    function setInvocation(&$invocation) {

        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;
        
        if(!empty($_POST['withoutplayer'])) :

			$this->maxInvocation->loc = $_POST['withoutplayer'];
			$this->maxInvocation->display = 2;
		endif;

		if(!$this->maxInvocation->loc) {
			$this->maxInvocation->loc = "location.protocol+window.location.hostname";
		}

    }

}

?>
