<?php
/*
 *    Copyright (c) 2009 Bouncing Minds - Option 3 Ventures Limited
 *
 *    This file is part of the Regions plug-in for Flowplayer.
 *
 *    The Regions plug-in is free software: you can redistribute it
 *    and/or modify it under the terms of the GNU General Public License
 *    as published by the Free Software Foundation, either version 3 of
 *    the License, or (at your option) any later version.
 *
 *    The Regions plug-in is distributed in the hope that it will be
 *    useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with the plug-in.  If not, see <http://www.gnu.org/licenses/>.
 */
require_once RV_PATH . '/lib/RV.php';

//~ require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/common.php';
//~ require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/commonAdmin.php';
require_once MAX_PATH . '/lib/OA.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';

/**
 * @package    OpenXPlugin
 * @subpackage Plugins_BannerTypes
 */
class Plugins_BannerTypeHTML_vmapBannerTypeHtml_vmap extends Plugins_BannerTypeHTML
{
    function getBannerShortName()
    {
        return 'VMAP video ad';
    }

    function getZoneToLinkShortName()
    {
        return $this->getBannerShortName();
    }

    /**
     * Return description of banner type
     * for the dropdown selection on the banner-edit screen
     *
     * @return string A string describing the type of plugin.
     */
    function getOptionDescription()
    {
        return $this->getBannerShortName();
    }

   


function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
       
       
        $aVastVariables = array();
        $aVastVariables['banner_vast_element_id'] = $aFields['banner_vast_element_id'];
        $aVastVariables['vast_video_delivery'] = 'vmap';
       
			$aVastVariables['width'] = -3;
			$aVastVariables['height'] = -3;
		
        
		$aVastVariables['vmapcount'] = $aFields['vmapcount'];
		$aVastVariables['vmapobjects'] = json_encode($_POST); 
        $aVariables['parameters'] = serialize($aVastVariables);
        $aVariables = array_merge($aVariables, $aVastVariables);
    
        
        return true;
    }
    
       
    
     function processForm($insert, $bannerid, &$aFields, &$aVariables)
    {
                
                $doBanners = OA_Dal::factoryDO('djaxbanner_vast_element');
				$rowId = $aFields['banner_vast_element_id'];
                $doBanners->vast_video_delivery =  'vmap';
                $doBanners->singlerow =  'singlerow';
                $doBanners->vmapcount            = ($aVariables['vmapcount']!="") ? $aVariables['vmapcount']+1 : 1 ;
				$doBanners->vmapobjects          = $aVariables['vmapobjects'];
                
                        
                if ( !$insert && ($rowId == 'banner_vast_element_id') )
                {
           				$insert = true;
				}
				
				if ($insert)
				{        
            		$doBanners->banner_id = $bannerid;
					$djax_insert=$doBanners->insert();
					
					return true;
				}
				else
				{
					$doBanners->whereAdd('banner_vast_element_id='. (int)$rowId, 'AND');
					return $doBanners->update(DB_DATAOBJECT_WHEREADD_ONLY);

				}
    }




    function buildForm(&$form, &$bannerRow)
    {
		
			$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
			$banner_id = $bannerRow['bannerid'];
			$azones = $this->getSuitableZones();
			
		
			
			
			$form->addElement('hidden', 'banner_vast_element_id', "banner_vast_element_id");
			$header = $form->createElement('header', 'header_txt', "Create VMAP Video Ad");
						$header->setAttribute('icon', 'icon-banner-text.gif');
						$form->addElement($header);
						$form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());
	
	
	
			$tempQuery= OA_Dal_Delivery_query("SELECT d.* FROM {$table_prefix}banners b LEFT JOIN {$table_prefix}djaxbanner_vast_element d ON b.bannerid = d.banner_id WHERE b.ext_bannertype = '".$bannerRow['ext_bannertype']."'
			AND b.bannerid = ".$bannerRow['bannerid']."");
	
	
	
	
				if(OA_Dal_Delivery_numRows($tempQuery)>0)
				{
					$row=OA_Dal_Delivery_fetchAssoc($tempQuery);
					$bannerRow['banner_vast_element_id'] = $row['banner_vast_element_id'];
					$vmapcount1  = $row['vmapcount'];
					$vmap_obj = $row['vmapobjects'];
					$vmapobjects  = json_decode($row['vmapobjects'],true);
				
					$someObject = json_decode($row['vmapobjects']);
					$temp_vmap=array_values($vmapobjects['vmap']);
					$temp_zone=array_values($vmapobjects['zoneid']);
					$temp_breaktype = array_values($vmapobjects['breaktype']);
					$temp_allowmultipleAds = array_values($vmapobjects['allowmultipleAds']);
					$temp_vmapoffsetadbreak = array_values($vmapobjects['vmap_offset_adbreak']);
					$temp_offsetsetting   = array_values($vmapobjects['offsetsetting']);
					$temp_vmapurl = array_values($vmapobjects['vmapurl']);
					$temp_adbreak   = array_values($vmapobjects['adbreak']);
					
					$a = array_keys($vmapobjects['vmapurl']);
					$j = 0;
					
					
					
						//~ if($vmapobjects['repeatafter'][$j] == 1)
						//~ {
								//~ // repeat after

							//~ $checkedrepeatafter ='checked';
							//~ $checkrepeat = $form->createElement('checkbox','repeatafter[0]', 'Repeat After');
							//~ $checkrepeat->setAttribute('class','repeatafter'); 
							//~ $checkrepeat-> setAttribute('id','repeatafter_0');
							//~ $checkrepeat->setAttribute($checkedrepeatafter,$checkedrepeatafter); 
							//~ $checkrepeat->setAttribute('onClick','VmapRepeatafter(this)'); 
							
							//~ $form->addElement($checkrepeat);
							
							//~ //repeat after time
							//~ $repeataftertime = $form->createElement('text','repeataftertime[0]','Repeat After time ',array('value'=>$vmapobjects['repeataftertime'][$j]));
							//~ $repeataftertime->setAttribute('class','repeataftertime');
							//~ $repeataftertime->setAttribute('id','repeataftertime_0');
							//~ $repeataftertime->setAttribute('onchange','validaterepeatafter(this);');
							//~ $form->addElement($repeataftertime);
						//~ }
						//~ else
						//~ {
								//~ // repeat after

							//~ $checkedrepeatafter = '';
							//~ $checkrepeat = $form->createElement('checkbox','repeatafter[0]', 'Repeat After');
							//~ $checkrepeat->setAttribute('class','repeatafter'); 
							//~ $checkrepeat-> setAttribute('id','repeatafter_0');
							//~ $checkrepeat->setAttribute($checkedrepeatafter,$checkedrepeatafter); 
							//~ $checkrepeat->setAttribute('onClick','VmapRepeatafter(this);'); 
							
							//~ $form->addElement($checkrepeat);
							
							//~ //repeat after time
							//~ $repeataftertime = $form->createElement('text','repeataftertime[0]','Repeat After time ',array('value'=>''));
							//~ $repeataftertime->setAttribute('class','repeataftertime');
							//~ $repeataftertime->setAttribute('id','repeataftertime_0');
							//~ $repeataftertime->setAttribute('onchange','validaterepeatafter(this);');
							//~ $form->addElement($repeataftertime);
						//~ }
						
						
						
						
						if($vmapobjects['offsetsetting'][0] == 'time')
						{
							 $selectiontime= 'checked=checked';
							 $offsetlable = 'Time';
						}
						else
						{
							$selectiontime= '';
						}	
						
						

						$offset[] = $form->createElement('radio', 'offsetsetting[0]','',"Time",'time',array('id' => 'time_0','class'=>'time',$selectiontime,'onClick' => 'vmaptime(this.id)'));
									
						if($vmapobjects['offsetsetting'][0] == 'percentage')
						{
							$selectionpercentage= 'checked=checked';
							$offsetlable = 'Percentage';
						}
						else
						{
							$selectionpercentage= '';
						}	
				
						$offset[] = $form->createElement('radio', 'offsetsetting[0]','', "Percentage",'percentage',array('id' => 'percentage_0',$selectionpercentage,'class'=>'percentage','onClick' => 'vmaptime(this.id)'));
						$form->addGroup($offset, 'Offset', 'Offset', "<br/>");

						
						for($j=0;$j<count($a);$j++)
						{
								
							$offset = '';
							$breaktype = [];
						
							// multile ads
							$checkmultiple = $form->createElement('checkbox','allowmultipleAds['.$j.']', 'Allow Mulitple ads');
							$checkmultiple->setAttribute('class','allowmultipleAds'); 
							$checkmultiple-> setAttribute('id','allowmultipleAds_'.$j);
								
								if(ISSET($vmapobjects['allowmultipleAds'][$a[$j]]) && $vmapobjects['allowmultipleAds'][$a[$j]] == 1)
								{
									$checkmultiple->setAttribute('checked','checked');
								}
								else
								{
									$checkmultiple->setAttribute('','');
								}	
						
							$form->addElement($checkmultiple);
						
								// ad breaks url options
						
								if($vmapobjects['vmapurl'][$a[$j]] == 'Internal')
								{
									$selectioninternal= 'checked=checked';
								}
								else
								{
										$selectioninternal= '';
								}
						
							$breaktype['linear1'] = $form->createElement('radio', 'vmapurl['.$j.']', '',"Internal",'Internal', array('id' => 'internal_'.$j,'class'=>'Internal',$selectioninternal,'onClick' => 'vmapinternal(this.id);'));
						
								if($vmapobjects['vmapurl'][$a[$j]] == 'External')
								{
									$selectionexternal= 'checked=checked';
								}
								else
								{
									$selectionexternal= '';
								}	
									
									
							$breaktype['nonlinear1'] = $form->createElement('radio', 'vmapurl['.$j.']', '', "External",'External', array('id' => 'non-linear_'.$j,'class'=>'External',$selectionexternal,'onClick' => 'vmapexternal(this.id);'));
							$form->addGroup($breaktype, 'overlaycount', 'Ad tags', "<br/>");
						
								if($vmapobjects['vmapurl'][$a[$j]] == 'External')
								{
									$externalurl = $form->createElement('text','adbreak['.$j.']','Ad break',array('value'=>$vmapobjects['adbreak'][$a[$j]]));
									$externalurl->setAttribute('class','adbreak');
									$externalurl->setAttribute('id','adbreak_'.$j);
									$form->addElement($externalurl);
								}
						
						
								// vmap zone id 
								if($vmapobjects['vmapurl'][$a[$j]] == 'Internal')
								{
										$aSettings =$form->createElement('select','zoneid['.$j.']','Zone id', array ('items'   => $azones));
										$aSettings->setAttribute('class','zoneid');
										$aSettings->setAttribute('id','zoneid_'.$j);
										$aSettings->setValue($vmapobjects['zoneid'][$a[$j]]);
										$form->addElement($aSettings);
								}
													
								if($vmapobjects['offsetsetting'][$a[$j]] == 'time')
								{
									$selectiontime= 'checked=checked';
								
								}
								else
								{
									$selectiontime= '';
								}	
								
							$offset =array();
							$offset = $form->createElement('radio', 'offsetsetting['.$j.']','',"Time",'time',array('id' => 'time_'.$j,'class'=>'time',$selectiontime,'onClick' => 'vmaptime(this.id)'));
									
								if($vmapobjects['offsetsetting'][$a[$j]] == 'percentage')
								{
									$selectionpercentage= 'checked=checked';
								}
								else
								{
									$selectionpercentage= '';
								}	

							// offset timimg 
							$offsettime = $form->createElement('text','vmap_offset_adbreak['.$j.']','Offset '.$offsetlable,array('value'=>$vmapobjects['vmap_offset_adbreak'][$a[$j]]));
							$offsettime->setAttribute('class','offset');
							$offsettime->setAttribute('id','offset_'.$j); 
							$offsettime->setAttribute('onchange','validateHhMm(this);');
							$form->addElement($offsettime);
						
								if($j > 0)
								{
									$bSettings = $form->createElement('submit', '', 'Remove', array('id' => 'remove_'.$j,'class'=>'remove','onClick' => 'return vmapRemove(this.id)','type'=>'button'));
									$form->addElement($bSettings);
									$form->addGroup($overlayvmapFormats, 'overlaycount', '', "<br/>");
								}

						}
				
					// foreach close

					// vmap count 
				
					$vmapcount = $form->createElement('hidden','vmapcount','0');
					$vmapcount->setAttribute('class','vmapcount');
					$vmapcount->setAttribute('id','vmapcount');
					$vmapcount->setAttribute('value',$vmapcount1 - 1);
					$form->addElement($vmapcount);
					
					$overlayvmapFormats[] = $form->createElement('button', '', 'ADD', array('id' => 'vast-overlay-format-vmapcount2','onClick' => 'phpAds_formOverlayIsVmapCount2();','value' => 'ADD','name' => 'find'));
					$form->setDefaults(array('vmap_overlay_count' => $overlayVmapValue));
					$form->addGroup($overlayvmapFormats, 'overlaycount', '', "<br/>");
				
				}
				else
				{

						

						//~ $checkrepeatinline = $form->createElement('checkbox','repeatafter[0]', 'Repeat After');
						//~ $checkrepeatinline->setAttribute('class','repeatafter_0'); 
						//~ $checkrepeatinline-> setAttribute('id','repeatafter_0');
						//~ $checkrepeatinline->setAttribute($checked,$checked); 
						//~ $checkrepeatinline->setAttribute('onClick','VmapRepeatafter(this);'); 
						//~ $form->addElement($checkrepeatinline);
	
						//~ $repeataftertime = $form->createElement('text','repeataftertime[0]','Repeat After time ',array('value'=>$antifraud_imp['imp_num'] ));
						//~ $repeataftertime->setAttribute('class','repeataftertime_0');
						//~ $repeataftertime->setAttribute('id','repeataftertime_0');
						//~ $repeataftertime->setAttribute('onchange','validaterepeatafter(this);');
						//~ $form->addElement($repeataftertime);
	
							
						// offset timing 
						
						$offset[] = $form->createElement('radio', 'offsetsetting[0]','',"Time",'time',array('id' => 'time_0','class'=>'time','onClick' => 'vmaptime(this.id);'));
						$offset[] = $form->createElement('radio', 'offsetsetting[0]','', "Percentage",'percentage',array('id' => 'percentage_0','class'=>'percentage','onClick' => 'vmaptime(this.id);'));
						$form->addGroup($offset, 'Offset', 'Offset', "<br/>");
		
					   // multile ads
						$checked='';
						$checkmultiple = $form->createElement('checkbox','allowmultipleAds[0]', 'Allow Mulitple ads');
						$checkmultiple->setAttribute('class','allowmultipleAds'); 
						$checkmultiple-> setAttribute('id','allowmultipleAds_0');
						$checkmultiple->setAttribute($checked,$checked); 
						$form->addElement($checkmultiple);
	
	
						// ad breaks url options
						$vmapurl[] = $form->createElement('radio', 'vmapurl[0]','',"Internal",'Internal',array('id' => 'internal_0','class'=>'internal','onClick' => 'vmapinternal(this.id);'));
						$vmapurl[] = $form->createElement('radio', 'vmapurl[0]','', "External",'External',array('id' => 'external_0','class'=>'external','onClick' => 'vmapexternal(this.id);'));
   
						$form->addGroup($vmapurl, 'Ad break', 'Ad Tags', "<br/>");
					
						$offsettime = $form->createElement('text','vmap_offset_adbreak[0]','offset Time',array('value'=>$antifraud_imp['resettime'] ));
						$offsettime->setAttribute('class','offset');
						$offsettime->setAttribute('id','offset_0');
						$offsettime->setAttribute('onchange','validateHhMm(this);');
						$form->addElement($offsettime);
	
						// vmap count 
						$vmapcount = $form->createElement('hidden','vmapcount','0');
						$vmapcount->setAttribute('class','vmapcount');
						$vmapcount->setAttribute('id','vmapcount');
						$form->addElement($vmapcount);
						
						$overlayvmapFormats[] = $form->createElement('button', '', 'ADD', array('id' => 'vast-overlay-format-vmapcount2','onClick' => 'phpAds_formOverlayIsVmapCount2();','value' => 'ADD','name' => 'find'));
						$form->setDefaults(array('vmapcount' => $overlayVmapValue));
						$form->addGroup($overlayvmapFormats, 'overlaycount', '', "<br/>");
	
	
				}
	
				$script = $this->getJsScript($bannerRow,$azones);
				$form->addElement('html','script_1', $script);
	
	
    }



	function getSuitableZones()
	{
		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	
		$tempQuery1= OA_Dal_Delivery_query("SELECT a.zoneid, a.delivery, b.vmapcount,b.vast_video_delivery, b.vast_overlay_format
											FROM {$table_prefix}zones AS a, {$table_prefix}djaxbanner_vast_element AS b, {$table_prefix}ad_zone_assoc AS c
											WHERE a.zoneid = c.zone_id
											AND b.banner_id = c.ad_id
											AND a.delivery
											IN ( 7, 6 )
											AND b.vast_video_delivery != 'vmap'
											GROUP BY a.zoneid");
		$azones = array();
		
			if(OA_Dal_Delivery_numRows($tempQuery1)>0)
			{
				$azones[0]	=	'Select';
				while($aRow	=	OA_Dal_Delivery_fetchAssoc($tempQuery1))
				{
					$azones[$aRow['zoneid']]	=	$aRow['zoneid'];
				}
			}
		
		return $azones;
			
	}






function getJsScript($bannerRow,$zones)
{
	
	$bannerid = $bannerRow['bannerid'];
	
		$azoneinline  = json_encode($zones); 
		
	
	$html_1 = <<<EOD

	<script>
	function VmapRepeatafter(t)
	{
		  if ($("#repeatafter_0").is(':checked') == true) {

                $("#repeataftertime_0").parent().parent().show();
                
                $("label[for=repeataftertime_0]").parent().parent().show();
                $(".offset").parent().parent().hide();
                $(".time").parent().parent().hide();
                $("label[for=offset_0]").hide();
                $("#time0").parent().parent().hide();
                $(".offsetall").hide();
                $("#repeataftertime_0").parent().parent().show();
                var count= $("input[name='vmapcount']").val();
                
                $(".time").prop('checked', false);
                $(".percentage").prop('checked', false);
                $(".start").prop('checked', false);
                $(".end").prop('checked', false);

            } else {
                $("#repeataftertime_0").parent().parent().hide();
                $("label[for=repeataftertime_0]").parent().parent().hide();
                $("#offset_0").show();
                $("label[for=offset_0]").show();
                $("#time_0").parent().parent().show();
                $(".offsetall").show();
                //~ $(".offset").parent().parent().hide();
                $(".time").parent().parent().show();
                $("#repeataftertime_0").parent().parent().hide();
            }
	}
	
	
	
<!-- for vmap time ,percentage,start and end-->
function vmaptime(idd){
	var count = idd.split('_');
	var timeid = count[count.length-1];
	
	if(idd == 'percentage_0')
	{
	$(".offset").parent().prev().children().html("Offset Percentage");
	}
   else
   {
   $(".offset").parent().prev().children().html("Offset Time");
   }
	
	
	$(".offset").parent().parent().show();
	

	//~ $("#offset_"+timeid).parent().parent().show();
	//~ $("#offset_"+timeid).show();
    //~ $("label[for=offset_"+timeid+"]").show();
	

}


<!-- vmap remove-->

function vmapRemove(iddd){

	
	var count = iddd.split('_');
	var removeid = count[count.length-1];
	//alert(removeid);
	
	if($("#remove_"+removeid).parent().parent().parent().next().attr('class') == 'spacer'){
	
		$("#remove_"+removeid).parent().parent().parent().next().attr('class').remove();
	
	}

	$("#remove_"+removeid).parent().parent().remove();
	
	$("#allowmultipleAds_"+removeid).parent().parent().remove();

	$("#adbreak_tag_"+removeid).parent().parent().remove();

	$("#linear_"+removeid).parent().parent().remove();

	$("#time_"+removeid).parent().parent().remove();
	
	$("#offset_"+removeid).parent().parent().remove();
	
	$("#zoneid_"+removeid).parent().parent().remove();
	$("#adbreak_"+removeid).parent().parent().remove();
	$("#internal_"+removeid).parent().parent().remove();
	$(".spacer_"+removeid).remove();
	
	
	var c = $("#vmapcount").val();
	c =c-1;
	$("#vmapcount").val(c);

	
}





function vmapexternal(idd){


	var countexternal = idd.split('_');
	var externalid = countexternal[countexternal.length-1];
	
	
	if(!($("#adbreak_"+externalid).length))
	{
	
	$("#zoneid_"+externalid).parent().parent().remove();
	$(".spacer_"+externalid).remove();
	$(".spacer_"+externalid).remove();
	$("#internal_"+externalid).parent().parent().after('<tr><td width="30">&nbsp;</td></tr><tr class=" spacer_'+externalid+'"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170"><label for="adbreak_'+externalid+'">Ad breaks</label></td><td width="100%"><input value="" name="adbreak['+externalid+']" class="adbreak" id="adbreak_'+externalid+'" type="text"></td></tr><tr class="spacer_'+externalid+'"><td style="height:1px;" colspan="3">&nbsp;</td></tr>');
	
	} 
	
}


 function vmapinternal(idd){

var data = '$azoneinline'; 

var zonearr = JSON.parse(data);


	var countinternal = idd.split('_');
	
	var internalid = countinternal[countinternal.length-1];
	
	
	if(!$("#zoneid_"+internalid).length){
	
	$("#adbreak_"+internalid).parent().parent().remove();
	$(".spacer_"+internalid).remove();
	$("#internal_"+internalid).parent().parent().after('<tr class="spacer_'+internalid+'"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr class="spacer_'+internalid+'"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170">Zone id </td><td width="100%"><select id="zoneid_'+internalid+'" name="zoneid['+internalid+']" class="subCategory'+internalid+'"></select> </td></tr><tr class="spacer_'+internalid+'"><td style="height:1px;" colspan="3">&nbsp;</td></tr>');
	
	}
	 
	
	$.each(zonearr, function(key, value) {
		$('.subCategory'+internalid).append(
		$('<option/>').val( key ).text(value)
        );
        });
	


}








  function validaterepeatafter(repeatField) {
			
        if ($('#repeatafter_0').is(':checked') == true) {

            var fieldid1 = repeatField.id;


            var isValid = /^([0-1]?[0-9]|2[0-4]):([0-5][0-9])(:[0-5][0-9])?$/.test(repeatField.value);

            if (isValid) {
                repeatField.style.backgroundColor = '#bfa';
                $('#time').remove();


            } else {

                var fieldid1 = repeatField.id;
                repeatField.style.backgroundColor = '#fba';
                $('#' + fieldid1).after('<span style="color:red;" id="time">The Repeat after time format should be (HH:mm:ss)</span>');


            }

            return isValid;
        }

       
    }
            
            
             function validateHhMm(inputField) {

        if ($('#time_0').is(':checked') == true) {

            var fieldid = inputField.id;


            var isValid = /^([0-1]?[0-9]|2[0-4]):([0-5][0-9])(:[0-5][0-9])?$/.test(inputField.value);

            if (isValid) {
                inputField.style.backgroundColor = '#bfa';
                $('#time').remove();


            } else {

                var fieldid = inputField.id;
                inputField.style.backgroundColor = '#fba';
                $('#' + fieldid).after('<span style="color:red;" id="time">The time format should be (HH:mm:ss)</span>');


            }

            return isValid;
        }

        if ($('#percentage_0').is(':checked') == true) {

            var fieldid1 = inputField.id;
            //~ $('#'+fieldid1).numeric();
            var pervalue = inputField.value;


            var regexPattern = /(^100(\.0{1,2})?$)|(^([1-9]([0-9])?|0)(\.[0-9]{1,2})?$)/.test(inputField.value);
            if (regexPattern) {

                inputField.style.backgroundColor = '#bfa';
                $('#percentage').remove();


            } else {
                var fieldid = inputField.id;
                inputField.style.backgroundColor = '#fba';

                $('#' + fieldid1).after('<span style="color:red;" id="percentage">The Percentage should be Numberic</span>');
            }

            return regexPattern;
        }
    }


function phpAds_formOverlayIsVmapCount2()
	    {
	   
		  var count = 0;
          var count= $("input[name='vmapcount']").val();
         
          if(count){
		
			count++;
			$("input[name=vmapcount]").val(count);
				
			}
			else{
			count=1;	
			}
		
		
	
			
			
		$("#vast-overlay-format-vmapcount2").parent().parent().before('<tr><td width="30">&nbsp;</td><td width="170">Allow Mulitple ads </td><td width="100%"><input name="allowmultipleAds[' + count + ']" id="allowmultipleAds_' + count + '" class="allowmultipleAds" type="checkbox" value="1"></td></tr><tr class="spacer spacer_' + count + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td style="padding-top: 5px" width="170" valign="top">Ad Tags</td><td width="100%"><input id="internal_' + count + '" class="internal" name="vmapurl[' + count + ']" value="Internal" type="radio" onclick="vmapinternal(this.id);"><label for="internal_' + count + '">Internal</label><br/><input id="external_' + count + '" class="external" name="vmapurl[' + count + ']" value="External" type="radio" onclick="vmapexternal(this.id);"><label for="external_' + count + '">External</label><br/></td></tr><tr class="spacer spacer_' + count + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170"><label for="offset_' + count + '">offset Time </label></td><td width="100%"><input value="" name="vmap_offset_adbreak[' + count + ']" class="offset" id="offset_' + count + '" type="text" onchange="validateHhMm(this);" ></td></tr><tr class="spacer spacer_' + count + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170"><input type="button" id="remove_' + count + '" value="Remove" onClick="return vmapRemove(this.id);"></td></tr><tr class="spacer"><td style="height:1px;" colspan="3"> &nbsp;</td></tr><tr><td width="30"></td><td colspan="2"></td></tr>');
				
				
			
			if($("#repeatafter_0").is(':checked') == true){
				 
				$("#repeataftertime_0").parent().parent().show();
				$(".offset").parent().parent().hide();
                $(".time").parent().parent().hide();
				  
			}else{
				
				$("#repeataftertime_0").parent().parent().hide();
				//~ $(".offset").parent().parent().show();
                $(".time").parent().parent().show();
				
			}
			if(($("#time_0").is(':checked') == true) || ($("#percentage_0").is(':checked') == true)){
			
				$(".offset").parent().parent().show();
			
			
			}
			else{
			
			$(".offset").parent().parent().hide();
			//~ $("label[for=offset_"+count+"]").hide();
		}
		
		  if($("#time_0").is(':checked') == true)
		{
		
		$(".offset").parent().prev().children().html("Offset Time");
		}
		else
		{
		
		$(".offset").parent().prev().children().html("Offset Percentage");
		}
		
		
		}
		
		     
			
			
			if($("#repeatafter_0").is(':checked') == true){
			
				$("#repeataftertime_0").parent().parent().show();
				$(".offset").parent().parent().hide();
                $(".time").parent().parent().hide();
                
				  
			}
			else{
			
				$("#repeataftertime_0").parent().parent().hide();
				//~ $(".offset").parent().parent().show();
                $(".time").parent().parent().show();
				
			}
			
		
	
	</script>
	
	
	<style>
		#thirdLevelContent
		{
			min-height:auto !important;
		}
		</style>
		
		
EOD;


if(!$bannerid)
{
	
	$html_1.= <<<EOD
		<script>
		
		 $("#repeataftertime_0").parent().parent().hide();
		 $("#adbreak_0").parent().parent().hide();
		 $("#zoneid_0").parent().parent().hide(); 
		 $("#offset_0").parent().parent().hide(); 
		</script>
EOD;

	
}


return $html_1;

}















   
}
